/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAd;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAdLoadCallback;
import com.hisavana.admoblibrary.check.ExistsCheck;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseVideo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;

public class AdmobInterstitiaVideo
extends BaseVideo {
    private RewardedInterstitialAd l;
    private RewardedInterstitialAdLoadCallback m;

    public AdmobInterstitiaVideo(Context context, Network network) {
        super(context, network);
    }

    public boolean isLoaded() {
        return this.l != null;
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.l != null) {
            this.l = null;
        }
        AdLogUtil.Log().d("AdmobInterstitiaVideo", "AdmobInterstitialVideo --> destroy" + this.getLogString());
        if (this.m != null) {
            this.m = null;
        }
    }

    protected boolean supportTimer() {
        return false;
    }

    protected void initVideo() {
        this.m = new RewardedInterstitialAdLoadCallback(){

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                AdmobInterstitiaVideo.this.l = null;
                AdLogUtil.Log().w("AdmobInterstitiaVideo", "AdmobInterstitialVideo --> ad load failed, error :" + loadAdError.toString() + AdmobInterstitiaVideo.this.getLogString());
                AdmobInterstitiaVideo.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
            }

            public void a(@NonNull RewardedInterstitialAd rewardedInterstitialAd) {
                AdmobInterstitiaVideo.this.l = rewardedInterstitialAd;
                AdLogUtil.Log().d("AdmobInterstitiaVideo", "AdmobInterstitialVideo --> Video Ad was loaded." + AdmobInterstitiaVideo.this.getLogString());
                AdmobInterstitiaVideo.this.adLoaded();
            }

            public /* synthetic */ void onAdLoaded(@NonNull Object object) {
                this.a((RewardedInterstitialAd)object);
            }
        };
    }

    protected void onVideoStartLoad() {
        try {
            ExistsCheck.a(CoreUtil.getContext(), new ExistsCheck.AdmobInitializationListener(){

                @Override
                public void c() {
                    if (AdmobInterstitiaVideo.this.mNetwork == null || TextUtils.isEmpty((CharSequence)AdmobInterstitiaVideo.this.mNetwork.getCodeSeatId()) || AdmobInterstitiaVideo.this.m == null) {
                        AdmobInterstitiaVideo.this.adFailedToLoad(new TAdErrorCode(30003, "rewardedAdLoadCallback or codeSeatId is null"));
                        return;
                    }
                    RewardedInterstitialAd.load((Context)CoreUtil.getContext(), (String)AdmobInterstitiaVideo.this.mNetwork.getCodeSeatId(), (AdRequest)PlatformUtil.k(), (RewardedInterstitialAdLoadCallback)AdmobInterstitiaVideo.this.m);
                }

                @Override
                public void d() {
                    AdmobInterstitiaVideo.this.adFailedToLoad(TAdErrorCode.ERROR_AD_SOURCE_INIT_FAILED);
                }
            });
        }
        catch (Exception exception) {
            this.adFailedToLoad(new TAdErrorCode(30003, exception.getMessage()));
            AdLogUtil.Log().e("AdmobInterstitiaVideo", "onVideoStartLoad " + Log.getStackTraceString((Throwable)exception));
        }
    }

    protected void onVideoShow(Activity activity) {
        if (null == activity) {
            AdLogUtil.Log().w("AdmobInterstitiaVideo", "AdmobInterstitialVideo --> onVideoShow null == activity " + this.getLogString());
            return;
        }
        if (this.l != null) {
            try {
                this.l.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdShowedFullScreenContent() {
                        AdLogUtil.Log().d("AdmobInterstitiaVideo", "AdmobInterstitialVideo --> Ad was shown." + AdmobInterstitiaVideo.this.getLogString());
                        AdmobInterstitiaVideo.this.adImpression(null);
                    }

                    public void onAdFailedToShowFullScreenContent(AdError adError) {
                        AdLogUtil.Log().w("AdmobInterstitiaVideo", "AdmobInterstitialVideo --> Ad failed to show." + AdmobInterstitiaVideo.this.getLogString());
                        AdmobInterstitiaVideo.this.l = null;
                        if (null != adError) {
                            AdmobInterstitiaVideo.this.onAdShowError(new TAdErrorCode(adError.getCode(), adError.getMessage()));
                        }
                    }

                    public void onAdDismissedFullScreenContent() {
                        AdmobInterstitiaVideo.this.l = null;
                        AdLogUtil.Log().d("AdmobInterstitiaVideo", "AdmobInterstitialVideo --> video is adClosed");
                        AdmobInterstitiaVideo.this.adClosed();
                    }

                    public void onAdClicked() {
                        super.onAdClicked();
                        AdmobInterstitiaVideo.this.adClicked(null);
                    }
                });
                AdLogUtil.Log().d("AdmobInterstitiaVideo", " activity is finish =" + activity.isFinishing());
                this.l.setOnPaidEventListener(new OnPaidEventListener(){

                    public void onPaidEvent(AdValue adValue) {
                        if (adValue == null) {
                            return;
                        }
                        long l = adValue.getValueMicros();
                        String string = adValue.getCurrencyCode();
                        int n = adValue.getPrecisionType();
                        AdLogUtil.Log().d("AdmobInterstitiaVideo", "onPaidEvent valueMicros " + l + ",currencyCode " + string + ",precisionType " + n);
                        AdmobInterstitiaVideo.this.admobShowPriceTracking(l, string, n);
                    }
                });
                ExistsCheck.a();
                this.l.show(activity, new OnUserEarnedRewardListener(){

                    public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                        AdLogUtil.Log().d("AdmobInterstitiaVideo", "AdmobInterstitialVideo --> The user earned the reward." + AdmobInterstitiaVideo.this.getLogString());
                        AdmobInterstitiaVideo.this.onReward();
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.onAdShowError(new TAdErrorCode(50001, exception.getMessage()));
                AdLogUtil.Log().e("AdmobInterstitiaVideo", "AdmobInterstitialVideo --> onVideoShow \u5c55\u793a\u5f02\u5e38" + Log.getStackTraceString((Throwable)exception) + this.getLogString());
            }
        } else {
            this.onAdShowError(TAdErrorCode.ERROR_SHOW_EXCEPTION);
            AdLogUtil.Log().w("AdmobInterstitiaVideo", "AdmobInterstitialVideo --> The rewarded ad wasn't ready yet." + this.getLogString());
        }
    }
}

