/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.LoadAdError;
import com.hisavana.admoblibrary.check.ExistsCheck;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseBanner;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;

public class AdmobBanner
extends BaseBanner<AdView> {
    private AdView d;
    private final int e;
    private int f;

    public AdmobBanner(Context context, Network network, int n, int n2) {
        super(context, network);
        this.e = n;
        this.f = n2;
        AdLogUtil.Log().d("AdmobBanner", "bannerSize:=" + n + this.getLogString());
    }

    private AdSize e() {
        AdSize adSize = AdSize.BANNER;
        if (this.mContext == null || this.mContext.get() == null) {
            return adSize;
        }
        Context context = (Context)this.mContext.get();
        if (context instanceof Activity) {
            Display display;
            WindowManager windowManager = ((Activity)context).getWindowManager();
            Display display2 = display = windowManager != null ? windowManager.getDefaultDisplay() : null;
            if (display == null) {
                return adSize;
            }
            DisplayMetrics displayMetrics = new DisplayMetrics();
            display.getMetrics(displayMetrics);
            float f = displayMetrics.widthPixels;
            float f2 = displayMetrics.density;
            if (f <= 0.0f || f2 <= 0.0f) {
                return adSize;
            }
            int n = (int)(f / f2);
            adSize = AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)context, (int)n);
        }
        return adSize != null ? adSize : AdSize.BANNER;
    }

    protected AdView f() {
        if (this.mContext == null || this.mContext.get() == null) {
            return this.d;
        }
        Context context = (Context)this.mContext.get();
        if (this.d == null && context != null && this.mNetwork != null) {
            if (!(context instanceof Activity)) {
                this.f = 0;
            }
            context = this.f == 0 ? context.getApplicationContext() : context;
            this.d = new AdView(context);
            this.d.setAdUnitId(this.mNetwork.getCodeSeatId());
            switch (this.e) {
                case 0: {
                    this.d.setAdSize(this.e());
                    break;
                }
                case 1: 
                case 3: {
                    this.d.setAdSize(AdSize.LARGE_BANNER);
                    break;
                }
                case 2: {
                    this.d.setAdSize(AdSize.MEDIUM_RECTANGLE);
                    break;
                }
                default: {
                    this.d.setAdSize(AdSize.BANNER);
                }
            }
            this.d.setAdListener(new AdListener(){

                public void onAdClosed() {
                    if (AdmobBanner.this.f == 0) {
                        AdmobBanner.this.adClosed();
                    }
                    AdLogUtil.Log().d("AdmobBanner", "onAdClosed bannerType " + AdmobBanner.this.f);
                }

                public void onAdFailedToLoad(LoadAdError loadAdError) {
                    AdLogUtil.Log().w("AdmobBanner", "banner onAdFailedToLoad:" + loadAdError.toString() + AdmobBanner.this.getLogString());
                    AdmobBanner.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
                }

                public void onAdLoaded() {
                    AdLogUtil.Log().d("AdmobBanner", "banner onAdLoaded" + AdmobBanner.this.getLogString());
                    AdmobBanner.this.adLoaded();
                }

                public void onAdClicked() {
                    AdLogUtil.Log().d("AdmobBanner", "onAdClicked");
                    super.onAdClicked();
                    AdmobBanner.this.adClicked(null);
                }

                public void onAdImpression() {
                    AdLogUtil.Log().d("AdmobBanner", "onAdImpression");
                    super.onAdImpression();
                    AdmobBanner.this.adImpression(null);
                }
            });
            this.d.setOnPaidEventListener(adValue -> {
                long l = adValue.getValueMicros();
                String string = adValue.getCurrencyCode();
                int n = adValue.getPrecisionType();
                AdLogUtil.Log().d("AdmobBanner", "onPaidEvent valueMicros " + l + ",currencyCode " + string + ",precisionType " + n);
                this.admobShowPriceTracking(l, string, n);
            });
        }
        return this.d;
    }

    protected boolean supportTimer() {
        return false;
    }

    protected void onBannerLoad() {
        try {
            ExistsCheck.a(CoreUtil.getContext(), new ExistsCheck.AdmobInitializationListener(){

                @Override
                public void c() {
                    if (AdmobBanner.this.d != null) {
                        AdmobBanner.this.d.loadAd(PlatformUtil.a(AdmobBanner.this.f));
                    } else {
                        AdLogUtil.Log().e("AdmobBanner", "onBannerLoad adView is null");
                    }
                }

                @Override
                public void d() {
                    AdmobBanner.this.adFailedToLoad(TAdErrorCode.ERROR_AD_SOURCE_INIT_FAILED);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.adFailedToLoad(new TAdErrorCode(30003, Log.getStackTraceString((Throwable)throwable)));
        }
    }

    protected void showBanner() {
        if (this.d != null) {
            this.d.setVisibility(0);
        }
    }

    public boolean destroyFoldAd() {
        super.destroyFoldAd();
        AdLogUtil.Log().d("AdmobBanner", "destroyFoldAd mBannerType " + this.f);
        if (this.f != 0) {
            this.destroyAd();
            return true;
        }
        return false;
    }

    protected void onBannerDestroy() {
        if (this.d != null) {
            this.d.setAdListener(null);
            this.d.setOnPaidEventListener(null);
            this.d.destroy();
            this.d = null;
        }
        AdLogUtil.Log().d("AdmobBanner", "banner destroy" + this.getLogString());
    }

    protected /* synthetic */ View getBanner() {
        return this.f();
    }
}

