/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.hisavana.admoblibrary.check.ExistsCheck;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseVideo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;

public class AdmobVideo
extends BaseVideo {
    private RewardedAd z;
    private RewardedAdLoadCallback A;

    public AdmobVideo(Context context, Network network) {
        super(context, network);
    }

    public boolean isLoaded() {
        return this.z != null;
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.z != null) {
            this.z = null;
        }
        AdLogUtil.Log().d("AdmobVideo", "AdmobVideo --> destroy" + this.getLogString());
        if (this.A != null) {
            this.A = null;
        }
    }

    protected boolean supportTimer() {
        return false;
    }

    protected void initVideo() {
        this.A = new RewardedAdLoadCallback(){

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                AdmobVideo.this.z = null;
                AdLogUtil.Log().w("AdmobVideo", "AdmobVideo --> ad load failed, error :" + loadAdError.toString() + AdmobVideo.this.getLogString());
                AdmobVideo.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
            }

            public void a(@NonNull RewardedAd rewardedAd) {
                AdmobVideo.this.z = rewardedAd;
                AdLogUtil.Log().d("AdmobVideo", "AdmobVideo --> Video Ad was loaded." + AdmobVideo.this.getLogString());
                AdmobVideo.this.adLoaded();
            }

            public /* synthetic */ void onAdLoaded(@NonNull Object object) {
                this.a((RewardedAd)object);
            }
        };
    }

    protected void onVideoStartLoad() {
        try {
            ExistsCheck.a(CoreUtil.getContext(), new ExistsCheck.AdmobInitializationListener(){

                @Override
                public void c() {
                    if (AdmobVideo.this.mNetwork == null || TextUtils.isEmpty((CharSequence)AdmobVideo.this.mNetwork.getCodeSeatId()) || AdmobVideo.this.A == null) {
                        AdmobVideo.this.adFailedToLoad(new TAdErrorCode(30003, "rewardedAdLoadCallback or codeSeatId is null"));
                        return;
                    }
                    RewardedAd.load((Context)CoreUtil.getContext(), (String)AdmobVideo.this.mNetwork.getCodeSeatId(), (AdRequest)PlatformUtil.k(), (RewardedAdLoadCallback)AdmobVideo.this.A);
                }

                @Override
                public void d() {
                    AdmobVideo.this.adFailedToLoad(TAdErrorCode.ERROR_AD_SOURCE_INIT_FAILED);
                }
            });
        }
        catch (Exception exception) {
            this.adFailedToLoad(new TAdErrorCode(30003, exception.getMessage()));
            AdLogUtil.Log().e("AdmobVideo", "onVideoStartLoad " + Log.getStackTraceString((Throwable)exception));
        }
    }

    protected void onVideoShow(Activity activity) {
        if (null == activity) {
            AdLogUtil.Log().w("AdmobVideo", "AdmobVideo --> onVideoShow null == activity " + this.getLogString());
            return;
        }
        if (this.z != null) {
            try {
                this.z.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdShowedFullScreenContent() {
                        AdLogUtil.Log().d("AdmobVideo", "AdmobVideo --> Ad was shown." + AdmobVideo.this.getLogString());
                        AdmobVideo.this.adImpression(null);
                    }

                    public void onAdFailedToShowFullScreenContent(AdError adError) {
                        AdLogUtil.Log().w("AdmobVideo", "AdmobVideo --> Ad failed to show." + AdmobVideo.this.getLogString());
                        AdmobVideo.this.z = null;
                        if (null != adError) {
                            AdmobVideo.this.onAdShowError(new TAdErrorCode(adError.getCode(), adError.getMessage()));
                        }
                    }

                    public void onAdDismissedFullScreenContent() {
                        AdmobVideo.this.z = null;
                        AdLogUtil.Log().d("AdmobVideo", "AdmobVideo --> video is adClosed");
                        AdmobVideo.this.adClosed();
                    }

                    public void onAdClicked() {
                        super.onAdClicked();
                        AdmobVideo.this.adClicked(null);
                    }
                });
                AdLogUtil.Log().d("AdmobVideo", " activity is finish =" + activity.isFinishing());
                this.z.setOnPaidEventListener(new OnPaidEventListener(){

                    public void onPaidEvent(AdValue adValue) {
                        if (adValue == null) {
                            return;
                        }
                        long l = adValue.getValueMicros();
                        String string = adValue.getCurrencyCode();
                        int n = adValue.getPrecisionType();
                        AdLogUtil.Log().d("AdmobVideo", "onPaidEvent valueMicros " + l + ",currencyCode " + string + ",precisionType " + n);
                        AdmobVideo.this.admobShowPriceTracking(l, string, n);
                    }
                });
                ExistsCheck.a();
                this.z.show(activity, new OnUserEarnedRewardListener(){

                    public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                        AdLogUtil.Log().d("AdmobVideo", "AdmobVideo --> The user earned the reward." + AdmobVideo.this.getLogString());
                        AdmobVideo.this.onReward();
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.onAdShowError(new TAdErrorCode(50001, exception.getMessage()));
                AdLogUtil.Log().e("AdmobVideo", "AdmobVideo --> onVideoShow \u5c55\u793a\u5f02\u5e38" + Log.getStackTraceString((Throwable)exception) + this.getLogString());
            }
        } else {
            this.onAdShowError(TAdErrorCode.ERROR_SHOW_EXCEPTION);
            AdLogUtil.Log().w("AdmobVideo", "AdmobVideo --> The rewarded ad wasn't ready yet." + this.getLogString());
        }
    }
}

