/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.hisavana.admoblibrary.check.ExistsCheck;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseSplash;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;

public class AdmobSplash
extends BaseSplash {
    private static final String TAG = "AdmobSplash";
    private static boolean isShowingAd = false;
    private AppOpenAd appOpenAd = null;
    private AppOpenAd.AppOpenAdLoadCallback loadCallback;
    private Activity currentActivity;

    public AdmobSplash(Context context, Network network) {
        super(context, network);
    }

    public static /* synthetic */ AppOpenAd access$002(AdmobSplash admobSplash, AppOpenAd appOpenAd) {
        admobSplash.appOpenAd = appOpenAd;
        return appOpenAd;
    }

    public void fetchAd() {
        admobSplash2.loadCallback = new AppOpenAd.AppOpenAdLoadCallback(){

            public void a(AppOpenAd appOpenAd) {
                if (appOpenAd == null) {
                    return;
                }
                1 v0 = this;
                AdmobSplash.access$002(v0.AdmobSplash.this, appOpenAd);
                v0.AdmobSplash.this.adLoaded();
                AdLogUtil.Log().d(AdmobSplash.TAG, "admob appOpenAd onAdLoaded" + AdmobSplash.this.getLogString());
                v0.AdmobSplash.this.appOpenAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdFailedToShowFullScreenContent(AdError adError) {
                        super.onAdFailedToShowFullScreenContent(adError);
                        if (adError != null) {
                            AdError adError2 = adError;
                            int n = adError2.getCode();
                            AdmobSplash.this.adFailedToLoad(new TAdErrorCode(n, adError2.getMessage()));
                            AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview show fail:" + adError.getMessage() + AdmobSplash.this.getLogString());
                        }
                    }

                    public void onAdShowedFullScreenContent() {
                        1 v0 = this;
                        super.onAdShowedFullScreenContent();
                        v0.AdmobSplash.this.adImpression(null);
                        isShowingAd = true;
                        AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview onAdShow" + AdmobSplash.this.getLogString());
                    }

                    public void onAdDismissedFullScreenContent() {
                        1 v0 = this;
                        super.onAdDismissedFullScreenContent();
                        v0.AdmobSplash.this.onSkipClick();
                        AdmobSplash.access$002(v0.AdmobSplash.this, null);
                        isShowingAd = false;
                        AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview onAdClicked" + AdmobSplash.this.getLogString());
                    }

                    public void onAdImpression() {
                        super.onAdImpression();
                        AdLogUtil.Log().d(AdmobSplash.TAG, "onAdImpression");
                    }

                    public void onAdClicked() {
                        1 v0 = this;
                        super.onAdClicked();
                        v0.AdmobSplash.this.adClicked(null);
                    }
                });
            }

            public void onAdFailedToLoad(LoadAdError loadAdError) {
                if (loadAdError != null) {
                    LoadAdError loadAdError2 = loadAdError;
                    int n = loadAdError2.getCode();
                    AdmobSplash.this.adFailedToLoad(new TAdErrorCode(n, loadAdError2.getMessage()));
                    AdLogUtil.Log().w(AdmobSplash.TAG, "admob splashview onError:" + loadAdError.toString() + AdmobSplash.this.getLogString());
                }
            }
        };
        try {
            ExistsCheck.a(CoreUtil.getContext(), new ExistsCheck.AdmobInitializationListener(){

                @Override
                public void b() {
                    if (this_.AdmobSplash.this.isAdAvailable()) {
                        return;
                    }
                    if (this_.AdmobSplash.this.mNetwork != null && !TextUtils.isEmpty((CharSequence)this_.AdmobSplash.this.mNetwork.getCodeSeatId())) {
                        2 v0 = this_;
                        2 this_ = PlatformUtil.a();
                        int n = v0.AdmobSplash.this.getOrientation();
                        AppOpenAd.AppOpenAdLoadCallback appOpenAdLoadCallback = v0.AdmobSplash.this.loadCallback;
                        AppOpenAd.load((Context)CoreUtil.getContext(), (String)this_.AdmobSplash.this.mNetwork.getCodeSeatId(), (AdRequest)this_, (int)n, (AppOpenAd.AppOpenAdLoadCallback)appOpenAdLoadCallback);
                    }
                }

                @Override
                public void a() {
                    AdmobSplash.this.adFailedToLoad(TAdErrorCode.ERROR_AD_SOURCE_INIT_FAILED);
                }
            });
        }
        catch (Exception exception) {
            TAdErrorCode tAdErrorCode;
            AdmobSplash admobSplash = admobSplash2;
            exception.printStackTrace();
            AdmobSplash admobSplash2 = tAdErrorCode;
            tAdErrorCode = new TAdErrorCode(30003, Log.getStackTraceString((Throwable)exception));
            admobSplash.adFailedToLoad((TAdErrorCode)admobSplash2);
        }
    }

    public void showAdIfAvailable() {
        if (!isShowingAd && this.isAdAvailable()) {
            try {
                AdmobSplash admobSplash = this;
                admobSplash.appOpenAd.setOnPaidEventListener(new OnPaidEventListener(){

                    public void onPaidEvent(AdValue adValue) {
                        if (adValue == null) {
                            return;
                        }
                        AdValue adValue2 = adValue;
                        long l = adValue2.getValueMicros();
                        String string = adValue2.getCurrencyCode();
                        int n = adValue2.getPrecisionType();
                        AdLogUtil.Log().d(AdmobSplash.TAG, "onPaidEvent valueMicros " + l + ",currencyCode " + string + ",precisionType " + n);
                        AdmobSplash.this.admobShowPriceTracking(l, string, n);
                    }
                });
                admobSplash.appOpenAd.show(this.currentActivity);
            }
            catch (Exception exception) {
                AdmobSplash admobSplash = this;
                admobSplash.onAdShowError(new TAdErrorCode(50001, exception.getMessage()));
                admobSplash.onTimeReach();
                AdLogUtil.Log().e(TAG, "showAdIfAvailable " + Log.getStackTraceString((Throwable)exception));
            }
        } else {
            AdmobSplash admobSplash = this;
            admobSplash.onAdShowError(TAdErrorCode.ERROR_SHOW_EXCEPTION);
            admobSplash.onTimeReach();
            AdLogUtil.Log().e(TAG, "showAdIfAvailable,show error,ad is showing or ad is not available");
        }
    }

    public boolean isAdAvailable() {
        return this.appOpenAd != null;
    }

    public void onSplashStartLoad() {
        this.fetchAd();
    }

    public View getSplash() {
        if (CoreUtil.getContext() != null) {
            return new View(CoreUtil.getContext().getApplicationContext());
        }
        return null;
    }

    public void onSplashShow() {
        this.showAdIfAvailable();
    }

    public boolean supportTimer() {
        return false;
    }

    public void destroyAd() {
        AdmobSplash admobSplash = this;
        super.destroyAd();
        AppOpenAd appOpenAd = admobSplash.appOpenAd;
        if (appOpenAd != null) {
            appOpenAd.setFullScreenContentCallback(null);
            this.appOpenAd = null;
        }
        if (this.loadCallback != null) {
            this.loadCallback = null;
        }
        AdLogUtil.Log().d(TAG, "destroy " + this.getLogString());
    }
}

