/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.applovin.excuter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinAdViewDisplayErrorCode;
import com.applovin.adview.AppLovinAdViewEventListener;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdService;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.cloud.sdk.commonutil.util.HSCoreUtil;
import com.hisavana.applovin.check.ExistsCheck;
import com.hisavana.common.base.BaseBanner;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;

public class AppLovinBanner
extends BaseBanner {
    private final String a;
    private AppLovinAdView b;
    private AppLovinAd c;
    private int d;
    private AppLovinAdLoadListener e;

    public AppLovinBanner(Context context, Network network, int n) {
        super(context, network);
        this.a = "AppLovinBanner";
        AdLogUtil.Log().d("AppLovinBanner", "bannerSize:=" + n + "," + this.getLogString());
        this.d = n;
    }

    static /* synthetic */ AppLovinAd a(AppLovinBanner appLovinBanner, AppLovinAd appLovinAd) {
        appLovinBanner.c = appLovinAd;
        return appLovinAd;
    }

    protected void onBannerDestroy() {
        AppLovinAdView appLovinAdView = this.b;
        if (appLovinAdView != null) {
            appLovinAdView.destroy();
            this.b = null;
        }
    }

    public void destroyAd() {
        super.destroyAd();
        AdLogUtil.Log().d("AppLovinBanner", "destroy " + this.getLogString());
    }

    protected View getBanner() {
        if (this.b == null) {
            AppLovinBanner appLovinBanner = this;
            appLovinBanner.b = new AppLovinAdView(AppLovinAdSize.BANNER, this.mNetwork.getCodeSeatId());
            appLovinBanner.e = new AppLovinAdLoadListener(){

                public void adReceived(AppLovinAd appLovinAd) {
                    if (appLovinAd != null) {
                        1 v0 = this;
                        AppLovinBanner.a(v0.AppLovinBanner.this, appLovinAd);
                        AdLogUtil.Log().d("applovin_log", "adReceived " + AppLovinBanner.this.getLogString());
                        v0.AppLovinBanner.this.adLoaded();
                    }
                }

                public void failedToReceiveAd(int n) {
                    AdLogUtil.Log().d("applovin_log", "failedToReceiveAd errorCode = " + n + "," + AppLovinBanner.this.getLogString());
                    AppLovinBanner.this.adFailedToLoad(new TAdErrorCode(n, "AppLovinBanner --> failedToReceiveAd"));
                }
            };
            appLovinBanner.b.setAdDisplayListener(new AppLovinAdDisplayListener(){

                public void adDisplayed(AppLovinAd appLovinAd) {
                    AdLogUtil.Log().d("AppLovinBanner", "adDisplayed " + AppLovinBanner.this.getLogString());
                    AppLovinBanner.this.adImpression(null);
                }

                public void adHidden(AppLovinAd appLovinAd) {
                }
            });
            appLovinBanner.b.setAdClickListener(appLovinAd -> this.adClicked(null));
            appLovinBanner.b.setAdViewEventListener(new AppLovinAdViewEventListener(){

                public void adOpenedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
                    AdLogUtil.Log().d("AppLovinBanner", "adOpenedFullscreen");
                }

                public void adClosedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
                    AdLogUtil.Log().d("AppLovinBanner", "adClosedFullscreen");
                }

                public void adLeftApplication(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
                    AdLogUtil.Log().d("AppLovinBanner", "adLeftApplication");
                }

                public void adFailedToDisplay(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView, AppLovinAdViewDisplayErrorCode appLovinAdViewDisplayErrorCode) {
                    AdLogUtil.Log().d("AppLovinBanner", "adFailedToDisplay");
                    AppLovinBanner.this.onAdShowError(TAdErrorCode.ERROR_SHOW_EXCEPTION);
                }
            });
        }
        return this.b;
    }

    protected void onBannerLoad() {
        Network network = this.mNetwork;
        if (network != null && this.mContext != null) {
            if (this.b == null) {
                AdLogUtil.Log().w("AppLovinBanner", "load error: bannerAdView is null, " + this.getLogString());
                this.adFailedToLoad(TAdErrorCode.ERROR_AD_REQUEST_FAILED);
                return;
            }
            ExistsCheck.initAppLovin(network.getApplicationId(), object -> {
                AppLovinAdService appLovinAdService = AppLovinSdk.getInstance((Context)HSCoreUtil.getContext()).getAdService();
                AppLovinBanner appLovinBanner = this;
                AppLovinBanner appLovinBanner2 = appLovinBanner;
                object = appLovinBanner.mNetwork.getCodeSeatId();
                try {
                    appLovinAdService.loadNextAdForZoneId((String)object, appLovinBanner2.e);
                }
                catch (Exception exception) {
                    AdLogUtil.Log().e("AppLovinBanner", "load error: " + exception.getMessage());
                    this.adFailedToLoad(TAdErrorCode.ERROR_AD_REQUEST_FAILED);
                }
            });
            return;
        }
        AdLogUtil.Log().w("AppLovinBanner", "banner load error:" + this.getLogString() + ", network :" + this.mNetwork);
        this.adFailedToLoad(TAdErrorCode.ERROR_AD_REQUEST_FAILED);
    }

    protected void showBanner() {
        AppLovinAdView appLovinAdView = this.b;
        if (appLovinAdView != null && this.c != null) {
            appLovinAdView.setVisibility(0);
            this.b.renderAd(this.c);
            int n = -1;
            Context context = HSCoreUtil.getContext();
            int n2 = AppLovinSdkUtils.isTablet((Context)HSCoreUtil.getContext()) ? 90 : 50;
            int n3 = AppLovinSdkUtils.dpToPx((Context)context, (int)n2);
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.b.getLayoutParams();
            if (layoutParams == null) {
                RelativeLayout.LayoutParams layoutParams2;
                layoutParams = layoutParams2;
                layoutParams2 = new RelativeLayout.LayoutParams(n, n3);
            } else {
                RelativeLayout.LayoutParams layoutParams3 = layoutParams;
                layoutParams3.width = n;
                layoutParams3.height = n3;
            }
            this.b.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        } else {
            this.onAdShowError(TAdErrorCode.ERROR_SHOW_EXCEPTION);
            AdLogUtil.Log().e("AppLovinBanner", "showBanner failed,adView or applovinAd is null");
        }
    }
}

