/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.base;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.hisavana.common.base.BaseAd;
import com.hisavana.common.base.WrapTadView;
import com.hisavana.common.bean.Network;
import com.hisavana.common.interfacz.IadView;
import com.hisavana.common.interfacz.OnSkipListener;

public abstract class BaseSplash<T extends View>
extends BaseAd
implements IadView {
    T splash;

    public BaseSplash(Context context, Network network) {
        super(context, network);
    }

    @Override
    public void loadAd() {
        this.splash = this.getSplash();
        if (this.splash != null) {
            super.loadAd();
            this.onSplashStartLoad();
        }
    }

    protected abstract void onSplashStartLoad();

    protected abstract T getSplash();

    @Override
    public void show(WrapTadView wrapTadView) {
        T t = this.splash;
        if (t != null) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            wrapTadView.removeAllViews();
            wrapTadView.addView((View)t, (ViewGroup.LayoutParams)layoutParams);
            wrapTadView.setVisibility(0);
            this.onSplashShow();
            this.logTrigerShow();
        } else {
            AdLogUtil.Log().e("BaseSplash", "Splash is null ");
        }
    }

    protected abstract void onSplashShow();

    @Override
    public int getAdType() {
        return 5;
    }

    @Override
    public void destroyAd() {
        if (null != this.splash) {
            if (this.splash.getParent() != null) {
                ((ViewGroup)this.splash.getParent()).removeView(this.splash);
            }
            this.splash = null;
        }
        super.destroyAd();
    }

    public abstract void setOnSkipListener(@NonNull OnSkipListener var1);
}

