/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.base;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.DeviceUtil;
import com.cloud.hisavana.sdk.common.util.Preconditions;
import com.cloud.hisavana.sdk.common.util.RunTimer;
import com.cloud.hisavana.sdk.data.control.AdxPreferencesHelper;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.bean.TAdRequestBody;
import com.hisavana.common.interfacz.Iad;
import com.hisavana.common.interfacz.WrapTAdAllianceListener;
import com.hisavana.common.tracking.TrackingManager;
import com.transsion.json.Tson;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseAd
implements Iad {
    private boolean isAdFillingTarget = false;
    protected int mAdCount = 1;
    protected WeakReference<Context> mContext;
    private String TAG = "BaseAd";
    private double price = 0.0;
    private int ttl;
    private int adSource;
    private long startTime;
    protected TAdRequestBody mAdRequestBody;
    private int delay;
    protected boolean isLoaded = false;
    private RunTimer runTimer;
    protected WrapTAdAllianceListener listener;
    private long mLoadedTime;
    private long mImpressionTime;
    protected Network mNetwork;
    public Bundle mBundle = new Bundle();
    protected String mRequestId = null;
    protected int isPreTrigger = 0;
    protected boolean mIsDefaultAd = false;
    private RunTimer.TimeOutCallback timeOutCallback = new RunTimer.TimeOutCallback(){

        public void isTimeOut() {
            AdLogUtil.Log().d(BaseAd.this.TAG, "Load ad is time out");
            BaseAd.this.onTimeOut();
        }
    };

    @Override
    public void setAdFillingTarget(boolean bl) {
        this.isAdFillingTarget = bl;
    }

    @Override
    public boolean isAdFillingTarget() {
        return this.isAdFillingTarget;
    }

    public BaseAd(Context context, Network network) {
        this.mContext = new WeakReference<Context>(context);
        Preconditions.checkNotNull((Object)network);
        this.mNetwork = network;
    }

    @Override
    public void setDefaultAd(boolean bl) {
        this.mIsDefaultAd = bl;
    }

    @Override
    public boolean isDefaultAd() {
        return this.mIsDefaultAd;
    }

    @Override
    public void loadAd() {
        this.mRequestId = DeviceUtil.getUUID();
        this.startTime = System.currentTimeMillis();
        if (this.listener != null) {
            this.listener.onStart();
        }
        if (this.supportTimer()) {
            this.startTimer();
        }
        this.adTrackingRequest();
    }

    public void adLoaded() {
        Bundle bundle = new Bundle();
        bundle.putInt("error_code", 0);
        this.adReturnTracking(bundle);
        this.isLoaded = true;
        this.mLoadedTime = System.currentTimeMillis();
        if (this.listener != null) {
            this.listener.onLoad();
        } else {
            this.destroyAd();
        }
        if (this.supportTimer()) {
            this.stopTimer();
        }
    }

    public void adLoaded(List<TAdNativeInfo> list) {
        Bundle bundle = new Bundle();
        bundle.putInt("error_code", 0);
        this.adReturnTracking(bundle);
        this.isLoaded = true;
        this.mLoadedTime = System.currentTimeMillis();
        if (this.listener != null) {
            this.listener.onLoad(list);
        } else {
            this.destroyAd();
        }
        if (this.supportTimer()) {
            this.stopTimer();
        }
    }

    protected void adFailedToLoad(TAdErrorCode tAdErrorCode) {
        int n;
        this.isLoaded = true;
        Bundle bundle = new Bundle();
        int n2 = n = tAdErrorCode != null ? tAdErrorCode.getErrorCode() : 100;
        if (n == 0) {
            n = 100;
        }
        bundle.putInt("is_timeout", 0);
        bundle.putInt("error_code", n);
        bundle.putString("error_message", tAdErrorCode.getErrorMessage());
        this.adReturnTracking(bundle);
        if (this.listener != null) {
            this.listener.onError(tAdErrorCode);
        }
        if (this.supportTimer()) {
            this.stopTimer();
        }
        this.destroyAd();
    }

    protected void onAdShowError(TAdErrorCode tAdErrorCode) {
        this.logImpression(false);
        if (this.listener != null) {
            this.listener.onError(tAdErrorCode);
        }
    }

    protected void adImpression() {
        this.logImpression(true);
        this.mImpressionTime = System.currentTimeMillis();
        if (this.listener != null) {
            this.listener.onShow();
        }
    }

    protected void onBiddingReturn(double d) {
        this.mBundle.putDouble("bidding_price", d);
        if (this.listener != null) {
            this.listener.onRtBiddingReturn(d);
        }
    }

    @Override
    public void onBiddingTimeEnd() {
    }

    @Override
    public boolean isSupportRtBidding() {
        return false;
    }

    protected void adClicked() {
        this.logClick();
        if (this.listener != null) {
            this.listener.onClicked();
        }
    }

    protected void adClosed() {
        this.logClose();
        if (this.listener != null) {
            this.listener.onClosed();
        }
    }

    protected void onReward() {
        if (this.listener != null) {
            this.listener.onRewarded();
        }
    }

    private void appendContextParam(Bundle bundle) {
        bundle.putString("trigger_id", this.mBundle.getString("trigger_id"));
        bundle.putLong("trigger_ts", this.mBundle.getLong("trigger_ts"));
        bundle.putInt("ad_type", this.mBundle.getInt("ad_type"));
        bundle.putString("cld_app_id", this.mBundle.getString("cld_app_id"));
        bundle.putString("cld_code_seat_id", this.mBundle.getString("cld_code_seat_id"));
        bundle.putInt("platform", this.mBundle.getInt("platform"));
        bundle.putString("app_id", this.mBundle.getString("app_id"));
        bundle.putString("code_seat_id", this.mBundle.getString("code_seat_id"));
        bundle.putDouble("bidding_price", this.mBundle.getDouble("bidding_price"));
        bundle.putInt("priority", this.mBundle.getInt("priority"));
        bundle.putInt("ad_count", this.mBundle.getInt("ad_count"));
        bundle.putInt("is_retreatad", this.mBundle.getInt("is_retreatad"));
        bundle.putInt("is_default_ad", this.mBundle.getInt("is_default_ad"));
        bundle.putLong("request_ts", this.mBundle.getLong("request_ts"));
        bundle.putInt("request_time", this.mBundle.getInt("request_time"));
        bundle.putString("request_id", this.mRequestId);
        bundle.putLong("return_ts", this.mBundle.getLong("return_ts"));
        bundle.putInt("return_time", this.mBundle.getInt("return_time"));
    }

    private void addToContextParam(String string, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Integer) {
            this.mBundle.putInt(string, ((Integer)object).intValue());
        } else if (object instanceof String) {
            this.mBundle.putString(string, (String)object);
        } else if (object instanceof Long) {
            this.mBundle.putLong(string, ((Long)object).longValue());
        }
    }

    protected void logImpression(boolean bl) {
        Bundle bundle = new Bundle();
        this.appendContextParam(bundle);
        bundle.putLong("show_ts", System.currentTimeMillis());
        bundle.putLong("show_time", System.currentTimeMillis() - this.mLoadedTime);
        bundle.putString("ad_title", this.mBundle.getString("ad_title"));
        bundle.putString("ad_url", this.mBundle.getString("ad_url"));
        bundle.putInt("filling_source", this.mBundle.getInt("filling_source"));
        bundle.putString("description", this.mBundle.getString("description"));
        bundle.putString("image_url", this.mBundle.getString("image_url"));
        bundle.putString("icon_url", this.mBundle.getString("icon_url"));
        bundle.putString("endcard_url", this.mBundle.getString("endcard_url"));
        bundle.putString("app_name", this.mBundle.getString("app_name"));
        bundle.putString("package_name", this.mBundle.getString("package_name"));
        bundle.putString("download_url", this.mBundle.getString("download_url"));
        bundle.putInt("slot_height", 0);
        bundle.putInt("slot_width", 0);
        bundle.putInt("is_expired", this.isExpired() ? 1 : 0);
        if (bl) {
            bundle.putInt("show_status", 1);
            bundle.putInt("fail_reason", 0);
        } else {
            bundle.putInt("show_status", 2);
            bundle.putInt("fail_reason", 2);
        }
        bundle.putInt("filling_source", this.mBundle.getInt("filling_source"));
        TrackingManager.trackingImpression(bundle);
        this.addToContextParam("show_ts", bundle.getLong("show_ts"));
        this.addToContextParam("show_time", bundle.getLong("show_time"));
        this.addToContextParam("slot_height", bundle.getInt("slot_height"));
        this.addToContextParam("slot_width", bundle.getInt("slot_width"));
        this.addToContextParam("show_status", bundle.getInt("show_status"));
        this.addToContextParam("fail_reason", bundle.getInt("fail_reason"));
    }

    protected void logTrigerShow() {
        this.logTrigerShow(null);
    }

    protected void logTrigerShow(TAdNativeInfo tAdNativeInfo) {
        if (null != tAdNativeInfo) {
            this.mBundle.putString("trigger_id", tAdNativeInfo.getTriggerId());
            this.mBundle.putLong("trigger_ts", tAdNativeInfo.getTriggerTs().longValue());
        }
        Bundle bundle = new Bundle();
        this.appendContextParam(bundle);
        if (bundle.containsKey("is_default_ad")) {
            bundle.remove("is_default_ad");
        }
        bundle.putInt("is_timeout", this.mBundle.getInt("is_timeout"));
        bundle.putString("error_code", this.mBundle.getString("error_code"));
        bundle.putString("error_message", this.mBundle.getString("error_message"));
        if (tAdNativeInfo != null) {
            bundle.putString("ad_title", tAdNativeInfo.getTitle());
            bundle.putString("ad_url", "");
            bundle.putString("description", tAdNativeInfo.getDescription());
            if (null != tAdNativeInfo.getImageList() && tAdNativeInfo.getImageList().size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (TAdNativeInfo.Image image : tAdNativeInfo.getImageList()) {
                    if (TextUtils.isEmpty((CharSequence)image.getUrl())) continue;
                    arrayList.add(image.getUrl());
                }
                bundle.putString("image_url", Tson.toJson(arrayList));
            }
            if (null != tAdNativeInfo.getIcon()) {
                bundle.putString("icon_url", tAdNativeInfo.getIcon().getUrl());
            }
            bundle.putString("endcard_url", "");
            bundle.putString("app_name", "");
            bundle.putString("package_name", "");
            bundle.putString("download_url", "");
        }
        bundle.putInt("filling_source", this.mBundle.getInt("filling_source"));
        TrackingManager.trackingTrigerShow(bundle);
        this.addToContextParam("ad_title", bundle.getString("ad_title"));
        this.addToContextParam("ad_url", "");
        this.addToContextParam("description", bundle.getString("description"));
        this.addToContextParam("image_url", bundle.getString("image_url"));
        this.addToContextParam("icon_url", bundle.getString("icon_url"));
        this.addToContextParam("endcard_url", "");
        this.addToContextParam("app_name", "");
        this.addToContextParam("package_name", "");
        this.addToContextParam("download_url", "");
    }

    protected void logClick() {
        Bundle bundle = new Bundle();
        this.appendContextParam(bundle);
        bundle.putInt("request_time", this.mBundle.getInt("request_time"));
        bundle.putLong("return_ts", this.mBundle.getLong("return_ts"));
        bundle.putInt("return_time", this.mBundle.getInt("return_time"));
        bundle.putLong("show_ts", this.mBundle.getLong("show_ts"));
        bundle.putLong("show_time", this.mBundle.getLong("show_time"));
        bundle.putLong("click_ts", System.currentTimeMillis());
        bundle.putInt("click_time", (int)(System.currentTimeMillis() - this.mImpressionTime));
        bundle.putString("ad_title", this.mBundle.getString("ad_title"));
        bundle.putString("ad_url", this.mBundle.getString("ad_url"));
        bundle.putInt("filling_source", this.mBundle.getInt("filling_source"));
        bundle.putString("description", this.mBundle.getString("description"));
        bundle.putString("image_url", this.mBundle.getString("image_url"));
        bundle.putString("icon_url", this.mBundle.getString("icon_url"));
        bundle.putString("endcard_url", this.mBundle.getString("app_name"));
        bundle.putString("app_name", this.mBundle.getString("app_name"));
        bundle.putString("package_name", this.mBundle.getString("package_name"));
        bundle.putString("download_url", this.mBundle.getString("download_url"));
        bundle.putInt("slot_height", this.mBundle.getInt("slot_height"));
        bundle.putInt("slot_width", this.mBundle.getInt("slot_width"));
        bundle.putInt("click_x", 0);
        bundle.putInt("click_y", 0);
        bundle.putInt("is_expired", this.isExpired() ? 1 : 0);
        TrackingManager.trackingAdClick(bundle);
    }

    protected void logClose() {
        Bundle bundle = new Bundle();
        this.appendContextParam(bundle);
        bundle.putInt("request_time", this.mBundle.getInt("request_time"));
        bundle.putLong("return_ts", this.mBundle.getLong("return_ts"));
        bundle.putInt("return_time", this.mBundle.getInt("return_time"));
        bundle.putLong("show_ts", this.mBundle.getLong("show_ts"));
        bundle.putLong("show_time", this.mBundle.getLong("show_time"));
        bundle.putLong("click_ts", System.currentTimeMillis());
        bundle.putInt("click_time", (int)(System.currentTimeMillis() - this.mImpressionTime));
        bundle.putString("ad_title", this.mBundle.getString("ad_title"));
        bundle.putString("ad_url", this.mBundle.getString("ad_url"));
        bundle.putInt("filling_source", this.mBundle.getInt("filling_source"));
        bundle.putString("description", this.mBundle.getString("description"));
        bundle.putString("image_url", this.mBundle.getString("image_url"));
        bundle.putString("icon_url", this.mBundle.getString("icon_url"));
        bundle.putString("endcard_url", this.mBundle.getString("endcard_url"));
        bundle.putString("app_name", this.mBundle.getString("app_name"));
        bundle.putString("package_name", this.mBundle.getString("package_name"));
        bundle.putString("download_url", this.mBundle.getString("download_url"));
        bundle.putInt("slot_height", 0);
        bundle.putInt("slot_width", 0);
        bundle.putInt("click_x", 0);
        bundle.putInt("click_y", 0);
        TrackingManager.trackingAdClose(bundle);
    }

    @Override
    public void destroyAd() {
        this.mContext = null;
        this.mAdRequestBody = null;
        this.listener = null;
        this.stopTimer();
    }

    @Override
    public void setRequestBody(TAdRequestBody tAdRequestBody) {
        this.mAdRequestBody = tAdRequestBody;
        if (tAdRequestBody != null) {
            this.listener = (WrapTAdAllianceListener)tAdRequestBody.getAdListener();
        }
    }

    @Override
    public TAdRequestBody getRequestBody() {
        return this.mAdRequestBody;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int n) {
        this.ttl = n;
    }

    @Override
    public boolean isExpired() {
        return this.getValidTimeLimit() <= 0L;
    }

    @Override
    public long getValidTimeLimit() {
        if (this.ttl <= 0) {
            return Long.MAX_VALUE;
        }
        return (long)(this.ttl * 60 * 1000) - Math.abs(System.currentTimeMillis() - this.startTime);
    }

    @Override
    public int getAdSource() {
        return this.adSource;
    }

    @Override
    public void setEcpmPrice(double d) {
        this.price = d;
    }

    @Override
    public double getEcpmPrice() {
        return this.price;
    }

    @Override
    public void setAdSource(int n) {
        this.adSource = n;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    @Override
    public String getPlacementId() {
        return this.mNetwork.codeSeatId;
    }

    @Override
    public void stopLoader() {
        if (this.isLoaded) {
            return;
        }
        this.destroyAd();
    }

    protected boolean supportTimer() {
        return false;
    }

    protected void startTimer() {
        if (this.runTimer == null) {
            this.runTimer = new RunTimer();
            this.runTimer.setScheduleTime(120000);
            this.runTimer.setTimeOutCallback(this.timeOutCallback);
        }
        this.runTimer.runTimerTask();
        AdLogUtil.Log().d(this.TAG, "\u542f\u52a8\u5e7f\u544a\u8bf7\u6c42\u8d85\u65f6\u76d1\u542c...");
    }

    protected void stopTimer() {
        if (this.runTimer != null) {
            this.runTimer.resetTimerTask();
            this.runTimer = null;
        }
    }

    public void onTimeOut() {
        this.isLoaded = true;
        this.adFailedToLoad(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
        this.destroyAd();
    }

    public void post(Handler handler, Runnable runnable) {
        if (handler != null) {
            handler.post(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public void setTrackingBundle(Bundle bundle) {
        if (null == bundle) {
            return;
        }
        this.mBundle.putAll(bundle);
    }

    protected void adTrackingRequest() {
        if (TextUtils.isEmpty((CharSequence)this.mRequestId)) {
            this.mRequestId = DeviceUtil.getUUID();
        }
        this.mBundle.putString("request_id", this.mRequestId);
        AdLogUtil.requestLog((String)("trackRequest/seatid---" + this.mRequestId + "/" + this.mBundle.get("code_seat_id") + "/" + this.mBundle.get("request_type")));
        this.mBundle.putInt("ad_count", this.mAdCount);
        this.mBundle.putInt("is_retreatad", 0);
        if (this.mIsDefaultAd) {
            this.mBundle.putInt("is_default_ad", 1);
        } else {
            this.mBundle.putInt("is_default_ad", 0);
        }
        this.mBundle.putString("cld_configure_id", AdxPreferencesHelper.getInstance().getString("cloudControlVersion"));
        this.mBundle.putInt("is_pre_trigger", this.mBundle.getInt("is_pre_trigger", 0));
        this.isPreTrigger = this.mBundle.getInt("is_pre_trigger", 0);
        TrackingManager.trackingAdRequest(this.mBundle);
    }

    private void adReturnTracking(Bundle bundle) {
        if (null == bundle || null == this.mBundle) {
            return;
        }
        if (this.mBundle.containsKey("cld_configure_id")) {
            this.mBundle.remove("cld_configure_id");
        }
        bundle.putString("trigger_id", this.mBundle.getString("trigger_id"));
        bundle.putLong("trigger_ts", this.mBundle.getLong("trigger_ts"));
        bundle.putLong("request_ts", this.mBundle.getLong("request_ts"));
        bundle.putInt("request_time", (int)(this.mBundle.getLong("request_ts") - this.mBundle.getLong("trigger_ts")));
        bundle.putString("request_id", this.mRequestId);
        AdLogUtil.requestLog((String)("trackReturn/seatid---" + this.mRequestId + "/" + this.mBundle.get("code_seat_id")));
        bundle.putLong("return_ts", System.currentTimeMillis());
        bundle.putInt("return_time", (int)(System.currentTimeMillis() - this.mBundle.getLong("request_ts")));
        bundle.putInt("ad_type", this.mBundle.getInt("ad_type"));
        bundle.putString("cld_app_id", this.mBundle.getString("cld_app_id"));
        bundle.putString("cld_code_seat_id", this.mBundle.getString("cld_code_seat_id"));
        bundle.putInt("platform", this.mBundle.getInt("platform"));
        bundle.putString("app_id", this.mBundle.getString("app_id"));
        bundle.putString("code_seat_id", this.mBundle.getString("code_seat_id"));
        bundle.putDouble("bidding_price", this.mBundle.getDouble("bidding_price"));
        bundle.putInt("priority", this.mBundle.getInt("priority"));
        bundle.putInt("ad_count", this.mBundle.getInt("ad_count"));
        bundle.putInt("is_retreatad", this.mBundle.getInt("is_retreatad"));
        bundle.putInt("is_default_ad", this.mBundle.getInt("is_default_ad"));
        bundle.putInt("is_pre_trigger", this.mBundle.getInt("is_pre_trigger", 0));
        bundle.putString("ad_title", this.mBundle.getString("ad_title"));
        bundle.putString("ad_url", this.mBundle.getString("ad_url"));
        bundle.putString("description", this.mBundle.getString("description"));
        bundle.putString("image_url", this.mBundle.getString("image_url"));
        bundle.putString("icon_url", this.mBundle.getString("icon_url"));
        bundle.putString("endcard_url", this.mBundle.getString("endcard_url"));
        bundle.putString("app_name", this.mBundle.getString("app_name"));
        bundle.putString("package_name", this.mBundle.getString("package_name"));
        bundle.putString("native_info_list", this.mBundle.getString("native_info_list"));
        bundle.putString("download_url", this.mBundle.getString("download_url"));
        TrackingManager.trackingAdReturn(bundle);
    }

    public void adBiddingTracking(Bundle bundle) {
        if (null == bundle || null == this.mBundle) {
            return;
        }
        this.fillParamsToBundle(bundle);
        TrackingManager.trackingAdBidding(bundle);
    }

    public void adBiddingReturnTracking(Bundle bundle) {
        if (null == bundle || null == this.mBundle) {
            return;
        }
        this.fillParamsToBundle(bundle);
        TrackingManager.trackingAdBiddingReturn(bundle);
    }

    private void fillParamsToBundle(Bundle bundle) {
        if (bundle != null && this.mBundle != null) {
            bundle.putString("trigger_id", this.mBundle.getString("trigger_id"));
            bundle.putInt("platform", this.mBundle.getInt("platform"));
            bundle.putString("app_id", this.mBundle.getString("app_id"));
            bundle.putString("code_seat_id", this.mBundle.getString("code_seat_id"));
            bundle.putString("cld_code_seat_id", this.mBundle.getString("cld_code_seat_id"));
            bundle.putString("cld_app_id", this.mBundle.getString("cld_app_id"));
            bundle.putInt("ad_type", this.mBundle.getInt("ad_type"));
        }
    }
}

