/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.base;

import android.content.Context;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.Preconditions;
import com.hisavana.common.base.BaseAd;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.interfacz.IadNative;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseNative
extends BaseAd
implements IadNative {
    private String TAG = "BaseNative";
    protected int mAdt;
    protected List<TAdNativeInfo> mNatives = new ArrayList<TAdNativeInfo>();
    private static final int defaultAdsCount = 1;
    protected static final int FILTER_NONE = 0;

    public BaseNative(Context context, Network network, int n) {
        super(context, network);
        this.mAdt = n;
    }

    public void setAdCount(int n) {
        this.mAdCount = n <= 0 ? 1 : n;
    }

    @Override
    public void loadAd() {
        super.loadAd();
        this.mNatives.clear();
        this.initNative();
        this.onNativeAdStartLoad();
    }

    protected abstract void onNativeAdStartLoad();

    protected abstract void initNative();

    protected boolean isNativeBanner() {
        return this.mAdt == 4;
    }

    @Override
    public void adLoaded(final List<TAdNativeInfo> list) {
        Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

            public void onRun() {
                BaseNative.super.adLoaded(list);
            }
        });
    }

    @Override
    protected void adFailedToLoad(final TAdErrorCode tAdErrorCode) {
        Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

            public void onRun() {
                BaseNative.super.adFailedToLoad(tAdErrorCode);
            }
        });
    }

    protected int filter(TAdNativeInfo tAdNativeInfo) {
        if (tAdNativeInfo == null) {
            return 9033;
        }
        if (this.isNativeBanner()) {
            boolean bl = tAdNativeInfo.isIconValid();
            AdLogUtil.Log().e(this.TAG, "ad nativebanner has icon:" + bl);
            return bl ? 0 : 9032;
        }
        boolean bl = tAdNativeInfo.isMaterielValid();
        AdLogUtil.Log().e(this.TAG, "ad native has meteriel:" + bl);
        return bl ? 0 : 9032;
    }

    @Override
    public int getAdType() {
        return this.mAdt;
    }

    @Override
    public void destroyAd() {
        super.destroyAd();
        for (TAdNativeInfo tAdNativeInfo : this.mNatives) {
            if (tAdNativeInfo == null) continue;
            tAdNativeInfo.release();
        }
        this.mNatives.clear();
    }

    public void setChoicesPosition(int n) {
    }
}

