/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.tracking;

import android.os.Bundle;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.transsion.athenacust.AthenaCust;

public class TrackingManager {
    public static final int TID = 8661;
    public static final int TRIGGER_TYPE_COLD = 1;
    public static final int TRIGGER_TYPE_NET = 2;
    public static final int CODE_ERROR = 1;
    public static final int CODE_SUCCESS = 0;

    private static void track(Bundle bundle, String string) {
        if (null == bundle) {
            return;
        }
        long l = System.currentTimeMillis();
        Bundle bundle2 = AthenaTracker.getBundle();
        AdLogUtil.Log().d("TrackingManager", "getBundle spend: " + (System.currentTimeMillis() - l));
        bundle2.putString("sdk_version", "1.2.1.22");
        bundle2.putAll(bundle);
        l = System.currentTimeMillis();
        new AthenaCust(string, 8661).trackCommon(bundle2, null).submit();
        AdLogUtil.Log().d("TrackingManager", "track spend: " + (System.currentTimeMillis() - l));
    }

    public static void trackingADCldRequest(Bundle bundle) {
        TrackingManager.track(bundle, "ad_cld_request");
    }

    public static void trackingCldReturn(Bundle bundle) {
        TrackingManager.track(bundle, "ad_cld_return");
    }

    public static void trackingADTrigger(Bundle bundle) {
        TrackingManager.track(bundle, "ad_trigger");
    }

    public static void trackingAdBidding(Bundle bundle) {
        TrackingManager.track(bundle, "inquiry_request");
    }

    public static void trackingAdBiddingReturn(Bundle bundle) {
        TrackingManager.track(bundle, "inquiry_return");
    }

    public static void trackingAdRequest(Bundle bundle) {
        TrackingManager.track(bundle, "ad_request");
    }

    public static void trackingAdReturn(Bundle bundle) {
        TrackingManager.track(bundle, "ad_return");
    }

    public static void trackingAdLoaded(Bundle bundle) {
        TrackingManager.track(bundle, "ad_filling");
    }

    public static void trackingTrigerShow(Bundle bundle) {
        TrackingManager.track(bundle, "ad_trigger_show");
    }

    public static void trackingAdClick(Bundle bundle) {
        TrackingManager.track(bundle, "ad_click");
    }

    public static void trackingAdClose(Bundle bundle) {
        TrackingManager.track(bundle, "ad_closure");
    }

    public static void trackingImpression(Bundle bundle) {
        TrackingManager.track(bundle, "ad_show");
    }

    public static void trackingErrorLog(Bundle bundle) {
        TrackingManager.track(bundle, "ad_error_log");
    }

    public static void trackingAdCancel(Bundle bundle) {
        TrackingManager.track(bundle, "ad_cancel");
    }
}

