/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.tracking;

import android.os.Bundle;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.transsion.athenacust.AthenaCust;

public class TrackingManager {
    public static final int TID = 8661;
    public static final int OFF_LINE_TID = 9339;
    public static final int TRIGGER_TYPE_COLD = 1;
    public static final int TRIGGER_TYPE_AD_FILLING = 3;
    public static final int TRIGGER_TYPE_DEFAULT_AD_FILLING = 4;
    public static final int TRIGGER_TYPE_AHA_ADD_IDS = 5;
    public static final int TRIGGER_TYPE_AD_UNIT_IS_CLOSED = 6;
    public static final int CODE_ERROR = 1;
    public static final int CODE_SUCCESS = 0;

    private static void track(Bundle bundle, String string) {
        TrackingManager.track(bundle, string, false);
    }

    private static void track(Bundle bundle, final String string, final boolean bl) {
        if (null == bundle) {
            return;
        }
        final Bundle bundle2 = new Bundle();
        bundle2.putAll(bundle);
        AthenaTracker.trackInNewThread((Runnable)new Runnable(){

            @Override
            public void run() {
                long l = System.currentTimeMillis();
                Bundle bundle = AthenaTracker.getBundle(null);
                AdLogUtil.Log().d("TrackingManager", "getBundle spend: " + (System.currentTimeMillis() - l));
                bundle.putString("sdk_version", "1.3.3.1");
                bundle.putAll(bundle2);
                l = System.currentTimeMillis();
                new AthenaCust(string, bl ? 9339 : 8661).trackCommon(bundle, null).submit();
                AdLogUtil.Log().d("TrackingManager", "track spend: " + (System.currentTimeMillis() - l));
            }
        });
    }

    public static void trackingADCldRequest(Bundle bundle) {
        TrackingManager.track(bundle, "ad_cld_request");
    }

    public static void trackingCldReturn(Bundle bundle) {
        TrackingManager.track(bundle, "ad_cld_return");
    }

    public static void trackingADTrigger(Bundle bundle, boolean bl) {
        TrackingManager.track(bundle, "ad_trigger", bl);
    }

    public static void trackingAdBidding(Bundle bundle) {
        TrackingManager.track(bundle, "inquiry_request");
    }

    public static void trackingAdBiddingReturn(Bundle bundle) {
        TrackingManager.track(bundle, "inquiry_return");
    }

    public static void trackingAdRequest(Bundle bundle, boolean bl) {
        TrackingManager.track(bundle, "ad_request", bl);
    }

    public static void trackingAdReturn(Bundle bundle, boolean bl) {
        TrackingManager.track(bundle, "ad_return", bl);
    }

    public static void trackingAdLoaded(Bundle bundle, boolean bl) {
        TrackingManager.track(bundle, "ad_filling", bl);
    }

    public static void trackingTrigerShow(Bundle bundle, boolean bl) {
        TrackingManager.track(bundle, "ad_trigger_show", bl);
    }

    public static void trackingAdClick(Bundle bundle, boolean bl) {
        TrackingManager.track(bundle, "ad_click", bl);
    }

    public static void trackingAdClose(Bundle bundle, boolean bl) {
        TrackingManager.track(bundle, "ad_closure", bl);
    }

    public static void trackingImpression(Bundle bundle, boolean bl) {
        TrackingManager.track(bundle, "ad_show", bl);
    }

    public static void trackingErrorLog(Bundle bundle) {
        TrackingManager.track(bundle, "ad_error_log");
    }

    public static void trackingAdCancel(Bundle bundle, boolean bl) {
        TrackingManager.track(bundle, "ad_cancel", bl);
    }

    public static void trackingStartBid(Bundle bundle) {
        TrackingManager.track(bundle, "ad_start_bid");
    }
}

