/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.base;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.hisavana.common.base.BaseAd;
import com.hisavana.common.base.WrapTadView;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.interfacz.IadView;

public abstract class BaseBanner<T extends View>
extends BaseAd
implements IadView {
    private String TAG = "BaseBanner";
    public static boolean isOptimized = true;

    public BaseBanner(Context context, Network network) {
        super(context, network);
    }

    @Override
    public int getAdType() {
        return 2;
    }

    @Override
    public void loadAd() {
        T t = this.getBanner();
        if (t != null) {
            super.loadAd();
            this.onBannerLoad();
        }
    }

    protected abstract T getBanner();

    protected abstract void onBannerLoad();

    @Override
    public void adLoaded() {
        if (!this.isLoaded) {
            super.adLoaded();
        } else {
            Bundle bundle = new Bundle();
            bundle.putInt("error_code", 0);
            this.adReturnTracking(bundle);
            AdLogUtil.Log().e(this.TAG, "banner have been Loaded, but refresh banner success ");
        }
    }

    @Override
    protected void adFailedToLoad(TAdErrorCode tAdErrorCode) {
        if (!this.isLoaded) {
            super.adFailedToLoad(tAdErrorCode);
        } else {
            int n;
            Bundle bundle = new Bundle();
            int n2 = n = tAdErrorCode != null ? tAdErrorCode.getErrorCode() : 100;
            if (n == 0) {
                n = 100;
            }
            bundle.putInt("error_code", n);
            bundle.putString("error_message", tAdErrorCode.getErrorMessage());
            this.adReturnTracking(bundle);
            AdLogUtil.Log().e(this.TAG, "banner have been Loaded, but refresh banner failed ");
        }
    }

    @Override
    public void show(WrapTadView wrapTadView) {
        T t = this.getBanner();
        if (t != null) {
            this.logTrigerShow();
            if (wrapTadView != null) {
                wrapTadView.removeAllViews();
                wrapTadView.onAddView((View)t);
            }
            this.showBanner();
        } else {
            AdLogUtil.Log().w(this.TAG, "banner is null ");
        }
    }

    protected abstract void showBanner();

    protected abstract void onBannerDestroy();

    @Override
    public void destroyAd() {
        super.destroyAd();
        this.isLoaded = false;
        T t = this.getBanner();
        if (t != null) {
            ViewParent viewParent = t.getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(t);
            }
            this.onBannerDestroy();
        }
        AdLogUtil.Log().d(this.TAG, "destroy");
    }
}

