/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.base;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.hisavana.common.base.BaseAd;
import com.hisavana.common.base.WrapTadView;
import com.hisavana.common.bean.Network;
import com.hisavana.common.interfacz.IadView;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.utils.ScreenUtil;

public abstract class BaseSplash<T extends View>
extends BaseAd
implements IadView {
    T splash;
    View logoLayout;
    private int orientation = 1;

    public BaseSplash(Context context, Network network) {
        super(context, network);
    }

    @Override
    public void loadAd() {
        this.splash = this.getSplash();
        if (this.splash != null) {
            super.loadAd();
            this.onSplashStartLoad();
        }
    }

    protected void onSkipClick() {
        if (this.listener != null) {
            this.listener.onSkipClick();
        }
    }

    protected void onTimeReach() {
        if (this.listener != null) {
            this.listener.onTimeReach();
        }
    }

    protected abstract void onSplashStartLoad();

    protected abstract T getSplash();

    public void addLogoLayout(View view) {
        this.logoLayout = view;
    }

    @Override
    public void show(WrapTadView wrapTadView) {
        T t = this.splash;
        if (t != null) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            wrapTadView.removeAllViews();
            if (t.getParent() != null) {
                ((ViewGroup)t.getParent()).removeView(t);
            }
            wrapTadView.addView((View)t, (ViewGroup.LayoutParams)layoutParams);
            wrapTadView.setVisibility(0);
            if (this.checkNeedAddLogo()) {
                this.addLogoLayout(wrapTadView, t, this.logoLayout);
            }
            this.onSplashShow();
            this.logTrigerShow();
        } else {
            AdLogUtil.Log().w("BaseSplash", "Splash is null " + this.getLogString());
            this.onTimeReach();
        }
    }

    private void addLogoLayout(WrapTadView wrapTadView, T t, View view) {
        if (view == null) {
            return;
        }
        int n = ScreenUtil.getWinHeight();
        int n2 = 0;
        if (n > 0) {
            n2 = (int)((double)n * 0.2);
        }
        if (n2 == 0) {
            return;
        }
        AdLogUtil.Log().d("BaseSplash", "addLogoLayout logoHeight = " + n2 + " screenHeight = " + n);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.setMargins(0, 0, 0, n2);
        t.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(-1, n2);
        layoutParams2.addRule(12);
        wrapTadView.addView(view, (ViewGroup.LayoutParams)layoutParams2);
    }

    protected boolean checkNeedAddLogo() {
        return false;
    }

    protected abstract void onSplashShow();

    @Override
    public int getAdType() {
        return 4;
    }

    @Override
    public void destroyAd() {
        if (null != this.splash && this.splash.getParent() != null) {
            ((ViewGroup)this.splash.getParent()).removeView(this.splash);
        }
        if (this.logoLayout != null && this.logoLayout.getParent() != null) {
            ((ViewGroup)this.logoLayout.getParent()).removeView(this.logoLayout);
        }
        this.logoLayout = null;
        this.splash = null;
        super.destroyAd();
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public int getOrientation() {
        return this.orientation;
    }
}

