/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.bean;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.hisavana.common.interfacz.ICacheAd;
import com.hisavana.common.mock.RecordTestInfo;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AdCache<T extends ICacheAd> {
    private static AdCacheComp mComparator = new AdCacheComp();
    HashMap<String, ArrayList<T>> map = new HashMap();
    private AdCacheExpiredWatcher watcher;
    private static final String TAG = "AdCache";
    private static final int CODE_SEAT_LIMIT_FIVE = 5;
    private static final int CODE_SEAT_LIMIT_TEN = 10;

    private ArrayList<T> getOrCreateList(String string) {
        ArrayList<Object> arrayList = this.map.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.map.put(string, arrayList);
        }
        return arrayList;
    }

    public void addCache(String string, @NonNull T t) {
        ArrayList<T> arrayList;
        if (t != null) {
            RecordTestInfo.record("add Cache list,AdSource is :" + t.getAdSource());
            t.detachContext();
        }
        if ((arrayList = this.getOrCreateList(string)).size() > this.getCodeSeatLimit(t)) {
            arrayList.remove(arrayList.size() - 1);
        }
        try {
            int n = Collections.binarySearch(arrayList, t, mComparator);
            if (n < 0) {
                n = -(n + 1);
            }
            arrayList.add(n, t);
            RecordTestInfo.record("add Cache list is :" + arrayList.size());
            AdLogUtil.Log().d(TAG, "*----> add Caches list is :" + arrayList.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addCaches(String string, List<T> list) {
        int n;
        for (ICacheAd iCacheAd : list) {
            if (iCacheAd == null) continue;
            RecordTestInfo.record("add Caches list,EcpmPrice is :" + iCacheAd.getEcpmPrice());
            iCacheAd.detachContext();
        }
        ArrayList<T> arrayList = this.getOrCreateList(string);
        if (list == null || list.size() == 0) {
            return;
        }
        int n2 = list.size();
        if (n2 <= (n = this.getCodeSeatLimit((ICacheAd)list.get(0)))) {
            while (n2 + arrayList.size() > n) {
                arrayList.remove(arrayList.size() - 1);
            }
        }
        arrayList.addAll(list);
        try {
            RecordTestInfo.record("add Caches list is :" + arrayList.size());
            AdLogUtil.Log().d(TAG, "*----> add Caches list is :" + arrayList.size());
            Collections.sort(arrayList, mComparator);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void removeCache(String string, T t) {
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList != null && arrayList.size() > 0) {
            AdLogUtil.Log().d(TAG, "---> Remove ad:" + t.getPlacementId() + " from cache");
            arrayList.remove(t);
        }
    }

    public boolean hasAd(String string, T t) {
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList.contains(t);
        }
        return false;
    }

    public T getCache(String string, boolean bl) {
        ICacheAd iCacheAd = null;
        ArrayList<T> arrayList = this.getCaches(string, 1, bl);
        if (arrayList != null && !arrayList.isEmpty()) {
            iCacheAd = (ICacheAd)arrayList.get(0);
        }
        return (T)iCacheAd;
    }

    public ArrayList<T> getCaches(@NonNull String string, int n, boolean bl) {
        Object object;
        ArrayList<Object> arrayList = null;
        ArrayList<T> arrayList2 = this.map.get(string);
        if (arrayList2 == null) {
            return arrayList;
        }
        Iterator<T> iterator = arrayList2.iterator();
        if (CoreUtil.isDebug()) {
            object = arrayList2.iterator();
            AdLogUtil.Log().d(TAG, "*----> current ad pool size is :" + arrayList2.size());
            while (object.hasNext()) {
                ICacheAd iCacheAd = (ICacheAd)object.next();
                AdLogUtil.Log().d(TAG, "---> ad: " + iCacheAd.getPlacementId() + "\uff0cprice\uff1a" + iCacheAd.getEcpmPrice());
            }
        }
        while (iterator.hasNext()) {
            object = (ICacheAd)iterator.next();
            if (null == object) continue;
            if (bl) {
                AdLogUtil.Log().d(TAG, "---> Remove ad:" + object.getPlacementId() + " from cache");
                iterator.remove();
            }
            if (object.isExpired()) {
                if (!bl) {
                    iterator.remove();
                }
                if (this.watcher != null) {
                    this.watcher.onExpired((ICacheAd)object);
                }
                object.destroyAd();
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
            }
            arrayList.add(object);
            if (arrayList.size() < n) continue;
            break;
        }
        return arrayList;
    }

    public ArrayList<T> getCaches(@NonNull String string, int n, boolean bl, boolean bl2) {
        ICacheAd iCacheAd;
        Object object;
        if (!bl2) {
            return this.getCaches(string, n, bl);
        }
        ArrayList<ICacheAd> arrayList = null;
        ArrayList<T> arrayList2 = this.map.get(string);
        if (arrayList2 == null) {
            return arrayList;
        }
        int n2 = -1;
        Iterator<T> iterator = arrayList2.iterator();
        if (CoreUtil.isDebug()) {
            object = arrayList2.iterator();
            AdLogUtil.Log().d(TAG, "*----> current ad pool size is :" + arrayList2.size());
            while (object.hasNext()) {
                iCacheAd = (ICacheAd)object.next();
                AdLogUtil.Log().d(TAG, "---> ad: " + iCacheAd.getPlacementId() + "\uff0cprice\uff1a" + iCacheAd.getEcpmPrice());
            }
        }
        object = new ArrayList();
        while (iterator.hasNext()) {
            iCacheAd = (ICacheAd)iterator.next();
            if (null == iCacheAd || n2 != -1 && n2 != iCacheAd.getAdSource()) continue;
            if (n2 == -1) {
                n2 = iCacheAd.getAdSource();
            }
            if (bl) {
                AdLogUtil.Log().d(TAG, "---> Remove ad:" + iCacheAd.getPlacementId() + " from cache");
                iterator.remove();
            }
            if (iCacheAd.isExpired()) {
                if (!bl) {
                    iterator.remove();
                }
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<ICacheAd>();
            }
            if (!TextUtils.isEmpty((CharSequence)iCacheAd.getFilterSource())) {
                if (object.contains(iCacheAd.getFilterSource())) continue;
                object.add(iCacheAd.getFilterSource());
            }
            arrayList.add(iCacheAd);
            if (arrayList.size() < n) continue;
            break;
        }
        return arrayList;
    }

    public void updateSecondPrice(T t, String string) {
        double d;
        if (t != null && t.getAdSource() == 0 && (d = this.getMaxPrice(string, t)) > 0.0) {
            t.setSecondPrice(d);
        }
    }

    private double getMaxPrice(String string, T t) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return d;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            if (t != null && t == iCacheAd) {
                AdLogUtil.Log().d("ssp_second_price", "*----> getMaxPrice updateSecondPrice()\uff0cexcludeAd == iteratorAd");
                continue;
            }
            AdLogUtil.Log().d(TAG, "*----> max ad in pool is :" + iCacheAd.getPlacementId() + ",EcpmPrice is :" + iCacheAd.getEcpmPrice() + ",AdSource is :" + iCacheAd.getAdSource() + ",isDefaultAd :" + iCacheAd.isDefaultAd() + ",ValidTimeLimit :" + iCacheAd.getValidTimeLimit());
            d = iCacheAd.getEcpmPrice();
            break;
        }
        return d;
    }

    public double getMaxPrice(String string) {
        return this.getMaxPrice(string, null);
    }

    public boolean hasAds(String string) {
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return false;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            return true;
        }
        return false;
    }

    public int getAdNum(String string) {
        int n = 0;
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return n;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            ++n;
            AdLogUtil.Log().d(TAG, "*----> ad in pool is :" + iCacheAd.getPlacementId() + ",EcpmPrice is :" + iCacheAd.getEcpmPrice() + ",AdSource is :" + iCacheAd.getAdSource() + ",isDefaultAd :" + iCacheAd.isDefaultAd() + ",ValidTimeLimit :" + iCacheAd.getValidTimeLimit());
        }
        return n;
    }

    public int getAdNum(String string, int n, String string2) {
        int n2 = 0;
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return n2;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            if (iCacheAd.getAdSource() != n || !TextUtils.equals((CharSequence)iCacheAd.getPlacementId(), (CharSequence)string2)) continue;
            ++n2;
        }
        return n2;
    }

    public double getNetworkPrice(String string, int n, String string2) {
        double d = 0.0;
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return d;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            if (iCacheAd.getAdSource() != n || !TextUtils.equals((CharSequence)iCacheAd.getPlacementId(), (CharSequence)string2)) continue;
            d = iCacheAd.getEcpmPrice();
            break;
        }
        return d;
    }

    public void registerWatcher(AdCacheExpiredWatcher adCacheExpiredWatcher) {
        this.watcher = adCacheExpiredWatcher;
    }

    public void unRegisterWatcher() {
        this.watcher = null;
    }

    public void removeAll() {
        this.map.clear();
    }

    private int getCodeSeatLimit(T t) {
        if (t == null || t.getAdSeatType() == null) {
            return 5;
        }
        return "Hotapps".equals(t.getAdSeatType()) ? 10 : 5;
    }

    public static interface AdCacheExpiredWatcher {
        public void onExpired(ICacheAd var1);
    }

    public static class AdCacheComp
    implements Comparator<ICacheAd> {
        @Override
        public int compare(ICacheAd iCacheAd, ICacheAd iCacheAd2) {
            try {
                if (iCacheAd.isExpired() && !iCacheAd2.isExpired()) {
                    return 1;
                }
                if (!iCacheAd.isExpired() && iCacheAd2.isExpired()) {
                    return -1;
                }
                if (iCacheAd.getEcpmPrice() == iCacheAd2.getEcpmPrice()) {
                    if (iCacheAd.getValidTimeLimit() - iCacheAd2.getValidTimeLimit() < 0L) {
                        return -1;
                    }
                    if (iCacheAd.getValidTimeLimit() - iCacheAd2.getValidTimeLimit() > 0L) {
                        return 1;
                    }
                    return 0;
                }
                if (iCacheAd.getEcpmPrice() > iCacheAd2.getEcpmPrice()) {
                    return -1;
                }
                return 1;
            }
            catch (Throwable throwable) {
                return 0;
            }
        }
    }
}

