/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.base;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.hisavana.common.bean.Network;
import com.hisavana.common.interfacz.QueryPriceListener;
import com.hisavana.common.tracking.TrackingManager;

public abstract class BaseQueryPrice {
    private long mInquiryStartTime;
    protected final Handler mMainHandler = new Handler(Looper.getMainLooper());
    protected QueryPriceListener mQueryPriceListener = null;
    public final Bundle mBundle = new Bundle();
    private Network mNetwork = null;

    public Network getNetwork() {
        return this.mNetwork;
    }

    public void setNetwork(Network network) {
        this.mNetwork = network;
    }

    public void setTrackingBundle(Bundle bundle) {
        this.mBundle.putAll(bundle);
    }

    public void setQueryPriceListener(QueryPriceListener queryPriceListener) {
        this.mQueryPriceListener = queryPriceListener;
    }

    public abstract void setBannerSize(int var1);

    public abstract void queryPrice(Context var1, Network var2);

    public void destroy() {
        this.mQueryPriceListener = null;
    }

    public void trackingBiddingStart() {
        Bundle bundle = new Bundle();
        this.mInquiryStartTime = System.currentTimeMillis();
        bundle.putLong("inquiry_request_ts", this.mInquiryStartTime);
        this.fillParamsToBundle(bundle);
        TrackingManager.trackingAdBidding(bundle);
    }

    public void trackingBiddingSuccess(double d) {
        Bundle bundle = new Bundle();
        long l = System.currentTimeMillis();
        bundle.putLong("inquiry_return_ts", l);
        bundle.putInt("error_code", 0);
        bundle.putDouble("bidding_price", d);
        bundle.putLong("inquiry_return_time", l - this.mInquiryStartTime);
        this.fillParamsToBundle(bundle);
        TrackingManager.trackingAdBiddingReturn(bundle);
    }

    public void trackingBiddingFailed(int n, String string) {
        Bundle bundle = new Bundle();
        long l = System.currentTimeMillis();
        bundle.putLong("inquiry_return_ts", l);
        bundle.putLong("inquiry_return_time", l - this.mInquiryStartTime);
        bundle.putInt("error_code", n);
        bundle.putDouble("bidding_price", 0.0);
        bundle.putString("error_message", string);
        this.fillParamsToBundle(bundle);
        TrackingManager.trackingAdBiddingReturn(bundle);
    }

    private void fillParamsToBundle(Bundle bundle) {
        if (bundle != null && this.mBundle != null) {
            bundle.putString("trigger_id", this.mBundle.getString("trigger_id"));
            bundle.putInt("platform", this.mBundle.getInt("platform"));
            bundle.putString("app_id", this.mBundle.getString("app_id"));
            bundle.putString("code_seat_id", this.mBundle.getString("code_seat_id"));
            bundle.putString("cld_code_seat_id", this.mBundle.getString("cld_code_seat_id"));
            bundle.putString("cld_app_id", this.mBundle.getString("cld_app_id"));
            bundle.putInt("ad_type", this.mBundle.getInt("ad_type"));
            bundle.putInt("is_pre_trigger", this.mBundle.getInt("is_pre_trigger"));
        }
    }
}

