/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.manager;

import android.os.SystemClock;
import android.text.TextUtils;
import com.hisavana.common.interfacz.Iad;
import com.hisavana.common.utils.ABConfig;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RequestingAdManager<T extends Iad> {
    private static final String TAG = "RequestingAdManager";
    private final Map<String, List<T>> requestingAdMap = new HashMap<String, List<T>>();
    private static final int REQUEST_CONTINUOUS_TIME = 4000;

    public static RequestingAdManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public T getRequest(String string, String string2) {
        List<T> list;
        if (CoreUtil.isDebug()) {
            AdLogUtil.Log().e(TAG, "start-----------------getRequest,placementid: " + string2 + "---------------------------->");
            AdLogUtil.Log().e(TAG, "get request from RequestingAdManager,placementid: " + string2);
            list = new StringBuffer();
            Iterator<Object> iterator = this.requestingAdMap.entrySet().iterator();
            ((StringBuffer)((Object)list)).append("[");
            while (iterator.hasNext()) {
                Object object = (Map.Entry)iterator.next();
                for (Iad iad : (List)object.getValue()) {
                    if (iad == null) continue;
                    ((StringBuffer)((Object)list)).append("{");
                    ((StringBuffer)((Object)list)).append(iad.getAdUnit());
                    ((StringBuffer)((Object)list)).append(",");
                    ((StringBuffer)((Object)list)).append(iad.getPlacementId());
                    ((StringBuffer)((Object)list)).append(",");
                    ((StringBuffer)((Object)list)).append(SystemClock.uptimeMillis() - iad.getRequestTime());
                    ((StringBuffer)((Object)list)).append("}");
                    ((StringBuffer)((Object)list)).append(",");
                }
            }
            ((StringBuffer)((Object)list)).append("]");
            AdLogUtil.Log().e(TAG, "current request list: " + ((StringBuffer)((Object)list)).toString());
            AdLogUtil.Log().e(TAG, "end--------------------getRequest->");
        }
        if (!ABConfig.getABValue(string)) {
            return null;
        }
        list = this.requestingAdMap.get(string);
        if (list == null) {
            return null;
        }
        for (Object object : list) {
            if (object == null || object.getNetwork() == null || !TextUtils.equals((CharSequence)object.getNetwork().getCodeSeatId(), (CharSequence)string2) || SystemClock.uptimeMillis() - object.getRequestTime() > 4000L) continue;
            return (T)object;
        }
        return null;
    }

    public boolean addRequest(T t) {
        Object object;
        if (CoreUtil.isDebug()) {
            AdLogUtil.Log().e(TAG, "start-----------------------addRequest,placementid: " + t.getPlacementId() + "----------------------->");
            AdLogUtil.Log().e(TAG, "add request to RequestingAdManager,placementid: " + t.getPlacementId());
            object = new StringBuffer();
            Iterator<Map.Entry<String, List<T>>> iterator = this.requestingAdMap.entrySet().iterator();
            ((StringBuffer)object).append("[");
            while (iterator.hasNext()) {
                Map.Entry<String, List<T>> entry = iterator.next();
                for (Iad iad : entry.getValue()) {
                    if (iad == null) continue;
                    ((StringBuffer)object).append("{");
                    ((StringBuffer)object).append(iad.getAdUnit());
                    ((StringBuffer)object).append(",");
                    ((StringBuffer)object).append(iad.getPlacementId());
                    ((StringBuffer)object).append(",");
                    ((StringBuffer)object).append(SystemClock.uptimeMillis() - iad.getRequestTime());
                    ((StringBuffer)object).append("}");
                    ((StringBuffer)object).append(",");
                }
            }
            ((StringBuffer)object).append("]");
            AdLogUtil.Log().e(TAG, "current request list: " + ((StringBuffer)object).toString());
            AdLogUtil.Log().e(TAG, "end--------------------addRequest->");
        }
        if (t == null) {
            return false;
        }
        if (!ABConfig.getABValue(t.getAdUnit())) {
            return false;
        }
        t.setRequestTime(SystemClock.uptimeMillis());
        object = this.requestingAdMap.get(t.getAdUnit());
        if (object == null) {
            object = new ArrayList<T>();
        }
        object.add(t);
        this.requestingAdMap.put(t.getAdUnit(), (List<T>)object);
        return true;
    }

    public boolean removeRequest(T t) {
        if (t == null) {
            return false;
        }
        if (!ABConfig.getABValue(t.getAdUnit())) {
            return false;
        }
        List<T> list = this.requestingAdMap.get(t.getAdUnit());
        if (list != null) {
            AdLogUtil.Log().e(TAG, "RequestingAdManager remove placementid: " + t.getPlacementId());
            return list.remove(t);
        }
        return false;
    }

    private static class SingletonHolder {
        private static final RequestingAdManager INSTANCE = new RequestingAdManager();

        private SingletonHolder() {
        }
    }
}

