/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.base;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.cloud.sdk.commonutil.gsonutil.GsonUtil;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.cloud.sdk.commonutil.util.RunTimer;
import com.hisavana.common.bean.AdCache;
import com.hisavana.common.bean.AdNativeInfo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.bean.TAdRequestBody;
import com.hisavana.common.interfacz.Iad;
import com.hisavana.common.interfacz.WrapTAdAllianceListener;
import com.hisavana.common.manager.AdCacheManager;
import com.hisavana.common.manager.RequestingAdManager;
import com.hisavana.common.mock.RecordTestInfo;
import com.hisavana.common.tracking.TrackingManager;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.common.utils.MediaLogUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseAd
implements Iad {
    private boolean isTimeOut = false;
    protected String mAdUnit;
    protected String adSeatType;
    protected List<String> adShowCreativeIds;
    protected List<String> adClickCreativeIds;
    protected boolean isOfflineAd;
    private int supportHisavanaFlag = 0;
    private double maxPrice;
    protected int mAdCount = 1;
    protected WeakReference<Context> mContext;
    private String TAG = "BaseAd";
    private double price = 0.0;
    public double secondPrice;
    private int ttl;
    private int adSource;
    protected long startTime;
    protected TAdRequestBody mAdRequestBody;
    protected boolean isLoaded = false;
    protected RunTimer runTimer;
    protected WrapTAdAllianceListener listener;
    private long mLoadedTime;
    private long mImpressionTime;
    protected final Network mNetwork;
    private int mLoadStatus;
    protected int requestType;
    private int mRequestRound = -1;
    public final Bundle mBundle = new Bundle();
    protected String mRequestId = null;
    protected String mTriggerId = null;
    private boolean isDestroyed = false;
    protected RunTimer.TimeOutCallback timeOutCallback = new RunTimer.TimeOutCallback(){

        public void isTimeOut() {
            AdLogUtil.Log().d(BaseAd.this.TAG, "Load ad is time out" + BaseAd.this.getLogString());
            BaseAd.this.onTimeOut();
        }
    };
    private long requestTime;

    @Override
    public void setTimeOut(boolean bl) {
        this.isTimeOut = bl;
    }

    public BaseAd(Context context, Network network) {
        this.mContext = new WeakReference<Context>(context);
        Preconditions.checkNotNull((Object)network);
        this.mNetwork = network;
    }

    @Override
    public void setSecondPrice(double d) {
        AdLogUtil.Log().d("ssp_second_price", "*----> BaseAd setSecondPrice price" + d + this.getLogString());
        this.secondPrice = d;
    }

    public String getLogString() {
        return "----- class name = " + this.getClass().getSimpleName() + " ----- mAdUnit = " + this.mAdUnit;
    }

    @Override
    public void setRequestRound(int n) {
        AdLogUtil.Log().d(this.TAG, "setRequestRound " + n + " " + this.getLogString());
        this.mRequestRound = n;
    }

    @Override
    public void setRequestType(int n) {
        this.requestType = n;
    }

    @Override
    public boolean isAdxAd() {
        return false;
    }

    @Override
    public boolean isEwAd() {
        return false;
    }

    @Override
    public void loadAd() {
        this.mRequestId = DeviceUtil.getUUID();
        this.startTime = System.currentTimeMillis();
        if (this.listener != null) {
            this.listener.onStart(this.getAdSource());
        }
        if (this.supportTimer()) {
            this.startTimer();
        }
        this.adTrackingRequest();
        if (this.mNetwork != null) {
            MediaLogUtil.d(this.TAG, "loadAd adSource " + this.mNetwork.getSource() + " id " + this.mNetwork.getCodeSeatId() + " " + this.getLogString());
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAdUnit)) {
            RequestingAdManager.getInstance().addRequest(this);
        }
    }

    private void adLoadedTemp() {
        RequestingAdManager.getInstance().removeRequest(this);
        if (this.isLoaded) {
            AdLogUtil.Log().d(this.TAG, "Ad request has been destroyed or loaded,isLoaded = " + this.isLoaded + ",isDestroyed = " + this.isDestroyed);
            return;
        }
        if (this.mNetwork != null) {
            MediaLogUtil.d(this.TAG, "loadSuccess adSource " + this.mNetwork.getSource() + " id " + this.mNetwork.getCodeSeatId() + " " + this.getLogString());
        }
        WrapTAdAllianceListener wrapTAdAllianceListener = this.listener;
        AdCache adCache = AdCacheManager.getCache(this.getAdType());
        if (adCache != null) {
            adCache.addCache(this.mAdUnit, this);
        }
        Bundle bundle = new Bundle();
        bundle.putInt("error_code", 0);
        bundle.putInt("request_num", this.mAdCount);
        this.adReturnTracking(bundle);
        this.isLoaded = true;
        this.mLoadedTime = System.currentTimeMillis();
        if (wrapTAdAllianceListener != null) {
            wrapTAdAllianceListener.onLoad(this.getAdSource());
        }
        if (this.supportTimer()) {
            this.stopTimer();
        }
    }

    public void adLoaded() {
        this.adLoadedTemp();
    }

    private void adLoadedTemp(List<TAdNativeInfo> list) {
        RequestingAdManager.getInstance().removeRequest(this);
        if (this.isLoaded) {
            AdLogUtil.Log().d(this.TAG, "Ad request has been destroyed or loaded,isLoaded = " + this.isLoaded + ",isDestroyed = " + this.isDestroyed);
            return;
        }
        if (this.mNetwork != null) {
            MediaLogUtil.d(this.TAG, "loadSuccess adSource " + this.mNetwork.getSource() + " id " + this.mNetwork.getCodeSeatId() + " " + this.getLogString());
        }
        WrapTAdAllianceListener wrapTAdAllianceListener = this.listener;
        AdCache adCache = AdCacheManager.getCache(this.getAdType());
        if (list != null && list.size() > 0 && adCache != null) {
            adCache.addCaches(this.mAdUnit, list);
        }
        Bundle bundle = new Bundle();
        bundle.putInt("error_code", 0);
        if (list != null && list.size() > 0) {
            TAdNativeInfo tAdNativeInfo = list.get(0);
            if (tAdNativeInfo.getEcpmPrice() > 0.0) {
                this.price = tAdNativeInfo.getEcpmPrice();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TAdNativeInfo tAdNativeInfo2 : list) {
                if (tAdNativeInfo2 == null) continue;
                arrayList.add(tAdNativeInfo2.getAdCreateId());
            }
            bundle.putString("ad_creative_ids", GsonUtil.toJson(arrayList));
        }
        this.adReturnTracking(bundle);
        this.isLoaded = true;
        this.mLoadedTime = System.currentTimeMillis();
        if (wrapTAdAllianceListener != null) {
            wrapTAdAllianceListener.onLoad(list, this.getAdSource());
        }
        if (this.supportTimer()) {
            this.stopTimer();
        }
    }

    public void adLoaded(List<TAdNativeInfo> list) {
        this.adLoadedTemp(list);
    }

    private void adFailedToLoadTemp(TAdErrorCode tAdErrorCode) {
        int n;
        RequestingAdManager.getInstance().removeRequest(this);
        if (this.isLoaded) {
            AdLogUtil.Log().d(this.TAG, "Ad request has been destroyed or loaded,isLoaded = " + this.isLoaded + ",isDestroyed = " + this.isDestroyed);
            return;
        }
        this.isLoaded = true;
        Bundle bundle = new Bundle();
        int n2 = n = tAdErrorCode != null ? tAdErrorCode.getErrorCode() : 100;
        if (n == 0) {
            n = 100;
        }
        bundle.putInt("error_code", n);
        bundle.putString("error_message", null == tAdErrorCode ? "null" : tAdErrorCode.getErrorMessage());
        bundle.putInt("request_num", this.mAdCount);
        this.adReturnTracking(bundle);
        if (this.listener != null) {
            this.listener.onError(tAdErrorCode);
        }
        if (this.supportTimer()) {
            this.stopTimer();
        }
        this.destroyAd();
    }

    protected void adFailedToLoad(TAdErrorCode tAdErrorCode) {
        this.adFailedToLoadTemp(tAdErrorCode);
    }

    protected void onAdShowError(TAdErrorCode tAdErrorCode) {
        this.logImpression(false);
        if (this.listener != null) {
            this.listener.onShowError(tAdErrorCode);
        }
    }

    protected void adImpression(AdNativeInfo adNativeInfo) {
        this.logImpression(true);
        this.mImpressionTime = System.currentTimeMillis();
        if (this.listener != null) {
            this.listener.onShow(this.getAdSource(), adNativeInfo);
        }
    }

    @Override
    public boolean isSupportRtBidding() {
        return false;
    }

    public boolean isSupportStopRequest() {
        return false;
    }

    @Override
    public Network getNetwork() {
        return this.mNetwork;
    }

    @Override
    public String getAdSeatType() {
        return this.adSeatType;
    }

    public void setAdSeatType(String string) {
        this.adSeatType = string;
    }

    protected void adClicked(AdNativeInfo adNativeInfo) {
        this.logClick();
        if (this.listener != null) {
            this.listener.onClicked(this.getAdSource(), adNativeInfo);
        }
    }

    @Override
    public void setLoadStatus(int n) {
        this.mLoadStatus = n;
    }

    @Override
    public int getLoadStatus() {
        return this.mLoadStatus;
    }

    protected void adClosed() {
        this.logClose();
        if (this.listener != null) {
            this.listener.onClosed(this.getAdSource());
        }
    }

    protected void adClosed(TAdNativeInfo tAdNativeInfo) {
        this.logClose();
        if (this.listener != null) {
            this.listener.onClosed(tAdNativeInfo);
        }
    }

    protected void onReward() {
        if (this.listener != null) {
            this.listener.onRewarded();
        }
    }

    private void appendContextParam(Bundle bundle) {
        bundle.putString("trigger_id", this.mBundle.getString("trigger_id"));
        bundle.putLong("trigger_ts", this.mBundle.getLong("trigger_ts"));
        bundle.putInt("ad_type", this.mBundle.getInt("ad_type"));
        bundle.putString("cld_app_id", this.mBundle.getString("cld_app_id"));
        bundle.putString("cld_code_seat_id", this.mBundle.getString("cld_code_seat_id"));
        bundle.putInt("platform", this.mBundle.getInt("platform"));
        bundle.putString("app_id", this.mBundle.getString("app_id"));
        bundle.putString("code_seat_id", this.mBundle.getString("code_seat_id"));
        bundle.putDouble("bidding_price", this.mBundle.getDouble("bidding_price"));
        bundle.putInt("priority", this.mBundle.getInt("priority"));
        bundle.putInt("ad_count", this.mBundle.getInt("ad_count"));
        bundle.putInt("is_retreatad", this.mBundle.getInt("is_retreatad"));
        bundle.putInt("is_default_ad", 0);
        bundle.putLong("request_ts", this.mBundle.getLong("request_ts"));
        bundle.putInt("request_time", this.mBundle.getInt("request_time"));
        bundle.putString("request_id", this.mBundle.getString("request_id"));
        bundle.putLong("return_ts", this.mBundle.getLong("return_ts"));
        bundle.putInt("return_time", this.mBundle.getInt("return_time"));
        bundle.putInt("request_type", this.mBundle.getInt("request_type"));
    }

    private void addToContextParam(String string, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Integer) {
            this.mBundle.putInt(string, ((Integer)object).intValue());
        } else if (object instanceof String) {
            this.mBundle.putString(string, (String)object);
        } else if (object instanceof Long) {
            this.mBundle.putLong(string, ((Long)object).longValue());
        }
    }

    protected void logImpression(boolean bl) {
        Bundle bundle = new Bundle();
        this.appendContextParam(bundle);
        bundle.putLong("show_ts", System.currentTimeMillis());
        bundle.putLong("show_time", System.currentTimeMillis() - this.mLoadedTime);
        bundle.putString("ad_title", this.mBundle.getString("ad_title"));
        bundle.putString("ad_url", this.mBundle.getString("ad_url"));
        bundle.putInt("filling_source", this.mBundle.getInt("filling_source"));
        bundle.putString("description", this.mBundle.getString("description"));
        bundle.putString("image_url", this.mBundle.getString("image_url"));
        bundle.putString("icon_url", this.mBundle.getString("icon_url"));
        bundle.putString("endcard_url", this.mBundle.getString("endcard_url"));
        bundle.putString("app_name", this.mBundle.getString("app_name"));
        bundle.putString("package_name", this.mBundle.getString("package_name"));
        bundle.putString("download_url", this.mBundle.getString("download_url"));
        bundle.putInt("ad_trigger_status", this.mBundle.getInt("ad_trigger_status"));
        bundle.putInt("is_offline_ad", this.isOfflineAd() ? 1 : 0);
        bundle.putInt("filling_ad_type", this.mBundle.getInt("filling_ad_type"));
        bundle.putInt("slot_height", 0);
        bundle.putInt("slot_width", 0);
        bundle.putInt("is_expired", this.isExpired() ? 1 : 0);
        if (bl) {
            bundle.putInt("show_status", 1);
            bundle.putInt("fail_reason", 0);
        } else {
            bundle.putInt("show_status", 2);
            bundle.putInt("fail_reason", 2);
        }
        bundle.putInt("is_pre_trigger", this.mBundle.getInt("is_pre_trigger"));
        bundle.putInt("filling_source", this.mBundle.getInt("filling_source"));
        bundle.putString("request_id", this.mBundle.getString("request_id"));
        bundle.putInt("request_num", this.mBundle.getInt("request_num"));
        String string = this.getAdShowCreativeIdsBundle();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putString("ad_creative_ids", string);
        }
        bundle.putString("traffic_group_id", this.mBundle.getString("traffic_group_id"));
        bundle.putString("experiment_group_id", this.mBundle.getString("experiment_group_id"));
        bundle.putInt("optimize_status", this.mBundle.getInt("optimize_status"));
        bundle.putInt("priority_code", this.mBundle.getInt("priority_code"));
        if (this.maxPrice == 0.0) {
            this.maxPrice = this.mBundle.getDouble("max_price");
        }
        bundle.putDouble("max_price", this.maxPrice);
        TrackingManager.trackingImpression(bundle);
        this.addToContextParam("show_ts", bundle.getLong("show_ts"));
        this.addToContextParam("show_time", bundle.getLong("show_time"));
        this.addToContextParam("slot_height", bundle.getInt("slot_height"));
        this.addToContextParam("slot_width", bundle.getInt("slot_width"));
        this.addToContextParam("show_status", bundle.getInt("show_status"));
        this.addToContextParam("fail_reason", bundle.getInt("fail_reason"));
        this.mBundle.putDouble("max_price", bundle.getDouble("max_price"));
    }

    @Override
    public String getAdUnit() {
        return this.mAdUnit;
    }

    @Override
    public void setAdUnit(String string) {
        this.mAdUnit = string;
    }

    protected void logTrigerShow() {
        this.trigerShow(null);
    }

    protected void logTrigerShow(TAdNativeInfo tAdNativeInfo) {
        this.trigerShow(tAdNativeInfo);
    }

    protected void trigerShow(TAdNativeInfo tAdNativeInfo) {
        if (null != tAdNativeInfo) {
            this.mBundle.putString("trigger_id", tAdNativeInfo.getTriggerId());
            this.mBundle.putLong("trigger_ts", tAdNativeInfo.getTriggerTs().longValue());
            this.mBundle.putDouble("max_price", tAdNativeInfo.getMaxPrice());
        }
        Bundle bundle = new Bundle();
        this.appendContextParam(bundle);
        if (bundle.containsKey("is_default_ad")) {
            bundle.remove("is_default_ad");
        }
        bundle.putInt("is_timeout", this.mBundle.getInt("is_timeout"));
        bundle.putString("error_code", this.mBundle.getString("error_code"));
        bundle.putString("error_message", this.mBundle.getString("error_message"));
        if (tAdNativeInfo != null) {
            bundle.putString("ad_title", tAdNativeInfo.getTitle());
            bundle.putString("ad_url", "");
            bundle.putString("description", tAdNativeInfo.getDescription());
            if (null != tAdNativeInfo.getImageList() && tAdNativeInfo.getImageList().size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (TAdNativeInfo.Image image : tAdNativeInfo.getImageList()) {
                    if (image == null || TextUtils.isEmpty((CharSequence)image.getUrl())) continue;
                    arrayList.add(image.getUrl());
                }
                bundle.putString("image_url", GsonUtil.toJson(arrayList));
            }
            if (null != tAdNativeInfo.getIcon()) {
                bundle.putString("icon_url", tAdNativeInfo.getIcon().getUrl());
            }
            bundle.putString("endcard_url", "");
            bundle.putString("app_name", "");
            bundle.putString("package_name", "");
            bundle.putString("download_url", "");
            if ("Hotapps".equals(tAdNativeInfo.getAdSeatType())) {
                if (this.adShowCreativeIds == null) {
                    this.adShowCreativeIds = new ArrayList<String>();
                }
                this.adShowCreativeIds.add(tAdNativeInfo.getAdCreateId());
            }
        }
        bundle.putInt("is_pre_trigger", this.mBundle.getInt("is_pre_trigger"));
        bundle.putInt("filling_source", this.mBundle.getInt("filling_source"));
        bundle.putString("request_id", this.mBundle.getString("request_id"));
        bundle.putInt("ad_trigger_status", this.mBundle.getInt("ad_trigger_status"));
        bundle.putInt("is_offline_ad", this.isOfflineAd() ? 1 : 0);
        bundle.putInt("filling_ad_type", this.mBundle.getInt("filling_ad_type"));
        bundle.putString("traffic_group_id", this.mBundle.getString("traffic_group_id"));
        bundle.putString("experiment_group_id", this.mBundle.getString("experiment_group_id"));
        TrackingManager.trackingTrigerShow(bundle);
        this.addToContextParam("ad_title", bundle.getString("ad_title"));
        this.addToContextParam("ad_url", "");
        this.addToContextParam("description", bundle.getString("description"));
        this.addToContextParam("image_url", bundle.getString("image_url"));
        this.addToContextParam("icon_url", bundle.getString("icon_url"));
        this.addToContextParam("endcard_url", "");
        this.addToContextParam("app_name", "");
        this.addToContextParam("package_name", "");
        this.addToContextParam("download_url", "");
        this.addToContextParam("request_num", this.mAdCount);
    }

    protected void logClick() {
        Bundle bundle = new Bundle();
        this.appendContextParam(bundle);
        bundle.putInt("request_time", this.mBundle.getInt("request_time"));
        bundle.putLong("return_ts", this.mBundle.getLong("return_ts"));
        bundle.putInt("return_time", this.mBundle.getInt("return_time"));
        bundle.putLong("show_ts", this.mBundle.getLong("show_ts"));
        bundle.putLong("show_time", this.mBundle.getLong("show_time"));
        bundle.putLong("click_ts", System.currentTimeMillis());
        bundle.putInt("click_time", (int)(System.currentTimeMillis() - this.mImpressionTime));
        bundle.putString("ad_title", this.mBundle.getString("ad_title"));
        bundle.putString("ad_url", this.mBundle.getString("ad_url"));
        bundle.putInt("filling_source", this.mBundle.getInt("filling_source"));
        bundle.putString("description", this.mBundle.getString("description"));
        bundle.putString("image_url", this.mBundle.getString("image_url"));
        bundle.putString("icon_url", this.mBundle.getString("icon_url"));
        bundle.putString("endcard_url", this.mBundle.getString("app_name"));
        bundle.putString("app_name", this.mBundle.getString("app_name"));
        bundle.putString("package_name", this.mBundle.getString("package_name"));
        bundle.putString("download_url", this.mBundle.getString("download_url"));
        bundle.putInt("slot_height", this.mBundle.getInt("slot_height"));
        bundle.putInt("slot_width", this.mBundle.getInt("slot_width"));
        bundle.putInt("is_pre_trigger", this.mBundle.getInt("is_pre_trigger"));
        bundle.putInt("request_type", this.mBundle.getInt("request_type"));
        bundle.putString("request_id", this.mBundle.getString("request_id"));
        bundle.putInt("click_x", 0);
        bundle.putInt("click_y", 0);
        bundle.putInt("is_expired", this.isExpired() ? 1 : 0);
        bundle.putInt("request_num", this.mBundle.getInt("request_num"));
        String string = this.getAdClickCreativeIdsBundle();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putString("ad_creative_ids", string);
        }
        bundle.putInt("ad_trigger_status", this.mBundle.getInt("ad_trigger_status"));
        bundle.putInt("is_offline_ad", this.isOfflineAd() ? 1 : 0);
        bundle.putInt("filling_ad_type", this.mBundle.getInt("filling_ad_type"));
        bundle.putString("traffic_group_id", this.mBundle.getString("traffic_group_id"));
        bundle.putString("experiment_group_id", this.mBundle.getString("experiment_group_id"));
        bundle.putInt("priority_code", this.mBundle.getInt("priority_code"));
        bundle.putDouble("max_price", this.mBundle.getDouble("max_price"));
        TrackingManager.trackingAdClick(bundle);
    }

    protected void logClose() {
        Bundle bundle = new Bundle();
        this.appendContextParam(bundle);
        bundle.putInt("request_time", this.mBundle.getInt("request_time"));
        bundle.putLong("return_ts", this.mBundle.getLong("return_ts"));
        bundle.putInt("return_time", this.mBundle.getInt("return_time"));
        bundle.putLong("show_ts", this.mBundle.getLong("show_ts"));
        bundle.putLong("show_time", this.mBundle.getLong("show_time"));
        bundle.putLong("click_ts", System.currentTimeMillis());
        bundle.putInt("click_time", (int)(System.currentTimeMillis() - this.mImpressionTime));
        bundle.putString("ad_title", this.mBundle.getString("ad_title"));
        bundle.putString("ad_url", this.mBundle.getString("ad_url"));
        bundle.putInt("filling_source", this.mBundle.getInt("filling_source"));
        bundle.putString("description", this.mBundle.getString("description"));
        bundle.putString("image_url", this.mBundle.getString("image_url"));
        bundle.putString("icon_url", this.mBundle.getString("icon_url"));
        bundle.putString("endcard_url", this.mBundle.getString("endcard_url"));
        bundle.putString("app_name", this.mBundle.getString("app_name"));
        bundle.putString("package_name", this.mBundle.getString("package_name"));
        bundle.putString("download_url", this.mBundle.getString("download_url"));
        bundle.putString("traffic_group_id", this.mBundle.getString("traffic_group_id"));
        bundle.putString("experiment_group_id", this.mBundle.getString("experiment_group_id"));
        bundle.putInt("slot_height", 0);
        bundle.putInt("slot_width", 0);
        bundle.putInt("click_x", 0);
        bundle.putInt("click_y", 0);
        TrackingManager.trackingAdClose(bundle);
    }

    @Override
    public void detachContext() {
        this.mAdRequestBody = null;
        this.listener = null;
    }

    @Override
    public void destroyAd() {
        this.isDestroyed = true;
        if (this.adShowCreativeIds != null) {
            this.adShowCreativeIds.clear();
            this.adShowCreativeIds = null;
        }
        if (this.adClickCreativeIds != null) {
            this.adClickCreativeIds.clear();
            this.adClickCreativeIds = null;
        }
        this.detachContext();
        this.stopTimer();
    }

    @Override
    public void setRequestBody(TAdRequestBody tAdRequestBody) {
        this.mAdRequestBody = tAdRequestBody;
        if (tAdRequestBody != null) {
            this.listener = (WrapTAdAllianceListener)tAdRequestBody.getAdListener();
        }
    }

    @Override
    public TAdRequestBody getRequestBody() {
        return this.mAdRequestBody;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int n) {
        this.ttl = n;
    }

    @Override
    public boolean isExpired() {
        return this.getValidTimeLimit() <= 0L;
    }

    @Override
    public long getValidTimeLimit() {
        if (this.ttl <= 0) {
            return Long.MAX_VALUE;
        }
        return (long)this.ttl * 60L * 1000L - Math.abs(System.currentTimeMillis() - this.startTime);
    }

    @Override
    public int getAdSource() {
        return this.adSource;
    }

    @Override
    public void setEcpmPrice(double d) {
        this.price = d;
    }

    @Override
    public double getEcpmPrice() {
        return this.price;
    }

    @Override
    public void setAdSource(int n) {
        this.adSource = n;
    }

    @Override
    public String getPlacementId() {
        return this.mNetwork.getCodeSeatId();
    }

    @Override
    public void stopLoader() {
        if (this.isLoaded) {
            return;
        }
        try {
            if (this.isSupportStopRequest()) {
                this.destroyAd();
            } else {
                this.detachContext();
                this.setLoadStatus(4);
            }
        }
        catch (Exception exception) {
            AdLogUtil.Log().e(this.TAG, Log.getStackTraceString((Throwable)exception));
        }
    }

    @Override
    public String getFilterSource() {
        return "";
    }

    @Override
    public void setOfflineAd(boolean bl) {
        this.isOfflineAd = bl;
    }

    protected boolean supportTimer() {
        return true;
    }

    protected void startTimer() {
        if (this.runTimer == null) {
            this.runTimer = new RunTimer();
            this.runTimer.setScheduleTime(this.getTimeOutTime());
            this.runTimer.setTimeOutCallback(this.timeOutCallback);
        }
        this.runTimer.runTimerTask();
        AdLogUtil.Log().d(this.TAG, "\u542f\u52a8\u5e7f\u544a\u8bf7\u6c42\u8d85\u65f6\u76d1\u542c...");
    }

    protected int getTimeOutTime() {
        return 30000;
    }

    protected void stopTimer() {
        if (this.runTimer != null) {
            this.runTimer.resetTimerTask();
            this.runTimer = null;
        }
    }

    public void onTimeOut() {
        this.isLoaded = true;
        this.adFailedToLoad(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
        this.destroyAd();
    }

    public void post(Handler handler, Runnable runnable) {
        if (handler != null) {
            handler.post(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public void setTrackingBundle(Bundle bundle) {
        if (null == bundle) {
            return;
        }
        this.mBundle.putAll(bundle);
        this.mBundle.putDouble("bidding_price", this.mNetwork.getPrice().doubleValue());
    }

    protected void adTrackingRequest() {
        RecordTestInfo.record("adTrackingRequest code_seat_id:" + this.getPlacementId() + ",bidding_price:" + this.mBundle.getDouble("bidding_price"));
        this.mBundle.putInt("ad_count", this.mAdCount);
        this.mBundle.putInt("is_retreatad", 0);
        this.mBundle.putInt("is_default_ad", 0);
        if (TextUtils.isEmpty((CharSequence)this.mRequestId)) {
            this.mRequestId = DeviceUtil.getUUID();
        }
        this.mTriggerId = this.mBundle.getString("trigger_id");
        this.mBundle.putString("request_id", this.mRequestId);
        this.mBundle.putString("cld_configure_id", AdxPreferencesHelper.getInstance().getString("cloudControlVersion"));
        this.mBundle.putInt("request_num", this.mAdCount);
        this.mBundle.putInt("request_round", this.mRequestRound);
        TrackingManager.trackingAdRequest(this.mBundle);
    }

    public void adReturnTracking(Bundle bundle) {
        if (null == bundle || null == this.mBundle) {
            return;
        }
        if (this.mBundle.containsKey("cld_configure_id")) {
            this.mBundle.remove("cld_configure_id");
        }
        bundle.putString("trigger_id", this.mBundle.getString("trigger_id"));
        bundle.putLong("trigger_ts", this.mBundle.getLong("trigger_ts"));
        bundle.putLong("request_ts", this.mBundle.getLong("request_ts"));
        bundle.putInt("request_time", (int)(this.mBundle.getLong("request_ts") - this.mBundle.getLong("trigger_ts")));
        bundle.putString("request_id", this.mBundle.getString("request_id"));
        bundle.putLong("return_ts", System.currentTimeMillis());
        bundle.putInt("return_time", (int)(System.currentTimeMillis() - this.mBundle.getLong("request_ts")));
        this.mBundle.putLong("return_ts", System.currentTimeMillis());
        this.mBundle.putInt("return_time", (int)(System.currentTimeMillis() - this.mBundle.getLong("request_ts")));
        bundle.putInt("ad_type", this.mBundle.getInt("ad_type"));
        bundle.putString("cld_app_id", this.mBundle.getString("cld_app_id"));
        bundle.putString("cld_code_seat_id", this.mBundle.getString("cld_code_seat_id"));
        bundle.putInt("platform", this.mBundle.getInt("platform"));
        bundle.putString("app_id", this.mBundle.getString("app_id"));
        bundle.putString("code_seat_id", this.mBundle.getString("code_seat_id"));
        if (this.adSource == 0 || this.adSource == 6) {
            bundle.putDouble("bidding_price", this.price);
        } else {
            bundle.putDouble("bidding_price", this.mBundle.getDouble("bidding_price"));
        }
        RecordTestInfo.record("adReturnTracking code_seat_id:" + this.mBundle.getString("code_seat_id") + ",bidding_price:" + bundle.getDouble("bidding_price"));
        bundle.putInt("priority", this.mBundle.getInt("priority"));
        bundle.putInt("ad_count", this.mBundle.getInt("ad_count"));
        bundle.putInt("is_retreatad", this.mBundle.getInt("is_retreatad"));
        bundle.putInt("is_default_ad", 0);
        bundle.putInt("request_type", this.mBundle.getInt("request_type"));
        bundle.putInt("is_pre_trigger", this.mBundle.getInt("is_pre_trigger"));
        bundle.putString("ad_title", this.mBundle.getString("ad_title"));
        bundle.putString("ad_url", this.mBundle.getString("ad_url"));
        bundle.putString("description", this.mBundle.getString("description"));
        bundle.putString("image_url", this.mBundle.getString("image_url"));
        bundle.putString("icon_url", this.mBundle.getString("icon_url"));
        bundle.putString("endcard_url", this.mBundle.getString("endcard_url"));
        bundle.putString("app_name", this.mBundle.getString("app_name"));
        bundle.putString("package_name", this.mBundle.getString("package_name"));
        bundle.putString("native_info_list", this.mBundle.getString("native_info_list"));
        bundle.putString("download_url", this.mBundle.getString("download_url"));
        bundle.putInt("is_timeout", this.isTimeOut ? 1 : 0);
        bundle.putInt("request_num", this.mAdCount);
        bundle.putLong("is_offline_ad", this.isOfflineAd() ? 1L : 0L);
        bundle.putLong("ad_trigger_status", (long)this.mBundle.getInt("ad_trigger_status"));
        bundle.putInt("request_round", this.mBundle.getInt("request_round"));
        bundle.putString("traffic_group_id", this.mBundle.getString("traffic_group_id"));
        bundle.putString("experiment_group_id", this.mBundle.getString("experiment_group_id"));
        bundle.putInt("optimize_status", this.mBundle.getInt("optimize_status"));
        bundle.putInt("priority_code", this.mBundle.getInt("priority_code"));
        TrackingManager.trackingAdReturn(bundle);
    }

    private String getAdShowCreativeIdsBundle() {
        if (!"Hotapps".equals(this.adSeatType)) {
            return null;
        }
        if (this.adShowCreativeIds != null && this.adShowCreativeIds.size() > 0) {
            String string = this.adShowCreativeIds.get(0);
            this.adShowCreativeIds.remove(0);
            if (this.adClickCreativeIds == null) {
                this.adClickCreativeIds = new ArrayList<String>();
            }
            this.adClickCreativeIds.add(string);
            return "[\"" + string + "\"]";
        }
        return null;
    }

    private String getAdClickCreativeIdsBundle() {
        if (!"Hotapps".equals(this.adSeatType)) {
            return null;
        }
        if (this.adClickCreativeIds != null && this.adClickCreativeIds.size() > 0) {
            String string = this.adClickCreativeIds.get(0);
            this.adClickCreativeIds.remove(0);
            this.adClickCreativeIds.add(string);
            return "[\"" + string + "\"]";
        }
        return null;
    }

    @Override
    public void setRequestTime(long l) {
        this.requestTime = l;
    }

    @Override
    public long getRequestTime() {
        return this.requestTime;
    }

    @Override
    public void setSupportFlag(int n) {
        this.supportHisavanaFlag = n;
    }

    protected int getSupportHisavanaFlag() {
        return this.supportHisavanaFlag;
    }

    @Override
    public void setMaxPrice(double d) {
        AdLogUtil.Log().d("Athena", "setMaxPrice " + d);
        this.maxPrice = d;
    }

    @Override
    public void setExt(String string) {
    }

    @Override
    public String getExt() {
        return "";
    }
}

