/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.bean;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.hisavana.common.interfacz.ICacheAd;
import com.hisavana.common.mock.RecordTestInfo;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AdCache<T extends ICacheAd> {
    private static AdCacheComp mComparator = new AdCacheComp();
    final HashMap<String, ArrayList<T>> map = new HashMap();
    private AdCacheExpiredWatcher watcher;
    private static final String TAG = "AdCache";
    private static final int CODE_SEAT_LIMIT_FIVE = 5;
    private static final int CODE_SEAT_LIMIT_TEN = 10;
    private static final int CODE_SEAT_LIMIT_30 = 30;

    private ArrayList<T> getOrCreateList(String string) {
        ArrayList<Object> arrayList = this.map.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.map.put(string, arrayList);
        }
        return arrayList;
    }

    public void addCache(String string, @NonNull T t) {
        ArrayList<T> arrayList;
        if (t != null) {
            RecordTestInfo.record("add Cache list,AdSource is :" + t.getAdSource());
            t.detachContext();
        }
        if ((arrayList = this.getOrCreateList(string)).size() > this.getCodeSeatLimit(t)) {
            arrayList.remove(arrayList.size() - 1);
        }
        try {
            int n = Collections.binarySearch(arrayList, t, mComparator);
            if (n < 0) {
                n = -(n + 1);
            }
            arrayList.add(n, t);
            RecordTestInfo.LogMsg("add cache:" + RecordTestInfo.getLogMsg(t), RecordTestInfo.LOG_CODE10);
            RecordTestInfo.record("add Cache list is :" + arrayList.size());
            AdLogUtil.Log().d(TAG, "*----> add Caches list is :" + arrayList.size());
        }
        catch (Exception exception) {
            AdLogUtil.Log().d(TAG, Log.getStackTraceString((Throwable)exception));
        }
    }

    public void addCaches(String string, List<T> list) {
        int n;
        for (ICacheAd iCacheAd : list) {
            if (iCacheAd == null) continue;
            RecordTestInfo.record("add Caches list,EcpmPrice is :" + iCacheAd.getEcpmPrice());
            iCacheAd.detachContext();
        }
        ArrayList<T> arrayList = this.getOrCreateList(string);
        if (list == null || list.size() == 0) {
            return;
        }
        int n2 = list.size();
        if (n2 <= (n = this.getCodeSeatLimit((ICacheAd)list.get(0)))) {
            while (n2 + arrayList.size() > n) {
                arrayList.remove(arrayList.size() - 1);
            }
        }
        arrayList.addAll(list);
        try {
            Collections.sort(arrayList, mComparator);
            RecordTestInfo.record("add Caches list is :" + arrayList.size());
            AdLogUtil.Log().d(TAG, "*----> add Caches list is :" + arrayList.size());
            RecordTestInfo.LogMsg("add caches:" + RecordTestInfo.getLogMsg(list), RecordTestInfo.LOG_CODE10);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void removeCache(String string, T t) {
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList != null && !arrayList.isEmpty()) {
            arrayList.remove(t);
            AdLogUtil.Log().d(TAG, "---> Remove ad:" + t.getPlacementId() + " from cache");
            RecordTestInfo.LogMsg("remove cache:" + RecordTestInfo.getLogMsg(t), RecordTestInfo.LOG_CODE10);
        }
    }

    public boolean hasAd(String string, T t) {
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList != null && !arrayList.isEmpty()) {
            return arrayList.contains(t);
        }
        return false;
    }

    public T getCache(String string, boolean bl, int n) {
        ArrayList<T> arrayList;
        ICacheAd iCacheAd = null;
        iCacheAd = (ICacheAd)this.getSupportAd(string, n);
        if (iCacheAd == null && (arrayList = this.getCaches(string, 1, bl)) != null && !arrayList.isEmpty()) {
            iCacheAd = (ICacheAd)arrayList.get(0);
        }
        return (T)iCacheAd;
    }

    private T getSupportAd(String string, int n) {
        AdLogUtil.Log().d(TAG, "getSupportAd " + string + " hisavanaAdSupportFlag " + n);
        ArrayList<T> arrayList = this.getCaches(string, Integer.MAX_VALUE, false);
        if (arrayList == null) {
            return null;
        }
        for (ICacheAd iCacheAd : arrayList) {
            if (iCacheAd == null || !this.isAdConformSupportFlag(iCacheAd, n)) continue;
            return (T)iCacheAd;
        }
        return null;
    }

    private boolean isAdConformSupportFlag(T t, int n) {
        if (t.isOfflineAd()) {
            return false;
        }
        switch (n) {
            case 2: {
                return t.isEwAd();
            }
            case 1: {
                return t.isAdxAd();
            }
            case 3: {
                return t.isAdxAd() || t.isEwAd();
            }
        }
        return false;
    }

    public ArrayList<T> getCaches(@NonNull String string, int n, boolean bl) {
        Object object;
        ArrayList<Object> arrayList = null;
        ArrayList<T> arrayList2 = this.map.get(string);
        if (arrayList2 == null) {
            return arrayList;
        }
        Iterator<T> iterator = arrayList2.iterator();
        if (CoreUtil.isDebug()) {
            object = arrayList2.iterator();
            AdLogUtil.Log().d(TAG, "*----> current ad pool size is :" + arrayList2.size());
            while (object.hasNext()) {
                ICacheAd iCacheAd = (ICacheAd)object.next();
                AdLogUtil.Log().d(TAG, "---> ad: " + iCacheAd.getPlacementId() + "\uff0cprice\uff1a" + iCacheAd.getEcpmPrice() + " source " + iCacheAd.getAdSource());
            }
        }
        while (iterator.hasNext()) {
            object = (ICacheAd)iterator.next();
            if (null == object) continue;
            if (bl) {
                AdLogUtil.Log().d(TAG, "---> Remove ad:" + object.getPlacementId() + " from cache");
                iterator.remove();
                RecordTestInfo.LogMsg("remove cache:" + RecordTestInfo.getLogMsg(object), RecordTestInfo.LOG_CODE10);
            }
            if (object.isExpired()) {
                if (!bl) {
                    iterator.remove();
                    RecordTestInfo.LogMsg("remove cache:" + RecordTestInfo.getLogMsg(object), RecordTestInfo.LOG_CODE10);
                }
                if (this.watcher != null) {
                    this.watcher.onExpired((ICacheAd)object);
                }
                object.destroyAd();
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
            }
            arrayList.add(object);
            if (arrayList.size() < n) continue;
            break;
        }
        return arrayList;
    }

    private boolean removeAd(Iterator<T> iterator, T t, boolean bl) {
        if (bl) {
            AdLogUtil.Log().d(TAG, "---> Remove ad:" + t.getPlacementId() + " from cache");
            iterator.remove();
            RecordTestInfo.LogMsg("remove cache:" + RecordTestInfo.getLogMsg(t), RecordTestInfo.LOG_CODE10);
        }
        if (t.isExpired()) {
            if (!bl) {
                iterator.remove();
                RecordTestInfo.LogMsg("remove cache:" + RecordTestInfo.getLogMsg(t), RecordTestInfo.LOG_CODE10);
            }
            if (this.watcher != null) {
                this.watcher.onExpired((ICacheAd)t);
            }
            t.destroyAd();
            return true;
        }
        return false;
    }

    public ArrayList<T> getCaches(@NonNull String string, int n, boolean bl, int n2) {
        Object object;
        Object object2;
        ArrayList<T> arrayList = this.map.get(string);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (arrayList == null || arrayList.isEmpty()) {
            return arrayList2;
        }
        Iterator<T> iterator = arrayList.iterator();
        if (CoreUtil.isDebug()) {
            object2 = arrayList.iterator();
            AdLogUtil.Log().d(TAG, "current ad pool size is :" + arrayList.size());
            while (object2.hasNext()) {
                object = (ICacheAd)object2.next();
                AdLogUtil.Log().d(TAG, "ad: " + object.getPlacementId() + "\uff0cprice\uff1a" + object.getEcpmPrice() + " isAdx " + object.isAdxAd() + " isEw " + object.isEwAd());
            }
        }
        while (iterator.hasNext()) {
            object2 = (ICacheAd)iterator.next();
            if (null == object2) continue;
            if (this.isAdConformSupportFlag(object2, n2) && !this.removeAd(iterator, object2, bl)) {
                arrayList2.add(object2);
            }
            if (arrayList2.size() < n) continue;
            return arrayList2;
        }
        if (arrayList2.size() < n) {
            int n3 = n - arrayList2.size();
            object = this.getCaches(string, n3, bl);
            arrayList2.addAll((Collection<Object>)object);
        }
        return arrayList2;
    }

    public ArrayList<T> getCaches(@NonNull String string, int n, boolean bl, boolean bl2, int n2) {
        Object object;
        Object object2;
        int n3;
        if (!bl2) {
            return this.getCaches(string, n, bl, n2);
        }
        ArrayList<ICacheAd> arrayList = null;
        ArrayList<T> arrayList2 = this.map.get(string);
        if (arrayList2 == null) {
            return null;
        }
        int n4 = n3 = n2 > 0 ? 0 : -1;
        if (CoreUtil.isDebug()) {
            object2 = arrayList2.iterator();
            AdLogUtil.Log().d(TAG, "*----> current ad pool size is :" + arrayList2.size());
            while (object2.hasNext()) {
                object = (ICacheAd)object2.next();
                AdLogUtil.Log().d(TAG, "---> ad: " + object.getPlacementId() + "\uff0cprice\uff1a" + object.getEcpmPrice());
            }
        }
        object2 = new ArrayList();
        object = arrayList2.iterator();
        while (object.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)object.next();
            if (null == iCacheAd || n3 != -1 && n3 != iCacheAd.getAdSource()) continue;
            if (n3 == -1) {
                n3 = iCacheAd.getAdSource();
            }
            if (iCacheAd.isExpired()) {
                object.remove();
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<ICacheAd>();
            }
            if (!TextUtils.isEmpty((CharSequence)iCacheAd.getFilterSource())) {
                AdLogUtil.Log().d(TAG, "current filter ------->" + iCacheAd.getFilterSource());
                if (object2.contains(iCacheAd.getFilterSource())) continue;
                object2.add(iCacheAd.getFilterSource());
            }
            if (bl) {
                AdLogUtil.Log().d(TAG, "---> Remove ad:" + iCacheAd.getPlacementId() + " from cache");
                object.remove();
            }
            arrayList.add(iCacheAd);
            if (arrayList.size() < n) continue;
            break;
        }
        return arrayList;
    }

    public double updateSecondPrice(T t, String string) {
        if (t != null && t.getAdSource() == 0) {
            double d = this.getMaxPrice(string, t);
            if (d > 0.0) {
                t.setSecondPrice(d);
            }
            return d;
        }
        return 0.0;
    }

    private double getMaxPrice(String string, T t) {
        double d = 0.0;
        if (string == null) {
            return d;
        }
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return d;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            if (t != null && t == iCacheAd) {
                AdLogUtil.Log().d("ssp_second_price", "*----> getMaxPrice updateSecondPrice()\uff0cexcludeAd == iteratorAd");
                continue;
            }
            AdLogUtil.Log().d(TAG, "*----> max ad in pool is :" + iCacheAd.getPlacementId() + ",EcpmPrice is :" + iCacheAd.getEcpmPrice() + ",AdSource is :" + iCacheAd.getAdSource() + ",ValidTimeLimit :" + iCacheAd.getValidTimeLimit());
            d = iCacheAd.getEcpmPrice();
            break;
        }
        return d;
    }

    public double getMaxPrice(String string) {
        return this.getMaxPrice(string, null);
    }

    public boolean hasAds(String string) {
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return false;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            return true;
        }
        return false;
    }

    public int getAdNum(String string) {
        int n = 0;
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return n;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            ++n;
            AdLogUtil.Log().d(TAG, "*----> ad in pool is :" + iCacheAd.getPlacementId() + ",EcpmPrice is :" + iCacheAd.getEcpmPrice() + ",AdSource is :" + iCacheAd.getAdSource() + ",ValidTimeLimit :" + iCacheAd.getValidTimeLimit());
        }
        return n;
    }

    public int[] getValidAndInvalidAdNum(String string) {
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[]{0, 0};
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return nArray;
        }
        for (ICacheAd iCacheAd : arrayList) {
            if (!iCacheAd.isExpired()) {
                ++n;
                continue;
            }
            ++n2;
        }
        nArray[0] = n;
        nArray[1] = n2;
        return nArray;
    }

    public int getAdNum(String string, int n, String string2) {
        int n2 = 0;
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return n2;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            if (iCacheAd.getAdSource() != n || !TextUtils.equals((CharSequence)iCacheAd.getPlacementId(), (CharSequence)string2)) continue;
            ++n2;
        }
        return n2;
    }

    public double getNetworkPrice(String string, int n, String string2) {
        double d = 0.0;
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return d;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            if (iCacheAd.getAdSource() != n || !TextUtils.equals((CharSequence)iCacheAd.getPlacementId(), (CharSequence)string2)) continue;
            d = iCacheAd.getEcpmPrice();
            break;
        }
        return d;
    }

    public void registerWatcher(AdCacheExpiredWatcher adCacheExpiredWatcher) {
        this.watcher = adCacheExpiredWatcher;
    }

    public void unRegisterWatcher() {
        this.watcher = null;
    }

    public void removeAll() {
        this.map.clear();
    }

    private int getCodeSeatLimit(T t) {
        if (t == null) {
            return 5;
        }
        return t.isIconAd() ? 30 : 5;
    }

    public static interface AdCacheExpiredWatcher {
        public void onExpired(ICacheAd var1);
    }

    public static class AdCacheComp
    implements Comparator<ICacheAd> {
        @Override
        public int compare(ICacheAd iCacheAd, ICacheAd iCacheAd2) {
            try {
                if (iCacheAd.isExpired() && !iCacheAd2.isExpired()) {
                    return 1;
                }
                if (!iCacheAd.isExpired() && iCacheAd2.isExpired()) {
                    return -1;
                }
                if (iCacheAd.getEcpmPrice() == iCacheAd2.getEcpmPrice()) {
                    if (iCacheAd.getValidTimeLimit() - iCacheAd2.getValidTimeLimit() < 0L) {
                        return -1;
                    }
                    if (iCacheAd.getValidTimeLimit() - iCacheAd2.getValidTimeLimit() > 0L) {
                        return 1;
                    }
                    return 0;
                }
                if (iCacheAd.getEcpmPrice() > iCacheAd2.getEcpmPrice()) {
                    return -1;
                }
                return 1;
            }
            catch (Throwable throwable) {
                return 0;
            }
        }
    }
}

