/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.base;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.hisavana.common.base.BaseAd;
import com.hisavana.common.bean.Network;
import com.hisavana.common.interfacz.IadVideo;
import com.hisavana.common.utils.AdLogUtil;
import java.lang.ref.WeakReference;

public abstract class BaseVideo<T>
extends BaseAd
implements IadVideo {
    public BaseVideo(Context context, Network network) {
        super(context, network);
    }

    @Override
    public int getAdType() {
        return 5;
    }

    @Override
    public void loadAd() {
        super.loadAd();
        this.initVideo();
        this.onVideoStartLoad();
    }

    @Override
    public void destroyAd() {
        super.destroyAd();
    }

    public void showVideo(Activity activity, String string) {
        this.mContext = new WeakReference<Activity>(activity);
        this.show(activity, string);
    }

    @Override
    public void show(Activity activity, String string) {
        if (activity == null) {
            AdLogUtil.Log().e("video", "show,activity is null");
            return;
        }
        try {
            if (this.isLoaded()) {
                this.logTrigerShow(string);
                this.onVideoShow(activity);
            } else {
                AdLogUtil.Log().w("video", "BaseVideo --> interstitial  is not ready" + this.getLogString());
            }
        }
        catch (Throwable throwable) {
            AdLogUtil.Log().e("video", "BaseVideo --> show exception:" + Log.getStackTraceString((Throwable)throwable));
        }
    }

    @Override
    public boolean isLoaded() {
        return false;
    }

    protected abstract void initVideo();

    protected abstract void onVideoStartLoad();

    protected abstract void onVideoShow(Activity var1);

    @Override
    public boolean isOfflineAd() {
        return false;
    }
}

