/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.utils;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadUtils {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private static final String WORK_THREAD_NAME = "h_adm_work_thread";
    private static final Handler WORKER_HANDLER = new Handler(ThreadUtils.getWorkHandlerThread().getLooper());
    private static final Map<Integer, Map<Integer, ExecutorService>> TYPE_PRIORITY_POOLS = new HashMap<Integer, Map<Integer, ExecutorService>>();
    private static final Map<Task, ExecutorService> TASK_POOL_MAP = new ConcurrentHashMap<Task, ExecutorService>();
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final Timer TIMER = new Timer();
    private static final byte TYPE_SINGLE = -1;
    private static final byte TYPE_CACHED = -2;
    private static final byte TYPE_IO = -4;
    private static final byte TYPE_CPU = -8;
    private static Executor sDeliver;

    public static boolean isInUiThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static Handler getMainHandler() {
        return HANDLER;
    }

    public static void runOnUiThread(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            HANDLER.post(runnable);
        }
    }

    public static void runOnUiThreadDelayed(Runnable runnable, long l) {
        HANDLER.postDelayed(runnable, l);
    }

    public static void runOnWorkThread(Runnable runnable) {
        if (Looper.myLooper() == WORKER_HANDLER.getLooper()) {
            runnable.run();
        } else {
            WORKER_HANDLER.post(runnable);
        }
    }

    public static void runOnWorkThreadDelayed(Runnable runnable, long l) {
        WORKER_HANDLER.postDelayed(runnable, l);
    }

    private static HandlerThread getWorkHandlerThread() {
        HandlerThread handlerThread = new HandlerThread(WORK_THREAD_NAME);
        handlerThread.start();
        return handlerThread;
    }

    public static Handler getWorkerHandler() {
        return WORKER_HANDLER;
    }

    public static ExecutorService getFixedPool(@IntRange(from=1L) int n) {
        return ThreadUtils.getPoolByTypeAndPriority(n);
    }

    public static ExecutorService getFixedPool(@IntRange(from=1L) int n, @IntRange(from=1L, to=10L) int n2) {
        return ThreadUtils.getPoolByTypeAndPriority(n, n2);
    }

    public static ExecutorService getSinglePool() {
        return ThreadUtils.getPoolByTypeAndPriority(-1);
    }

    public static ExecutorService getSinglePool(@IntRange(from=1L, to=10L) int n) {
        return ThreadUtils.getPoolByTypeAndPriority(-1, n);
    }

    public static ExecutorService getCachedPool() {
        return ThreadUtils.getPoolByTypeAndPriority(-2);
    }

    public static ExecutorService getCachedPool(@IntRange(from=1L, to=10L) int n) {
        return ThreadUtils.getPoolByTypeAndPriority(-2, n);
    }

    public static ExecutorService getIoPool() {
        return ThreadUtils.getPoolByTypeAndPriority(-4);
    }

    public static ExecutorService getIoPool(@IntRange(from=1L, to=10L) int n) {
        return ThreadUtils.getPoolByTypeAndPriority(-4, n);
    }

    public static ExecutorService getCpuPool() {
        return ThreadUtils.getPoolByTypeAndPriority(-8);
    }

    public static ExecutorService getCpuPool(@IntRange(from=1L, to=10L) int n) {
        return ThreadUtils.getPoolByTypeAndPriority(-8, n);
    }

    public static <T> void executeByFixed(@IntRange(from=1L) int n, Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(n), task);
    }

    public static <T> void executeByFixed(@IntRange(from=1L) int n, Task<T> task, @IntRange(from=1L, to=10L) int n2) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(n, n2), task);
    }

    public static <T> void executeByFixedWithDelay(@IntRange(from=1L) int n, Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(n), task, l, timeUnit);
    }

    public static <T> void executeByFixedWithDelay(@IntRange(from=1L) int n, Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n2) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(n, n2), task, l, timeUnit);
    }

    public static <T> void executeByFixedAtFixRate(@IntRange(from=1L) int n, Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(n), task, 0L, l, timeUnit);
    }

    public static <T> void executeByFixedAtFixRate(@IntRange(from=1L) int n, Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n2) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(n, n2), task, 0L, l, timeUnit);
    }

    public static <T> void executeByFixedAtFixRate(@IntRange(from=1L) int n, Task<T> task, long l, long l2, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(n), task, l, l2, timeUnit);
    }

    public static <T> void executeByFixedAtFixRate(@IntRange(from=1L) int n, Task<T> task, long l, long l2, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n2) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(n, n2), task, l, l2, timeUnit);
    }

    public static <T> void executeBySingle(Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-1), task);
    }

    public static <T> void executeBySingle(Task<T> task, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-1, n), task);
    }

    public static <T> void executeBySingleWithDelay(Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-1), task, l, timeUnit);
    }

    public static <T> void executeBySingleWithDelay(Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-1, n), task, l, timeUnit);
    }

    public static <T> void executeBySingleAtFixRate(Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-1), task, 0L, l, timeUnit);
    }

    public static <T> void executeBySingleAtFixRate(Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-1, n), task, 0L, l, timeUnit);
    }

    public static <T> void executeBySingleAtFixRate(Task<T> task, long l, long l2, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-1), task, l, l2, timeUnit);
    }

    public static <T> void executeBySingleAtFixRate(Task<T> task, long l, long l2, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-1, n), task, l, l2, timeUnit);
    }

    public static <T> void executeByCached(Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-2), task);
    }

    public static <T> void executeByCached(Task<T> task, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-2, n), task);
    }

    public static <T> void executeByCachedWithDelay(Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-2), task, l, timeUnit);
    }

    public static <T> void executeByCachedWithDelay(Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-2, n), task, l, timeUnit);
    }

    public static <T> void executeByCachedAtFixRate(Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-2), task, 0L, l, timeUnit);
    }

    public static <T> void executeByCachedAtFixRate(Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-2, n), task, 0L, l, timeUnit);
    }

    public static <T> void executeByCachedAtFixRate(Task<T> task, long l, long l2, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-2), task, l, l2, timeUnit);
    }

    public static <T> void executeByCachedAtFixRate(Task<T> task, long l, long l2, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-2, n), task, l, l2, timeUnit);
    }

    public static <T> void executeByIo(Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-4), task);
    }

    public static <T> void executeByIo(Task<T> task, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-4, n), task);
    }

    public static <T> void executeByIoWithDelay(Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-4), task, l, timeUnit);
    }

    public static <T> void executeByIoWithDelay(Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-4, n), task, l, timeUnit);
    }

    public static <T> void executeByIoAtFixRate(Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-4), task, 0L, l, timeUnit);
    }

    public static <T> void executeByIoAtFixRate(Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-4, n), task, 0L, l, timeUnit);
    }

    public static <T> void executeByIoAtFixRate(Task<T> task, long l, long l2, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-4), task, l, l2, timeUnit);
    }

    public static <T> void executeByIoAtFixRate(Task<T> task, long l, long l2, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-4, n), task, l, l2, timeUnit);
    }

    public static <T> void executeByCpu(Task<T> task) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-8), task);
    }

    public static <T> void executeByCpu(Task<T> task, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.execute(ThreadUtils.getPoolByTypeAndPriority(-8, n), task);
    }

    public static <T> void executeByCpuWithDelay(Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-8), task, l, timeUnit);
    }

    public static <T> void executeByCpuWithDelay(Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeWithDelay(ThreadUtils.getPoolByTypeAndPriority(-8, n), task, l, timeUnit);
    }

    public static <T> void executeByCpuAtFixRate(Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-8), task, 0L, l, timeUnit);
    }

    public static <T> void executeByCpuAtFixRate(Task<T> task, long l, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-8, n), task, 0L, l, timeUnit);
    }

    public static <T> void executeByCpuAtFixRate(Task<T> task, long l, long l2, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-8), task, l, l2, timeUnit);
    }

    public static <T> void executeByCpuAtFixRate(Task<T> task, long l, long l2, TimeUnit timeUnit, @IntRange(from=1L, to=10L) int n) {
        ThreadUtils.executeAtFixedRate(ThreadUtils.getPoolByTypeAndPriority(-8, n), task, l, l2, timeUnit);
    }

    public static <T> void executeByCustom(ExecutorService executorService, Task<T> task) {
        ThreadUtils.execute(executorService, task);
    }

    public static <T> void executeByCustomWithDelay(ExecutorService executorService, Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeWithDelay(executorService, task, l, timeUnit);
    }

    public static <T> void executeByCustomAtFixRate(ExecutorService executorService, Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(executorService, task, 0L, l, timeUnit);
    }

    public static <T> void executeByCustomAtFixRate(ExecutorService executorService, Task<T> task, long l, long l2, TimeUnit timeUnit) {
        ThreadUtils.executeAtFixedRate(executorService, task, l, l2, timeUnit);
    }

    public static void cancel(Task task) {
        if (task == null) {
            return;
        }
        task.cancel();
    }

    public static void cancel(Task ... taskArray) {
        if (taskArray == null) {
            return;
        }
        for (Task task : taskArray) {
            if (task == null) continue;
            task.cancel();
        }
    }

    public static void cancel(List<Task> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        for (Task task : list) {
            if (task == null) continue;
            task.cancel();
        }
    }

    public static void cancel(ExecutorService executorService) {
        if (executorService instanceof ThreadPoolExecutor4Util) {
            for (Map.Entry<Task, ExecutorService> entry : TASK_POOL_MAP.entrySet()) {
                if (entry.getValue() != executorService) continue;
                ThreadUtils.cancel(entry.getKey());
            }
        } else {
            Log.e((String)"ThreadUtils", (String)"The executorService is not ThreadUtils's pool.");
        }
    }

    public static void setDeliver(Executor executor) {
        sDeliver = executor;
    }

    private static <T> void execute(ExecutorService executorService, Task<T> task) {
        ThreadUtils.execute(executorService, task, 0L, 0L, null);
    }

    private static <T> void executeWithDelay(ExecutorService executorService, Task<T> task, long l, TimeUnit timeUnit) {
        ThreadUtils.execute(executorService, task, l, 0L, timeUnit);
    }

    private static <T> void executeAtFixedRate(ExecutorService executorService, Task<T> task, long l, long l2, TimeUnit timeUnit) {
        ThreadUtils.execute(executorService, task, l, l2, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void execute(final ExecutorService executorService, final Task<T> task, long l, long l2, TimeUnit timeUnit) {
        Object object = TASK_POOL_MAP;
        synchronized (object) {
            if (TASK_POOL_MAP.get(task) != null) {
                Log.e((String)"ThreadUtils", (String)"Task can only be executed once.");
                return;
            }
            TASK_POOL_MAP.put(task, executorService);
        }
        if (l2 == 0L) {
            if (l == 0L) {
                executorService.execute(task);
            } else {
                object = new TimerTask(){

                    @Override
                    public void run() {
                        executorService.execute(task);
                    }
                };
                TIMER.schedule((TimerTask)object, timeUnit.toMillis(l));
            }
        } else {
            ((Task)task).setSchedule(true);
            object = new TimerTask(){

                @Override
                public void run() {
                    executorService.execute(task);
                }
            };
            TIMER.scheduleAtFixedRate((TimerTask)object, timeUnit.toMillis(l), timeUnit.toMillis(l2));
        }
    }

    private static ExecutorService getPoolByTypeAndPriority(int n) {
        return ThreadUtils.getPoolByTypeAndPriority(n, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorService getPoolByTypeAndPriority(int n, int n2) {
        Map<Integer, Map<Integer, ExecutorService>> map = TYPE_PRIORITY_POOLS;
        synchronized (map) {
            ExecutorService executorService;
            Map<Integer, ExecutorService> map2 = TYPE_PRIORITY_POOLS.get(n);
            if (map2 == null) {
                map2 = new ConcurrentHashMap<Integer, ExecutorService>();
                executorService = ThreadPoolExecutor4Util.createPool(n, n2);
                map2.put(n2, executorService);
                TYPE_PRIORITY_POOLS.put(n, map2);
            } else {
                executorService = map2.get(n2);
                if (executorService == null) {
                    executorService = ThreadPoolExecutor4Util.createPool(n, n2);
                    map2.put(n2, executorService);
                }
            }
            return executorService;
        }
    }

    private static Executor getGlobalDeliver() {
        if (sDeliver == null) {
            sDeliver = new Executor(){

                @Override
                public void execute(@NonNull Runnable runnable) {
                    ThreadUtils.runOnUiThread(runnable);
                }
            };
        }
        return sDeliver;
    }

    public static class SyncValue<T> {
        private final CountDownLatch mLatch = new CountDownLatch(1);
        private final AtomicBoolean mFlag = new AtomicBoolean();
        private T mValue;

        public void setValue(T t) {
            if (this.mFlag.compareAndSet(false, true)) {
                this.mValue = t;
                this.mLatch.countDown();
            }
        }

        public T getValue() {
            if (!this.mFlag.get()) {
                try {
                    this.mLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    Log.e((String)"errorMessage", (String)interruptedException.getMessage());
                    Thread.currentThread().interrupt();
                }
            }
            return this.mValue;
        }

        public T getValue(long l, TimeUnit timeUnit, T t) {
            if (!this.mFlag.get()) {
                try {
                    this.mLatch.await(l, timeUnit);
                }
                catch (InterruptedException interruptedException) {
                    Log.e((String)"errorMessage", (String)interruptedException.getMessage());
                    Thread.currentThread().interrupt();
                    return t;
                }
            }
            return this.mValue;
        }
    }

    public static abstract class Task<T>
    implements Runnable {
        private static final int NEW = 0;
        private static final int RUNNING = 1;
        private static final int EXCEPTIONAL = 2;
        private static final int COMPLETING = 3;
        private static final int CANCELLED = 4;
        private static final int INTERRUPTED = 5;
        private static final int TIMEOUT = 6;
        private final AtomicInteger state = new AtomicInteger(0);
        private volatile boolean isSchedule;
        private volatile Thread runner;
        private Timer mTimer;
        private long mTimeoutMillis;
        private OnTimeoutListener mTimeoutListener;
        private Executor deliver;

        public abstract T doInBackground() throws Throwable;

        public abstract void onSuccess(T var1);

        public abstract void onCancel();

        public abstract void onFail(Throwable var1);

        @Override
        public void run() {
            if (this.isSchedule) {
                if (this.runner == null) {
                    if (!this.state.compareAndSet(0, 1)) {
                        return;
                    }
                    this.runner = Thread.currentThread();
                    if (this.mTimeoutListener != null) {
                        Log.w((String)"ThreadUtils", (String)"Scheduled task doesn't support timeout.");
                    }
                } else if (this.state.get() != 1) {
                    return;
                }
            } else {
                if (!this.state.compareAndSet(0, 1)) {
                    return;
                }
                this.runner = Thread.currentThread();
                if (this.mTimeoutListener != null) {
                    this.mTimer = new Timer();
                    this.mTimer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (!this.isDone() && mTimeoutListener != null) {
                                this.timeout();
                                mTimeoutListener.onTimeout();
                                this.onDone();
                            }
                        }
                    }, this.mTimeoutMillis);
                }
            }
            try {
                final T t = this.doInBackground();
                if (this.isSchedule) {
                    if (this.state.get() != 1) {
                        return;
                    }
                    this.getDeliver().execute(new Runnable(){

                        @Override
                        public void run() {
                            this.onSuccess(t);
                        }
                    });
                } else {
                    if (!this.state.compareAndSet(1, 3)) {
                        return;
                    }
                    this.getDeliver().execute(new Runnable(){

                        @Override
                        public void run() {
                            this.onSuccess(t);
                            this.onDone();
                        }
                    });
                }
            }
            catch (Exception exception) {
                this.state.compareAndSet(4, 5);
            }
            catch (Throwable throwable) {
                if (!this.state.compareAndSet(1, 2)) {
                    return;
                }
                this.getDeliver().execute(new Runnable(){

                    @Override
                    public void run() {
                        this.onFail(throwable);
                        this.onDone();
                    }
                });
            }
        }

        public void cancel() {
            this.cancel(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(boolean bl) {
            AtomicInteger atomicInteger = this.state;
            synchronized (atomicInteger) {
                if (this.state.get() > 1) {
                    return;
                }
                this.state.set(4);
            }
            if (bl && this.runner != null) {
                this.runner.interrupt();
            }
            this.getDeliver().execute(new Runnable(){

                @Override
                public void run() {
                    this.onCancel();
                    this.onDone();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void timeout() {
            AtomicInteger atomicInteger = this.state;
            synchronized (atomicInteger) {
                if (this.state.get() > 1) {
                    return;
                }
                this.state.set(6);
            }
            if (this.runner != null) {
                this.runner.interrupt();
            }
        }

        public boolean isCanceled() {
            return this.state.get() >= 4;
        }

        public boolean isDone() {
            return this.state.get() > 1;
        }

        public Task<T> setDeliver(Executor executor) {
            this.deliver = executor;
            return this;
        }

        public Task<T> setTimeout(long l, OnTimeoutListener onTimeoutListener) {
            this.mTimeoutMillis = l;
            this.mTimeoutListener = onTimeoutListener;
            return this;
        }

        private void setSchedule(boolean bl) {
            this.isSchedule = bl;
        }

        private Executor getDeliver() {
            if (this.deliver == null) {
                return ThreadUtils.getGlobalDeliver();
            }
            return this.deliver;
        }

        @CallSuper
        protected void onDone() {
            TASK_POOL_MAP.remove(this);
            if (this.mTimer != null) {
                this.mTimer.cancel();
                this.mTimer = null;
                this.mTimeoutListener = null;
            }
        }

        public static interface OnTimeoutListener {
            public void onTimeout();
        }
    }

    public static abstract class SimpleTask<T>
    extends Task<T> {
        @Override
        public void onCancel() {
            Log.e((String)"ThreadUtils", (String)("onCancel: " + Thread.currentThread()));
        }

        @Override
        public void onFail(Throwable throwable) {
            Log.e((String)"ThreadUtils", (String)"onFail: ", (Throwable)throwable);
        }
    }

    static final class UtilsThreadFactory
    extends AtomicLong
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private static final long serialVersionUID = -9209200509960368598L;
        private final String namePrefix;
        private final int priority;
        private final boolean isDaemon;

        UtilsThreadFactory(String string, int n) {
            this(string, n, false);
        }

        UtilsThreadFactory(String string, int n, boolean bl) {
            this.namePrefix = string + "-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";
            this.priority = n;
            this.isDaemon = bl;
        }

        @Override
        public Thread newThread(@NonNull Runnable runnable) {
            Thread thread = new Thread(runnable, this.namePrefix + this.getAndIncrement()){

                @Override
                public void run() {
                    try {
                        super.run();
                    }
                    catch (Throwable throwable) {
                        Log.e((String)"ThreadUtils", (String)"Request threw uncaught throwable", (Throwable)throwable);
                    }
                }
            };
            thread.setDaemon(this.isDaemon);
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    System.out.println(throwable);
                }
            });
            thread.setPriority(this.priority);
            return thread;
        }
    }

    private static final class LinkedBlockingQueue4Util
    extends LinkedBlockingQueue<Runnable> {
        private volatile ThreadPoolExecutor4Util mPool;
        private int mCapacity = Integer.MAX_VALUE;

        LinkedBlockingQueue4Util() {
        }

        LinkedBlockingQueue4Util(boolean bl) {
            if (bl) {
                this.mCapacity = 0;
            }
        }

        LinkedBlockingQueue4Util(int n) {
            this.mCapacity = n;
        }

        @Override
        public boolean offer(@NonNull Runnable runnable) {
            if (this.mCapacity <= this.size() && this.mPool != null && this.mPool.getPoolSize() < this.mPool.getMaximumPoolSize()) {
                return false;
            }
            return super.offer(runnable);
        }
    }

    static final class ThreadPoolExecutor4Util
    extends ThreadPoolExecutor {
        private final AtomicInteger mSubmittedCount = new AtomicInteger();
        private final LinkedBlockingQueue4Util mWorkQueue;

        private static ExecutorService createPool(int n, int n2) {
            switch (n) {
                case -1: {
                    return new ThreadPoolExecutor4Util(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue4Util(), (ThreadFactory)new UtilsThreadFactory("single", n2));
                }
                case -2: {
                    return new ThreadPoolExecutor4Util(0, 128, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue4Util(true), (ThreadFactory)new UtilsThreadFactory("cached", n2));
                }
                case -4: {
                    return new ThreadPoolExecutor4Util(2 * CPU_COUNT + 1, 2 * CPU_COUNT + 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue4Util(), (ThreadFactory)new UtilsThreadFactory("io", n2));
                }
                case -8: {
                    return new ThreadPoolExecutor4Util(CPU_COUNT + 1, 2 * CPU_COUNT + 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue4Util(true), (ThreadFactory)new UtilsThreadFactory("cpu", n2));
                }
            }
            return new ThreadPoolExecutor4Util(n, n, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue4Util(), (ThreadFactory)new UtilsThreadFactory("fixed(" + n + ")", n2));
        }

        ThreadPoolExecutor4Util(int n, int n2, long l, TimeUnit timeUnit, LinkedBlockingQueue4Util linkedBlockingQueue4Util, ThreadFactory threadFactory) {
            super(n, n2, l, timeUnit, (BlockingQueue<Runnable>)linkedBlockingQueue4Util, threadFactory);
            linkedBlockingQueue4Util.mPool = this;
            this.mWorkQueue = linkedBlockingQueue4Util;
        }

        private int getSubmittedCount() {
            return this.mSubmittedCount.get();
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            this.mSubmittedCount.decrementAndGet();
            super.afterExecute(runnable, throwable);
        }

        @Override
        public void execute(@NonNull Runnable runnable) {
            if (this.isShutdown()) {
                return;
            }
            this.mSubmittedCount.incrementAndGet();
            try {
                super.execute(runnable);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                Log.e((String)"ThreadUtils", (String)"This will not happen!");
                this.mWorkQueue.offer(runnable);
            }
            catch (Throwable throwable) {
                this.mSubmittedCount.decrementAndGet();
            }
        }
    }
}

