/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.base;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import com.cloud.hisavana.sdk.manager.NetStateManager;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.cloud.sdk.commonutil.util.RunTimer;
import com.hisavana.common.bean.AdCache;
import com.hisavana.common.bean.AdNativeInfo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.bean.TAdRequestBody;
import com.hisavana.common.interfacz.Iad;
import com.hisavana.common.interfacz.WrapTAdAllianceListener;
import com.hisavana.common.manager.AdCacheManager;
import com.hisavana.common.manager.RequestingAdManager;
import com.hisavana.common.mock.RecordTestInfo;
import com.hisavana.common.tracking.TrackingManager;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.common.utils.MediaLogUtil;
import com.hisavana.common.utils.ThreadUtils;
import java.lang.ref.WeakReference;
import java.util.List;

public abstract class BaseAd
implements Iad {
    private boolean isTimeOut = false;
    protected String mAdUnit;
    protected boolean isOfflineAd;
    private int supportHisavanaFlag = 0;
    private double maxPrice;
    private String sceneId;
    private String sceneToken;
    protected int mAdCount = 1;
    protected volatile WeakReference<Context> mContext;
    private final String TAG = "BaseAd";
    private double price = 0.0;
    public double secondPrice;
    private int ttl;
    private int adSource;
    protected long startTime;
    protected TAdRequestBody mAdRequestBody;
    protected volatile boolean isLoaded = false;
    protected RunTimer runTimer;
    protected volatile WrapTAdAllianceListener listener;
    private long mLoadedTime;
    private long mImpressionTime;
    protected volatile Network mNetwork;
    private int mLoadStatus;
    protected int requestType;
    private int mRequestRound = -1;
    public final Bundle mBundle = new Bundle();
    protected String mRequestId = null;
    protected String mTriggerId = null;
    protected String mShowId = null;
    private volatile boolean isDestroyed = false;
    protected RunTimer.TimeOutCallback timeOutCallback = new RunTimer.TimeOutCallback(){

        public void isTimeOut() {
            AdLogUtil.Log().d("BaseAd", "Load ad is time out" + BaseAd.this.getLogString());
            BaseAd.this.onTimeOut();
        }
    };
    private long requestTime;

    @Override
    public void setTimeOut(boolean bl) {
        this.isTimeOut = bl;
    }

    public BaseAd(Context context, Network network) {
        this.mContext = new WeakReference<Context>(context);
        Preconditions.checkNotNull((Object)network);
        this.mNetwork = network;
    }

    @Override
    public void setSecondPrice(double d) {
        AdLogUtil.Log().d("ssp_second_price", "*----> BaseAd setSecondPrice price" + d + this.getLogString());
        this.secondPrice = d;
    }

    public String getLogString() {
        return "----- class name = " + this.getClass().getSimpleName() + " ----- mAdUnit = " + this.mAdUnit;
    }

    @Override
    public void setRequestRound(int n) {
        AdLogUtil.Log().d("BaseAd", "setRequestRound " + n + " " + this.getLogString());
        this.mRequestRound = n;
    }

    @Override
    public void setRequestType(int n) {
        this.requestType = n;
    }

    @Override
    public boolean isAdxAd() {
        return false;
    }

    @Override
    public boolean isEwAd() {
        return false;
    }

    @Override
    public void loadAd() {
        this.mRequestId = DeviceUtil.getUUID();
        this.startTime = System.currentTimeMillis();
        if (this.listener != null) {
            this.listener.onStart(this.getAdSource());
        }
        if (this.supportTimer()) {
            this.startTimer();
        }
        this.adTrackingRequest();
        if (this.mNetwork != null) {
            MediaLogUtil.d("BaseAd", "loadAd adSource " + this.mNetwork.getSource() + " id " + this.mNetwork.getCodeSeatId() + " " + this.getLogString());
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAdUnit)) {
            RequestingAdManager.getInstance().addRequest(this);
        }
    }

    public void setShowId(String string) {
        this.mShowId = string;
    }

    private void adLoadedTemp() {
        ThreadUtils.runOnWorkThread(() -> {
            RequestingAdManager.getInstance().removeRequest(this);
            if (this.isLoaded) {
                AdLogUtil.Log().d("BaseAd", "Ad request has been destroyed or loaded,isLoaded = " + this.isLoaded + ",isDestroyed = " + this.isDestroyed);
                return;
            }
            if (this.mNetwork != null) {
                MediaLogUtil.d("BaseAd", "loadSuccess adSource " + this.mNetwork.getSource() + " id " + this.mNetwork.getCodeSeatId() + " " + this.getLogString());
            }
            WrapTAdAllianceListener wrapTAdAllianceListener = this.listener;
            AdCache adCache = AdCacheManager.getCache(this.getAdType());
            if (adCache != null) {
                adCache.addCache(this.mAdUnit, this);
            }
            Bundle bundle = new Bundle();
            bundle.putInt("error_code", 0);
            bundle.putInt("request_num", this.mAdCount);
            this.adReturnTracking(bundle);
            this.isLoaded = true;
            this.mLoadedTime = System.currentTimeMillis();
            if (wrapTAdAllianceListener != null) {
                wrapTAdAllianceListener.onLoad();
            }
            if (this.supportTimer()) {
                this.stopTimer();
            }
        });
    }

    public void adLoaded() {
        this.adLoadedTemp();
    }

    private void adLoadedTemp(List<TAdNativeInfo> list) {
        ThreadUtils.runOnWorkThread(() -> {
            TAdNativeInfo tAdNativeInfo;
            RequestingAdManager.getInstance().removeRequest(this);
            if (this.isLoaded) {
                AdLogUtil.Log().d("BaseAd", "Ad request has been destroyed or loaded,isLoaded = " + this.isLoaded + ",isDestroyed = " + this.isDestroyed);
                return;
            }
            if (this.mNetwork != null) {
                MediaLogUtil.d("BaseAd", "loadSuccess adSource " + this.mNetwork.getSource() + " id " + this.mNetwork.getCodeSeatId() + " " + this.getLogString());
            }
            WrapTAdAllianceListener wrapTAdAllianceListener = this.listener;
            AdCache adCache = AdCacheManager.getCache(this.getAdType());
            if (list != null && list.size() > 0 && adCache != null) {
                adCache.addCaches(this.mAdUnit, list);
            }
            Bundle bundle = new Bundle();
            bundle.putInt("error_code", 0);
            if (list != null && list.size() > 0 && (tAdNativeInfo = (TAdNativeInfo)list.get(0)).getEcpmPrice() > 0.0) {
                this.price = tAdNativeInfo.getEcpmPrice();
            }
            this.adReturnTracking(bundle);
            this.isLoaded = true;
            this.mLoadedTime = System.currentTimeMillis();
            if (wrapTAdAllianceListener != null) {
                wrapTAdAllianceListener.onLoad(list);
            }
            if (this.supportTimer()) {
                this.stopTimer();
            }
        });
    }

    public void adLoaded(List<TAdNativeInfo> list) {
        this.adLoadedTemp(list);
    }

    private void adFailedToLoadTemp(TAdErrorCode tAdErrorCode) {
        ThreadUtils.runOnWorkThread(() -> {
            int n;
            RequestingAdManager.getInstance().removeRequest(this);
            if (this.isLoaded) {
                AdLogUtil.Log().d("BaseAd", "Ad request has been destroyed or loaded,isLoaded = " + this.isLoaded + ",isDestroyed = " + this.isDestroyed);
                return;
            }
            this.isLoaded = true;
            Bundle bundle = new Bundle();
            int n2 = n = tAdErrorCode != null ? tAdErrorCode.getErrorCode() : 30003;
            if (n == 0) {
                n = 30003;
            }
            bundle.putInt("error_code", n);
            bundle.putString("error_message", null == tAdErrorCode ? "null" : tAdErrorCode.getErrorMessage());
            bundle.putInt("request_num", this.mAdCount);
            this.adReturnTracking(bundle);
            if (this.listener != null) {
                this.listener.onError(tAdErrorCode);
            }
            if (this.supportTimer()) {
                this.stopTimer();
            }
            this.destroyAd();
        });
    }

    protected void adFailedToLoad(TAdErrorCode tAdErrorCode) {
        this.adFailedToLoadTemp(tAdErrorCode);
    }

    protected void onAdShowError(TAdErrorCode tAdErrorCode) {
        this.onAdShowError(null, tAdErrorCode);
    }

    protected void onAdShowError(TAdNativeInfo tAdNativeInfo, TAdErrorCode tAdErrorCode) {
        this.logImpression(tAdNativeInfo, false, tAdErrorCode);
        if (this.listener != null) {
            this.listener.onShowError(tAdErrorCode);
        }
    }

    public void adImpression(AdNativeInfo adNativeInfo) {
        this.logImpression(adNativeInfo, true, TAdErrorCode.SUCCESS_MESSAGE);
        this.mImpressionTime = System.currentTimeMillis();
        if (this.listener != null) {
            this.listener.onNativeFeedShow(this.getAdSource(), adNativeInfo);
        }
    }

    @Override
    public boolean isIconAd() {
        return this.mNetwork == null ? false : this.mNetwork.getAdt() == 6;
    }

    @Override
    public boolean isSupportRtBidding() {
        return false;
    }

    public boolean isSupportStopRequest() {
        return false;
    }

    @Override
    public Network getNetwork() {
        return this.mNetwork;
    }

    public void adClicked(AdNativeInfo adNativeInfo) {
        this.logClick();
        if (this.listener != null) {
            this.listener.onNativeFeedClicked(this.getAdSource(), adNativeInfo);
        }
    }

    @Override
    public void setLoadStatus(int n) {
        this.mLoadStatus = n;
    }

    @Override
    public int getLoadStatus() {
        return this.mLoadStatus;
    }

    protected void adClosed() {
        this.logClose();
        if (this.listener != null) {
            this.listener.onClosed(this.getAdSource());
        }
    }

    protected void adClosed(TAdNativeInfo tAdNativeInfo) {
        this.logClose();
        if (this.listener != null) {
            this.listener.onClosed(tAdNativeInfo);
        }
    }

    protected void onReward() {
        if (this.listener != null) {
            this.listener.onRewarded();
        }
    }

    private void appendContextParam(Bundle bundle) {
        bundle.putString("trigger_id", this.mBundle.getString("trigger_id"));
        bundle.putLong("trigger_ts", this.mBundle.getLong("trigger_ts"));
        bundle.putInt("ad_type", this.mBundle.getInt("ad_type"));
        bundle.putString("cld_app_id", this.mBundle.getString("cld_app_id"));
        bundle.putString("cld_code_seat_id", this.mBundle.getString("cld_code_seat_id"));
        bundle.putInt("platform", this.mBundle.getInt("platform"));
        bundle.putString("app_id", this.mBundle.getString("app_id"));
        bundle.putString("code_seat_id", this.mBundle.getString("code_seat_id"));
        bundle.putDouble("bidding_price", this.mBundle.getDouble("bidding_price"));
        bundle.putInt("priority", this.mBundle.getInt("priority"));
        bundle.putInt("ad_count", this.mBundle.getInt("ad_count"));
        bundle.putInt("is_retreatad", this.mBundle.getInt("is_retreatad"));
        bundle.putInt("is_default_ad", 0);
        bundle.putLong("request_ts", this.mBundle.getLong("request_ts"));
        bundle.putInt("request_time", this.mBundle.getInt("request_time"));
        bundle.putString("request_id", this.mBundle.getString("request_id"));
        bundle.putLong("return_ts", this.mBundle.getLong("return_ts"));
        bundle.putInt("return_time", this.mBundle.getInt("return_time"));
        bundle.putInt("request_type", this.mBundle.getInt("request_type"));
    }

    private void addToContextParam(String string, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Integer) {
            this.mBundle.putInt(string, ((Integer)object).intValue());
        } else if (object instanceof String) {
            this.mBundle.putString(string, (String)object);
        } else if (object instanceof Long) {
            this.mBundle.putLong(string, ((Long)object).longValue());
        }
    }

    protected void logImpression(TAdNativeInfo tAdNativeInfo, boolean bl, TAdErrorCode tAdErrorCode) {
        Bundle bundle = new Bundle();
        this.appendContextParam(bundle);
        bundle.putLong("show_ts", System.currentTimeMillis());
        bundle.putLong("show_time", System.currentTimeMillis() - this.mLoadedTime);
        bundle.putString("ad_title", this.mBundle.getString("ad_title"));
        bundle.putString("ad_url", this.mBundle.getString("ad_url"));
        bundle.putInt("filling_source", this.mBundle.getInt("filling_source"));
        bundle.putString("description", this.mBundle.getString("description"));
        bundle.putString("image_url", this.mBundle.getString("image_url"));
        bundle.putString("icon_url", this.mBundle.getString("icon_url"));
        bundle.putString("endcard_url", this.mBundle.getString("endcard_url"));
        bundle.putString("app_name", this.mBundle.getString("app_name"));
        bundle.putString("package_name", this.mBundle.getString("package_name"));
        bundle.putString("download_url", this.mBundle.getString("download_url"));
        bundle.putInt("ad_trigger_status", this.mBundle.getInt("ad_trigger_status"));
        bundle.putInt("is_offline_ad", this.isOfflineAd() ? 1 : 0);
        bundle.putInt("filling_ad_type", this.mBundle.getInt("filling_ad_type"));
        bundle.putInt("slot_height", 0);
        bundle.putInt("slot_width", 0);
        bundle.putString("scene_id", this.sceneId);
        bundle.putInt("is_expired", this.isExpired() ? 1 : 0);
        if (bl) {
            bundle.putInt("show_status", 1);
            bundle.putInt("fail_reason", 0);
        } else {
            bundle.putInt("show_status", 2);
            bundle.putInt("fail_reason", 2);
        }
        bundle.putInt("is_pre_trigger", this.mBundle.getInt("is_pre_trigger"));
        bundle.putInt("filling_source", this.mBundle.getInt("filling_source"));
        bundle.putString("request_id", this.mBundle.getString("request_id"));
        bundle.putInt("request_num", this.mBundle.getInt("request_num"));
        bundle.putString("traffic_group_id", this.mBundle.getString("traffic_group_id"));
        bundle.putString("experiment_group_id", this.mBundle.getString("experiment_group_id"));
        bundle.putInt("optimize_status", this.mBundle.getInt("optimize_status"));
        bundle.putInt("priority_code", this.mBundle.getInt("priority_code"));
        if (this.maxPrice == 0.0) {
            this.maxPrice = this.mBundle.getDouble("max_price");
        }
        bundle.putDouble("max_price", this.maxPrice);
        bundle.putDouble("ecpm", tAdNativeInfo == null ? this.price : tAdNativeInfo.getEcpmPrice());
        bundle.putString("ecpm_precision", this.isWaterFallExecuter() ? "estimated" : "exact");
        bundle.putString("show_id", tAdNativeInfo == null ? this.mShowId : tAdNativeInfo.getShowId());
        bundle.putString("scene_token", tAdNativeInfo == null ? this.sceneToken : tAdNativeInfo.getSceneToken());
        bundle.putString("error_code", tAdErrorCode == null ? null : String.valueOf(tAdErrorCode.getErrorCode()));
        bundle.putString("error_message", tAdErrorCode == null ? null : tAdErrorCode.getErrorMessage());
        bundle.putInt("is_offline", NetStateManager.checkNetworkState() ? 0 : 1);
        TrackingManager.trackingImpression(bundle);
        this.addToContextParam("show_ts", bundle.getLong("show_ts"));
        this.addToContextParam("show_time", bundle.getLong("show_time"));
        this.addToContextParam("slot_height", bundle.getInt("slot_height"));
        this.addToContextParam("slot_width", bundle.getInt("slot_width"));
        this.addToContextParam("show_status", bundle.getInt("show_status"));
        this.addToContextParam("fail_reason", bundle.getInt("fail_reason"));
        this.mBundle.putDouble("max_price", bundle.getDouble("max_price"));
    }

    @Override
    public String getAdUnit() {
        return this.mAdUnit;
    }

    @Override
    public void setAdUnit(String string) {
        this.mAdUnit = string;
    }

    protected void logTrigerShow(String string, String string2) {
        this.trigerShow(null, string, string2);
    }

    public void logTrigerShow(TAdNativeInfo tAdNativeInfo) {
        this.trigerShow(tAdNativeInfo, "", "");
    }

    protected void trigerShow(TAdNativeInfo tAdNativeInfo, String string, String string2) {
        Bundle bundle = new Bundle();
        this.appendContextParam(bundle);
        if (bundle.containsKey("is_default_ad")) {
            bundle.remove("is_default_ad");
        }
        bundle.putInt("is_timeout", this.mBundle.getInt("is_timeout"));
        bundle.putString("error_code", this.mBundle.getString("error_code"));
        bundle.putString("error_message", this.mBundle.getString("error_message"));
        if (tAdNativeInfo != null) {
            bundle.putString("ad_title", tAdNativeInfo.getTitle());
            bundle.putString("ad_url", "");
            bundle.putString("description", tAdNativeInfo.getDescription());
            if (null != tAdNativeInfo.getIcon()) {
                bundle.putString("icon_url", tAdNativeInfo.getIcon().getUrl());
            }
            bundle.putString("endcard_url", "");
            bundle.putString("app_name", "");
            bundle.putString("package_name", "");
            bundle.putString("download_url", "");
            bundle.putString("scene_id", tAdNativeInfo.getSceneId());
            this.sceneId = tAdNativeInfo.getSceneId() == null ? "" : tAdNativeInfo.getSceneId();
            bundle.putString("scene_token", tAdNativeInfo.getSceneToken());
            this.sceneToken = tAdNativeInfo.getSceneToken();
        } else {
            bundle.putString("scene_id", string2);
            this.sceneId = string2 == null ? "" : string2;
            bundle.putString("scene_token", string);
            this.sceneToken = string;
        }
        bundle.putInt("is_pre_trigger", this.mBundle.getInt("is_pre_trigger"));
        bundle.putInt("filling_source", this.mBundle.getInt("filling_source"));
        bundle.putString("request_id", this.mBundle.getString("request_id"));
        bundle.putInt("ad_trigger_status", this.mBundle.getInt("ad_trigger_status"));
        bundle.putInt("is_offline_ad", this.isOfflineAd() ? 1 : 0);
        bundle.putInt("filling_ad_type", this.mBundle.getInt("filling_ad_type"));
        bundle.putString("traffic_group_id", this.mBundle.getString("traffic_group_id"));
        bundle.putString("experiment_group_id", this.mBundle.getString("experiment_group_id"));
        bundle.putString("show_id", tAdNativeInfo == null ? this.mShowId : tAdNativeInfo.getShowId());
        bundle.putInt("is_offline", NetStateManager.checkNetworkState() ? 0 : 1);
        TrackingManager.trackingTrigerShow(bundle);
        this.addToContextParam("ad_title", bundle.getString("ad_title"));
        this.addToContextParam("ad_url", "");
        this.addToContextParam("description", bundle.getString("description"));
        this.addToContextParam("image_url", bundle.getString("image_url"));
        this.addToContextParam("icon_url", bundle.getString("icon_url"));
        this.addToContextParam("endcard_url", "");
        this.addToContextParam("app_name", "");
        this.addToContextParam("package_name", "");
        this.addToContextParam("download_url", "");
        this.addToContextParam("request_num", this.mAdCount);
    }

    protected void logClick() {
        Bundle bundle = new Bundle();
        this.appendContextParam(bundle);
        bundle.putInt("request_time", this.mBundle.getInt("request_time"));
        bundle.putLong("return_ts", this.mBundle.getLong("return_ts"));
        bundle.putInt("return_time", this.mBundle.getInt("return_time"));
        bundle.putLong("show_ts", this.mBundle.getLong("show_ts"));
        bundle.putLong("show_time", this.mBundle.getLong("show_time"));
        bundle.putLong("click_ts", System.currentTimeMillis());
        bundle.putInt("click_time", (int)(System.currentTimeMillis() - this.mImpressionTime));
        bundle.putString("ad_title", this.mBundle.getString("ad_title"));
        bundle.putString("ad_url", this.mBundle.getString("ad_url"));
        bundle.putInt("filling_source", this.mBundle.getInt("filling_source"));
        bundle.putString("description", this.mBundle.getString("description"));
        bundle.putString("image_url", this.mBundle.getString("image_url"));
        bundle.putString("icon_url", this.mBundle.getString("icon_url"));
        bundle.putString("endcard_url", this.mBundle.getString("app_name"));
        bundle.putString("app_name", this.mBundle.getString("app_name"));
        bundle.putString("package_name", this.mBundle.getString("package_name"));
        bundle.putString("download_url", this.mBundle.getString("download_url"));
        bundle.putInt("slot_height", this.mBundle.getInt("slot_height"));
        bundle.putInt("slot_width", this.mBundle.getInt("slot_width"));
        bundle.putInt("is_pre_trigger", this.mBundle.getInt("is_pre_trigger"));
        bundle.putInt("request_type", this.mBundle.getInt("request_type"));
        bundle.putString("request_id", this.mBundle.getString("request_id"));
        bundle.putInt("click_x", 0);
        bundle.putInt("click_y", 0);
        bundle.putInt("is_expired", this.isExpired() ? 1 : 0);
        bundle.putInt("request_num", this.mBundle.getInt("request_num"));
        bundle.putInt("ad_trigger_status", this.mBundle.getInt("ad_trigger_status"));
        bundle.putInt("is_offline_ad", this.isOfflineAd() ? 1 : 0);
        bundle.putInt("filling_ad_type", this.mBundle.getInt("filling_ad_type"));
        bundle.putString("traffic_group_id", this.mBundle.getString("traffic_group_id"));
        bundle.putString("experiment_group_id", this.mBundle.getString("experiment_group_id"));
        bundle.putInt("priority_code", this.mBundle.getInt("priority_code"));
        bundle.putDouble("max_price", this.mBundle.getDouble("max_price"));
        bundle.putString("scene_id", this.sceneId);
        TrackingManager.trackingAdClick(bundle);
    }

    protected void logClose() {
        Bundle bundle = new Bundle();
        this.appendContextParam(bundle);
        bundle.putInt("request_time", this.mBundle.getInt("request_time"));
        bundle.putLong("return_ts", this.mBundle.getLong("return_ts"));
        bundle.putInt("return_time", this.mBundle.getInt("return_time"));
        bundle.putLong("show_ts", this.mBundle.getLong("show_ts"));
        bundle.putLong("show_time", this.mBundle.getLong("show_time"));
        bundle.putLong("click_ts", System.currentTimeMillis());
        bundle.putInt("click_time", (int)(System.currentTimeMillis() - this.mImpressionTime));
        bundle.putString("ad_title", this.mBundle.getString("ad_title"));
        bundle.putString("ad_url", this.mBundle.getString("ad_url"));
        bundle.putInt("filling_source", this.mBundle.getInt("filling_source"));
        bundle.putString("description", this.mBundle.getString("description"));
        bundle.putString("image_url", this.mBundle.getString("image_url"));
        bundle.putString("icon_url", this.mBundle.getString("icon_url"));
        bundle.putString("endcard_url", this.mBundle.getString("endcard_url"));
        bundle.putString("app_name", this.mBundle.getString("app_name"));
        bundle.putString("package_name", this.mBundle.getString("package_name"));
        bundle.putString("download_url", this.mBundle.getString("download_url"));
        bundle.putString("traffic_group_id", this.mBundle.getString("traffic_group_id"));
        bundle.putString("experiment_group_id", this.mBundle.getString("experiment_group_id"));
        bundle.putInt("slot_height", 0);
        bundle.putInt("slot_width", 0);
        bundle.putInt("click_x", 0);
        bundle.putInt("click_y", 0);
        bundle.putString("scene_id", this.sceneId);
        TrackingManager.trackingAdClose(bundle);
    }

    @Override
    public void detachContext() {
        this.mAdRequestBody = null;
        this.listener = null;
    }

    @Override
    public void destroyAd() {
        this.isDestroyed = true;
        this.detachContext();
        this.stopTimer();
        if (!this.isLoaded) {
            this.isLoaded = true;
            Bundle bundle = new Bundle();
            bundle.putInt("error_code", 30005);
            bundle.putString("error_message", TAdErrorCode.ERROR_REQUEST_OBJECT_IS_DESTROYED.getErrorMessage());
            bundle.putInt("request_num", this.mAdCount);
            this.adReturnTracking(bundle);
        }
    }

    @Override
    public void setRequestBody(TAdRequestBody tAdRequestBody) {
        this.mAdRequestBody = tAdRequestBody;
        if (tAdRequestBody != null) {
            this.listener = (WrapTAdAllianceListener)tAdRequestBody.getAdListener();
        }
    }

    @Override
    public TAdRequestBody getRequestBody() {
        return this.mAdRequestBody;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int n) {
        this.ttl = n;
    }

    @Override
    public boolean isExpired() {
        return this.getValidTimeLimit() <= 0L;
    }

    @Override
    public long getValidTimeLimit() {
        if (this.ttl <= 0) {
            return Long.MAX_VALUE;
        }
        return (long)this.ttl * 60L * 1000L - Math.abs(System.currentTimeMillis() - this.startTime);
    }

    @Override
    public int getAdSource() {
        return this.adSource;
    }

    @Override
    public void setEcpmPrice(double d) {
        this.price = d;
    }

    @Override
    public double getEcpmPrice() {
        return this.price;
    }

    @Override
    public void setAdSource(int n) {
        this.adSource = n;
    }

    @Override
    public String getPlacementId() {
        return this.mNetwork.getCodeSeatId();
    }

    @Override
    public void stopLoader() {
        if (this.isLoaded) {
            return;
        }
        try {
            if (this.isSupportStopRequest()) {
                this.destroyAd();
            } else {
                this.detachContext();
                this.setLoadStatus(4);
            }
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("BaseAd", Log.getStackTraceString((Throwable)exception));
        }
    }

    @Override
    public String getFilterSource() {
        return "";
    }

    @Override
    public void setOfflineAd(boolean bl) {
        this.isOfflineAd = bl;
    }

    protected boolean supportTimer() {
        return true;
    }

    protected void startTimer() {
        if (this.runTimer == null) {
            this.runTimer = new RunTimer();
            this.runTimer.setScheduleTime(this.getTimeOutTime());
            this.runTimer.setTimeOutCallback(this.timeOutCallback);
        }
        this.runTimer.runTimerTask();
        AdLogUtil.Log().d("BaseAd", "\u542f\u52a8\u5e7f\u544a\u8bf7\u6c42\u8d85\u65f6\u76d1\u542c...");
    }

    protected int getTimeOutTime() {
        return 30000;
    }

    protected void stopTimer() {
        if (this.runTimer != null) {
            this.runTimer.cancelTimeTask();
            this.runTimer = null;
        }
    }

    public void onTimeOut() {
        this.adFailedToLoad(TAdErrorCode.ERROR_AD_REQUEST_TIME_OUT);
        this.destroyAd();
    }

    public void post(Handler handler, Runnable runnable) {
        if (handler != null) {
            handler.post(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public void setTrackingBundle(Bundle bundle) {
        if (null == bundle) {
            return;
        }
        this.mBundle.putAll(bundle);
        this.mBundle.putDouble("bidding_price", this.mNetwork.getPrice().doubleValue());
    }

    protected void adTrackingRequest() {
        RecordTestInfo.record("adTrackingRequest code_seat_id:" + this.getPlacementId() + ",bidding_price:" + this.mBundle.getDouble("bidding_price"));
        this.mBundle.putInt("ad_count", this.mAdCount);
        this.mBundle.putInt("is_retreatad", 0);
        this.mBundle.putInt("is_default_ad", 0);
        if (TextUtils.isEmpty((CharSequence)this.mRequestId)) {
            this.mRequestId = DeviceUtil.getUUID();
        }
        this.mTriggerId = this.mBundle.getString("trigger_id");
        this.mBundle.putString("request_id", this.mRequestId);
        this.mBundle.putString("cld_configure_id", AdxPreferencesHelper.getInstance().getString("cloudControlVersion"));
        this.mBundle.putInt("request_num", this.mAdCount);
        this.mBundle.putInt("request_round", this.mRequestRound);
        TrackingManager.trackingAdRequest(this.mBundle);
    }

    public void adReturnTracking(Bundle bundle) {
        if (null == bundle || null == this.mBundle) {
            return;
        }
        Bundle bundle2 = new Bundle(this.mBundle);
        if (bundle2.containsKey("cld_configure_id")) {
            bundle2.remove("cld_configure_id");
        }
        bundle.putString("trigger_id", bundle2.getString("trigger_id"));
        bundle.putLong("trigger_ts", bundle2.getLong("trigger_ts"));
        bundle.putLong("request_ts", bundle2.getLong("request_ts"));
        bundle.putInt("request_time", (int)(bundle2.getLong("request_ts") - bundle2.getLong("trigger_ts")));
        bundle.putString("request_id", bundle2.getString("request_id"));
        bundle.putLong("return_ts", System.currentTimeMillis());
        bundle.putInt("return_time", (int)(System.currentTimeMillis() - bundle2.getLong("request_ts")));
        bundle2.putLong("return_ts", System.currentTimeMillis());
        bundle2.putInt("return_time", (int)(System.currentTimeMillis() - bundle2.getLong("request_ts")));
        bundle.putInt("ad_type", bundle2.getInt("ad_type"));
        bundle.putString("cld_app_id", bundle2.getString("cld_app_id"));
        bundle.putString("cld_code_seat_id", bundle2.getString("cld_code_seat_id"));
        bundle.putInt("platform", bundle2.getInt("platform"));
        bundle.putString("app_id", bundle2.getString("app_id"));
        bundle.putString("code_seat_id", bundle2.getString("code_seat_id"));
        if (this.adSource == 0 || this.adSource == 6 || this.adSource == 14) {
            bundle.putDouble("bidding_price", this.price);
        } else {
            bundle.putDouble("bidding_price", bundle2.getDouble("bidding_price"));
        }
        RecordTestInfo.record("adReturnTracking code_seat_id:" + bundle2.getString("code_seat_id") + ",bidding_price:" + bundle.getDouble("bidding_price"));
        bundle.putInt("priority", bundle2.getInt("priority"));
        bundle.putInt("ad_count", bundle2.getInt("ad_count"));
        bundle.putInt("is_retreatad", bundle2.getInt("is_retreatad"));
        bundle.putInt("is_default_ad", 0);
        bundle.putInt("request_type", bundle2.getInt("request_type"));
        bundle.putInt("is_pre_trigger", bundle2.getInt("is_pre_trigger"));
        bundle.putString("ad_title", bundle2.getString("ad_title"));
        bundle.putString("ad_url", bundle2.getString("ad_url"));
        bundle.putString("description", bundle2.getString("description"));
        bundle.putString("image_url", bundle2.getString("image_url"));
        bundle.putString("icon_url", bundle2.getString("icon_url"));
        bundle.putString("endcard_url", bundle2.getString("endcard_url"));
        bundle.putString("app_name", bundle2.getString("app_name"));
        bundle.putString("package_name", bundle2.getString("package_name"));
        bundle.putString("native_info_list", bundle2.getString("native_info_list"));
        bundle.putString("download_url", bundle2.getString("download_url"));
        bundle.putInt("is_timeout", this.isTimeOut ? 1 : 0);
        bundle.putInt("request_num", this.mAdCount);
        bundle.putLong("is_offline_ad", this.isOfflineAd() ? 1L : 0L);
        bundle.putLong("ad_trigger_status", (long)bundle2.getInt("ad_trigger_status"));
        bundle.putInt("request_round", bundle2.getInt("request_round"));
        bundle.putString("traffic_group_id", bundle2.getString("traffic_group_id"));
        bundle.putString("experiment_group_id", bundle2.getString("experiment_group_id"));
        bundle.putInt("optimize_status", bundle2.getInt("optimize_status"));
        bundle.putInt("priority_code", bundle2.getInt("priority_code"));
        TrackingManager.trackingAdReturn(bundle);
    }

    public void admobShowPriceTracking(float f, String string, int n) {
        if (null == this.mBundle) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("trigger_id", this.mBundle.getString("trigger_id"));
        bundle.putString("request_id", this.mBundle.getString("request_id"));
        bundle.putString("cld_app_id", this.mBundle.getString("cld_app_id"));
        bundle.putString("app_id", this.mBundle.getString("app_id"));
        bundle.putString("cld_code_seat_id", this.mBundle.getString("cld_code_seat_id"));
        bundle.putString("code_seat_id", this.mBundle.getString("code_seat_id"));
        bundle.putFloat("ad_value", f);
        bundle.putString("advalue_currency_code", string);
        bundle.putInt("ad_value_type", n);
        bundle.putLong("event_ts", System.currentTimeMillis());
        TrackingManager.trackingAdmobShowPrice(bundle);
    }

    @Override
    public void setRequestTime(long l) {
        this.requestTime = l;
    }

    @Override
    public long getRequestTime() {
        return this.requestTime;
    }

    @Override
    public void setSupportFlag(int n) {
        this.supportHisavanaFlag = n;
    }

    protected int getSupportHisavanaFlag() {
        return this.supportHisavanaFlag;
    }

    @Override
    public void setMaxPrice(double d) {
        AdLogUtil.Log().d("Athena", "setMaxPrice " + d);
        this.maxPrice = d;
    }

    @Override
    public void setExt(String string) {
    }

    @Override
    public String getExt() {
        return "";
    }

    private boolean isWaterFallExecuter() {
        return this.adSource == 1 || this.adSource == 3 || this.adSource == 5 || this.adSource == 4 || this.adSource == 12 || this.adSource == 11 || this.adSource == 14;
    }
}

