/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.base;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.hisavana.common.base.BaseAd;
import com.hisavana.common.base.WrapTadView;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.interfacz.IadView;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.common.utils.ThreadUtils;

public abstract class BaseBanner<T extends View>
extends BaseAd
implements IadView {
    private final String TAG = "BaseBanner";
    protected boolean isHideAdCloseView;

    public BaseBanner(Context context, Network network) {
        super(context, network);
    }

    @Override
    public int getAdType() {
        return 2;
    }

    @Override
    public void loadAd() {
        ThreadUtils.runOnUiThread(() -> {
            T t = this.getBanner();
            if (t != null) {
                BaseBanner.super.loadAd();
                this.onBannerLoad();
            }
        });
    }

    protected abstract T getBanner();

    protected abstract void onBannerLoad();

    public void resumeAd() {
    }

    public void pauseAd() {
    }

    @Override
    public void adLoaded() {
        if (!this.isLoaded) {
            super.adLoaded();
        } else {
            Bundle bundle = new Bundle();
            bundle.putInt("error_code", 0);
            bundle.putInt("request_num", this.mAdCount);
            this.adReturnTracking(bundle);
            AdLogUtil.Log().e("BaseBanner", "banner have been Loaded, but refresh banner success " + this.getLogString());
        }
    }

    @Override
    protected void adFailedToLoad(TAdErrorCode tAdErrorCode) {
        if (!this.isLoaded) {
            super.adFailedToLoad(tAdErrorCode);
        } else {
            int n;
            Bundle bundle = new Bundle();
            int n2 = n = tAdErrorCode != null ? tAdErrorCode.getErrorCode() : 30003;
            if (n == 0) {
                n = 30003;
            }
            bundle.putInt("error_code", n);
            bundle.putString("error_message", null == tAdErrorCode ? "null" : tAdErrorCode.getErrorMessage());
            bundle.putInt("request_num", this.mAdCount);
            this.adReturnTracking(bundle);
            AdLogUtil.Log().e("BaseBanner", "banner have been Loaded, but refresh banner failed " + this.getLogString());
        }
    }

    @Override
    public void show(WrapTadView wrapTadView, String string, String string2) {
        T t = this.getBanner();
        if (t != null && wrapTadView != null) {
            this.logTrigerShow(string, string2);
            wrapTadView.onAddView((View)t);
            this.showBanner();
        } else {
            AdLogUtil.Log().w("BaseBanner", "banner is null " + this.getLogString());
        }
    }

    protected abstract void showBanner();

    protected abstract void onBannerDestroy();

    public boolean destroyFoldAd() {
        return false;
    }

    @Override
    public void destroyAd() {
        super.destroyAd();
        this.isLoaded = false;
        ThreadUtils.runOnUiThread(() -> {
            T t = this.getBanner();
            if (t != null) {
                ViewParent viewParent = t.getParent();
                if (viewParent != null && viewParent instanceof ViewGroup) {
                    ((ViewGroup)viewParent).removeView(t);
                }
                this.onBannerDestroy();
            }
        });
    }

    @Override
    public boolean isOfflineAd() {
        return false;
    }

    public void setHideAdCloseView(boolean bl) {
        this.isHideAdCloseView = bl;
    }
}

