/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.base;

import android.content.Context;
import com.hisavana.common.base.BaseAd;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.interfacz.IadNative;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.common.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseNative
extends BaseAd
implements IadNative {
    private final String TAG = "BaseNative";
    protected int mAdt;
    protected final List<TAdNativeInfo> mNatives = new ArrayList<TAdNativeInfo>();
    private static final int defaultAdsCount = 1;
    protected static final int FILTER_NONE = 0;

    public BaseNative(Context context, Network network, int n) {
        super(context, network);
        this.mAdt = n;
    }

    public void setAdCount(int n) {
        this.mAdCount = n <= 0 ? 1 : n;
    }

    @Override
    public void loadAd() {
        ThreadUtils.runOnWorkThread(() -> {
            super.loadAd();
            this.mNatives.clear();
            this.initNative();
            ThreadUtils.runOnUiThread(() -> this.onNativeAdStartLoad());
        });
    }

    protected abstract void onNativeAdStartLoad();

    protected abstract void initNative();

    protected boolean isNativeBanner() {
        return this.mAdt == 10;
    }

    @Override
    public void adLoaded(List<TAdNativeInfo> list) {
        BaseNative.super.adLoaded(list);
    }

    @Override
    protected void adFailedToLoad(TAdErrorCode tAdErrorCode) {
        BaseNative.super.adFailedToLoad(tAdErrorCode);
    }

    protected int filter(TAdNativeInfo tAdNativeInfo) {
        if (tAdNativeInfo == null) {
            return -10000;
        }
        if (this.isNativeBanner()) {
            boolean bl = tAdNativeInfo.isIconValid();
            AdLogUtil.Log().d("BaseNative", "ad nativebanner has icon:" + bl);
            return bl ? 0 : 30004;
        }
        boolean bl = tAdNativeInfo.isMaterielValid();
        AdLogUtil.Log().d("BaseNative", "ad native has meteriel:" + bl);
        return bl ? 0 : 30004;
    }

    @Override
    public int getAdType() {
        return this.mAdt;
    }

    @Override
    public void destroyAd() {
        super.destroyAd();
        for (TAdNativeInfo tAdNativeInfo : this.mNatives) {
            if (tAdNativeInfo == null) continue;
            tAdNativeInfo.release();
        }
        this.mNatives.clear();
    }

    public void destroySingleAd(TAdNativeInfo tAdNativeInfo) {
        if (tAdNativeInfo == null) {
            return;
        }
        if (this.mNatives != null && !this.mNatives.isEmpty() && this.mNatives.contains(tAdNativeInfo)) {
            AdLogUtil.Log().d("BaseNative", "remove tAdNativeInfo from mNatives\uff0ccutrrent ad id is " + tAdNativeInfo.getAdCreateId());
            this.mNatives.remove(tAdNativeInfo);
        }
    }

    public void setChoicesPosition(int n) {
    }

    @Override
    public boolean isOfflineAd() {
        return false;
    }

    public String getTriggerId() {
        return this.mTriggerId;
    }
}

