/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.bean;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.hisavana.common.base.LogSwitch;
import com.hisavana.common.interfacz.ICacheAd;
import com.hisavana.common.mock.RecordTestInfo;
import com.hisavana.common.utils.AdLogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class AdCache<T extends ICacheAd> {
    private static final AdCacheComp mComparator = new AdCacheComp();
    final ConcurrentHashMap<String, CopyOnWriteArrayList<T>> map = new ConcurrentHashMap();
    private AdCacheExpiredWatcher watcher;
    private static final String TAG = "AdCache";
    private static final int CODE_SEAT_LIMIT_FIVE = 5;
    private static final int CODE_SEAT_LIMIT_TEN = 10;
    private static final int CODE_SEAT_LIMIT_30 = 30;

    private CopyOnWriteArrayList<T> getOrCreateList(String string) {
        CopyOnWriteArrayList<Object> copyOnWriteArrayList = this.map.get(string);
        if (copyOnWriteArrayList == null) {
            copyOnWriteArrayList = new CopyOnWriteArrayList();
            this.map.put(string, copyOnWriteArrayList);
        }
        return copyOnWriteArrayList;
    }

    public void addCache(String string, @NonNull T t) {
        CopyOnWriteArrayList<T> copyOnWriteArrayList;
        if (t != null) {
            RecordTestInfo.record(LogSwitch.isDebug ? "add Cache list,AdSource is :" + t.getAdSource() : null);
            t.detachContext();
        }
        if ((copyOnWriteArrayList = this.getOrCreateList(string)).size() > this.getCodeSeatLimit(t)) {
            copyOnWriteArrayList.remove(copyOnWriteArrayList.size() - 1);
        }
        try {
            ArrayList<T> arrayList = new ArrayList<T>(copyOnWriteArrayList);
            int n = Collections.binarySearch(arrayList, t, mComparator);
            if (n < 0) {
                n = -(n + 1);
            }
            arrayList.add(n, t);
            copyOnWriteArrayList.clear();
            copyOnWriteArrayList.addAll(arrayList);
            if (LogSwitch.isDebug) {
                RecordTestInfo.LogMsg("add cache:" + RecordTestInfo.getLogMsg(t), RecordTestInfo.LOG_CODE10);
                RecordTestInfo.record("add Cache list is :" + arrayList.size());
            }
            AdLogUtil.Log().d(TAG, "*----> add Caches list is :" + arrayList.size());
        }
        catch (Exception exception) {
            AdLogUtil.Log().d(TAG, Log.getStackTraceString((Throwable)exception));
        }
    }

    public void addCaches(String string, List<T> list) {
        Object object2;
        for (Object object2 : list) {
            if (object2 == null) continue;
            if (LogSwitch.isDebug) {
                RecordTestInfo.record("add Caches list,EcpmPrice is :" + object2.getEcpmPrice());
            }
            object2.detachContext();
        }
        CopyOnWriteArrayList<T> copyOnWriteArrayList = this.getOrCreateList(string);
        if (list == null || list.size() == 0 || copyOnWriteArrayList == null) {
            return;
        }
        object2 = new ArrayList(copyOnWriteArrayList);
        int n = list.size();
        int n2 = this.getCodeSeatLimit((ICacheAd)list.get(0));
        int n3 = n + ((ArrayList)object2).size() - n2;
        ((ArrayList)object2).addAll(list);
        if (n3 > 0) {
            for (int i = 0; i < n3; ++i) {
                int n4 = ((ArrayList)object2).size();
                if (n4 > 0) {
                    ((ArrayList)object2).remove(n4 - 1);
                    continue;
                }
                AdLogUtil.Log().e(TAG, "addCaches,index out of bounds");
            }
        }
        try {
            Collections.sort(object2, mComparator);
            copyOnWriteArrayList.clear();
            copyOnWriteArrayList.addAll((Collection<T>)object2);
            AdLogUtil.Log().d(TAG, "*----> add Caches list is :" + ((ArrayList)object2).size());
            if (LogSwitch.isDebug) {
                RecordTestInfo.record("add Caches list is :" + ((ArrayList)object2).size());
                RecordTestInfo.LogMsg("add caches:" + RecordTestInfo.getLogMsg(list), RecordTestInfo.LOG_CODE10);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void removeCache(String string, T t) {
        CopyOnWriteArrayList<T> copyOnWriteArrayList = this.map.get(string);
        if (copyOnWriteArrayList != null && !copyOnWriteArrayList.isEmpty()) {
            copyOnWriteArrayList.remove(t);
            AdLogUtil.Log().d(TAG, "---> Remove ad:" + t.getPlacementId() + " from cache");
            if (LogSwitch.isDebug) {
                RecordTestInfo.LogMsg("remove cache:" + RecordTestInfo.getLogMsg(t), RecordTestInfo.LOG_CODE10);
            }
        }
    }

    public boolean hasAd(String string, T t) {
        CopyOnWriteArrayList<T> copyOnWriteArrayList = this.map.get(string);
        if (copyOnWriteArrayList != null && !copyOnWriteArrayList.isEmpty()) {
            return copyOnWriteArrayList.contains(t);
        }
        return false;
    }

    public T getCache(String string, boolean bl, int n) {
        ArrayList<T> arrayList;
        ICacheAd iCacheAd = null;
        iCacheAd = (ICacheAd)this.getSupportAd(string, n);
        if (iCacheAd == null && (arrayList = this.getCaches(string, 1, bl)) != null && !arrayList.isEmpty()) {
            iCacheAd = (ICacheAd)arrayList.get(0);
        }
        return (T)iCacheAd;
    }

    private T getSupportAd(String string, int n) {
        AdLogUtil.Log().d(TAG, "getSupportAd " + string + " hisavanaAdSupportFlag " + n);
        ArrayList<T> arrayList = this.getCaches(string, Integer.MAX_VALUE, false);
        if (arrayList == null) {
            return null;
        }
        for (ICacheAd iCacheAd : arrayList) {
            if (iCacheAd == null || !this.isAdConformSupportFlag(iCacheAd, n)) continue;
            return (T)iCacheAd;
        }
        return null;
    }

    private boolean isAdConformSupportFlag(T t, int n) {
        if (t.isOfflineAd()) {
            return false;
        }
        switch (n) {
            case 2: {
                return t.isEwAd();
            }
            case 1: {
                return t.isAdxAd();
            }
            case 3: {
                return t.isAdxAd() || t.isEwAd();
            }
        }
        return false;
    }

    public ArrayList<T> getCaches(@NonNull String string, int n, boolean bl) {
        try {
            Object object;
            ArrayList<Object> arrayList = null;
            CopyOnWriteArrayList<T> copyOnWriteArrayList = this.map.get(string);
            if (copyOnWriteArrayList == null) {
                return new ArrayList();
            }
            Iterator<T> iterator = copyOnWriteArrayList.iterator();
            if (LogSwitch.isDebug) {
                object = copyOnWriteArrayList.iterator();
                AdLogUtil.Log().d(TAG, "*----> current ad pool size is :" + copyOnWriteArrayList.size());
                while (object.hasNext()) {
                    ICacheAd iCacheAd = (ICacheAd)object.next();
                    AdLogUtil.Log().d(TAG, "---> ad: " + iCacheAd.getPlacementId() + "\uff0cprice\uff1a" + iCacheAd.getEcpmPrice() + " source " + iCacheAd.getAdSource());
                }
            }
            while (iterator.hasNext()) {
                object = (ICacheAd)iterator.next();
                if (null == object) continue;
                if (bl) {
                    copyOnWriteArrayList.remove(object);
                    if (LogSwitch.isDebug) {
                        RecordTestInfo.LogMsg("remove cache:" + RecordTestInfo.getLogMsg(object), RecordTestInfo.LOG_CODE10);
                    }
                }
                if (object.isExpired()) {
                    if (!bl) {
                        copyOnWriteArrayList.remove(object);
                        if (LogSwitch.isDebug) {
                            RecordTestInfo.LogMsg("remove cache:" + RecordTestInfo.getLogMsg(object), RecordTestInfo.LOG_CODE10);
                        }
                    }
                    if (this.watcher != null) {
                        this.watcher.onExpired((ICacheAd)object);
                    }
                    object.destroyAd();
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                }
                arrayList.add(object);
                if (arrayList.size() < n) continue;
                break;
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            AdLogUtil.Log().e(TAG, Log.getStackTraceString((Throwable)throwable));
            return null;
        }
    }

    private boolean removeAd(CopyOnWriteArrayList<T> copyOnWriteArrayList, T t, boolean bl) {
        if (bl) {
            AdLogUtil.Log().d(TAG, "---> Remove ad:" + t.getPlacementId() + " from cache");
            copyOnWriteArrayList.remove(t);
            if (LogSwitch.isDebug) {
                RecordTestInfo.LogMsg("remove cache:" + RecordTestInfo.getLogMsg(t), RecordTestInfo.LOG_CODE10);
            }
        }
        if (t.isExpired()) {
            if (!bl) {
                copyOnWriteArrayList.remove(t);
                if (LogSwitch.isDebug) {
                    RecordTestInfo.LogMsg("remove cache:" + RecordTestInfo.getLogMsg(t), RecordTestInfo.LOG_CODE10);
                }
            }
            if (this.watcher != null) {
                this.watcher.onExpired((ICacheAd)t);
            }
            t.destroyAd();
            return true;
        }
        return false;
    }

    public ArrayList<T> getCaches(@NonNull String string, int n, boolean bl, int n2) {
        try {
            Object object;
            Object object2;
            CopyOnWriteArrayList<T> copyOnWriteArrayList = this.map.get(string);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (copyOnWriteArrayList == null || copyOnWriteArrayList.isEmpty()) {
                return arrayList;
            }
            Iterator<T> iterator = copyOnWriteArrayList.iterator();
            if (LogSwitch.isDebug) {
                object2 = copyOnWriteArrayList.iterator();
                AdLogUtil.Log().d(TAG, "current ad pool size is :" + copyOnWriteArrayList.size());
                while (object2.hasNext()) {
                    object = (ICacheAd)object2.next();
                    AdLogUtil.Log().d(TAG, "ad: " + object.getPlacementId() + "\uff0cprice\uff1a" + object.getEcpmPrice() + " isAdx " + object.isAdxAd() + " isEw " + object.isEwAd());
                }
            }
            while (iterator.hasNext()) {
                object2 = (ICacheAd)iterator.next();
                if (null == object2) continue;
                if (this.isAdConformSupportFlag(object2, n2) && !this.removeAd(copyOnWriteArrayList, object2, bl)) {
                    arrayList.add(object2);
                }
                if (arrayList.size() < n) continue;
                return arrayList;
            }
            if (arrayList.size() < n) {
                int n3 = n - arrayList.size();
                object = this.getCaches(string, n3, bl);
                arrayList.addAll((Collection<Object>)object);
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            AdLogUtil.Log().e(TAG, Log.getStackTraceString((Throwable)throwable));
            return null;
        }
    }

    public ArrayList<T> getCaches(@NonNull String string, int n, boolean bl, boolean bl2, int n2) {
        try {
            Object object;
            int n3;
            if (!bl2) {
                return this.getCaches(string, n, bl, n2);
            }
            ArrayList<ICacheAd> arrayList = null;
            CopyOnWriteArrayList<T> copyOnWriteArrayList = this.map.get(string);
            if (copyOnWriteArrayList == null) {
                return null;
            }
            int n4 = n3 = n2 > 0 ? 0 : -1;
            if (LogSwitch.isDebug) {
                object = copyOnWriteArrayList.iterator();
                AdLogUtil.Log().d(TAG, "*----> current ad pool size is :" + copyOnWriteArrayList.size());
                while (object.hasNext()) {
                    ICacheAd iCacheAd = (ICacheAd)object.next();
                    AdLogUtil.Log().d(TAG, "---> ad: " + iCacheAd.getPlacementId() + "\uff0cprice\uff1a" + iCacheAd.getEcpmPrice());
                }
            }
            object = new ArrayList();
            for (ICacheAd iCacheAd : copyOnWriteArrayList) {
                if (null == iCacheAd || n3 != -1 && n3 != iCacheAd.getAdSource()) continue;
                if (n3 == -1) {
                    n3 = iCacheAd.getAdSource();
                }
                if (iCacheAd.isExpired()) {
                    copyOnWriteArrayList.remove(iCacheAd);
                    if (this.watcher != null) {
                        this.watcher.onExpired(iCacheAd);
                    }
                    iCacheAd.destroyAd();
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<ICacheAd>();
                }
                if (!TextUtils.isEmpty((CharSequence)iCacheAd.getFilterSource())) {
                    AdLogUtil.Log().d(TAG, "current filter ------->" + iCacheAd.getFilterSource());
                    if (object.contains(iCacheAd.getFilterSource())) continue;
                    object.add(iCacheAd.getFilterSource());
                }
                if (bl) {
                    AdLogUtil.Log().d(TAG, "---> Remove ad:" + iCacheAd.getPlacementId() + " from cache");
                    copyOnWriteArrayList.remove(iCacheAd);
                }
                arrayList.add(iCacheAd);
                if (arrayList.size() < n) continue;
                break;
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            AdLogUtil.Log().e(TAG, Log.getStackTraceString((Throwable)throwable));
            return null;
        }
    }

    public double updateSecondPrice(T t, String string) {
        if (t != null && t.getAdSource() == 0) {
            double d = this.getMaxPrice(string, t);
            if (d > 0.0) {
                t.setSecondPrice(d);
            }
            return d;
        }
        return 0.0;
    }

    private double getMaxPrice(String string, T t) {
        try {
            double d = 0.0;
            if (string == null) {
                return d;
            }
            CopyOnWriteArrayList<T> copyOnWriteArrayList = this.map.get(string);
            if (copyOnWriteArrayList == null) {
                return d;
            }
            for (ICacheAd iCacheAd : copyOnWriteArrayList) {
                if (iCacheAd.isExpired()) {
                    if (this.watcher != null) {
                        this.watcher.onExpired(iCacheAd);
                    }
                    iCacheAd.destroyAd();
                    copyOnWriteArrayList.remove(iCacheAd);
                    continue;
                }
                if (t != null && t == iCacheAd) {
                    AdLogUtil.Log().d("ssp_second_price", "*----> getMaxPrice updateSecondPrice()\uff0cexcludeAd == iteratorAd");
                    continue;
                }
                AdLogUtil.Log().d(TAG, "*----> max ad in pool is :" + iCacheAd.getPlacementId() + ",EcpmPrice is :" + iCacheAd.getEcpmPrice() + ",AdSource is :" + iCacheAd.getAdSource() + ",ValidTimeLimit :" + iCacheAd.getValidTimeLimit());
                d = iCacheAd.getEcpmPrice();
                break;
            }
            return d;
        }
        catch (Throwable throwable) {
            AdLogUtil.Log().e(TAG, Log.getStackTraceString((Throwable)throwable));
            return 0.0;
        }
    }

    public double getMaxPrice(String string) {
        return this.getMaxPrice(string, null);
    }

    public boolean hasAds(String string) {
        try {
            CopyOnWriteArrayList<T> copyOnWriteArrayList = this.map.get(string);
            if (copyOnWriteArrayList == null) {
                return false;
            }
            for (ICacheAd iCacheAd : copyOnWriteArrayList) {
                if (iCacheAd.isExpired()) {
                    if (this.watcher != null) {
                        this.watcher.onExpired(iCacheAd);
                    }
                    iCacheAd.destroyAd();
                    copyOnWriteArrayList.remove(iCacheAd);
                    continue;
                }
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            AdLogUtil.Log().e(TAG, Log.getStackTraceString((Throwable)throwable));
            return false;
        }
    }

    public int getAdNum(String string) {
        try {
            int n = 0;
            CopyOnWriteArrayList<T> copyOnWriteArrayList = this.map.get(string);
            if (copyOnWriteArrayList == null) {
                return n;
            }
            for (ICacheAd iCacheAd : copyOnWriteArrayList) {
                if (iCacheAd.isExpired()) {
                    if (this.watcher != null) {
                        this.watcher.onExpired(iCacheAd);
                    }
                    iCacheAd.destroyAd();
                    copyOnWriteArrayList.remove(iCacheAd);
                    continue;
                }
                ++n;
                AdLogUtil.Log().d(TAG, "*----> ad in pool is :" + iCacheAd.getPlacementId() + ",EcpmPrice is :" + iCacheAd.getEcpmPrice() + ",AdSource is :" + iCacheAd.getAdSource() + ",ValidTimeLimit :" + iCacheAd.getValidTimeLimit());
            }
            return n;
        }
        catch (Throwable throwable) {
            AdLogUtil.Log().e(TAG, Log.getStackTraceString((Throwable)throwable));
            return 0;
        }
    }

    public int[] getValidAndInvalidAdNum(String string) {
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[]{0, 0};
        CopyOnWriteArrayList<T> copyOnWriteArrayList = this.map.get(string);
        if (copyOnWriteArrayList == null) {
            return nArray;
        }
        for (ICacheAd iCacheAd : copyOnWriteArrayList) {
            if (!iCacheAd.isExpired()) {
                ++n;
                continue;
            }
            ++n2;
        }
        nArray[0] = n;
        nArray[1] = n2;
        return nArray;
    }

    public int getAdNum(String string, int n, String string2) {
        try {
            int n2 = 0;
            CopyOnWriteArrayList<T> copyOnWriteArrayList = this.map.get(string);
            if (copyOnWriteArrayList == null) {
                return n2;
            }
            for (ICacheAd iCacheAd : copyOnWriteArrayList) {
                if (iCacheAd.isExpired()) {
                    if (this.watcher != null) {
                        this.watcher.onExpired(iCacheAd);
                    }
                    iCacheAd.destroyAd();
                    copyOnWriteArrayList.remove(iCacheAd);
                    continue;
                }
                if (iCacheAd.getAdSource() != n || !TextUtils.equals((CharSequence)iCacheAd.getPlacementId(), (CharSequence)string2)) continue;
                ++n2;
            }
            return n2;
        }
        catch (Throwable throwable) {
            AdLogUtil.Log().e(TAG, Log.getStackTraceString((Throwable)throwable));
            return 0;
        }
    }

    public double getNetworkPrice(String string, int n, String string2) {
        try {
            double d = 0.0;
            CopyOnWriteArrayList<T> copyOnWriteArrayList = this.map.get(string);
            if (copyOnWriteArrayList == null) {
                return d;
            }
            for (ICacheAd iCacheAd : copyOnWriteArrayList) {
                if (iCacheAd.isExpired()) {
                    if (this.watcher != null) {
                        this.watcher.onExpired(iCacheAd);
                    }
                    iCacheAd.destroyAd();
                    copyOnWriteArrayList.remove(iCacheAd);
                    continue;
                }
                if (iCacheAd.getAdSource() != n || !TextUtils.equals((CharSequence)iCacheAd.getPlacementId(), (CharSequence)string2)) continue;
                d = iCacheAd.getEcpmPrice();
                break;
            }
            return d;
        }
        catch (Throwable throwable) {
            AdLogUtil.Log().e(TAG, Log.getStackTraceString((Throwable)throwable));
            return 0.0;
        }
    }

    public T getOfflineCache(String string, boolean bl) {
        ArrayList<T> arrayList = this.getOfflineCache(string, 1, bl);
        if (arrayList != null && arrayList.size() > 0) {
            return (T)((ICacheAd)arrayList.get(0));
        }
        return null;
    }

    public ArrayList<T> getOfflineCache(String string, int n, boolean bl) {
        try {
            Object object;
            ArrayList<ICacheAd> arrayList = null;
            CopyOnWriteArrayList<T> copyOnWriteArrayList = this.map.get(string);
            if (copyOnWriteArrayList == null) {
                return null;
            }
            if (LogSwitch.isDebug) {
                object = copyOnWriteArrayList.iterator();
                AdLogUtil.Log().d(TAG, "*----> current ad pool size is :" + copyOnWriteArrayList.size());
                while (object.hasNext()) {
                    ICacheAd iCacheAd = (ICacheAd)object.next();
                    if (!iCacheAd.isOfflineAd()) continue;
                    AdLogUtil.Log().d(TAG, "---> ad: " + iCacheAd.getPlacementId() + "\uff0cprice\uff1a" + iCacheAd.getEcpmPrice());
                }
            }
            object = new ArrayList();
            for (ICacheAd iCacheAd : copyOnWriteArrayList) {
                if (null == iCacheAd) continue;
                if (iCacheAd.isExpired()) {
                    copyOnWriteArrayList.remove(iCacheAd);
                    if (this.watcher != null) {
                        this.watcher.onExpired(iCacheAd);
                    }
                    iCacheAd.destroyAd();
                    continue;
                }
                if (!iCacheAd.isOfflineAd()) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<ICacheAd>();
                }
                if (!TextUtils.isEmpty((CharSequence)iCacheAd.getFilterSource())) {
                    AdLogUtil.Log().d(TAG, "current filter ------->" + iCacheAd.getFilterSource());
                    if (object.contains(iCacheAd.getFilterSource())) continue;
                    object.add(iCacheAd.getFilterSource());
                }
                if (bl) {
                    AdLogUtil.Log().d(TAG, "---> Remove ad:" + iCacheAd.getPlacementId() + " from cache");
                    copyOnWriteArrayList.remove(iCacheAd);
                }
                arrayList.add(iCacheAd);
                if (arrayList.size() < n) continue;
                break;
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            AdLogUtil.Log().e(TAG, Log.getStackTraceString((Throwable)throwable));
            return null;
        }
    }

    public void registerWatcher(AdCacheExpiredWatcher adCacheExpiredWatcher) {
        this.watcher = adCacheExpiredWatcher;
    }

    public void unRegisterWatcher() {
        this.watcher = null;
    }

    public void removeAll() {
        this.map.clear();
    }

    private int getCodeSeatLimit(T t) {
        if (t == null) {
            return 5;
        }
        return t.isIconAd() ? 30 : 5;
    }

    public static interface AdCacheExpiredWatcher {
        public void onExpired(ICacheAd var1);
    }

    public static class AdCacheComp
    implements Comparator<ICacheAd> {
        @Override
        public int compare(ICacheAd iCacheAd, ICacheAd iCacheAd2) {
            try {
                if (iCacheAd.isExpired() && !iCacheAd2.isExpired()) {
                    return 1;
                }
                if (!iCacheAd.isExpired() && iCacheAd2.isExpired()) {
                    return -1;
                }
                if (iCacheAd.getEcpmPrice() == iCacheAd2.getEcpmPrice()) {
                    if (iCacheAd.getValidTimeLimit() - iCacheAd2.getValidTimeLimit() < 0L) {
                        return -1;
                    }
                    if (iCacheAd.getValidTimeLimit() - iCacheAd2.getValidTimeLimit() > 0L) {
                        return 1;
                    }
                    return 0;
                }
                if (iCacheAd.getEcpmPrice() > iCacheAd2.getEcpmPrice()) {
                    return -1;
                }
                return 1;
            }
            catch (Throwable throwable) {
                return 0;
            }
        }
    }
}

