/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.text.TextUtils;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;
import java.util.Iterator;
import java.util.List;

public class AdUtil {
    public static void release(TAdNativeInfo tAdNativeInfo) {
        if (tAdNativeInfo != null) {
            tAdNativeInfo.release();
        }
    }

    public static boolean isDebuggable() {
        try {
            ApplicationInfo applicationInfo = CoreUtil.getContext().getApplicationInfo();
            return (applicationInfo.flags & 2) != 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean checkAppInstalled(Context context, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        try {
            PackageInfo packageInfo;
            if (!TextUtils.isEmpty((CharSequence)string) && (packageInfo = context.getPackageManager().getPackageInfo(TextUtils.isEmpty((CharSequence)string) ? "" : string, 0)) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static int filterAdByPullOrNew(List<TAdNativeInfo> list) {
        int n = 0;
        if (list == null || list.isEmpty()) {
            return n;
        }
        Iterator<TAdNativeInfo> iterator = list.iterator();
        while (iterator.hasNext()) {
            TAdNativeInfo tAdNativeInfo = iterator.next();
            if (!tAdNativeInfo.isIconAd()) continue;
            int n2 = tAdNativeInfo.getPullNewestLive();
            String string = tAdNativeInfo.getPackageName();
            AdLogUtil.Log().d("AdUtil", "current ad  ----->  packageName: " + string + ";    PullNewestLive:" + tAdNativeInfo.getPullNewestLive());
            if (n2 != 3 && n2 != 2) continue;
            if (TextUtils.isEmpty((CharSequence)string)) {
                iterator.remove();
                ++n;
                continue;
            }
            boolean bl = AdUtil.checkAppInstalled(CoreUtil.getContext(), string);
            if (n2 == 3 && !bl) {
                iterator.remove();
                ++n;
                continue;
            }
            if (n2 != 2 || !bl) continue;
            iterator.remove();
            ++n;
        }
        return n;
    }
}

