/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.base;

import android.content.Context;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.common.base.BaseAd;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.interfacz.IadNative;
import com.hisavana.common.utils.AdLogUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseNative
extends BaseAd
implements IadNative {
    private static final int defaultAdsCount = 1;
    protected static final int FILTER_NONE = 0;
    private String TAG = "BaseNative";
    protected int mAdt;
    protected final List<TAdNativeInfo> mNatives;

    public BaseNative(Context context, Network network, int n) {
        super(context, network);
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        v1.mNatives = arrayList2;
        v1.mAdt = n;
    }

    public void setAdCount(int n) {
        this.mAdCount = n <= 0 ? 1 : n;
    }

    @Override
    public void loadAd() {
        BaseNative baseNative = this;
        super.loadAd();
        baseNative.mNatives.clear();
        baseNative.initNative();
        baseNative.onNativeAdStartLoad();
    }

    protected abstract void onNativeAdStartLoad();

    protected abstract void initNative();

    protected boolean isNativeBanner() {
        return this.mAdt == 10;
    }

    @Override
    public void adLoaded(final List<TAdNativeInfo> list) {
        Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

            public void onRun() {
                BaseNative.super.adLoaded(list);
            }
        });
    }

    @Override
    protected void adFailedToLoad(final TAdErrorCode tAdErrorCode) {
        Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

            public void onRun() {
                BaseNative.super.adFailedToLoad(tAdErrorCode);
            }
        });
    }

    protected int filter(TAdNativeInfo tAdNativeInfo) {
        if (tAdNativeInfo == null) {
            return -10000;
        }
        if (this.isNativeBanner()) {
            boolean bl = tAdNativeInfo.isIconValid();
            AdLogUtil.Log().d(this.TAG, "ad nativebanner has icon:" + bl);
            return bl ? 0 : 30004;
        }
        boolean bl = tAdNativeInfo.isMaterielValid();
        AdLogUtil.Log().d(this.TAG, "ad native has meteriel:" + bl);
        return bl ? 0 : 30004;
    }

    @Override
    public int getAdType() {
        return this.mAdt;
    }

    @Override
    public void destroyAd() {
        BaseNative baseNative = this;
        super.destroyAd();
        for (TAdNativeInfo tAdNativeInfo : baseNative.mNatives) {
            if (tAdNativeInfo == null) continue;
            tAdNativeInfo.release();
        }
        this.mNatives.clear();
    }

    public void destroySingleAd(TAdNativeInfo tAdNativeInfo) {
        if (tAdNativeInfo == null) {
            return;
        }
        List<TAdNativeInfo> list = this.mNatives;
        if (list != null && !list.isEmpty() && this.mNatives.contains(tAdNativeInfo)) {
            AdLogUtil.Log().d(this.TAG, "remove tAdNativeInfo from mNatives\uff0ccutrrent ad id is " + tAdNativeInfo.getAdCreateId());
            this.mNatives.remove(tAdNativeInfo);
        }
    }

    public void setChoicesPosition(int n) {
    }

    @Override
    public boolean isOfflineAd() {
        return false;
    }

    public String getTriggerId() {
        return this.mTriggerId;
    }
}

