/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.bean;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.hisavana.common.base.BaseNative;
import com.hisavana.common.bean.AdNativeInfo;
import com.hisavana.common.interfacz.AdShowListener;
import java.util.List;

public abstract class NativeAdWrapper<T> {
    private final T nativeAd;
    private BaseNative adImpl;

    public NativeAdWrapper(T t, BaseNative baseNative) {
        this.nativeAd = t;
        this.adImpl = baseNative;
    }

    @SuppressLint(value={"RestrictedApi"})
    public abstract void destroy();

    public boolean isExpired() {
        return this.adImpl != null ? this.adImpl.isExpired() : true;
    }

    public void registerViewForInteraction(ViewGroup viewGroup, List<View> list, @NonNull AdNativeInfo adNativeInfo) {
        if (this.adImpl != null) {
            this.adImpl.registerViewForInteraction(viewGroup, list, adNativeInfo);
        }
    }

    public void unregisterView(@NonNull AdNativeInfo adNativeInfo) {
        if (this.adImpl != null) {
            this.adImpl.unregisterView(adNativeInfo);
        }
    }

    public T getNativeAd() {
        return this.nativeAd;
    }

    public BaseNative getAdImpl() {
        return this.adImpl;
    }

    public boolean isMaterielValid() {
        return this.isImageValid() || this.isIconValid();
    }

    public abstract boolean isIconValid();

    public abstract boolean isImageValid();

    public abstract Bundle getTrackBundle();

    public void detachContext() {
        if (this.adImpl != null) {
            this.adImpl.detachContext();
        }
    }

    public void handleClick() {
    }

    public void registerViewForInteraction(View view, AdShowListener adShowListener) {
    }
}

