/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.base;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.hisavana.common.base.BaseAd;
import com.hisavana.common.base.WrapTadView;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.interfacz.IadView;
import com.hisavana.common.utils.AdLogUtil;

public abstract class BaseBanner<T extends View>
extends BaseAd
implements IadView {
    private String TAG = "BaseBanner";
    protected boolean isHideAdCloseView;

    public BaseBanner(Context context, Network network) {
        super(context, network);
    }

    @Override
    public int getAdType() {
        return 2;
    }

    @Override
    public void loadAd() {
        if (this.getBanner() != null) {
            BaseBanner baseBanner = this;
            super.loadAd();
            baseBanner.onBannerLoad();
        }
    }

    protected abstract T getBanner();

    protected abstract void onBannerLoad();

    public void resumeAd() {
    }

    public void pauseAd() {
    }

    @Override
    public void adLoaded() {
        if (!this.isLoaded) {
            super.adLoaded();
        } else {
            Bundle bundle = new Bundle();
            bundle.putInt("error_code", 0);
            bundle.putInt("request_num", this.mAdCount);
            this.adReturnTracking(bundle);
            AdLogUtil.Log().e(this.TAG, "banner have been Loaded, but refresh banner success " + this.getLogString());
        }
    }

    @Override
    protected void adFailedToLoad(TAdErrorCode object) {
        if (!this.isLoaded) {
            super.adFailedToLoad((TAdErrorCode)object);
        } else {
            Bundle bundle;
            Bundle bundle2 = bundle;
            bundle = new Bundle();
            int n = object != null ? ((TAdErrorCode)object).getErrorCode() : 30003;
            if (n == 0) {
                n = 30003;
            }
            bundle2.putInt("error_code", n);
            String string = "error_message";
            object = object == null ? "null" : ((TAdErrorCode)object).getErrorMessage();
            Bundle bundle3 = bundle2;
            bundle2.putString(string, (String)object);
            bundle3.putInt("request_num", this.mAdCount);
            this.adReturnTracking(bundle3);
            AdLogUtil.Log().e(this.TAG, "banner have been Loaded, but refresh banner failed " + this.getLogString());
        }
    }

    @Override
    public void show(WrapTadView wrapTadView, String string, String string2) {
        T t = this.getBanner();
        if (t != null && wrapTadView != null) {
            this.logTrigerShow(string, string2);
            wrapTadView.onAddView((View)t);
            this.showBanner();
        } else {
            AdLogUtil.Log().w(this.TAG, "banner is null " + this.getLogString());
        }
    }

    protected abstract void showBanner();

    protected abstract void onBannerDestroy();

    public boolean destroyFoldAd() {
        return false;
    }

    @Override
    public void destroyAd() {
        BaseBanner baseBanner = this;
        super.destroyAd();
        baseBanner.isLoaded = false;
        T t = baseBanner.getBanner();
        if (t != null) {
            ViewParent viewParent = t.getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(t);
            }
            this.onBannerDestroy();
        }
    }

    @Override
    public boolean isOfflineAd() {
        return false;
    }

    public void setHideAdCloseView(boolean bl) {
        this.isHideAdCloseView = bl;
    }
}

