/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.bean;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.hisavana.common.base.LogSwitch;
import com.hisavana.common.interfacz.ICacheAd;
import com.hisavana.common.mock.RecordTestInfo;
import com.hisavana.common.utils.AdLogUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class AdCache<T extends ICacheAd> {
    private static final AdCacheComp mComparator = new AdCacheComp();
    private static final String TAG = "AdCache";
    private static final int CODE_SEAT_LIMIT_FIVE = 5;
    private static final int CODE_SEAT_LIMIT_TEN = 10;
    private static final int CODE_SEAT_LIMIT_30 = 30;
    final ConcurrentHashMap<String, CopyOnWriteArrayList<T>> map;
    private AdCacheExpiredWatcher watcher;

    public AdCache() {
        ConcurrentHashMap concurrentHashMap;
        ConcurrentHashMap concurrentHashMap2 = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        v1.map = concurrentHashMap2;
    }

    private CopyOnWriteArrayList<T> getOrCreateList(String string) {
        CopyOnWriteArrayList copyOnWriteArrayList = this.map.get(string);
        if (copyOnWriteArrayList == null) {
            CopyOnWriteArrayList copyOnWriteArrayList2;
            copyOnWriteArrayList = copyOnWriteArrayList2;
            copyOnWriteArrayList2 = new CopyOnWriteArrayList();
            this.map.put(string, copyOnWriteArrayList);
        }
        return copyOnWriteArrayList;
    }

    private T getSupportAd(String iterator, int n, boolean bl) {
        AdLogUtil.Log().d(TAG, "getSupportAd " + (String)((Object)iterator) + " hisavanaAdSupportFlag " + n);
        iterator = this.getCaches((String)((Object)iterator), Integer.MAX_VALUE, false, bl);
        if (iterator == null) {
            return null;
        }
        iterator = ((ArrayList)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd == null || !this.isAdConformSupportFlag(iCacheAd, n)) continue;
            return (T)iCacheAd;
        }
        return null;
    }

    private boolean isAdConformSupportFlag(T t, int n) {
        if (t.isOfflineAd()) {
            return false;
        }
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    return false;
                }
                return t.isAdxAd() || t.isEwAd();
            }
            return t.isEwAd();
        }
        return t.isAdxAd();
    }

    private boolean removeAd(CopyOnWriteArrayList<T> copyOnWriteArrayList, T t, boolean bl) {
        if (bl) {
            AdLogUtil.Log().d(TAG, "---> Remove ad:" + t.getPlacementId() + " from cache");
            copyOnWriteArrayList.remove(t);
            if (LogSwitch.isDebug) {
                RecordTestInfo.LogMsg("remove cache:" + RecordTestInfo.getLogMsg(t), RecordTestInfo.LOG_CODE10);
            }
        }
        if (t.isExpired()) {
            if (!bl) {
                copyOnWriteArrayList.remove(t);
                if (LogSwitch.isDebug) {
                    RecordTestInfo.LogMsg("remove cache:" + RecordTestInfo.getLogMsg(t), RecordTestInfo.LOG_CODE10);
                }
            }
            if ((this = ((AdCache)this).watcher) != null) {
                this.onExpired((ICacheAd)t);
            }
            t.destroyAd();
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private double getMaxPrice(String var1_2, T var2_3, boolean var3_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getCodeSeatLimit(T t) {
        if (t == null) {
            return 5;
        }
        return t.isIconAd() ? 30 : 5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addCache(String copyOnWriteArrayList, @NonNull T t) {
        int n;
        block8: {
            ArrayList<T> arrayList;
            if (t != null) {
                RecordTestInfo.record(LogSwitch.isDebug ? "add Cache list,AdSource is :" + t.getAdSource() : null);
                t.detachContext();
            }
            if ((copyOnWriteArrayList = ((AdCache)((Object)arrayList2)).getOrCreateList((String)((Object)copyOnWriteArrayList))).size() > ((AdCache)((Object)arrayList2)).getCodeSeatLimit(t)) {
                CopyOnWriteArrayList<T> copyOnWriteArrayList2 = copyOnWriteArrayList;
                copyOnWriteArrayList2.remove(copyOnWriteArrayList2.size() - 1);
            }
            ArrayList<T> arrayList2 = arrayList;
            n = Collections.binarySearch(new ArrayList<T>(copyOnWriteArrayList), t, mComparator);
            if (n >= 0) break block8;
            n = -(n + 1);
        }
        arrayList2.add(n, t);
        copyOnWriteArrayList.clear();
        copyOnWriteArrayList.addAll(arrayList2);
        try {
            if (LogSwitch.isDebug) {
                RecordTestInfo.LogMsg("add cache:" + RecordTestInfo.getLogMsg(t), RecordTestInfo.LOG_CODE10);
                RecordTestInfo.record("add Cache list is :" + arrayList2.size());
            }
            AdLogUtil.Log().d(TAG, "*----> add Caches list is :" + arrayList2.size());
            return;
        }
        catch (Exception exception) {
            AdLogUtil.Log().d(TAG, Log.getStackTraceString((Throwable)exception));
        }
    }

    public void addCaches(String object, List<T> list) {
        for (ICacheAd iCacheAd : list) {
            if (iCacheAd == null) continue;
            if (LogSwitch.isDebug) {
                RecordTestInfo.record("add Caches list,EcpmPrice is :" + iCacheAd.getEcpmPrice());
            }
            iCacheAd.detachContext();
        }
        object = this.getOrCreateList((String)object);
        if (list.size() != 0 && object != null) {
            block10: {
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList(object);
                int n = this.getCodeSeatLimit((ICacheAd)list.get(0));
                n = list.size() + arrayList2.size() - n;
                arrayList2.addAll(list);
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        int n2 = arrayList2.size();
                        if (n2 > 0) {
                            arrayList2.remove(n2 - 1);
                            continue;
                        }
                        AdLogUtil.Log().e(TAG, "addCaches,index out of bounds");
                    }
                }
                Collections.sort(arrayList2, mComparator);
                ((CopyOnWriteArrayList)object).clear();
                ((CopyOnWriteArrayList)object).addAll(arrayList2);
                AdLogUtil.Log().d(TAG, "*----> add Caches list is :" + arrayList2.size());
                if (!LogSwitch.isDebug) break block10;
                try {
                    RecordTestInfo.record("add Caches list is :" + arrayList2.size());
                    RecordTestInfo.LogMsg("add caches:" + RecordTestInfo.getLogMsg(list), RecordTestInfo.LOG_CODE10);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            return;
        }
    }

    public void removeCache(String string, T t) {
        CopyOnWriteArrayList<T> copyOnWriteArrayList = ((AdCache)((Object)copyOnWriteArrayList)).map.get(string);
        if (copyOnWriteArrayList != null && !copyOnWriteArrayList.isEmpty()) {
            copyOnWriteArrayList.remove(t);
            AdLogUtil.Log().d(TAG, "---> Remove ad:" + t.getPlacementId() + " from cache");
            if (LogSwitch.isDebug) {
                RecordTestInfo.LogMsg("remove cache:" + RecordTestInfo.getLogMsg(t), RecordTestInfo.LOG_CODE10);
            }
        }
    }

    public boolean hasAd(String string, T t) {
        CopyOnWriteArrayList<T> copyOnWriteArrayList = ((AdCache)((Object)copyOnWriteArrayList)).map.get(string);
        if (copyOnWriteArrayList != null && !copyOnWriteArrayList.isEmpty()) {
            return copyOnWriteArrayList.contains(t);
        }
        return false;
    }

    public T getCache(String string, boolean bl, int n, boolean bl2) {
        Object object = ((AdCache)this).getSupportAd(string, n, bl2);
        if (object == null && (this = ((AdCache)this).getCaches(string, 1, bl, bl2)) != null && !((ArrayList)this).isEmpty()) {
            object = (ICacheAd)((ArrayList)this).get(0);
        }
        return object;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<T> getCaches(@NonNull String var1_2, int var2_3, boolean var3_4, boolean var4_5) {
        var5_6 = null;
        try {
            var1_2 = this.map.get(var1_2);
            if (var1_2 == null) {
                return new ArrayList<E>();
            }
            var6_7 = var1_2.iterator();
            if (LogSwitch.isDebug) {
                var7_8 = var1_2.iterator();
                v0 = AdLogUtil.Log();
                v1 = "AdCache";
                v2 = "*----> current ad pool size is :" + var1_2.size();
                while (true) {
                    v0.d(v1, v2);
                    if (!var7_8.hasNext()) break;
                    var8_9 = (ICacheAd)var7_8.next();
                    v0 = AdLogUtil.Log();
                    v1 = "AdCache";
                    v2 = "---> ad: " + var8_9.getPlacementId() + "\uff0cprice\uff1a" + var8_9.getEcpmPrice() + " source " + var8_9.getAdSource();
                }
            }
            while (var6_7.hasNext()) {
                var7_8 = (ICacheAd)var6_7.next();
                if (var7_8 == null) continue;
                if (!var3_4) ** GOTO lbl32
                var1_2.remove(var7_8);
            }
        }
        catch (Throwable var0_1) {
            AdLogUtil.Log().e("AdCache", Log.getStackTraceString((Throwable)var0_1));
            return null;
        }
        {
            if (LogSwitch.isDebug) {
                RecordTestInfo.LogMsg("remove cache:" + RecordTestInfo.getLogMsg(var7_8), RecordTestInfo.LOG_CODE10);
            }
lbl32:
            // 4 sources

            if (!var7_8.isExpired()) ** GOTO lbl43
            if (var3_4) ** GOTO lbl39
            var1_2.remove(var7_8);
            if (LogSwitch.isDebug) {
                RecordTestInfo.LogMsg("remove cache:" + RecordTestInfo.getLogMsg(var7_8), RecordTestInfo.LOG_CODE10);
            }
lbl39:
            // 4 sources

            if ((var8_9 = this.watcher) == null) ** GOTO lbl50
            var8_9.onExpired((ICacheAd)var7_8);
            ** GOTO lbl50
lbl43:
            // 1 sources

            if (!var4_5 || !var7_8.isMatchVulgarBrand()) ** GOTO lbl52
            if (var3_4) ** GOTO lbl50
            var1_2.remove(var7_8);
            if (LogSwitch.isDebug) {
                RecordTestInfo.LogMsg("remove cache:" + RecordTestInfo.getLogMsg(var7_8), RecordTestInfo.LOG_CODE10);
            }
lbl50:
            // 6 sources

            var7_8.destroyAd();
            continue;
lbl52:
            // 1 sources

            if (var5_6 != null) ** GOTO lbl56
            var5_6 = v3;
            v3 = new ArrayList<Object>();
lbl56:
            // 2 sources

            v4 = var5_6;
            v5 = v4;
            v4.add(var7_8);
            if (v5.size() < var2_3) continue;
        }
        return var5_6;
    }

    /*
     * Exception decompiling
     */
    public ArrayList<T> getCaches(@NonNull String var1_2, int var2_3, boolean var3_4, int var4_5, boolean var5_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 22[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<T> getCaches(@NonNull String var1_2, int var2_3, boolean var3_4, boolean var4_5, int var5_7, boolean var6_8) {
        if (var4_5) ** GOTO lbl4
        return this.getCaches((String)var1_2, var2_3, var3_4, var5_7, var6_8);
lbl4:
        // 1 sources

        var4_6 = null;
        if ((var1_2 = this.map.get(var1_2)) == null) {
            return null;
        }
        var5_7 = var5_7 > 0 ? 0 : -1;
        if (LogSwitch.isDebug) {
            var7_9 = var1_2.iterator();
            v0 = AdLogUtil.Log();
            v1 = "AdCache";
            v2 = "*----> current ad pool size is :" + var1_2.size();
            while (true) {
                v0.d(v1, v2);
                if (!var7_9.hasNext()) break;
                var8_10 = (ICacheAd)var7_9.next();
                v0 = AdLogUtil.Log();
                v1 = "AdCache";
                v2 = "---> ad: " + var8_10.getPlacementId() + "\uff0cprice\uff1a" + var8_10.getEcpmPrice();
            }
        }
        v3 = var1_2;
        var7_9 = v4;
        try {
            v4 = new ArrayList<E>();
            for (ICacheAd var9_11 : v3) {
                if (var9_11 == null) continue;
            }
        }
        catch (Throwable var0_1) {
            AdLogUtil.Log().e("AdCache", Log.getStackTraceString((Throwable)var0_1));
            return null;
        }
        {
            block18: {
                if (!var9_11.isExpired()) ** GOTO lbl42
                v5 = this;
                var1_2.remove(var9_11);
                var10_12 = v5.watcher;
                if (var10_12 == null) ** GOTO lbl40
                var10_12.onExpired(var9_11);
lbl40:
                // 2 sources

                var9_11.destroyAd();
                continue;
lbl42:
                // 1 sources

                if (!var6_8 || !var9_11.isMatchVulgarBrand()) ** GOTO lbl50
                v6 = var9_11;
                var1_2.remove(var9_11);
                v6.destroyAd();
                AdLogUtil.Log().d("AdCache", "current ad filter by vulgar content");
                continue;
lbl50:
                // 1 sources

                if (var5_7 != -1 && var5_7 != var9_11.getAdSource()) continue;
                if (var5_7 == -1) {
                    var5_7 = var9_11.getAdSource();
                }
                if (var4_6 != null) ** GOTO lbl57
                var4_6 = v7;
                v7 = new ArrayList<ICacheAd>();
lbl57:
                // 2 sources

                if (TextUtils.isEmpty((CharSequence)var9_11.getFilterSource())) break block18;
                AdLogUtil.Log().d("AdCache", "current filter ------->" + var9_11.getFilterSource());
                if (var7_9.contains(var9_11.getFilterSource())) continue;
                var7_9.add(var9_11.getFilterSource());
            }
            if (var3_4) {
                AdLogUtil.Log().d("AdCache", "---> Remove ad:" + var9_11.getPlacementId() + " from cache");
                var1_2.remove(var9_11);
            }
            v8 = var4_6;
            v9 = v8;
            v8.add(var9_11);
            if (v9.size() < var2_3) continue;
        }
        return var4_6;
    }

    public double getMaxPrice(String string, boolean bl) {
        return this.getMaxPrice(string, null, bl);
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasAds(String var1_2, boolean var2_3) {
        block11: {
            block10: {
                var1_2 = this.map.get(var1_2);
                if (var1_2 != null) break block10;
                return false;
            }
            try {
                var3_4 = var1_2.iterator();
            }
            catch (Throwable var0_1) {
                AdLogUtil.Log().e("AdCache", Log.getStackTraceString((Throwable)var0_1));
                return false;
            }
            while (true) {
                block12: {
                    if (!var3_4.hasNext()) break block11;
                    var4_5 = (ICacheAd)var3_4.next();
                    if (!var4_5.isExpired()) break block12;
                    var5_6 = this.watcher;
                    if (var5_6 == null) ** GOTO lbl20
                    var5_6.onExpired(var4_5);
lbl20:
                    // 2 sources

                    var4_5.destroyAd();
                    var1_2.remove(var4_5);
                    continue;
                }
                if (!var2_3) break;
                if (!var4_5.isMatchVulgarBrand()) break;
                continue;
                break;
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public int getAdNum(String var1_2) {
        block10: {
            var2_3 = 0;
            var1_2 = this.map.get(var1_2);
            if (var1_2 != null) break block10;
            return var2_3;
        }
        try {
            var3_4 = var1_2.iterator();
        }
        catch (Throwable var0_1) {
            AdLogUtil.Log().e("AdCache", Log.getStackTraceString((Throwable)var0_1));
            return 0;
        }
        while (true) {
            block11: {
                if (!var3_4.hasNext()) break;
                var4_5 = (ICacheAd)var3_4.next();
                if (!var4_5.isExpired()) break block11;
                var5_6 = this.watcher;
                if (var5_6 == null) ** GOTO lbl21
                var5_6.onExpired(var4_5);
lbl21:
                // 2 sources

                var4_5.destroyAd();
                var1_2.remove(var4_5);
                continue;
            }
            ++var2_3;
            AdLogUtil.Log().d("AdCache", "*----> ad in pool is :" + var4_5.getPlacementId() + ",EcpmPrice is :" + var4_5.getEcpmPrice() + ",AdSource is :" + var4_5.getAdSource() + ",ValidTimeLimit :" + var4_5.getValidTimeLimit());
            continue;
            break;
        }
        return var2_3;
    }

    public int[] getValidAndInvalidAdNum(String iterator) {
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = n;
        nArray[1] = n2;
        if ((iterator = this.map.get(iterator)) == null) {
            return nArray2;
        }
        iterator = ((CopyOnWriteArrayList)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            if (!((ICacheAd)iterator.next()).isExpired()) {
                ++n;
                continue;
            }
            ++n2;
        }
        int[] nArray3 = nArray2;
        nArray3[0] = n;
        nArray3[1] = n2;
        return nArray2;
    }

    /*
     * Exception decompiling
     */
    public int getAdNum(String var1_2, int var2_3, String var3_4, boolean var4_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    public double getNetworkPrice(String var1_2, int var2_3, String var3_4) {
        block13: {
            block12: {
                var4_5 = 0.0;
                var1_2 = this.map.get(var1_2);
                if (var1_2 != null) break block12;
                return var4_5;
            }
            var6_6 = var1_2.iterator();
            while (true) {
                block14: {
                    if (!var6_6.hasNext()) break block13;
                    var7_7 = (ICacheAd)var6_6.next();
                    if (!var7_7.isExpired()) break block14;
                    var8_8 = this.watcher;
                    if (var8_8 == null) ** GOTO lbl21
                    var8_8.onExpired(var7_7);
lbl21:
                    // 2 sources

                    var7_7.destroyAd();
                    var1_2.remove(var7_7);
                    continue;
                }
                if (var7_7.getAdSource() != var2_3) continue;
                if (TextUtils.equals((CharSequence)var7_7.getPlacementId(), (CharSequence)var3_4)) break;
                continue;
                break;
            }
            try {
                var4_5 = var7_7.getEcpmPrice();
            }
            catch (Throwable var0_1) {
                AdLogUtil.Log().e("AdCache", Log.getStackTraceString((Throwable)var0_1));
                return 0.0;
            }
        }
        return var4_5;
    }

    public void registerWatcher(AdCacheExpiredWatcher adCacheExpiredWatcher) {
        this.watcher = adCacheExpiredWatcher;
    }

    public void unRegisterWatcher() {
        this.watcher = null;
    }

    public void removeAll() {
        this.map.clear();
    }

    public static interface AdCacheExpiredWatcher {
        public void onExpired(ICacheAd var1);
    }

    public static class AdCacheComp
    implements Comparator<ICacheAd> {
        @Override
        public int compare(ICacheAd iCacheAd, ICacheAd iCacheAd2) {
            block13: {
                block14: {
                    block12: {
                        block11: {
                            try {
                                if (!iCacheAd.isExpired()) break block11;
                            }
                            catch (Throwable throwable) {
                                return 0;
                            }
                            if (iCacheAd2.isExpired()) break block11;
                            return 1;
                        }
                        if (iCacheAd.isExpired()) break block12;
                        if (!iCacheAd2.isExpired()) break block12;
                        return -1;
                    }
                    if (iCacheAd.getEcpmPrice() != iCacheAd2.getEcpmPrice()) break block13;
                    if (iCacheAd.getValidTimeLimit() - iCacheAd2.getValidTimeLimit() >= 0L) break block14;
                    return -1;
                }
                if (iCacheAd.getValidTimeLimit() - iCacheAd2.getValidTimeLimit() > 0L) {
                    return 1;
                }
                return 0;
            }
            if (iCacheAd.getEcpmPrice() > iCacheAd2.getEcpmPrice()) {
                return -1;
            }
            return 1;
        }
    }
}

