/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.base;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import com.cloud.hisavana.sdk.manager.NetStateManager;
import com.cloud.sdk.commonutil.athena.PostConstant;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.cloud.sdk.commonutil.util.RunTimer;
import com.hisavana.common.bean.AdCache;
import com.hisavana.common.bean.AdNativeInfo;
import com.hisavana.common.bean.AdditionalInfo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.bean.TInnerAdRequestBody;
import com.hisavana.common.interfacz.Iad;
import com.hisavana.common.interfacz.TAdditionalListener;
import com.hisavana.common.interfacz.TInnerAdListener;
import com.hisavana.common.interfacz.WrapTAdAllianceListener;
import com.hisavana.common.manager.AdCacheManager;
import com.hisavana.common.manager.RequestingAdManager;
import com.hisavana.common.mock.RecordTestInfo;
import com.hisavana.common.tracking.TrackingManager;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.common.utils.AdUtil;
import com.hisavana.common.utils.MediaLogUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class BaseAd
implements Iad {
    private boolean isTimeOut;
    protected String mAdUnit;
    protected boolean isOfflineAd;
    private int supportHisavanaFlag;
    private double maxPrice;
    private String sceneId;
    private String sceneToken;
    protected String mGameName;
    protected String mGameScene;
    protected Map<String, Object> mExtInfo;
    protected boolean mCurrActivityFullscreen;
    protected int mAdCount;
    protected WeakReference<Context> mContext;
    private final String TAG;
    private double price;
    public double secondPrice;
    private int ttl;
    private int adSource;
    protected long startTime;
    protected boolean isLoaded;
    protected RunTimer runTimer;
    protected final List<WrapTAdAllianceListener> mListenerList;
    private long mLoadedTime;
    private long mImpressionTime;
    protected final Network mNetwork;
    private int mLoadStatus;
    protected int requestType;
    private int mRequestRound;
    public final Bundle mBundle;
    protected String mRequestId;
    protected String mTriggerId;
    protected String mShowId;
    private boolean isDestroyed;
    protected boolean isContainVulgarContent;
    private TAdditionalListener additionalListener;
    protected RunTimer.TimeOutCallback timeOutCallback;
    private long requestTime;

    public BaseAd(Context context, Network network) {
        WeakReference<Context> weakReference;
        RunTimer.TimeOutCallback timeOutCallback;
        Bundle bundle;
        Bundle bundle2;
        BaseAd baseAd = weakReference2;
        ((BaseAd)((Object)weakReference2)).isTimeOut = false;
        ((BaseAd)((Object)weakReference2)).supportHisavanaFlag = 0;
        ((BaseAd)((Object)weakReference2)).mAdCount = 1;
        ((BaseAd)((Object)weakReference2)).TAG = "BaseAd";
        ((BaseAd)((Object)weakReference2)).price = 0.0;
        ((BaseAd)((Object)weakReference2)).isLoaded = false;
        Object object = bundle2;
        bundle2 = new CopyOnWriteArrayList();
        ((BaseAd)((Object)weakReference2)).mListenerList = object;
        ((BaseAd)((Object)weakReference2)).mRequestRound = -1;
        object = bundle;
        bundle = new Bundle();
        ((BaseAd)((Object)weakReference2)).mBundle = object;
        ((BaseAd)((Object)weakReference2)).mRequestId = null;
        ((BaseAd)((Object)weakReference2)).mTriggerId = null;
        ((BaseAd)((Object)weakReference2)).mShowId = null;
        ((BaseAd)((Object)weakReference2)).isDestroyed = false;
        object = timeOutCallback;
        timeOutCallback = new RunTimer.TimeOutCallback(){

            public void isTimeOut() {
                AdLogUtil.Log().d("BaseAd", "Load ad is time out" + BaseAd.this.getLogString());
                BaseAd.this.onTimeOut();
            }
        };
        ((BaseAd)((Object)weakReference2)).timeOutCallback = object;
        WeakReference<Context> weakReference2 = weakReference;
        weakReference = new WeakReference<Context>(context);
        v5.mContext = weakReference2;
        Preconditions.checkNotNull((Object)network);
        baseAd.mNetwork = network;
    }

    private void adLoadedTemp() {
        ArrayList arrayList;
        Object object = AdLogUtil.Log();
        Object object2 = "BaseAd";
        StringBuilder stringBuilder = new StringBuilder().append("Ad request has been destroyed or loaded,isLoaded = ").append(this.isLoaded).append(",isDestroyed = ").append(this.isDestroyed).append("( triggerId is ").append(this.mTriggerId).append(", code seat id is ");
        Object object3 = this.mNetwork;
        object3 = object3 == null ? "" : ((Network)object3).getCodeSeatId();
        object.d((String)object2, stringBuilder.append((String)object3).append(" )").toString());
        RequestingAdManager.getInstance().removeRequest(this);
        if (this.isLoaded) {
            return;
        }
        if (this.mNetwork != null) {
            MediaLogUtil.d("BaseAd", "loadSuccess adSource " + this.mNetwork.getSource() + " id " + this.mNetwork.getCodeSeatId() + " " + this.getLogString());
        }
        object = arrayList;
        ((ArrayList)object)(this.mListenerList.size());
        arrayList.addAll(this.mListenerList);
        object2 = AdCacheManager.getCache(this.getAdType());
        if (object2 != null) {
            ((AdCache)object2).addCache(this.mAdUnit, this);
        }
        BaseAd baseAd = this;
        Bundle bundle = new Bundle();
        bundle.putInt("error_code", 0);
        bundle.putInt("request_num", this.mAdCount);
        this.adReturnTracking(bundle);
        this.isLoaded = true;
        this.mLoadedTime = System.currentTimeMillis();
        baseAd.loadedCallBack((List<WrapTAdAllianceListener>)object);
        if (baseAd.supportTimer()) {
            this.stopTimer();
        }
    }

    private void adLoadedTemp(List<TAdNativeInfo> list) {
        Bundle bundle;
        ArrayList arrayList;
        Object object = AdLogUtil.Log();
        Object object2 = "BaseAd";
        Object object3 = new StringBuilder().append("Ad request has been destroyed or loaded,isLoaded = ").append(this.isLoaded).append(",isDestroyed = ").append(this.isDestroyed).append("( triggerId is ").append(this.mTriggerId).append(", code seat id is ");
        Object object4 = this.mNetwork;
        object4 = object4 == null ? "" : ((Network)object4).getCodeSeatId();
        object.d((String)object2, ((StringBuilder)object3).append((String)object4).append(" )").toString());
        RequestingAdManager.getInstance().removeRequest(this);
        if (this.isLoaded) {
            return;
        }
        if (this.mNetwork != null) {
            MediaLogUtil.d("BaseAd", "loadSuccess adSource " + this.mNetwork.getSource() + " id " + this.mNetwork.getCodeSeatId() + " " + this.getLogString());
        }
        object = arrayList;
        ((ArrayList)object)(this.mListenerList.size());
        arrayList.addAll(this.mListenerList);
        object2 = AdCacheManager.getCache(this.getAdType());
        if (list != null && list.size() > 0 && object2 != null) {
            ((AdCache)object2).addCaches(this.mAdUnit, list);
        }
        object2 = bundle;
        new Bundle().putInt("error_code", 0);
        if (list != null && list.size() > 0) {
            TAdNativeInfo tAdNativeInfo;
            object3 = list.get(0);
            if (tAdNativeInfo.getEcpmPrice() > 0.0) {
                this.price = object3.getEcpmPrice();
            }
        }
        BaseAd baseAd = this;
        this.adReturnTracking((Bundle)object2);
        this.isLoaded = true;
        this.mLoadedTime = System.currentTimeMillis();
        baseAd.loadedCallBack((List<WrapTAdAllianceListener>)object, list);
        if (baseAd.supportTimer()) {
            this.stopTimer();
        }
    }

    private void adFailedToLoadTemp(TAdErrorCode tAdErrorCode) {
        Bundle bundle;
        RequestingAdManager.getInstance().removeRequest(this);
        AdLogUtil adLogUtil = AdLogUtil.Log();
        String string = "BaseAd";
        CharSequence charSequence = new StringBuilder().append("Ad request has been destroyed or loaded,isLoaded = ").append(this.isLoaded).append(",isDestroyed = ").append(this.isDestroyed).append("( triggerId is ").append(this.mTriggerId).append(", code seat id is ");
        Object object = this.mNetwork;
        object = object == null ? "" : ((Network)object).getCodeSeatId();
        adLogUtil.d(string, charSequence.append((String)object).append(" )").toString());
        if (this.isLoaded) {
            return;
        }
        this.isLoaded = true;
        adLogUtil = bundle;
        bundle = new Bundle();
        int n = tAdErrorCode != null ? tAdErrorCode.getErrorCode() : 30003;
        if (n == 0) {
            n = 30003;
        }
        adLogUtil.putInt("error_code", n);
        String string2 = "error_message";
        charSequence = tAdErrorCode == null ? "null" : tAdErrorCode.getErrorMessage();
        BaseAd baseAd = this;
        AdLogUtil adLogUtil2 = adLogUtil;
        adLogUtil.putString(string2, (String)charSequence);
        adLogUtil2.putInt("request_num", this.mAdCount);
        this.adReturnTracking((Bundle)adLogUtil2);
        baseAd.errorCallBack(tAdErrorCode);
        if (baseAd.supportTimer()) {
            this.stopTimer();
        }
        this.destroyAd();
    }

    private void loadedCallBack(List<WrapTAdAllianceListener> object) {
        if (object != null && !object.isEmpty()) {
            Iterator<WrapTAdAllianceListener> iterator = object.iterator();
            while (iterator.hasNext()) {
                object = (WrapTAdAllianceListener)iterator.next();
                if (object == null) continue;
                ((TInnerAdListener)object).onLoad();
            }
            return;
        }
    }

    private void loadedCallBack(List<WrapTAdAllianceListener> object, List<TAdNativeInfo> list) {
        if (object != null && !object.isEmpty()) {
            Iterator<WrapTAdAllianceListener> iterator = object.iterator();
            while (iterator.hasNext()) {
                object = (WrapTAdAllianceListener)iterator.next();
                if (object == null) continue;
                ((WrapTAdAllianceListener)object).onLoad(list);
            }
            return;
        }
    }

    private void errorCallBack(TAdErrorCode tAdErrorCode) {
        for (WrapTAdAllianceListener wrapTAdAllianceListener : ((BaseAd)this).mListenerList) {
            if (wrapTAdAllianceListener == null) continue;
            wrapTAdAllianceListener.onError(tAdErrorCode);
        }
    }

    private void appendContextParam(Bundle bundle) {
        Bundle bundle2 = bundle;
        bundle.putString("trigger_id", this.mBundle.getString("trigger_id"));
        long l = this.mBundle.getLong("trigger_ts");
        bundle.putLong("trigger_ts", l);
        bundle.putInt("ad_type", this.mBundle.getInt("ad_type"));
        bundle.putString("cld_app_id", this.mBundle.getString("cld_app_id"));
        bundle.putString("cld_code_seat_id", this.mBundle.getString("cld_code_seat_id"));
        bundle.putInt("platform", this.mBundle.getInt("platform"));
        bundle.putString("app_id", this.mBundle.getString("app_id"));
        bundle.putString("code_seat_id", this.mBundle.getString("code_seat_id"));
        double d = this.mBundle.getDouble("bidding_price");
        bundle.putDouble("bidding_price", d);
        bundle.putInt("priority", this.mBundle.getInt("priority"));
        bundle.putInt("ad_count", this.mBundle.getInt("ad_count"));
        bundle2.putInt("is_retreatad", this.mBundle.getInt("is_retreatad"));
        bundle2.putInt("is_default_ad", 0);
        long l2 = this.mBundle.getLong("request_ts");
        bundle.putLong("request_ts", l2);
        bundle.putInt("request_time", this.mBundle.getInt("request_time"));
        bundle.putString("request_id", this.mBundle.getString("request_id"));
        l2 = this.mBundle.getLong("return_ts");
        bundle.putLong("return_ts", l2);
        bundle.putInt("return_time", this.mBundle.getInt("return_time"));
        bundle.putInt("request_type", this.mBundle.getInt("request_type"));
    }

    private void addToContextParam(String string, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Integer) {
            this.mBundle.putInt(string, ((Integer)object).intValue());
        } else if (object instanceof String) {
            this.mBundle.putString(string, (String)object);
        } else if (object instanceof Long) {
            this.mBundle.putLong(string, ((Long)object).longValue());
        }
    }

    private boolean isWaterFallExecutor() {
        return AdUtil.isWaterFall(this.adSource);
    }

    private AdditionalInfo getBaseAdditionalInfo() {
        AdditionalInfo additionalInfo;
        AdditionalInfo additionalInfo2;
        AdditionalInfo additionalInfo3 = additionalInfo2 = additionalInfo;
        additionalInfo2();
        additionalInfo3.setPlacementId(this.mAdUnit);
        additionalInfo3.setMcc(PostConstant.getMcc());
        additionalInfo2.setTriggerId(this.mBundle.getString("trigger_id"));
        additionalInfo2.setTrafficGroupId(this.mBundle.getString("traffic_group_id"));
        additionalInfo.setExperimentGroupId(this.mBundle.getString("experiment_group_id"));
        additionalInfo.setSdkVersion(PostConstant.getSdkVersion());
        return additionalInfo;
    }

    private AdditionalInfo getShowAdditionalInfo() {
        BaseAd baseAd = this;
        AdditionalInfo additionalInfo = baseAd.getBaseAdditionalInfo();
        Object object = baseAd.mNetwork;
        if (object != null) {
            additionalInfo.setSource(((Network)object).getSource());
            additionalInfo.setApplicationId(this.mNetwork.getApplicationId());
            additionalInfo.setApplicationKey(this.mNetwork.getApplicationKey());
            additionalInfo.setCodeSeatId(this.mNetwork.getCodeSeatId());
            additionalInfo.setECPM(this.mBundle.getDouble("bidding_price"));
            object = this.isWaterFallExecutor() ? "estimated" : "exact";
            AdditionalInfo additionalInfo2 = additionalInfo;
            additionalInfo2.setPrecision((String)object);
            additionalInfo2.setCurrency("USD");
            additionalInfo.setBidding(AdUtil.isBiddingNetwork(this.mNetwork.getSource()));
            additionalInfo.setMediatorSource(this.mNetwork.getMediatorSource());
        }
        return additionalInfo;
    }

    private void saveShowedValue(long l) {
        if (this.mNetwork != null && l > 0L) {
            AdxPreferencesHelper.getInstance().putLong(this.mNetwork.getCodeSeatId(), l);
            AdLogUtil.Log().w("ad_flow", ">>>>> codeSeatId: " + this.mNetwork.getCodeSeatId() + " | adType : " + this.mNetwork.getAdt() + " | valueMicros: " + l);
        }
    }

    @Override
    public void setTimeOut(boolean bl) {
        this.isTimeOut = bl;
    }

    @Override
    public void setSecondPrice(double d) {
        AdLogUtil.Log().d("ssp_second_price", "*----> BaseAd setSecondPrice price" + d + this.getLogString());
        this.secondPrice = d;
    }

    public String getLogString() {
        return "----- class name = " + this.getClass().getSimpleName() + " ----- mAdUnit = " + this.mAdUnit;
    }

    @Override
    public void setRequestRound(int n) {
        AdLogUtil.Log().d("BaseAd", "setRequestRound " + n + " " + this.getLogString());
        this.mRequestRound = n;
    }

    public void setContainVulgarContent(boolean bl) {
        this.isContainVulgarContent = bl;
    }

    public void setAdLoadScenes(String string, String string2, Map<String, Object> map) {
        BaseAd baseAd = this;
        baseAd.mGameName = string;
        baseAd.mGameScene = string2;
        baseAd.mExtInfo = map;
    }

    public void setCurrActivityFullscreen(boolean bl) {
        this.mCurrActivityFullscreen = bl;
    }

    @Override
    public void setRequestType(int n) {
        this.requestType = n;
    }

    @Override
    public boolean isAdxAd() {
        return false;
    }

    @Override
    public boolean isEwAd() {
        return false;
    }

    @Override
    public void loadAd() {
        this.mRequestId = DeviceUtil.getUUID();
        this.startTime = System.currentTimeMillis();
        if (this.supportTimer()) {
            this.startTimer();
        }
        BaseAd baseAd = this;
        baseAd.adTrackingRequest();
        if (baseAd.mNetwork != null) {
            MediaLogUtil.d("BaseAd", "loadAd adSource " + this.mNetwork.getSource() + " id " + this.mNetwork.getCodeSeatId() + " " + this.getLogString());
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAdUnit)) {
            RequestingAdManager.getInstance().addRequest(this);
        }
    }

    public void setShowId(String string) {
        this.mShowId = string;
    }

    public void adLoaded() {
        this.adLoadedTemp();
    }

    public void adLoaded(List<TAdNativeInfo> list) {
        this.adLoadedTemp(list);
    }

    protected void adFailedToLoad(TAdErrorCode tAdErrorCode) {
        this.adFailedToLoadTemp(tAdErrorCode);
    }

    protected void onAdShowError(TAdErrorCode tAdErrorCode) {
        this.onAdShowError(null, tAdErrorCode);
    }

    protected void onAdShowError(TAdNativeInfo tAdNativeInfo, TAdErrorCode tAdErrorCode) {
        BaseAd baseAd = object;
        baseAd.logImpression(tAdNativeInfo, false, tAdErrorCode);
        Object object = baseAd.mListenerList.isEmpty() ? null : ((BaseAd)object).mListenerList.get(0);
        if (object != null) {
            ((WrapTAdAllianceListener)object).onShowError(tAdErrorCode);
        }
    }

    public void adImpression(AdNativeInfo adNativeInfo) {
        BaseAd baseAd = this;
        baseAd.logImpression(adNativeInfo, true, TAdErrorCode.SUCCESS_MESSAGE);
        baseAd.mImpressionTime = System.currentTimeMillis();
        Object object = baseAd.mListenerList.isEmpty() ? null : this.mListenerList.get(0);
        if (object != null) {
            WrapTAdAllianceListener wrapTAdAllianceListener = object;
            BaseAd baseAd2 = this;
            int n = baseAd2.getAdSource();
            object = baseAd2.getShowAdditionalInfo();
            wrapTAdAllianceListener.onNativeFeedShow(n, adNativeInfo, (AdditionalInfo)object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isIconAd() {
        Network network = ((BaseAd)((Object)network)).mNetwork;
        if (network == null) {
            return false;
        }
        if (network.getAdt() != 6) return false;
        return true;
    }

    @Override
    public boolean isSupportRtBidding() {
        return false;
    }

    public boolean isSupportStopRequest() {
        return false;
    }

    @Override
    public Network getNetwork() {
        return this.mNetwork;
    }

    public void adClicked(AdNativeInfo adNativeInfo) {
        BaseAd baseAd = this;
        baseAd.logClick();
        Object object = baseAd.mListenerList.isEmpty() ? null : this.mListenerList.get(0);
        if (object != null) {
            WrapTAdAllianceListener wrapTAdAllianceListener = object;
            BaseAd baseAd2 = this;
            int n = baseAd2.getAdSource();
            object = baseAd2.getClickAdditionalInfo();
            wrapTAdAllianceListener.onNativeFeedClicked(n, adNativeInfo, (AdditionalInfo)object);
        }
    }

    @Override
    public void setLoadStatus(int n) {
        this.mLoadStatus = n;
    }

    @Override
    public int getLoadStatus() {
        return this.mLoadStatus;
    }

    @Override
    public boolean isMatchVulgarBrand() {
        return false;
    }

    protected void adClosed() {
        BaseAd baseAd = this;
        baseAd.logClose();
        WrapTAdAllianceListener wrapTAdAllianceListener = baseAd.mListenerList.isEmpty() ? null : this.mListenerList.get(0);
        if (wrapTAdAllianceListener != null) {
            wrapTAdAllianceListener.onClosed(this.getAdSource());
        }
    }

    protected void adClosed(TAdNativeInfo tAdNativeInfo) {
        BaseAd baseAd = object;
        baseAd.logClose();
        Object object = baseAd.mListenerList.isEmpty() ? null : ((BaseAd)object).mListenerList.get(0);
        if (object != null) {
            ((WrapTAdAllianceListener)object).onClosed(tAdNativeInfo);
        }
    }

    protected void onReward() {
        Object object = ((BaseAd)object).mListenerList.isEmpty() ? null : ((BaseAd)object).mListenerList.get(0);
        if (object != null) {
            ((WrapTAdAllianceListener)object).onRewarded();
        }
    }

    protected void logImpression(TAdNativeInfo object, boolean bl, TAdErrorCode object2) {
        Bundle bundle;
        Bundle bundle2;
        Bundle bundle3 = bundle2 = bundle;
        Bundle bundle4 = bundle2;
        Bundle bundle5 = bundle2;
        bundle5();
        this.appendContextParam(bundle5);
        long l = System.currentTimeMillis();
        bundle4.putLong("show_ts", l);
        l = System.currentTimeMillis() - this.mLoadedTime;
        bundle4.putLong("show_time", l);
        bundle2.putString("ad_title", this.mBundle.getString("ad_title"));
        bundle2.putString("ad_url", this.mBundle.getString("ad_url"));
        bundle2.putInt("filling_source", this.mBundle.getInt("filling_source"));
        bundle2.putString("description", this.mBundle.getString("description"));
        bundle2.putString("image_url", this.mBundle.getString("image_url"));
        bundle2.putString("icon_url", this.mBundle.getString("icon_url"));
        bundle2.putString("endcard_url", this.mBundle.getString("endcard_url"));
        bundle2.putString("app_name", this.mBundle.getString("app_name"));
        bundle2.putString("package_name", this.mBundle.getString("package_name"));
        bundle2.putString("download_url", this.mBundle.getString("download_url"));
        bundle2.putInt("ad_trigger_status", this.mBundle.getInt("ad_trigger_status"));
        String string = "is_offline_ad";
        bundle2.putInt(string, this.isOfflineAd() ? 1 : 0);
        bundle3.putInt("filling_ad_type", this.mBundle.getInt("filling_ad_type"));
        bundle3.putInt("slot_height", 0);
        bundle3.putInt("slot_width", 0);
        bundle2.putString("scene_id", this.sceneId);
        string = "is_expired";
        bundle.putInt(string, this.isExpired() ? 1 : 0);
        if (bl) {
            Bundle bundle6 = bundle2;
            bundle6.putInt("show_status", 1);
            bundle6.putInt("fail_reason", 0);
        } else {
            Bundle bundle7 = bundle2;
            bundle7.putInt("show_status", 2);
            bundle7.putInt("fail_reason", 2);
        }
        bundle2.putInt("is_pre_trigger", this.mBundle.getInt("is_pre_trigger"));
        bundle2.putInt("filling_source", this.mBundle.getInt("filling_source"));
        bundle2.putString("request_id", this.mBundle.getString("request_id"));
        bundle2.putInt("request_num", this.mBundle.getInt("request_num"));
        bundle2.putString("traffic_group_id", this.mBundle.getString("traffic_group_id"));
        bundle2.putString("experiment_group_id", this.mBundle.getString("experiment_group_id"));
        bundle2.putInt("optimize_status", this.mBundle.getInt("optimize_status"));
        bundle2.putInt("priority_code", this.mBundle.getInt("priority_code"));
        if (this.maxPrice == 0.0) {
            this.maxPrice = this.mBundle.getDouble("max_price");
        }
        double d = this.maxPrice;
        bundle2.putDouble("max_price", d);
        String string2 = "ecpm";
        double d2 = object == null ? this.price : object.getEcpmPrice();
        bundle2.putDouble(string2, d2);
        string2 = "ecpm_precision";
        String string3 = this.isWaterFallExecutor() ? "estimated" : "exact";
        bundle2.putString(string2, string3);
        string2 = "show_id";
        string3 = object == null ? this.mShowId : ((TAdNativeInfo)object).getShowId();
        bundle2.putString(string2, string3);
        string2 = "scene_token";
        object = object == null ? this.sceneToken : ((TAdNativeInfo)object).getSceneToken();
        bundle2.putString(string2, (String)object);
        object = "error_code";
        string2 = object2 == null ? null : String.valueOf(((TAdErrorCode)object2).getErrorCode());
        bundle2.putString((String)object, string2);
        object = "error_message";
        object2 = object2 == null ? null : ((TAdErrorCode)object2).getErrorMessage();
        Bundle bundle8 = bundle2;
        bundle8.putString((String)object, (String)object2);
        bundle8.putInt("is_offline", NetStateManager.checkNetworkState() ^ 1);
        bundle2.putInt("is_contain_vulgar", this.mBundle.getInt("is_contain_vulgar"));
        object = "mediator_source";
        object2 = this.mNetwork;
        object2 = object2 != null ? ((Network)object2).getMediatorSource() : "";
        bundle2.putString((String)object, (String)object2);
        object = "price_coefficient";
        object2 = this.mNetwork;
        double d3 = object2 != null ? ((Network)object2).getShowPriceCoefficient().doubleValue() : 0.0;
        BaseAd baseAd = this;
        Bundle bundle9 = bundle2;
        bundle9.putDouble((String)object, d3);
        TrackingManager.trackingImpression(bundle9);
        this.addToContextParam("show_ts", bundle9.getLong("show_ts"));
        this.addToContextParam("show_time", bundle2.getLong("show_time"));
        this.addToContextParam("slot_height", bundle2.getInt("slot_height"));
        this.addToContextParam("slot_width", bundle2.getInt("slot_width"));
        this.addToContextParam("show_status", bundle2.getInt("show_status"));
        baseAd.addToContextParam("fail_reason", bundle2.getInt("fail_reason"));
        double d4 = bundle2.getDouble("max_price");
        baseAd.mBundle.putDouble("max_price", d4);
    }

    @Override
    public String getAdUnit() {
        return this.mAdUnit;
    }

    @Override
    public void setAdUnit(String string) {
        this.mAdUnit = string;
    }

    protected void logTrigerShow(String string, String string2) {
        this.trigerShow(null, string, string2);
    }

    public void logTrigerShow(TAdNativeInfo tAdNativeInfo) {
        this.trigerShow(tAdNativeInfo, "", "");
    }

    protected void trigerShow(TAdNativeInfo object, String object2, String string) {
        Bundle bundle;
        Bundle bundle2;
        Bundle bundle3 = bundle2 = bundle;
        bundle3();
        this.appendContextParam(bundle3);
        if (bundle.containsKey("is_default_ad")) {
            bundle2.remove("is_default_ad");
        }
        bundle2.putInt("is_timeout", this.mBundle.getInt("is_timeout"));
        bundle2.putString("error_code", this.mBundle.getString("error_code"));
        bundle2.putString("error_message", this.mBundle.getString("error_message"));
        if (object != null) {
            Bundle bundle4 = bundle2;
            bundle4.putString("ad_title", ((TAdNativeInfo)object).getTitle());
            bundle4.putString("ad_url", "");
            bundle2.putString("description", ((TAdNativeInfo)object).getDescription());
            if (((TAdNativeInfo)object).getIcon() != null) {
                bundle2.putString("icon_url", ((TAdNativeInfo)object).getIcon().getUrl());
            }
            Bundle bundle5 = bundle2;
            bundle5.putString("endcard_url", "");
            bundle5.putString("app_name", "");
            bundle5.putString("package_name", "");
            bundle5.putString("download_url", "");
            bundle2.putString("scene_id", ((TAdNativeInfo)object).getSceneId());
            object2 = ((TAdNativeInfo)object).getSceneId() == null ? "" : ((TAdNativeInfo)object).getSceneId();
            this.sceneId = object2;
            bundle2.putString("scene_token", ((TAdNativeInfo)object).getSceneToken());
            this.sceneToken = ((TAdNativeInfo)object).getSceneToken();
        } else {
            bundle2.putString("scene_id", string);
            if (string == null) {
                string = "";
            }
            this.sceneId = string;
            bundle2.putString("scene_token", (String)object2);
            this.sceneToken = object2;
        }
        bundle2.putInt("is_pre_trigger", this.mBundle.getInt("is_pre_trigger"));
        bundle2.putInt("filling_source", this.mBundle.getInt("filling_source"));
        bundle2.putString("request_id", this.mBundle.getString("request_id"));
        bundle2.putInt("ad_trigger_status", this.mBundle.getInt("ad_trigger_status"));
        object2 = "is_offline_ad";
        bundle2.putInt((String)object2, this.isOfflineAd() ? 1 : 0);
        bundle2.putInt("filling_ad_type", this.mBundle.getInt("filling_ad_type"));
        bundle2.putString("traffic_group_id", this.mBundle.getString("traffic_group_id"));
        bundle2.putString("experiment_group_id", this.mBundle.getString("experiment_group_id"));
        object2 = "show_id";
        object = object == null ? this.mShowId : ((TAdNativeInfo)object).getShowId();
        Bundle bundle6 = bundle2;
        bundle6.putString((String)object2, (String)object);
        bundle6.putInt("is_offline", NetStateManager.checkNetworkState() ^ 1);
        bundle2.putInt("is_contain_vulgar", this.mBundle.getInt("is_contain_vulgar"));
        object = "mediator_source";
        object2 = this.mNetwork;
        object2 = object2 != null ? ((Network)object2).getMediatorSource() : "";
        bundle2.putString((String)object, (String)object2);
        object = "price_coefficient";
        object2 = this.mNetwork;
        double d = object2 != null ? ((Network)object2).getShowPriceCoefficient().doubleValue() : 0.0;
        BaseAd baseAd = this;
        BaseAd baseAd2 = this;
        Bundle bundle7 = bundle2;
        bundle7.putDouble((String)object, d);
        TrackingManager.trackingTriggerShow(bundle7);
        baseAd2.addToContextParam("ad_title", bundle7.getString("ad_title"));
        baseAd2.addToContextParam("ad_url", "");
        this.addToContextParam("description", bundle2.getString("description"));
        this.addToContextParam("image_url", bundle2.getString("image_url"));
        baseAd.addToContextParam("icon_url", bundle2.getString("icon_url"));
        baseAd.addToContextParam("endcard_url", "");
        baseAd.addToContextParam("app_name", "");
        baseAd.addToContextParam("package_name", "");
        baseAd.addToContextParam("download_url", "");
        baseAd.addToContextParam("request_num", baseAd.mAdCount);
    }

    protected void logClick() {
        Bundle bundle;
        Bundle bundle2;
        Bundle bundle3 = bundle2 = bundle;
        Bundle bundle4 = bundle2;
        BaseAd baseAd = string2;
        Bundle bundle5 = bundle2;
        bundle5();
        baseAd.appendContextParam(bundle5);
        bundle2.putInt("request_time", baseAd.mBundle.getInt("request_time"));
        long l = ((BaseAd)((Object)string2)).mBundle.getLong("return_ts");
        bundle2.putLong("return_ts", l);
        bundle2.putInt("return_time", ((BaseAd)((Object)string2)).mBundle.getInt("return_time"));
        l = ((BaseAd)((Object)string2)).mBundle.getLong("show_ts");
        bundle2.putLong("show_ts", l);
        l = ((BaseAd)((Object)string2)).mBundle.getLong("show_time");
        bundle4.putLong("show_time", l);
        l = System.currentTimeMillis();
        bundle4.putLong("click_ts", l);
        bundle4.putInt("click_time", (int)(System.currentTimeMillis() - ((BaseAd)((Object)string2)).mImpressionTime));
        bundle2.putString("ad_title", ((BaseAd)((Object)string2)).mBundle.getString("ad_title"));
        bundle2.putString("ad_url", ((BaseAd)((Object)string2)).mBundle.getString("ad_url"));
        bundle2.putInt("filling_source", ((BaseAd)((Object)string2)).mBundle.getInt("filling_source"));
        bundle2.putString("description", ((BaseAd)((Object)string2)).mBundle.getString("description"));
        bundle2.putString("image_url", ((BaseAd)((Object)string2)).mBundle.getString("image_url"));
        bundle2.putString("icon_url", ((BaseAd)((Object)string2)).mBundle.getString("icon_url"));
        bundle2.putString("endcard_url", ((BaseAd)((Object)string2)).mBundle.getString("app_name"));
        bundle2.putString("app_name", ((BaseAd)((Object)string2)).mBundle.getString("app_name"));
        bundle2.putString("package_name", ((BaseAd)((Object)string2)).mBundle.getString("package_name"));
        bundle2.putString("download_url", ((BaseAd)((Object)string2)).mBundle.getString("download_url"));
        bundle2.putInt("slot_height", ((BaseAd)((Object)string2)).mBundle.getInt("slot_height"));
        bundle2.putInt("slot_width", ((BaseAd)((Object)string2)).mBundle.getInt("slot_width"));
        bundle2.putInt("is_pre_trigger", ((BaseAd)((Object)string2)).mBundle.getInt("is_pre_trigger"));
        bundle2.putInt("request_type", ((BaseAd)((Object)string2)).mBundle.getInt("request_type"));
        bundle3.putString("request_id", ((BaseAd)((Object)string2)).mBundle.getString("request_id"));
        bundle3.putInt("click_x", 0);
        bundle3.putInt("click_y", 0);
        String string = "is_expired";
        bundle2.putInt(string, ((BaseAd)((Object)string2)).isExpired() ? 1 : 0);
        bundle2.putInt("request_num", ((BaseAd)((Object)string2)).mBundle.getInt("request_num"));
        bundle2.putInt("ad_trigger_status", ((BaseAd)((Object)string2)).mBundle.getInt("ad_trigger_status"));
        string = "is_offline_ad";
        bundle2.putInt(string, string2.isOfflineAd() ? 1 : 0);
        bundle2.putInt("filling_ad_type", ((BaseAd)((Object)string2)).mBundle.getInt("filling_ad_type"));
        bundle2.putString("traffic_group_id", ((BaseAd)((Object)string2)).mBundle.getString("traffic_group_id"));
        bundle2.putString("experiment_group_id", ((BaseAd)((Object)string2)).mBundle.getString("experiment_group_id"));
        bundle2.putInt("priority_code", ((BaseAd)((Object)string2)).mBundle.getInt("priority_code"));
        double d = ((BaseAd)((Object)string2)).mBundle.getDouble("max_price");
        bundle2.putDouble("max_price", d);
        bundle.putString("scene_id", ((BaseAd)((Object)string2)).sceneId);
        Object object = "mediator_source";
        Object object2 = ((BaseAd)((Object)string2)).mNetwork;
        object2 = object2 != null ? ((Network)object2).getMediatorSource() : "";
        BaseAd baseAd2 = string2;
        bundle2.putString((String)object, (String)object2);
        String string2 = "price_coefficient";
        object = baseAd2.mNetwork;
        double d2 = object != null ? ((Network)object).getShowPriceCoefficient().doubleValue() : 0.0;
        Bundle bundle6 = bundle2;
        bundle6.putDouble(string2, d2);
        TrackingManager.trackingAdClick(bundle6);
    }

    protected void logClose() {
        Bundle bundle;
        Bundle bundle2;
        Bundle bundle3 = bundle2 = bundle;
        Bundle bundle4 = bundle2;
        BaseAd baseAd = string;
        Bundle bundle5 = bundle2;
        bundle5();
        baseAd.appendContextParam(bundle5);
        bundle2.putInt("request_time", baseAd.mBundle.getInt("request_time"));
        long l = ((BaseAd)((Object)string)).mBundle.getLong("return_ts");
        bundle2.putLong("return_ts", l);
        bundle2.putInt("return_time", ((BaseAd)((Object)string)).mBundle.getInt("return_time"));
        l = ((BaseAd)((Object)string)).mBundle.getLong("show_ts");
        bundle2.putLong("show_ts", l);
        l = ((BaseAd)((Object)string)).mBundle.getLong("show_time");
        bundle4.putLong("show_time", l);
        l = System.currentTimeMillis();
        bundle4.putLong("click_ts", l);
        bundle4.putInt("click_time", (int)(System.currentTimeMillis() - ((BaseAd)((Object)string)).mImpressionTime));
        bundle2.putString("ad_title", ((BaseAd)((Object)string)).mBundle.getString("ad_title"));
        bundle2.putString("ad_url", ((BaseAd)((Object)string)).mBundle.getString("ad_url"));
        bundle2.putInt("filling_source", ((BaseAd)((Object)string)).mBundle.getInt("filling_source"));
        bundle2.putString("description", ((BaseAd)((Object)string)).mBundle.getString("description"));
        bundle2.putString("image_url", ((BaseAd)((Object)string)).mBundle.getString("image_url"));
        bundle2.putString("icon_url", ((BaseAd)((Object)string)).mBundle.getString("icon_url"));
        bundle2.putString("endcard_url", ((BaseAd)((Object)string)).mBundle.getString("endcard_url"));
        bundle2.putString("app_name", ((BaseAd)((Object)string)).mBundle.getString("app_name"));
        bundle2.putString("package_name", ((BaseAd)((Object)string)).mBundle.getString("package_name"));
        bundle2.putString("download_url", ((BaseAd)((Object)string)).mBundle.getString("download_url"));
        bundle2.putString("traffic_group_id", ((BaseAd)((Object)string)).mBundle.getString("traffic_group_id"));
        bundle3.putString("experiment_group_id", ((BaseAd)((Object)string)).mBundle.getString("experiment_group_id"));
        bundle3.putInt("slot_height", 0);
        bundle3.putInt("slot_width", 0);
        bundle3.putInt("click_x", 0);
        bundle3.putInt("click_y", 0);
        bundle.putString("scene_id", ((BaseAd)((Object)string)).sceneId);
        Object object = "mediator_source";
        Object object2 = ((BaseAd)((Object)string)).mNetwork;
        object2 = object2 != null ? ((Network)object2).getMediatorSource() : "";
        BaseAd baseAd2 = string;
        bundle2.putString((String)object, (String)object2);
        String string = "price_coefficient";
        object = baseAd2.mNetwork;
        double d = object != null ? ((Network)object).getShowPriceCoefficient().doubleValue() : 0.0;
        Bundle bundle6 = bundle2;
        bundle6.putDouble(string, d);
        TrackingManager.trackingAdClose(bundle6);
    }

    @Override
    public void detachContext() {
        this.mListenerList.clear();
    }

    @Override
    public void destroyAd() {
        BaseAd baseAd = this;
        baseAd.isDestroyed = true;
        baseAd.detachContext();
        baseAd.stopTimer();
        if (!baseAd.isLoaded) {
            this.isLoaded = true;
            Bundle bundle = new Bundle();
            bundle.putInt("error_code", 30005);
            bundle.putString("error_message", TAdErrorCode.ERROR_REQUEST_OBJECT_IS_DESTROYED.getErrorMessage());
            bundle.putInt("request_num", this.mAdCount);
            this.adReturnTracking(bundle);
        }
    }

    @Override
    public void addRequestBody(TInnerAdRequestBody tInnerAdRequestBody) {
        if (tInnerAdRequestBody != null) {
            BaseAd baseAd = wrapTAdAllianceListener;
            WrapTAdAllianceListener wrapTAdAllianceListener = tInnerAdRequestBody.getAdListener();
            baseAd.mListenerList.add(wrapTAdAllianceListener);
        }
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int n) {
        this.ttl = n;
    }

    @Override
    public boolean isExpired() {
        return this.getValidTimeLimit() <= 0L;
    }

    @Override
    public long getValidTimeLimit() {
        int n = this.ttl;
        if (n <= 0) {
            return Long.MAX_VALUE;
        }
        return (long)n * 60L * 1000L - Math.abs(System.currentTimeMillis() - this.startTime);
    }

    @Override
    public int getAdSource() {
        return this.adSource;
    }

    @Override
    public void setEcpmPrice(double d) {
        this.price = d;
    }

    @Override
    public double getEcpmPrice() {
        return this.price;
    }

    @Override
    public void setAdSource(int n) {
        this.adSource = n;
    }

    @Override
    public String getPlacementId() {
        return this.mNetwork.getCodeSeatId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void stopLoader() {
        if (this.isLoaded) {
            return;
        }
        try {
            if (this.isSupportStopRequest()) {
                this.destroyAd();
                return;
            }
            BaseAd baseAd = this;
            baseAd.detachContext();
            baseAd.setLoadStatus(4);
            return;
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("BaseAd", Log.getStackTraceString((Throwable)exception));
        }
    }

    @Override
    public String getFilterSource() {
        return "";
    }

    @Override
    public void setOfflineAd(boolean bl) {
        this.isOfflineAd = bl;
    }

    protected boolean supportTimer() {
        return true;
    }

    protected void startTimer() {
        if (this.runTimer == null) {
            RunTimer runTimer;
            RunTimer runTimer2;
            RunTimer runTimer3 = runTimer2 = runTimer;
            runTimer3();
            this.runTimer = runTimer3;
            runTimer.setScheduleTime(this.getTimeOutTime());
            this.runTimer.setTimeOutCallback(this.timeOutCallback);
        }
        this.runTimer.runTimerTask();
        AdLogUtil.Log().d("BaseAd", "\u542f\u52a8\u5e7f\u544a\u8bf7\u6c42\u8d85\u65f6\u76d1\u542c...");
    }

    protected int getTimeOutTime() {
        return 30000;
    }

    protected void stopTimer() {
        RunTimer runTimer = this.runTimer;
        if (runTimer != null) {
            runTimer.cancelTimeTask();
            this.runTimer = null;
        }
    }

    public void onTimeOut() {
        BaseAd baseAd = this;
        baseAd.adFailedToLoad(TAdErrorCode.ERROR_AD_REQUEST_TIME_OUT);
        baseAd.destroyAd();
    }

    public void post(Handler handler, Runnable runnable) {
        if (handler != null) {
            handler.post(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public void setTrackingBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        BaseAd baseAd = this;
        baseAd.mBundle.putAll(bundle);
        double d = this.mNetwork.getPrice();
        baseAd.mBundle.putDouble("bidding_price", d);
    }

    protected void adTrackingRequest() {
        BaseAd baseAd = this;
        RecordTestInfo.record("adTrackingRequest code_seat_id:" + this.getPlacementId() + ",bidding_price:" + this.mBundle.getDouble("bidding_price"));
        baseAd.mBundle.putInt("ad_count", this.mAdCount);
        baseAd.mBundle.putInt("is_retreatad", 0);
        baseAd.mBundle.putInt("is_default_ad", 0);
        if (TextUtils.isEmpty((CharSequence)baseAd.mRequestId)) {
            this.mRequestId = DeviceUtil.getUUID();
        }
        BaseAd baseAd2 = this;
        baseAd2.mTriggerId = baseAd2.mBundle.getString("trigger_id");
        baseAd2.mBundle.putString("request_id", this.mRequestId);
        baseAd2.mBundle.putString("cld_configure_id", AdxPreferencesHelper.getInstance().getString("cloudControlVersion"));
        baseAd2.mBundle.putInt("request_num", this.mAdCount);
        baseAd2.mBundle.putInt("request_round", this.mRequestRound);
        Bundle bundle = baseAd2.mBundle;
        String string = "price_coefficient";
        Network network = baseAd2.mNetwork;
        double d = network != null ? network.getShowPriceCoefficient().doubleValue() : 0.0;
        bundle.putDouble(string, d);
        TrackingManager.trackingAdRequest(this.mBundle);
    }

    public void adReturnTracking(Bundle bundle) {
        Bundle bundle2;
        if (bundle != null && (bundle2 = ((BaseAd)((Object)string2)).mBundle) != null) {
            double d;
            if (bundle2.containsKey("cld_configure_id")) {
                ((BaseAd)((Object)string2)).mBundle.remove("cld_configure_id");
            }
            BaseAd baseAd = string2;
            Bundle bundle3 = bundle;
            bundle.putString("trigger_id", ((BaseAd)((Object)string2)).mBundle.getString("trigger_id"));
            long l = ((BaseAd)((Object)string2)).mBundle.getLong("trigger_ts");
            bundle.putLong("trigger_ts", l);
            l = ((BaseAd)((Object)string2)).mBundle.getLong("request_ts");
            bundle.putLong("request_ts", l);
            bundle.putInt("request_time", (int)(((BaseAd)((Object)string2)).mBundle.getLong("request_ts") - ((BaseAd)((Object)string2)).mBundle.getLong("trigger_ts")));
            bundle3.putString("request_id", ((BaseAd)((Object)string2)).mBundle.getString("request_id"));
            l = System.currentTimeMillis();
            bundle3.putLong("return_ts", l);
            bundle3.putInt("return_time", (int)(System.currentTimeMillis() - ((BaseAd)((Object)string2)).mBundle.getLong("request_ts")));
            l = System.currentTimeMillis();
            baseAd.mBundle.putLong("return_ts", l);
            baseAd.mBundle.putInt("return_time", (int)(System.currentTimeMillis() - ((BaseAd)((Object)string2)).mBundle.getLong("request_ts")));
            bundle.putInt("ad_type", baseAd.mBundle.getInt("ad_type"));
            bundle.putString("cld_app_id", ((BaseAd)((Object)string2)).mBundle.getString("cld_app_id"));
            bundle.putString("cld_code_seat_id", ((BaseAd)((Object)string2)).mBundle.getString("cld_code_seat_id"));
            bundle.putInt("platform", ((BaseAd)((Object)string2)).mBundle.getInt("platform"));
            bundle.putString("app_id", ((BaseAd)((Object)string2)).mBundle.getString("app_id"));
            bundle.putString("code_seat_id", ((BaseAd)((Object)string2)).mBundle.getString("code_seat_id"));
            if (AdUtil.isBiddingNetwork(((BaseAd)((Object)string2)).adSource)) {
                d = ((BaseAd)((Object)string2)).price;
                bundle.putDouble("bidding_price", d);
            } else {
                d = ((BaseAd)((Object)string2)).mBundle.getDouble("bidding_price");
                bundle.putDouble("bidding_price", d);
            }
            Bundle bundle4 = bundle;
            RecordTestInfo.record("adReturnTracking code_seat_id:" + ((BaseAd)((Object)string2)).mBundle.getString("code_seat_id") + ",bidding_price:" + bundle.getDouble("bidding_price"));
            bundle.putInt("priority", ((BaseAd)((Object)string2)).mBundle.getInt("priority"));
            bundle.putInt("ad_count", ((BaseAd)((Object)string2)).mBundle.getInt("ad_count"));
            bundle4.putInt("is_retreatad", ((BaseAd)((Object)string2)).mBundle.getInt("is_retreatad"));
            bundle4.putInt("is_default_ad", 0);
            bundle.putInt("request_type", ((BaseAd)((Object)string2)).mBundle.getInt("request_type"));
            bundle.putInt("is_pre_trigger", ((BaseAd)((Object)string2)).mBundle.getInt("is_pre_trigger"));
            bundle.putString("ad_title", ((BaseAd)((Object)string2)).mBundle.getString("ad_title"));
            bundle.putString("ad_url", ((BaseAd)((Object)string2)).mBundle.getString("ad_url"));
            bundle.putString("description", ((BaseAd)((Object)string2)).mBundle.getString("description"));
            bundle.putString("image_url", ((BaseAd)((Object)string2)).mBundle.getString("image_url"));
            bundle.putString("icon_url", ((BaseAd)((Object)string2)).mBundle.getString("icon_url"));
            bundle.putString("endcard_url", ((BaseAd)((Object)string2)).mBundle.getString("endcard_url"));
            bundle.putString("app_name", ((BaseAd)((Object)string2)).mBundle.getString("app_name"));
            bundle.putString("package_name", ((BaseAd)((Object)string2)).mBundle.getString("package_name"));
            bundle.putString("native_info_list", ((BaseAd)((Object)string2)).mBundle.getString("native_info_list"));
            bundle.putString("download_url", ((BaseAd)((Object)string2)).mBundle.getString("download_url"));
            String string = "is_timeout";
            bundle.putInt(string, ((BaseAd)((Object)string2)).isTimeOut ? 1 : 0);
            bundle.putInt("request_num", ((BaseAd)((Object)string2)).mAdCount);
            string = "is_offline_ad";
            long l2 = string2.isOfflineAd() ? 1L : 0L;
            bundle.putLong(string, l2);
            long l3 = ((BaseAd)((Object)string2)).mBundle.getInt("ad_trigger_status");
            bundle.putLong("ad_trigger_status", l3);
            bundle.putInt("request_round", ((BaseAd)((Object)string2)).mBundle.getInt("request_round"));
            bundle.putString("traffic_group_id", ((BaseAd)((Object)string2)).mBundle.getString("traffic_group_id"));
            bundle.putString("experiment_group_id", ((BaseAd)((Object)string2)).mBundle.getString("experiment_group_id"));
            bundle.putInt("optimize_status", ((BaseAd)((Object)string2)).mBundle.getInt("optimize_status"));
            bundle.putInt("priority_code", ((BaseAd)((Object)string2)).mBundle.getInt("priority_code"));
            Object object = "mediator_source";
            Object object2 = ((BaseAd)((Object)string2)).mNetwork;
            object2 = object2 != null ? ((Network)object2).getMediatorSource() : "";
            BaseAd baseAd2 = string2;
            bundle.putString((String)object, (String)object2);
            String string2 = "price_coefficient";
            object = baseAd2.mNetwork;
            double d2 = object != null ? ((Network)object).getShowPriceCoefficient().doubleValue() : 0.0;
            Bundle bundle5 = bundle;
            bundle5.putDouble(string2, d2);
            TrackingManager.trackingAdReturn(bundle5);
            return;
        }
    }

    public void admobShowPriceTracking(float f, String string, int n) {
        Bundle bundle;
        Bundle bundle2 = bundle;
        bundle2();
        bundle2.putString("trigger_id", this.mBundle.getString("trigger_id"));
        bundle2.putString("request_id", this.mBundle.getString("request_id"));
        bundle2.putString("cld_app_id", this.mBundle.getString("cld_app_id"));
        bundle2.putString("app_id", this.mBundle.getString("app_id"));
        bundle2.putString("cld_code_seat_id", this.mBundle.getString("cld_code_seat_id"));
        bundle.putString("code_seat_id", this.mBundle.getString("code_seat_id"));
        bundle.putFloat("ad_value", f);
        bundle.putString("advalue_currency_code", string);
        bundle.putInt("ad_value_type", n);
        long l = System.currentTimeMillis();
        bundle.putLong("event_ts", l);
        TrackingManager.trackingAdmobShowPrice(bundle);
    }

    @Override
    public void setRequestTime(long l) {
        this.requestTime = l;
    }

    @Override
    public long getRequestTime() {
        return this.requestTime;
    }

    @Override
    public void setSupportFlag(int n) {
        this.supportHisavanaFlag = n;
    }

    protected int getSupportHisavanaFlag() {
        return this.supportHisavanaFlag;
    }

    @Override
    public void setMaxPrice(double d) {
        AdLogUtil.Log().d("Athena", "setMaxPrice " + d);
        this.maxPrice = d;
    }

    @Override
    public void setExt(String string) {
    }

    @Override
    public String getExt() {
        return "";
    }

    protected void onAdditionalShowed(long l, String string, int n) {
        BaseAd baseAd = additionalInfo;
        baseAd.saveShowedValue(l);
        WrapTAdAllianceListener wrapTAdAllianceListener = baseAd.mListenerList.isEmpty() ? null : ((BaseAd)((Object)additionalInfo)).mListenerList.get(0);
        if (wrapTAdAllianceListener == null) {
            return;
        }
        BaseAd baseAd2 = additionalInfo;
        AdditionalInfo additionalInfo = baseAd2.getBaseAdditionalInfo();
        additionalInfo.setAdmobECPM((double)l / 1000000.0);
        additionalInfo.setCurrencyCode(string);
        additionalInfo.setPrecisionType(n);
        Network network = baseAd2.mNetwork;
        if (network != null) {
            additionalInfo.setCodeSeatId(network.getCodeSeatId());
        }
        wrapTAdAllianceListener.onShowed(additionalInfo);
    }

    protected AdditionalInfo getClickAdditionalInfo() {
        BaseAd baseAd = this;
        AdditionalInfo additionalInfo = baseAd.getBaseAdditionalInfo();
        Object object = baseAd.mNetwork;
        if (object != null) {
            additionalInfo.setSource(((Network)object).getSource());
            additionalInfo.setApplicationId(this.mNetwork.getApplicationId());
            additionalInfo.setApplicationKey(this.mNetwork.getApplicationKey());
            additionalInfo.setCodeSeatId(this.mNetwork.getCodeSeatId());
            additionalInfo.setECPM(this.mBundle.getDouble("bidding_price"));
            object = this.isWaterFallExecutor() ? "estimated" : "exact";
            AdditionalInfo additionalInfo2 = additionalInfo;
            additionalInfo2.setPrecision((String)object);
            additionalInfo2.setCurrency("USD");
            additionalInfo.setBidding(AdUtil.isBiddingNetwork(this.mNetwork.getSource()));
            additionalInfo.setMediatorSource(this.mNetwork.getMediatorSource());
        }
        return additionalInfo;
    }

    protected void setAdmobMediatorInfo(String string) {
        if (this.mNetwork == null) {
            return;
        }
        AdLogUtil.Log().w("ad_flow", ">>>>> sourceName: " + string + " | " + this.mNetwork.getCodeSeatId());
        this.mNetwork.setMediatorSource(string);
    }
}

