/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.bean;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.hisavana.common.base.BaseNative;
import com.hisavana.common.bean.AdNativeInfo;
import com.hisavana.common.interfacz.AdShowListener;
import java.util.List;

public abstract class NativeAdWrapper<T> {
    private final T nativeAd;
    private BaseNative adImpl;

    public NativeAdWrapper(T t, BaseNative baseNative) {
        this.nativeAd = t;
        this.adImpl = baseNative;
    }

    @SuppressLint(value={"RestrictedApi"})
    public abstract void destroy();

    public boolean isExpired() {
        BaseNative baseNative = ((NativeAdWrapper)((Object)baseNative)).adImpl;
        return baseNative != null ? baseNative.isExpired() : true;
    }

    public void registerViewForInteraction(ViewGroup viewGroup, List<View> list, @NonNull AdNativeInfo adNativeInfo) {
        BaseNative baseNative = ((NativeAdWrapper)((Object)baseNative)).adImpl;
        if (baseNative != null) {
            baseNative.registerViewForInteraction(viewGroup, list, adNativeInfo);
        }
    }

    public void unregisterView(@NonNull AdNativeInfo adNativeInfo) {
        BaseNative baseNative = ((NativeAdWrapper)((Object)baseNative)).adImpl;
        if (baseNative != null) {
            baseNative.unregisterView(adNativeInfo);
        }
    }

    public T getNativeAd() {
        return this.nativeAd;
    }

    public BaseNative getAdImpl() {
        return this.adImpl;
    }

    public boolean isMaterielValid() {
        return this.isImageValid() || this.isIconValid();
    }

    public boolean isMatchVulgarBrand() {
        return false;
    }

    public abstract boolean isIconValid();

    public abstract boolean isImageValid();

    public abstract Bundle getTrackBundle();

    public void detachContext() {
        BaseNative baseNative = ((NativeAdWrapper)((Object)baseNative)).adImpl;
        if (baseNative != null) {
            baseNative.detachContext();
        }
    }

    public void handleClick() {
    }

    public void registerViewForInteraction(View view, AdShowListener adShowListener) {
    }
}

