/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.base;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.hisavana.common.bean.Network;
import com.hisavana.common.interfacz.QueryPriceListener;
import com.hisavana.common.tracking.TrackingManager;

public abstract class BaseQueryPrice {
    private long mInquiryStartTime;
    protected final Handler mMainHandler = new Handler(Looper.getMainLooper());
    protected QueryPriceListener mQueryPriceListener = null;
    public final Bundle mBundle = new Bundle();
    private Network mNetwork = null;
    private int orientation = 1;

    private void fillParamsToBundle(Bundle bundle) {
        Bundle bundle2;
        if (bundle != null && (bundle2 = this.mBundle) != null) {
            bundle.putString("trigger_id", bundle2.getString("trigger_id"));
            bundle.putInt("platform", this.mBundle.getInt("platform"));
            bundle.putString("app_id", this.mBundle.getString("app_id"));
            bundle.putString("code_seat_id", this.mBundle.getString("code_seat_id"));
            bundle.putString("cld_code_seat_id", this.mBundle.getString("cld_code_seat_id"));
            bundle.putString("cld_app_id", this.mBundle.getString("cld_app_id"));
            bundle.putInt("ad_type", this.mBundle.getInt("ad_type"));
            bundle.putInt("is_pre_trigger", this.mBundle.getInt("is_pre_trigger"));
            bundle.putString("traffic_group_id", this.mBundle.getString("traffic_group_id"));
            bundle.putString("experiment_group_id", this.mBundle.getString("experiment_group_id"));
        }
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Network getNetwork() {
        return this.mNetwork;
    }

    public void setNetwork(Network network) {
        this.mNetwork = network;
    }

    public void setTrackingBundle(Bundle bundle) {
        this.mBundle.putAll(bundle);
    }

    public void setQueryPriceListener(QueryPriceListener queryPriceListener) {
        this.mQueryPriceListener = queryPriceListener;
    }

    public abstract void setBannerSize(int var1);

    public abstract void queryPrice(Context var1, Network var2);

    public void destroy() {
        this.mQueryPriceListener = null;
    }

    public void trackingBiddingStart() {
        long l;
        Bundle bundle;
        Bundle bundle2 = bundle;
        bundle2();
        this.mInquiryStartTime = l = System.currentTimeMillis();
        bundle2.putLong("inquiry_request_ts", l);
        this.fillParamsToBundle(bundle2);
        TrackingManager.trackingAdBidding(bundle);
    }

    public void trackingBiddingSuccess(double d) {
        Bundle bundle;
        Bundle bundle2;
        Bundle bundle3 = bundle2 = bundle;
        bundle3();
        long l = System.currentTimeMillis();
        Bundle bundle4 = bundle2;
        bundle4.putLong("inquiry_return_ts", l);
        bundle4.putInt("error_code", 0);
        bundle4.putDouble("bidding_price", d);
        long l2 = l - this.mInquiryStartTime;
        bundle3.putLong("inquiry_return_time", l2);
        this.fillParamsToBundle(bundle3);
        TrackingManager.trackingAdBiddingReturn(bundle);
    }

    public void trackingBiddingFailed(int n, String string) {
        Bundle bundle;
        Bundle bundle2;
        Bundle bundle3 = bundle2 = bundle;
        bundle3();
        long l = System.currentTimeMillis();
        bundle2.putLong("inquiry_return_ts", l);
        long l2 = l - this.mInquiryStartTime;
        bundle3.putLong("inquiry_return_time", l2);
        bundle3.putInt("error_code", n);
        bundle3.putDouble("bidding_price", 0.0);
        bundle3.putString("error_message", string);
        this.fillParamsToBundle(bundle3);
        TrackingManager.trackingAdBiddingReturn(bundle);
    }
}

