/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.utils;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.data.bean.response.ConfigTotalDTO;
import com.cloud.hisavana.sdk.internal.helper.InternalConfigHelper;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.cloud.sdk.commonutil.util.HSCoreUtil;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.utils.AdLogUtil;
import java.math.BigDecimal;
import java.util.List;

public class AdUtil {
    public static void release(TAdNativeInfo tAdNativeInfo) {
        if (tAdNativeInfo != null) {
            tAdNativeInfo.release();
        }
    }

    public static boolean isDebuggable() {
        try {
            return (HSCoreUtil.getContext().getApplicationInfo().flags & 2) != 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean checkAppInstalled(Context context, String string) {
        block8: {
            block9: {
                if (TextUtils.isEmpty((CharSequence)string)) {
                    return false;
                }
                try {
                    if (TextUtils.isEmpty((CharSequence)string)) break block8;
                }
                catch (Exception exception) {}
                String string2 = string;
                context = context.getPackageManager();
                if (!TextUtils.isEmpty((CharSequence)string2)) break block9;
                string = "";
            }
            if (context.getPackageInfo(string, 0) != null) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int filterAdByPullOrNew(List<TAdNativeInfo> iterator) {
        int n = 0;
        if (iterator == null) return n;
        if (iterator.isEmpty()) {
            return n;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            TAdNativeInfo tAdNativeInfo = (TAdNativeInfo)iterator.next();
            if (!tAdNativeInfo.isIconAd()) continue;
            int n2 = tAdNativeInfo.getPullNewestLive();
            String string = tAdNativeInfo.getPackageName();
            AdLogUtil.Log().d("AdUtil", "current ad  ----->  packageName: " + string + ";    PullNewestLive:" + tAdNativeInfo.getPullNewestLive());
            if (n2 != 3 && n2 != 2) continue;
            if (!TextUtils.isEmpty((CharSequence)string)) {
                boolean bl = AdUtil.checkAppInstalled(HSCoreUtil.getContext(), string);
                if ((n2 != 3 || bl) && (n2 != 2 || !bl)) continue;
            }
            iterator.remove();
            ++n;
        }
        return n;
    }

    public static boolean isWaterFall(Network network) {
        return 2 == AdUtil.getNetworkType(network);
    }

    public static boolean isBiddingNetwork(Network network) {
        return 1 == AdUtil.getNetworkType(network);
    }

    private static boolean isBiddingNetwork(int n) {
        return n == 6 || n == 0 || n == 14 || n == 16 || n == 5 || n == 8 || n == 17;
    }

    public static boolean isQueryPriceNetwork(Network network) {
        return 3 == AdUtil.getNetworkType(network);
    }

    private static boolean isQueryPriceNetwork(int n) {
        return n == 9 || n == 2;
    }

    public static int getNetworkType(Network network) {
        if (network != null && network.getAdt() != -1) {
            int n = network.getBiddingType();
            if (n != 1) {
                if (n != 2) {
                    if (AdUtil.isQueryPriceNetwork(network.getSource())) {
                        return 3;
                    }
                    return AdUtil.isBiddingNetwork(network.getSource()) ? 1 : 2;
                }
                return 2;
            }
            if (AdUtil.isQueryPriceNetwork(network.getSource())) {
                return 3;
            }
            return 1;
        }
        return 0;
    }

    public static boolean isAdmobNetwork(int n) {
        return n == 1;
    }

    public static boolean isZero(@NonNull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(new BigDecimal("0")) == 0;
    }

    public static void overwriteAdmobNetworkPrice(@NonNull Network network) {
        AdUtil.overwriteAdmobNetworkPrice(network, "");
    }

    public static void overwriteAdmobNetworkPrice(@NonNull Network network, String object) {
        if (!AdUtil.isAdmobNetwork(network.getSource())) {
            return;
        }
        object = network.getShowPriceCoefficient();
        AdLogUtil.Log().w("ad_flow", ">>>>> priceCoefficient: " + ((BigDecimal)object).doubleValue() + " | codeSeatId: " + network.getCodeSeatId());
        if (AdUtil.isZero((BigDecimal)object)) {
            return;
        }
        long l = AdxPreferencesHelper.getInstance().getLong(network.getCodeSeatId(), 0L);
        if (l > 0L) {
            double d;
            double d2 = network.getTempPrice();
            BigDecimal bigDecimal = BigDecimal.valueOf((double)l / 1000.0);
            double d3 = bigDecimal.multiply((BigDecimal)object).multiply(BigDecimal.valueOf(100L)).stripTrailingZeros().doubleValue();
            if (d > d2) {
                network.setPrice(d3);
            }
            AdLogUtil.Log().w("ad_flow", ">>>>> valueMicros: " + l + " | valueDollar :" + bigDecimal + " | price :" + d3 + " | formerPrice: " + d2 + " | nowPrice: " + network.getPrice());
        }
    }

    public static boolean requestStatusOff() {
        ConfigTotalDTO.ExtInfo extInfo = InternalConfigHelper.getExtInfo();
        if (extInfo == null) {
            return true;
        }
        return extInfo.getRequestStatusOff();
    }
}

