/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.common.base;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import com.cloud.hisavana.sdk.manager.NetStateManager;
import com.cloud.sdk.commonutil.athena.PostConstant;
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper;
import com.cloud.sdk.commonutil.util.DeviceUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.common.base.LogSwitch;
import com.hisavana.common.bean.AdCache;
import com.hisavana.common.bean.AdNativeInfo;
import com.hisavana.common.bean.AdditionalInfo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.bean.TInnerAdRequestBody;
import com.hisavana.common.interfacz.ICacheAd;
import com.hisavana.common.interfacz.Iad;
import com.hisavana.common.interfacz.TAdditionalListener;
import com.hisavana.common.interfacz.TInnerAdListener;
import com.hisavana.common.interfacz.WrapTAdAllianceListener;
import com.hisavana.common.manager.AdCacheManager;
import com.hisavana.common.manager.RequestingAdManager;
import com.hisavana.common.mock.RecordTestInfo;
import com.hisavana.common.tracking.TrackingManager;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.common.utils.AdUtil;
import com.hisavana.common.utils.MediaLogUtil;
import com.hisavana.common.utils.RunTimer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class BaseAd
implements Iad {
    private boolean isTimeOut;
    protected String mAdUnit;
    protected boolean isOfflineAd;
    private int supportHisavanaFlag;
    private double maxPrice;
    private String sceneId;
    private String sceneToken;
    protected String mGameName;
    protected String mGameScene;
    protected Map<String, Object> mExtInfo;
    protected boolean mCurrActivityFullscreen;
    protected int mAdCount;
    protected WeakReference<Context> mContext;
    private final String TAG;
    private double price;
    public double secondPrice;
    private int ttl;
    private int adSource;
    protected long startTime;
    protected boolean isLoaded;
    protected RunTimer runTimer;
    protected final List<WrapTAdAllianceListener> mListenerList;
    private long mLoadedTime;
    private long mImpressionTime;
    protected final Network mNetwork;
    private int mLoadStatus;
    protected int requestType;
    private int mRequestRound;
    public final Bundle mBundle;
    protected String mRequestId;
    protected String mTriggerId;
    protected String mShowId;
    private boolean isDestroyed;
    protected boolean isContainVulgarContent;
    private TAdditionalListener additionalListener;
    private boolean isPreload;
    private String mediatorSourceName;
    private String mediatorSourceUnitId;
    protected RunTimer.TimeOutCallback timeOutCallback;
    private long requestTime;

    public BaseAd(Context context, Network network) {
        WeakReference<Context> weakReference;
        RunTimer.TimeOutCallback timeOutCallback;
        Bundle bundle;
        Bundle bundle2;
        BaseAd baseAd = weakReference2;
        ((BaseAd)((Object)weakReference2)).isTimeOut = false;
        ((BaseAd)((Object)weakReference2)).supportHisavanaFlag = 0;
        ((BaseAd)((Object)weakReference2)).mAdCount = 1;
        ((BaseAd)((Object)weakReference2)).TAG = "BaseAd";
        ((BaseAd)((Object)weakReference2)).price = 0.0;
        ((BaseAd)((Object)weakReference2)).isLoaded = false;
        Object object = bundle2;
        bundle2 = new CopyOnWriteArrayList();
        ((BaseAd)((Object)weakReference2)).mListenerList = object;
        ((BaseAd)((Object)weakReference2)).mRequestRound = -1;
        object = bundle;
        bundle = new Bundle();
        ((BaseAd)((Object)weakReference2)).mBundle = object;
        ((BaseAd)((Object)weakReference2)).mRequestId = null;
        ((BaseAd)((Object)weakReference2)).mTriggerId = null;
        ((BaseAd)((Object)weakReference2)).mShowId = null;
        ((BaseAd)((Object)weakReference2)).isDestroyed = false;
        object = timeOutCallback;
        timeOutCallback = new RunTimer.TimeOutCallback(){

            @Override
            public void isTimeOut() {
                AdLogUtil.Log().d("BaseAd", "Load ad is time out" + BaseAd.this.getLogString());
                BaseAd.this.onTimeOut();
            }
        };
        ((BaseAd)((Object)weakReference2)).timeOutCallback = object;
        WeakReference<Context> weakReference2 = weakReference;
        weakReference = new WeakReference<Context>(context);
        v5.mContext = weakReference2;
        Preconditions.checkNotNull((Object)network);
        baseAd.mNetwork = network;
    }

    private void adLoadedTemp() {
        long l;
        Bundle bundle;
        ArrayList<WrapTAdAllianceListener> arrayList;
        Object object = AdLogUtil.Log();
        Object object2 = "BaseAd";
        StringBuilder stringBuilder = new StringBuilder().append("Ad request has been destroyed or loaded,isLoaded = ").append(this.isLoaded).append(",isDestroyed = ").append(this.isDestroyed).append("( triggerId is ").append(this.mTriggerId).append(", code seat id is ");
        Object object3 = this.mNetwork;
        object3 = object3 == null ? "" : ((Network)object3).getCodeSeatId();
        object.d((String)object2, stringBuilder.append((String)object3).append(" )").toString());
        RequestingAdManager.getInstance().removeRequest(this);
        if (this.isLoaded) {
            return;
        }
        if (this.mNetwork != null) {
            MediaLogUtil.d("BaseAd", "loadSuccess adSource " + this.mNetwork.getSource() + " id " + this.mNetwork.getCodeSeatId() + " " + this.getLogString());
        }
        object = arrayList;
        new ArrayList<WrapTAdAllianceListener>(this.mListenerList.size()).addAll(this.mListenerList);
        object2 = AdCacheManager.getCache(this.getAdType());
        if (object2 != null) {
            ((AdCache)object2).addCache(this.mAdUnit, this);
        }
        object2 = bundle;
        new Bundle().putInt("error_code", 0);
        object2.putInt("request_num", this.mAdCount);
        object2.putInt("is_internal_ad", this.isInternalAd() ? 1 : 0);
        this.adReturnTracking((Bundle)object2);
        this.isLoaded = true;
        this.mLoadedTime = l = System.currentTimeMillis();
        this.loadedCallBack((List<WrapTAdAllianceListener>)object);
        if (this.supportTimer()) {
            this.stopTimer();
        }
    }

    private void adLoadedTemp(List<TAdNativeInfo> list) {
        long l;
        Bundle bundle;
        ArrayList<WrapTAdAllianceListener> arrayList;
        Object object = AdLogUtil.Log();
        Object object2 = "BaseAd";
        Object object3 = new StringBuilder().append("Ad request has been destroyed or loaded,isLoaded = ").append(this.isLoaded).append(",isDestroyed = ").append(this.isDestroyed).append("( triggerId is ").append(this.mTriggerId).append(", code seat id is ");
        Object object4 = this.mNetwork;
        object4 = object4 == null ? "" : ((Network)object4).getCodeSeatId();
        object.d((String)object2, ((StringBuilder)object3).append((String)object4).append(" )").toString());
        RequestingAdManager.getInstance().removeRequest(this);
        if (this.isLoaded) {
            return;
        }
        if (this.mNetwork != null) {
            MediaLogUtil.d("BaseAd", "loadSuccess adSource " + this.mNetwork.getSource() + " id " + this.mNetwork.getCodeSeatId() + " " + this.getLogString());
        }
        object = arrayList;
        new ArrayList<WrapTAdAllianceListener>(this.mListenerList.size()).addAll(this.mListenerList);
        object2 = AdCacheManager.getCache(this.getAdType());
        if (list != null && list.size() > 0 && object2 != null) {
            ((AdCache)object2).addCaches(this.mAdUnit, list);
        }
        object2 = bundle;
        new Bundle().putInt("error_code", 0);
        if (list != null && list.size() > 0) {
            TAdNativeInfo tAdNativeInfo;
            object3 = list.get(0);
            if (tAdNativeInfo.getEcpmPrice() > 0.0) {
                double d;
                this.price = d = object3.getEcpmPrice();
            }
            Object object5 = object3;
            object3 = "is_internal_ad";
            object2.putInt((String)object3, object5.isInternalAd() ? 1 : 0);
        }
        this.adReturnTracking((Bundle)object2);
        this.isLoaded = true;
        this.mLoadedTime = l = System.currentTimeMillis();
        this.loadedCallBack((List<WrapTAdAllianceListener>)object, list);
        if (this.supportTimer()) {
            this.stopTimer();
        }
    }

    private void adFailedToLoadTemp(TAdErrorCode tAdErrorCode) {
        Bundle bundle;
        RequestingAdManager.getInstance().removeRequest(this);
        AdLogUtil adLogUtil = AdLogUtil.Log();
        String string = "BaseAd";
        CharSequence charSequence = new StringBuilder().append("Ad request has been destroyed or loaded,isLoaded = ").append(this.isLoaded).append(",isDestroyed = ").append(this.isDestroyed).append("( triggerId is ").append(this.mTriggerId).append(", code seat id is ");
        Object object = this.mNetwork;
        object = object == null ? "" : ((Network)object).getCodeSeatId();
        adLogUtil.d(string, charSequence.append((String)object).append(" )").toString());
        if (this.isLoaded) {
            return;
        }
        this.isLoaded = true;
        adLogUtil = bundle;
        bundle = new Bundle();
        int n = tAdErrorCode != null ? tAdErrorCode.getErrorCode() : 30003;
        if (n == 0) {
            n = 30003;
        }
        adLogUtil.putInt("error_code", n);
        String string2 = "error_message";
        charSequence = tAdErrorCode == null ? "null" : TAdErrorCode.simpleErrorMessage(tAdErrorCode.getErrorMessage());
        BaseAd baseAd = this;
        AdLogUtil adLogUtil2 = adLogUtil;
        adLogUtil.putString(string2, (String)charSequence);
        adLogUtil2.putInt("request_num", this.mAdCount);
        this.adReturnTracking((Bundle)adLogUtil2);
        baseAd.errorCallBack(tAdErrorCode);
        if (baseAd.supportTimer()) {
            this.stopTimer();
        }
        this.destroyAd();
    }

    private void loadedCallBack(List<WrapTAdAllianceListener> object) {
        if (object != null && !object.isEmpty()) {
            Iterator<WrapTAdAllianceListener> iterator = object.iterator();
            while (iterator.hasNext()) {
                object = (WrapTAdAllianceListener)iterator.next();
                if (object == null) continue;
                ((TInnerAdListener)object).onLoad();
            }
            return;
        }
    }

    private void loadedCallBack(List<WrapTAdAllianceListener> object, List<TAdNativeInfo> list) {
        if (object != null && !object.isEmpty()) {
            Iterator<WrapTAdAllianceListener> iterator = object.iterator();
            while (iterator.hasNext()) {
                object = (WrapTAdAllianceListener)iterator.next();
                if (object == null) continue;
                ((WrapTAdAllianceListener)object).onLoad(list);
            }
            return;
        }
    }

    private void errorCallBack(TAdErrorCode tAdErrorCode) {
        for (WrapTAdAllianceListener wrapTAdAllianceListener : ((BaseAd)this).mListenerList) {
            if (wrapTAdAllianceListener == null) continue;
            wrapTAdAllianceListener.onError(tAdErrorCode);
        }
    }

    private void appendContextParam(Bundle bundle) {
        Bundle bundle2 = bundle;
        bundle.putString("trigger_id", this.mBundle.getString("trigger_id"));
        long l = this.mBundle.getLong("trigger_ts");
        bundle.putLong("trigger_ts", l);
        bundle.putInt("ad_type", this.mBundle.getInt("ad_type"));
        bundle.putString("cld_app_id", this.mBundle.getString("cld_app_id"));
        bundle.putString("cld_code_seat_id", this.mBundle.getString("cld_code_seat_id"));
        bundle.putInt("platform", this.mBundle.getInt("platform"));
        bundle.putString("app_id", this.mBundle.getString("app_id"));
        bundle.putString("code_seat_id", this.mBundle.getString("code_seat_id"));
        double d = this.mBundle.getDouble("bidding_price");
        bundle.putDouble("bidding_price", d);
        bundle.putInt("priority", this.mBundle.getInt("priority"));
        bundle.putInt("ad_count", this.mBundle.getInt("ad_count"));
        bundle2.putInt("is_retreatad", this.mBundle.getInt("is_retreatad"));
        bundle2.putInt("is_default_ad", 0);
        long l2 = this.mBundle.getLong("request_ts");
        bundle.putLong("request_ts", l2);
        bundle.putInt("request_time", this.mBundle.getInt("request_time"));
        bundle.putString("request_id", this.mBundle.getString("request_id"));
        l2 = this.mBundle.getLong("return_ts");
        bundle.putLong("return_ts", l2);
        bundle.putInt("return_time", this.mBundle.getInt("return_time"));
        bundle.putInt("request_type", this.mBundle.getInt("request_type"));
        bundle.putInt("biddingType", this.mBundle.getInt("biddingType"));
    }

    private void addToContextParam(String string, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Integer) {
            this.mBundle.putInt(string, ((Integer)object).intValue());
        } else if (object instanceof String) {
            this.mBundle.putString(string, (String)object);
        } else if (object instanceof Long) {
            this.mBundle.putLong(string, ((Long)object).longValue());
        }
    }

    private boolean isWaterFallExecutor() {
        return AdUtil.isWaterFall(this.mNetwork);
    }

    private AdditionalInfo getBaseAdditionalInfo() {
        AdditionalInfo additionalInfo;
        AdditionalInfo additionalInfo2;
        AdditionalInfo additionalInfo3 = additionalInfo2 = additionalInfo;
        additionalInfo2();
        additionalInfo3.setPlacementId(this.mAdUnit);
        additionalInfo3.setMcc(PostConstant.getMcc());
        additionalInfo2.setTriggerId(this.mBundle.getString("trigger_id"));
        additionalInfo2.setTrafficGroupId(this.mBundle.getString("traffic_group_id"));
        additionalInfo.setExperimentGroupId(this.mBundle.getString("experiment_group_id"));
        additionalInfo.setSdkVersion(PostConstant.getSdkVersion());
        return additionalInfo;
    }

    private AdditionalInfo getShowAdditionalInfo(AdNativeInfo adNativeInfo) {
        BaseAd baseAd = bl;
        AdditionalInfo additionalInfo = baseAd.getBaseAdditionalInfo();
        Object object = baseAd.mNetwork;
        if (object != null) {
            additionalInfo.setSource(((Network)object).getSource());
            additionalInfo.setApplicationId(((BaseAd)((Object)bl)).mNetwork.getApplicationId());
            additionalInfo.setApplicationKey(((BaseAd)((Object)bl)).mNetwork.getApplicationKey());
            additionalInfo.setCodeSeatId(((BaseAd)((Object)bl)).mNetwork.getCodeSeatId());
            additionalInfo.setECPM(((BaseAd)((Object)bl)).mBundle.getDouble("bidding_price"));
            object = ((BaseAd)((Object)bl)).isWaterFallExecutor() ? "estimated" : "exact";
            AdditionalInfo additionalInfo2 = additionalInfo;
            additionalInfo2.setPrecision((String)object);
            additionalInfo2.setCurrency("USD");
            additionalInfo.setBidding(AdUtil.isBiddingNetwork(((BaseAd)((Object)bl)).mNetwork));
            additionalInfo.setMediatorSource(((BaseAd)((Object)bl)).mediatorSourceName);
        }
        Boolean bl = adNativeInfo == null ? ((BaseAd)((Object)bl)).isInternalAd() : adNativeInfo.isInternalAd();
        AdditionalInfo additionalInfo3 = additionalInfo;
        additionalInfo3.setInternalAd(bl);
        return additionalInfo3;
    }

    private void saveShowedValue(long l) {
        if (this.mNetwork != null && l > 0L) {
            AdxPreferencesHelper.getInstance().putLong(this.mNetwork.getCodeSeatId(), l);
            AdLogUtil.Log().w("ad_flow", ">>>>> codeSeatId: " + this.mNetwork.getCodeSeatId() + " | adType : " + this.mNetwork.getAdt() + " | valueMicros: " + l);
        }
    }

    private double getBiddingPrice() {
        Network network = this.mNetwork;
        if (network == null) {
            return 0.0;
        }
        int n = AdUtil.getNetworkType(network);
        return n != 1 ? (n != 3 ? this.mNetwork.getTempPrice() : this.mNetwork.getPrice().doubleValue()) : this.price;
    }

    @Override
    public void setTimeOut(boolean bl) {
        this.isTimeOut = bl;
    }

    @Override
    public boolean isInternalAd() {
        return false;
    }

    @Override
    public void setSecondPrice(double d) {
        AdLogUtil.Log().d("ssp_second_price", "*----> BaseAd setSecondPrice price" + d + this.getLogString());
        this.secondPrice = d;
    }

    public String getLogString() {
        return "----- class name = " + this.getClass().getSimpleName() + " ----- mAdUnit = " + this.mAdUnit;
    }

    @Override
    public void setRequestRound(int n) {
        AdLogUtil.Log().d("BaseAd", "setRequestRound " + n + " " + this.getLogString());
        this.mRequestRound = n;
    }

    @Override
    public String getMediatorSourceName() {
        return this.mediatorSourceName;
    }

    @Override
    public String getMediatorSourceUnitId() {
        return this.mediatorSourceUnitId;
    }

    public void setContainVulgarContent(boolean bl) {
        this.isContainVulgarContent = bl;
    }

    public void setAdLoadScenes(String string, String string2, Map<String, Object> map) {
        BaseAd baseAd = this;
        baseAd.mGameName = string;
        baseAd.mGameScene = string2;
        baseAd.mExtInfo = map;
    }

    public void setCurrActivityFullscreen(boolean bl) {
        this.mCurrActivityFullscreen = bl;
    }

    @Override
    public void setRequestType(int n) {
        this.requestType = n;
    }

    @Override
    public boolean isAdxAd() {
        return false;
    }

    @Override
    public boolean isEwAd() {
        return false;
    }

    @Override
    public void loadAd() {
        this.mRequestId = DeviceUtil.getUUID();
        this.startTime = System.currentTimeMillis();
        if (this.supportTimer()) {
            this.startTimer();
        }
        BaseAd baseAd = this;
        baseAd.adTrackingRequest();
        if (baseAd.mNetwork != null) {
            MediaLogUtil.d("BaseAd", "loadAd adSource " + this.mNetwork.getSource() + " id " + this.mNetwork.getCodeSeatId() + " " + this.getLogString());
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAdUnit)) {
            RequestingAdManager.getInstance().addRequest(this);
        }
    }

    public void setShowId(String string) {
        this.mShowId = string;
    }

    public void adLoaded() {
        this.adLoadedTemp();
    }

    public void adLoaded(List<TAdNativeInfo> list) {
        this.adLoadedTemp(list);
    }

    protected void adFailedToLoad(TAdErrorCode tAdErrorCode) {
        this.adFailedToLoadTemp(tAdErrorCode);
    }

    protected void onAdShowError(TAdErrorCode tAdErrorCode) {
        this.onAdShowError(null, tAdErrorCode);
    }

    protected void onAdShowError(TAdNativeInfo tAdNativeInfo, TAdErrorCode tAdErrorCode) {
        BaseAd baseAd = object;
        baseAd.logImpression(tAdNativeInfo, false, tAdErrorCode);
        Object object = baseAd.mListenerList.isEmpty() ? null : ((BaseAd)object).mListenerList.get(0);
        if (object != null) {
            ((WrapTAdAllianceListener)object).onShowError(tAdErrorCode);
        }
    }

    public void adImpression(AdNativeInfo adNativeInfo) {
        Object object;
        if (LogSwitch.isDebug) {
            StringBuilder stringBuilder;
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            ICacheAd iCacheAd = adNativeInfo == null ? this : adNativeInfo;
            RecordTestInfo.LogMsg(((StringBuilder)object).append(RecordTestInfo.getLogMsg(iCacheAd)).append("  isSupportFlag = ").append(this.supportHisavanaFlag).toString(), RecordTestInfo.LOG_CODE12);
        }
        BaseAd baseAd = this;
        baseAd.logImpression(adNativeInfo, true, TAdErrorCode.SUCCESS_MESSAGE);
        baseAd.mImpressionTime = System.currentTimeMillis();
        object = baseAd.mListenerList.isEmpty() ? null : this.mListenerList.get(0);
        if (object != null) {
            StringBuilder stringBuilder = object;
            BaseAd baseAd2 = this;
            int n = baseAd2.getAdSource();
            object = baseAd2.getShowAdditionalInfo(adNativeInfo);
            ((WrapTAdAllianceListener)((Object)stringBuilder)).onNativeFeedShow(n, adNativeInfo, (AdditionalInfo)object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isIconAd() {
        Network network = ((BaseAd)((Object)network)).mNetwork;
        if (network == null) {
            return false;
        }
        if (network.getAdt() != 6) return false;
        return true;
    }

    @Override
    public boolean isSupportRtBidding() {
        return false;
    }

    public boolean isSupportStopRequest() {
        return false;
    }

    @Override
    public Network getNetwork() {
        return this.mNetwork;
    }

    public void adClicked(AdNativeInfo adNativeInfo) {
        BaseAd baseAd = this;
        baseAd.logClick(adNativeInfo);
        Object object = baseAd.mListenerList.isEmpty() ? null : this.mListenerList.get(0);
        if (object != null) {
            WrapTAdAllianceListener wrapTAdAllianceListener = object;
            BaseAd baseAd2 = this;
            int n = baseAd2.getAdSource();
            object = baseAd2.getClickAdditionalInfo(adNativeInfo);
            wrapTAdAllianceListener.onNativeFeedClicked(n, adNativeInfo, (AdditionalInfo)object);
        }
    }

    @Override
    public void setLoadStatus(int n) {
        this.mLoadStatus = n;
    }

    @Override
    public int getLoadStatus() {
        return this.mLoadStatus;
    }

    @Override
    public boolean isMatchVulgarBrand() {
        return false;
    }

    protected void adClosed() {
        BaseAd baseAd = this;
        baseAd.logClose(null);
        WrapTAdAllianceListener wrapTAdAllianceListener = baseAd.mListenerList.isEmpty() ? null : this.mListenerList.get(0);
        if (wrapTAdAllianceListener != null) {
            wrapTAdAllianceListener.onClosed(this.getAdSource());
        }
    }

    protected void adClosed(TAdNativeInfo tAdNativeInfo) {
        BaseAd baseAd = object;
        baseAd.logClose(tAdNativeInfo);
        Object object = baseAd.mListenerList.isEmpty() ? null : ((BaseAd)object).mListenerList.get(0);
        if (object != null) {
            ((WrapTAdAllianceListener)object).onClosed(tAdNativeInfo);
        }
    }

    protected void onReward() {
        Object object = ((BaseAd)object).mListenerList.isEmpty() ? null : ((BaseAd)object).mListenerList.get(0);
        if (object != null) {
            ((WrapTAdAllianceListener)object).onRewarded();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void logImpression(TAdNativeInfo object, boolean bl, TAdErrorCode object2) {
        void var3_30;
        void var3_27;
        void var4_68;
        void var4_65;
        void var3_18;
        void var3_15;
        void var2_13;
        Bundle bundle;
        Bundle bundle2 = bundle;
        bundle = new Bundle();
        this.appendContextParam(bundle2);
        long l = System.currentTimeMillis();
        bundle2.putLong("show_ts", l);
        l = System.currentTimeMillis() - this.mLoadedTime;
        bundle2.putLong("show_time", l);
        String string = this.mBundle.getString("ad_title");
        bundle2.putString("ad_title", string);
        String string2 = this.mBundle.getString("ad_url");
        bundle2.putString("ad_url", string2);
        int n = this.mBundle.getInt("filling_source");
        bundle2.putInt("filling_source", n);
        String string3 = this.mBundle.getString("description");
        bundle2.putString("description", string3);
        String string4 = this.mBundle.getString("image_url");
        bundle2.putString("image_url", string4);
        String string5 = this.mBundle.getString("icon_url");
        bundle2.putString("icon_url", string5);
        String string6 = this.mBundle.getString("endcard_url");
        bundle2.putString("endcard_url", string6);
        String string7 = this.mBundle.getString("app_name");
        bundle2.putString("app_name", string7);
        String string8 = this.mBundle.getString("package_name");
        bundle2.putString("package_name", string8);
        String string9 = this.mBundle.getString("download_url");
        bundle2.putString("download_url", string9);
        int n2 = this.mBundle.getInt("ad_trigger_status");
        bundle2.putInt("ad_trigger_status", n2);
        int n3 = this.isOfflineAd();
        bundle2.putInt("is_offline_ad", n3);
        int n4 = this.mBundle.getInt("filling_ad_type");
        bundle2.putInt("filling_ad_type", n4);
        bundle2.putInt("slot_height", 0);
        bundle2.putInt("slot_width", 0);
        String string10 = this.sceneId;
        bundle2.putString("scene_id", string10);
        int n5 = this.isExpired();
        bundle2.putInt("is_expired", n5);
        if (var2_13 != false) {
            bundle2.putInt("show_status", 1);
            bundle2.putInt("fail_reason", 0);
        } else {
            bundle2.putInt("show_status", 2);
            bundle2.putInt("fail_reason", 2);
        }
        int n6 = this.mBundle.getInt("is_pre_trigger");
        bundle2.putInt("is_pre_trigger", n6);
        int n7 = this.mBundle.getInt("filling_source");
        bundle2.putInt("filling_source", n7);
        String string11 = this.mBundle.getString("request_id");
        bundle2.putString("request_id", string11);
        int n8 = this.mBundle.getInt("request_num");
        bundle2.putInt("request_num", n8);
        String string12 = this.mBundle.getString("traffic_group_id");
        bundle2.putString("traffic_group_id", string12);
        String string13 = this.mBundle.getString("experiment_group_id");
        bundle2.putString("experiment_group_id", string13);
        int n9 = this.mBundle.getInt("optimize_status");
        bundle2.putInt("optimize_status", n9);
        int n10 = this.mBundle.getInt("priority_code");
        bundle2.putInt("priority_code", n10);
        if (this.maxPrice == 0.0) {
            double d;
            this.maxPrice = d = this.mBundle.getDouble("max_price");
        }
        double d = this.maxPrice;
        bundle2.putDouble("max_price", d);
        String string14 = "ecpm";
        double d2 = object == null ? this.price : object.getEcpmPrice();
        bundle2.putDouble(string14, d2);
        String string15 = "ecpm_precision";
        String string16 = this.isWaterFallExecutor() ? "estimated" : "exact";
        bundle2.putString(string15, string16);
        String string17 = "show_id";
        string16 = object == null ? this.mShowId : ((TAdNativeInfo)object).getShowId();
        bundle2.putString(string17, string16);
        String string18 = "scene_token";
        string16 = object == null ? this.sceneToken : ((TAdNativeInfo)object).getSceneToken();
        bundle2.putString(string18, string16);
        String string19 = "error_code";
        string16 = var3_15 == null ? null : String.valueOf(var3_15.getErrorCode());
        bundle2.putString(string19, string16);
        String string20 = "error_message";
        if (var3_15 == null) {
            Object var3_16 = null;
        } else {
            String string21 = TAdErrorCode.simpleErrorMessage(var3_15.getErrorMessage());
        }
        bundle2.putString(string20, (String)var3_18);
        int n11 = NetStateManager.checkNetworkState((boolean)false) ^ 1;
        bundle2.putInt("is_offline", n11);
        int n12 = this.mBundle.getInt("is_contain_vulgar");
        bundle2.putInt("is_contain_vulgar", n12);
        String string22 = "mediator_source";
        if (object == null) {
            String string23 = this.mediatorSourceName;
        } else {
            String string24 = object.getMediatorSourceName();
        }
        bundle2.putString(string22, (String)var4_65);
        String string25 = "mediator_code_seat_id";
        if (object == null) {
            String string26 = this.mediatorSourceUnitId;
        } else {
            String string27 = object.getMediatorSourceUnitId();
        }
        bundle2.putString(string25, (String)var4_68);
        String string28 = "price_coefficient";
        Network network = this.mNetwork;
        double d3 = network != null ? network.getShowPriceCoefficient().doubleValue() : 0.0;
        bundle2.putDouble(string28, d3);
        if (object == null) {
            int n72 = this.isInternalAd();
            bundle2.putInt("is_internal_ad", n72);
        } else {
            String object4 = "is_internal_ad";
            int n13 = object.isInternalAd();
            bundle2.putInt(object4, n13);
        }
        String string29 = "game_name";
        String string30 = this.mGameName;
        if (string30 == null) {
            String string31 = "";
        }
        bundle2.putString(string29, (String)var3_27);
        String string32 = "game_scene";
        String string33 = this.mGameScene;
        if (string33 == null) {
            String string34 = "";
        }
        bundle2.putString(string32, (String)var3_30);
        TrackingManager.trackingImpression(bundle2);
        Long l2 = bundle2.getLong("show_ts");
        this.addToContextParam("show_ts", l2);
        Long l3 = bundle2.getLong("show_time");
        this.addToContextParam("show_time", l3);
        Integer n14 = bundle2.getInt("slot_height");
        this.addToContextParam("slot_height", n14);
        Integer n15 = bundle2.getInt("slot_width");
        this.addToContextParam("slot_width", n15);
        Integer n16 = bundle2.getInt("show_status");
        this.addToContextParam("show_status", n16);
        Integer n17 = bundle2.getInt("fail_reason");
        this.addToContextParam("fail_reason", n17);
        double d4 = bundle2.getDouble("max_price");
        this.mBundle.putDouble("max_price", d4);
    }

    @Override
    public String getAdUnit() {
        return this.mAdUnit;
    }

    @Override
    public void setAdUnit(String string) {
        this.mAdUnit = string;
    }

    protected void logTrigerShow(String string, String string2) {
        this.trigerShow(null, string, string2);
    }

    public void logTrigerShow(TAdNativeInfo tAdNativeInfo) {
        this.trigerShow(tAdNativeInfo, "", "");
    }

    /*
     * WARNING - void declaration
     */
    protected void trigerShow(TAdNativeInfo object, String string, String string2) {
        void var3_38;
        void var3_35;
        Bundle bundle;
        Bundle bundle2 = bundle;
        bundle = new Bundle();
        this.appendContextParam(bundle2);
        if (bundle2.containsKey("is_default_ad")) {
            bundle2.remove("is_default_ad");
        }
        int n = this.mBundle.getInt("is_timeout");
        bundle2.putInt("is_timeout", n);
        String string3 = this.mBundle.getString("error_code");
        bundle2.putString("error_code", string3);
        string3 = TAdErrorCode.simpleErrorMessage(this.mBundle.getString("error_message"));
        bundle2.putString("error_message", string3);
        if (object != null) {
            void d;
            Object object2 = object;
            String n3 = ((TAdNativeInfo)object2).getTitle();
            bundle2.putString("ad_title", n3);
            bundle2.putString("ad_url", "");
            String n4 = ((TAdNativeInfo)object2).getDescription();
            bundle2.putString("description", n4);
            if (((TAdNativeInfo)object2).getIcon() != null) {
                String string4 = ((TAdNativeInfo)object).getIcon().getUrl();
                bundle2.putString("icon_url", string4);
            }
            Object object3 = object;
            bundle2.putString("endcard_url", "");
            bundle2.putString("app_name", "");
            bundle2.putString("package_name", "");
            bundle2.putString("download_url", "");
            String string5 = ((TAdNativeInfo)object3).getSceneId();
            bundle2.putString("scene_id", string5);
            if (((TAdNativeInfo)object3).getSceneId() == null) {
                String n6 = "";
            } else {
                String object22 = ((TAdNativeInfo)object).getSceneId();
            }
            Object object4 = object;
            this.sceneId = d;
            String string4 = ((TAdNativeInfo)object4).getSceneToken();
            bundle2.putString("scene_token", string4);
            this.sceneToken = ((TAdNativeInfo)object4).getSceneToken();
            String string6 = "is_internal_ad";
            int n2 = object4.isInternalAd();
            bundle2.putInt(string6, n2);
        } else {
            void var3_32;
            void var3_29;
            bundle2.putString("scene_id", (String)var3_29);
            if (var3_29 == null) {
                String string7 = "";
            }
            this.sceneId = var3_32;
            bundle2.putString("scene_token", string);
            this.sceneToken = string;
            int n3 = this.isInternalAd();
            bundle2.putInt("is_internal_ad", n3);
        }
        int n4 = this.mBundle.getInt("is_pre_trigger");
        bundle2.putInt("is_pre_trigger", n4);
        int n5 = this.mBundle.getInt("filling_source");
        bundle2.putInt("filling_source", n5);
        String string8 = this.mBundle.getString("request_id");
        bundle2.putString("request_id", string8);
        int n6 = this.mBundle.getInt("ad_trigger_status");
        bundle2.putInt("ad_trigger_status", n6);
        int n7 = this.isOfflineAd();
        bundle2.putInt("is_offline_ad", n7);
        int n8 = this.mBundle.getInt("filling_ad_type");
        bundle2.putInt("filling_ad_type", n8);
        String string9 = this.mBundle.getString("traffic_group_id");
        bundle2.putString("traffic_group_id", string9);
        String string10 = this.mBundle.getString("experiment_group_id");
        bundle2.putString("experiment_group_id", string10);
        String string11 = "show_id";
        if (object == null) {
            String string12 = this.mShowId;
        } else {
            String string13 = ((TAdNativeInfo)object).getShowId();
        }
        bundle2.putString(string11, (String)var3_35);
        int n9 = NetStateManager.checkNetworkState((boolean)false) ^ 1;
        bundle2.putInt("is_offline", n9);
        int n10 = this.mBundle.getInt("is_contain_vulgar");
        bundle2.putInt("is_contain_vulgar", n10);
        String string14 = "mediator_source";
        if (object == null) {
            String string15 = this.mediatorSourceName;
        } else {
            String string16 = object.getMediatorSourceName();
        }
        bundle2.putString(string14, (String)var3_38);
        String string17 = "mediator_code_seat_id";
        object = object == null ? this.mediatorSourceUnitId : object.getMediatorSourceUnitId();
        bundle2.putString(string17, (String)object);
        object = "price_coefficient";
        Network network = this.mNetwork;
        double d = network != null ? network.getShowPriceCoefficient().doubleValue() : 0.0;
        bundle2.putDouble((String)object, d);
        TrackingManager.trackingTriggerShow(bundle2);
        object = bundle2.getString("ad_title");
        this.addToContextParam("ad_title", object);
        this.addToContextParam("ad_url", "");
        object = bundle2.getString("description");
        this.addToContextParam("description", object);
        object = bundle2.getString("image_url");
        this.addToContextParam("image_url", object);
        object = bundle2.getString("icon_url");
        this.addToContextParam("icon_url", object);
        this.addToContextParam("endcard_url", "");
        this.addToContextParam("app_name", "");
        this.addToContextParam("package_name", "");
        this.addToContextParam("download_url", "");
        object = this.mAdCount;
        this.addToContextParam("request_num", object);
    }

    /*
     * WARNING - void declaration
     */
    protected void logClick(TAdNativeInfo object) {
        void var3_43;
        Object object3;
        Bundle bundle;
        Bundle bundle2 = bundle;
        bundle = new Bundle();
        ((BaseAd)object3).appendContextParam(bundle2);
        int n2 = ((BaseAd)object3).mBundle.getInt("request_time");
        bundle2.putInt("request_time", n2);
        long l2 = ((BaseAd)object3).mBundle.getLong("return_ts");
        bundle2.putLong("return_ts", l2);
        int n3 = ((BaseAd)object3).mBundle.getInt("return_time");
        bundle2.putInt("return_time", n3);
        long string = ((BaseAd)object3).mBundle.getLong("show_ts");
        bundle2.putLong("show_ts", string);
        string = ((BaseAd)object3).mBundle.getLong("show_time");
        bundle2.putLong("show_time", string);
        string = System.currentTimeMillis();
        bundle2.putLong("click_ts", string);
        int n4 = (int)(System.currentTimeMillis() - ((BaseAd)object3).mImpressionTime);
        bundle2.putInt("click_time", n4);
        String string2 = ((BaseAd)object3).mBundle.getString("ad_title");
        bundle2.putString("ad_title", string2);
        String n5 = ((BaseAd)object3).mBundle.getString("ad_url");
        bundle2.putString("ad_url", n5);
        int string3 = ((BaseAd)object3).mBundle.getInt("filling_source");
        bundle2.putInt("filling_source", string3);
        String n6 = ((BaseAd)object3).mBundle.getString("description");
        bundle2.putString("description", n6);
        String string4 = ((BaseAd)object3).mBundle.getString("image_url");
        bundle2.putString("image_url", string4);
        String n7 = ((BaseAd)object3).mBundle.getString("icon_url");
        bundle2.putString("icon_url", n7);
        String d = ((BaseAd)object3).mBundle.getString("app_name");
        bundle2.putString("endcard_url", d);
        String string5 = ((BaseAd)object3).mBundle.getString("app_name");
        bundle2.putString("app_name", string5);
        String n9 = ((BaseAd)object3).mBundle.getString("package_name");
        bundle2.putString("package_name", n9);
        String string7 = ((BaseAd)object3).mBundle.getString("download_url");
        bundle2.putString("download_url", string7);
        int n = ((BaseAd)object3).mBundle.getInt("slot_height");
        bundle2.putInt("slot_height", n);
        int n8 = ((BaseAd)object3).mBundle.getInt("slot_width");
        bundle2.putInt("slot_width", n8);
        int n10 = ((BaseAd)object3).mBundle.getInt("is_pre_trigger");
        bundle2.putInt("is_pre_trigger", n10);
        int n11 = ((BaseAd)object3).mBundle.getInt("request_type");
        bundle2.putInt("request_type", n11);
        String string6 = ((BaseAd)object3).mBundle.getString("request_id");
        bundle2.putString("request_id", string6);
        bundle2.putInt("click_x", 0);
        bundle2.putInt("click_y", 0);
        int n12 = ((BaseAd)object3).isExpired();
        bundle2.putInt("is_expired", n12);
        int n13 = ((BaseAd)object3).mBundle.getInt("request_num");
        bundle2.putInt("request_num", n13);
        int n14 = ((BaseAd)object3).mBundle.getInt("ad_trigger_status");
        bundle2.putInt("ad_trigger_status", n14);
        int n15 = object3.isOfflineAd();
        bundle2.putInt("is_offline_ad", n15);
        int n16 = ((BaseAd)object3).mBundle.getInt("filling_ad_type");
        bundle2.putInt("filling_ad_type", n16);
        String string8 = ((BaseAd)object3).mBundle.getString("traffic_group_id");
        bundle2.putString("traffic_group_id", string8);
        String string9 = ((BaseAd)object3).mBundle.getString("experiment_group_id");
        bundle2.putString("experiment_group_id", string9);
        int n17 = ((BaseAd)object3).mBundle.getInt("priority_code");
        bundle2.putInt("priority_code", n17);
        double d2 = ((BaseAd)object3).mBundle.getDouble("max_price");
        bundle2.putDouble("max_price", d2);
        String string10 = ((BaseAd)object3).sceneId;
        bundle2.putString("scene_id", string10);
        String string11 = "mediator_source";
        Object object2 = object == null ? ((BaseAd)object3).mediatorSourceName : object.getMediatorSourceName();
        bundle2.putString(string11, (String)object2);
        String string12 = "mediator_code_seat_id";
        object2 = object == null ? ((BaseAd)object3).mediatorSourceUnitId : object.getMediatorSourceUnitId();
        bundle2.putString(string12, (String)object2);
        String string13 = "price_coefficient";
        object2 = ((BaseAd)object3).mNetwork;
        double d3 = object2 != null ? ((Network)object2).getShowPriceCoefficient().doubleValue() : 0.0;
        bundle2.putDouble(string13, d3);
        if (object == null) {
            int n82 = ((BaseAd)object3).isInternalAd();
            bundle2.putInt("is_internal_ad", n82);
        } else {
            String string62 = "is_internal_ad";
            int n18 = object.isInternalAd();
            bundle2.putInt(string62, n18);
        }
        String string14 = "game_name";
        String string15 = ((BaseAd)object3).mGameName;
        if (string15 == null) {
            String string16 = "";
        }
        bundle2.putString(string14, (String)var3_43);
        String string17 = "game_scene";
        object3 = ((BaseAd)object3).mGameScene;
        if (object3 == null) {
            object3 = "";
        }
        bundle2.putString(string17, (String)object3);
        TrackingManager.trackingAdClick(bundle2);
    }

    /*
     * WARNING - void declaration
     */
    protected void logClose(TAdNativeInfo object) {
        void var3_31;
        Object object3;
        Bundle bundle;
        Bundle bundle2 = bundle;
        bundle = new Bundle();
        ((BaseAd)object3).appendContextParam(bundle2);
        int n2 = ((BaseAd)object3).mBundle.getInt("request_time");
        bundle2.putInt("request_time", n2);
        long l2 = ((BaseAd)object3).mBundle.getLong("return_ts");
        bundle2.putLong("return_ts", l2);
        int n3 = ((BaseAd)object3).mBundle.getInt("return_time");
        bundle2.putInt("return_time", n3);
        long string = ((BaseAd)object3).mBundle.getLong("show_ts");
        bundle2.putLong("show_ts", string);
        string = ((BaseAd)object3).mBundle.getLong("show_time");
        bundle2.putLong("show_time", string);
        string = System.currentTimeMillis();
        bundle2.putLong("click_ts", string);
        int n4 = (int)(System.currentTimeMillis() - ((BaseAd)object3).mImpressionTime);
        bundle2.putInt("click_time", n4);
        String string2 = ((BaseAd)object3).mBundle.getString("ad_title");
        bundle2.putString("ad_title", string2);
        String n6 = ((BaseAd)object3).mBundle.getString("ad_url");
        bundle2.putString("ad_url", n6);
        int string4 = ((BaseAd)object3).mBundle.getInt("filling_source");
        bundle2.putInt("filling_source", string4);
        String string3 = ((BaseAd)object3).mBundle.getString("description");
        bundle2.putString("description", string3);
        String string5 = ((BaseAd)object3).mBundle.getString("image_url");
        bundle2.putString("image_url", string5);
        String string6 = ((BaseAd)object3).mBundle.getString("icon_url");
        bundle2.putString("icon_url", string6);
        String string7 = ((BaseAd)object3).mBundle.getString("endcard_url");
        bundle2.putString("endcard_url", string7);
        String string8 = ((BaseAd)object3).mBundle.getString("app_name");
        bundle2.putString("app_name", string8);
        String string9 = ((BaseAd)object3).mBundle.getString("package_name");
        bundle2.putString("package_name", string9);
        String string10 = ((BaseAd)object3).mBundle.getString("download_url");
        bundle2.putString("download_url", string10);
        String string11 = ((BaseAd)object3).mBundle.getString("traffic_group_id");
        bundle2.putString("traffic_group_id", string11);
        String string12 = ((BaseAd)object3).mBundle.getString("experiment_group_id");
        bundle2.putString("experiment_group_id", string12);
        bundle2.putInt("slot_height", 0);
        bundle2.putInt("slot_width", 0);
        bundle2.putInt("click_x", 0);
        bundle2.putInt("click_y", 0);
        String string13 = ((BaseAd)object3).sceneId;
        bundle2.putString("scene_id", string13);
        String string14 = "mediator_source";
        Object object2 = object == null ? ((BaseAd)object3).mediatorSourceName : object.getMediatorSourceName();
        bundle2.putString(string14, (String)object2);
        String string15 = "mediator_code_seat_id";
        object2 = object == null ? ((BaseAd)object3).mediatorSourceUnitId : object.getMediatorSourceUnitId();
        bundle2.putString(string15, (String)object2);
        String string16 = "price_coefficient";
        object2 = ((BaseAd)object3).mNetwork;
        double d = object2 != null ? ((Network)object2).getShowPriceCoefficient().doubleValue() : 0.0;
        bundle2.putDouble(string16, d);
        if (object == null) {
            int n5 = ((BaseAd)object3).isInternalAd();
            bundle2.putInt("is_internal_ad", n5);
        } else {
            String string32 = "is_internal_ad";
            int n = object.isInternalAd();
            bundle2.putInt(string32, n);
        }
        String string17 = "game_name";
        String string18 = ((BaseAd)object3).mGameName;
        if (string18 == null) {
            String string19 = "";
        }
        bundle2.putString(string17, (String)var3_31);
        String string20 = "game_scene";
        object3 = ((BaseAd)object3).mGameScene;
        if (object3 == null) {
            object3 = "";
        }
        bundle2.putString(string20, (String)object3);
        TrackingManager.trackingAdClose(bundle2);
    }

    @Override
    public void detachContext() {
        this.mListenerList.clear();
    }

    @Override
    public void destroyAd() {
        BaseAd baseAd = this;
        baseAd.isDestroyed = true;
        baseAd.detachContext();
        baseAd.stopTimer();
        if (!baseAd.isLoaded) {
            this.isLoaded = true;
            Bundle bundle = new Bundle();
            bundle.putInt("error_code", 30005);
            bundle.putString("error_message", TAdErrorCode.ERROR_REQUEST_OBJECT_IS_DESTROYED.getErrorMessage());
            bundle.putInt("request_num", this.mAdCount);
            this.adReturnTracking(bundle);
        }
    }

    @Override
    public void addRequestBody(TInnerAdRequestBody object) {
        if (object != null) {
            BaseAd baseAd = this;
            object = ((TInnerAdRequestBody)object).getAdListener();
            baseAd.mListenerList.add((WrapTAdAllianceListener)object);
            if (baseAd.mListenerList.size() > 2) {
                this.mListenerList.remove(0);
            }
        }
    }

    @Override
    public void setPreload(boolean bl) {
        this.isPreload = bl;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int n) {
        this.ttl = n;
    }

    @Override
    public boolean isExpired() {
        return this.getValidTimeLimit() <= 0L;
    }

    @Override
    public long getValidTimeLimit() {
        int n = this.ttl;
        if (n <= 0) {
            return Long.MAX_VALUE;
        }
        return (long)n * 60000L - Math.abs(System.currentTimeMillis() - this.startTime);
    }

    @Override
    public int getAdSource() {
        return this.adSource;
    }

    @Override
    public void setEcpmPrice(double d) {
        this.price = d;
    }

    @Override
    public double getEcpmPrice() {
        return this.price;
    }

    @Override
    public void setAdSource(int n) {
        this.adSource = n;
    }

    @Override
    public String getPlacementId() {
        return this.mNetwork.getCodeSeatId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void stopLoader() {
        Exception exception2;
        block4: {
            if (this.isLoaded) {
                return;
            }
            try {
                if (this.isSupportStopRequest()) {
                    this.destroyAd();
                    return;
                }
            }
            catch (Exception exception2) {
                break block4;
            }
            BaseAd baseAd = this;
            baseAd.detachContext();
            baseAd.setLoadStatus(4);
            return;
        }
        AdLogUtil.Log().e("BaseAd", Log.getStackTraceString((Throwable)exception2));
    }

    @Override
    public String getFilterSource() {
        return "";
    }

    @Override
    public void setOfflineAd(boolean bl) {
        this.isOfflineAd = bl;
    }

    protected boolean supportTimer() {
        return true;
    }

    protected void startTimer() {
        if (this.runTimer == null) {
            RunTimer runTimer;
            RunTimer runTimer2;
            RunTimer runTimer3 = runTimer2 = runTimer;
            runTimer3();
            this.runTimer = runTimer3;
            runTimer.setScheduleTime(this.getTimeOutTime());
            this.runTimer.setTimeOutCallback(this.timeOutCallback);
        }
        this.runTimer.runTimerTask();
        AdLogUtil.Log().d("BaseAd", "\u542f\u52a8\u5e7f\u544a\u8bf7\u6c42\u8d85\u65f6\u76d1\u542c...");
    }

    protected int getTimeOutTime() {
        return 30000;
    }

    protected void stopTimer() {
        RunTimer runTimer = this.runTimer;
        if (runTimer != null) {
            runTimer.cancelTimeTask();
            this.runTimer = null;
        }
    }

    public void onTimeOut() {
        BaseAd baseAd = this;
        baseAd.adFailedToLoad(TAdErrorCode.ERROR_AD_REQUEST_TIME_OUT);
        baseAd.destroyAd();
    }

    public void post(Handler handler, Runnable runnable) {
        if (handler != null) {
            handler.post(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public void setTrackingBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        BaseAd baseAd = this;
        baseAd.mBundle.putAll(bundle);
        double d = this.mNetwork.getPrice();
        baseAd.mBundle.putDouble("bidding_price", d);
    }

    protected void adTrackingRequest() {
        RecordTestInfo.record("adTrackingRequest code_seat_id:" + this.getPlacementId() + ",bidding_price:" + this.mBundle.getDouble("bidding_price"));
        this.mBundle.putInt("ad_count", this.mAdCount);
        this.mBundle.putInt("is_retreatad", 0);
        this.mBundle.putInt("is_default_ad", 0);
        if (TextUtils.isEmpty((CharSequence)this.mRequestId)) {
            this.mRequestId = DeviceUtil.getUUID();
        }
        this.mTriggerId = this.mBundle.getString("trigger_id");
        this.mBundle.putString("request_id", this.mRequestId);
        this.mBundle.putString("cld_configure_id", AdxPreferencesHelper.getInstance().getString("cloudControlVersion"));
        this.mBundle.putInt("request_num", this.mAdCount);
        this.mBundle.putInt("request_round", this.mRequestRound);
        Bundle bundle = this.mBundle;
        String string = "price_coefficient";
        Network network = this.mNetwork;
        double d = network != null ? network.getShowPriceCoefficient().doubleValue() : 0.0;
        bundle.putDouble(string, d);
        this.mBundle.putInt("is_preload", this.isPreload ? 1 : 0);
        bundle = this.mBundle;
        string = "biddingType";
        int n = AdUtil.isBiddingNetwork(this.mNetwork) || AdUtil.isQueryPriceNetwork(this.mNetwork) ? 1 : 2;
        bundle.putInt(string, n);
        TrackingManager.trackingAdRequest(this.mBundle);
    }

    public void adReturnTracking(Bundle bundle) {
        Bundle object;
        if (bundle != null && (object = this.mBundle) != null) {
            if (object.containsKey("cld_configure_id")) {
                this.mBundle.remove("cld_configure_id");
            }
            String l = this.mBundle.getString("trigger_id");
            bundle.putString("trigger_id", l);
            long n = this.mBundle.getLong("trigger_ts");
            bundle.putLong("trigger_ts", n);
            n = this.mBundle.getLong("request_ts");
            bundle.putLong("request_ts", n);
            int string = (int)(this.mBundle.getLong("request_ts") - this.mBundle.getLong("trigger_ts"));
            bundle.putInt("request_time", string);
            String l2 = this.mBundle.getString("request_id");
            bundle.putString("request_id", l2);
            long n2 = System.currentTimeMillis();
            bundle.putLong("return_ts", n2);
            int l3 = (int)(System.currentTimeMillis() - this.mBundle.getLong("request_ts"));
            bundle.putInt("return_time", l3);
            long n3 = System.currentTimeMillis();
            this.mBundle.putLong("return_ts", n3);
            this.mBundle.putInt("return_time", (int)(System.currentTimeMillis() - this.mBundle.getLong("request_ts")));
            int string2 = this.mBundle.getInt("ad_type");
            bundle.putInt("ad_type", string2);
            String n4 = this.mBundle.getString("cld_app_id");
            bundle.putString("cld_app_id", n4);
            String string3 = this.mBundle.getString("cld_code_seat_id");
            bundle.putString("cld_code_seat_id", string3);
            int d = this.mBundle.getInt("platform");
            bundle.putInt("platform", d);
            String n5 = this.mBundle.getString("app_id");
            bundle.putString("app_id", n5);
            String string4 = this.mBundle.getString("code_seat_id");
            bundle.putString("code_seat_id", string4);
            double n6 = this.getBiddingPrice();
            bundle.putDouble("bidding_price", n6);
            this.mBundle.putDouble("bidding_price", n6);
            RecordTestInfo.record("adReturnTracking code_seat_id:" + this.mBundle.getString("code_seat_id") + ",bidding_price:" + bundle.getDouble("bidding_price"));
            int string5 = this.mBundle.getInt("priority");
            bundle.putInt("priority", string5);
            int l5 = this.mBundle.getInt("ad_count");
            bundle.putInt("ad_count", l5);
            int n7 = this.mBundle.getInt("is_retreatad");
            bundle.putInt("is_retreatad", n7);
            bundle.putInt("is_default_ad", 0);
            int string6 = this.mBundle.getInt("request_type");
            bundle.putInt("request_type", string6);
            int n8 = this.mBundle.getInt("is_pre_trigger");
            bundle.putInt("is_pre_trigger", n8);
            String string7 = this.mBundle.getString("ad_title");
            bundle.putString("ad_title", string7);
            String string8 = this.mBundle.getString("ad_url");
            bundle.putString("ad_url", string8);
            String string9 = this.mBundle.getString("description");
            bundle.putString("description", string9);
            String string10 = this.mBundle.getString("image_url");
            bundle.putString("image_url", string10);
            String string11 = this.mBundle.getString("icon_url");
            bundle.putString("icon_url", string11);
            String string12 = this.mBundle.getString("endcard_url");
            bundle.putString("endcard_url", string12);
            String string13 = this.mBundle.getString("app_name");
            bundle.putString("app_name", string13);
            String string14 = this.mBundle.getString("package_name");
            bundle.putString("package_name", string14);
            String string15 = this.mBundle.getString("native_info_list");
            bundle.putString("native_info_list", string15);
            String string16 = this.mBundle.getString("download_url");
            bundle.putString("download_url", string16);
            int n9 = this.isTimeOut;
            bundle.putInt("is_timeout", n9);
            int n10 = this.mAdCount;
            bundle.putInt("request_num", n10);
            String string17 = "is_offline_ad";
            long l4 = this.isOfflineAd() ? 1L : 0L;
            bundle.putLong(string17, l4);
            long l6 = this.mBundle.getInt("ad_trigger_status");
            bundle.putLong("ad_trigger_status", l6);
            int n11 = this.mBundle.getInt("request_round");
            bundle.putInt("request_round", n11);
            String string18 = this.mBundle.getString("traffic_group_id");
            bundle.putString("traffic_group_id", string18);
            String string19 = this.mBundle.getString("experiment_group_id");
            bundle.putString("experiment_group_id", string19);
            int n12 = this.mBundle.getInt("optimize_status");
            bundle.putInt("optimize_status", n12);
            int n13 = this.mBundle.getInt("priority_code");
            bundle.putInt("priority_code", n13);
            String string20 = this.mediatorSourceName;
            bundle.putString("mediator_source", string20);
            String string21 = this.mediatorSourceUnitId;
            bundle.putString("mediator_code_seat_id", string21);
            String string22 = "price_coefficient";
            Network network = this.mNetwork;
            double d2 = network != null ? network.getShowPriceCoefficient().doubleValue() : 0.0;
            bundle.putDouble(string22, d2);
            int n92 = this.mBundle.getInt("biddingType");
            bundle.putInt("biddingType", n92);
            TrackingManager.trackingAdReturn(bundle);
            return;
        }
    }

    public void admobShowPriceTracking(float f, String object, int n) {
        Bundle bundle;
        Bundle bundle2 = bundle;
        bundle2();
        bundle2.putString("trigger_id", ((BaseAd)((Object)string)).mBundle.getString("trigger_id"));
        bundle2.putString("request_id", ((BaseAd)((Object)string)).mBundle.getString("request_id"));
        bundle2.putString("cld_app_id", ((BaseAd)((Object)string)).mBundle.getString("cld_app_id"));
        bundle2.putString("app_id", ((BaseAd)((Object)string)).mBundle.getString("app_id"));
        bundle2.putString("cld_code_seat_id", ((BaseAd)((Object)string)).mBundle.getString("cld_code_seat_id"));
        bundle.putString("code_seat_id", ((BaseAd)((Object)string)).mBundle.getString("code_seat_id"));
        bundle.putFloat("ad_value", f);
        bundle.putString("advalue_currency_code", (String)object);
        bundle.putInt("ad_value_type", n);
        long l = System.currentTimeMillis();
        bundle.putLong("event_ts", l);
        Object object2 = "bidding_price";
        object = ((BaseAd)((Object)string)).mNetwork;
        double d = object == null ? 0.0 : ((Network)object).getPrice();
        bundle2.putDouble((String)object2, d);
        object2 = "ad_type";
        Network network = ((BaseAd)((Object)string)).mNetwork;
        int n2 = network == null ? 0 : network.getAdt();
        BaseAd baseAd = string;
        bundle2.putInt((String)object2, n2);
        bundle2.putString("traffic_group_id", ((BaseAd)((Object)string)).mBundle.getString("traffic_group_id"));
        bundle2.putString("experiment_group_id", ((BaseAd)((Object)string)).mBundle.getString("experiment_group_id"));
        bundle2.putString("mediator_source", ((BaseAd)((Object)string)).mediatorSourceName);
        bundle2.putString("mediator_code_seat_id", ((BaseAd)((Object)string)).mediatorSourceUnitId);
        String string = "price_coefficient";
        object2 = baseAd.mNetwork;
        double d2 = object2 != null ? ((Network)object2).getShowPriceCoefficient().doubleValue() : 0.0;
        Bundle bundle3 = bundle2;
        bundle3.putDouble(string, d2);
        TrackingManager.trackingAdmobShowPrice(bundle3);
    }

    @Override
    public void setRequestTime(long l) {
        this.requestTime = l;
    }

    @Override
    public long getRequestTime() {
        return this.requestTime;
    }

    @Override
    public void setSupportFlag(int n) {
        this.supportHisavanaFlag = n;
    }

    protected int getSupportHisavanaFlag() {
        return this.supportHisavanaFlag;
    }

    @Override
    public void setMaxPrice(double d) {
        AdLogUtil.Log().d("Athena", "setMaxPrice " + d);
        this.maxPrice = d;
    }

    @Override
    public void setExt(String string) {
    }

    @Override
    public String getExt() {
        return "";
    }

    protected void onAdditionalShowed(long l, String string, int n) {
        BaseAd baseAd = this;
        baseAd.saveShowedValue(l);
        WrapTAdAllianceListener wrapTAdAllianceListener = baseAd.mListenerList.isEmpty() ? null : this.mListenerList.get(0);
        if (wrapTAdAllianceListener == null) {
            return;
        }
        BaseAd baseAd2 = this;
        AdditionalInfo additionalInfo = baseAd2.getBaseAdditionalInfo();
        additionalInfo.setAdmobECPM((double)l / 1000000.0);
        additionalInfo.setCurrencyCode(string);
        additionalInfo.setPrecisionType(n);
        Network network = baseAd2.mNetwork;
        if (network != null) {
            additionalInfo.setSource(network.getSource());
            additionalInfo.setApplicationId(this.mNetwork.getApplicationId());
            additionalInfo.setApplicationKey(this.mNetwork.getApplicationKey());
            additionalInfo.setCodeSeatId(this.mNetwork.getCodeSeatId());
            additionalInfo.setBidding(AdUtil.isBiddingNetwork(this.mNetwork));
            additionalInfo.setMediatorSource(this.mediatorSourceName);
        }
        wrapTAdAllianceListener.onShowed(additionalInfo);
    }

    protected AdditionalInfo getClickAdditionalInfo(AdNativeInfo adNativeInfo) {
        BaseAd baseAd = bl;
        AdditionalInfo additionalInfo = baseAd.getBaseAdditionalInfo();
        Object object = baseAd.mNetwork;
        if (object != null) {
            additionalInfo.setSource(((Network)object).getSource());
            additionalInfo.setApplicationId(((BaseAd)((Object)bl)).mNetwork.getApplicationId());
            additionalInfo.setApplicationKey(((BaseAd)((Object)bl)).mNetwork.getApplicationKey());
            additionalInfo.setCodeSeatId(((BaseAd)((Object)bl)).mNetwork.getCodeSeatId());
            additionalInfo.setECPM(((BaseAd)((Object)bl)).mBundle.getDouble("bidding_price"));
            object = ((BaseAd)((Object)bl)).isWaterFallExecutor() ? "estimated" : "exact";
            AdditionalInfo additionalInfo2 = additionalInfo;
            additionalInfo2.setPrecision((String)object);
            additionalInfo2.setCurrency("USD");
            additionalInfo.setBidding(AdUtil.isBiddingNetwork(((BaseAd)((Object)bl)).mNetwork));
            additionalInfo.setMediatorSource(((BaseAd)((Object)bl)).mediatorSourceName);
        }
        Boolean bl = adNativeInfo == null ? ((BaseAd)((Object)bl)).isInternalAd() : adNativeInfo.isInternalAd();
        AdditionalInfo additionalInfo3 = additionalInfo;
        additionalInfo3.setInternalAd(bl);
        return additionalInfo3;
    }

    protected void setMediatorInfo(String string, String string2) {
        if (this.mNetwork == null) {
            return;
        }
        AdLogUtil.Log().d("ad_flow", ">>>>> sourceName: " + string + " | sourceUnitId: " + string2 + " | " + this.mNetwork.getCodeSeatId());
        this.mediatorSourceName = string;
        this.mediatorSourceUnitId = string2;
    }
}

