/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.fblibrary.excuter.bidding;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.facebook.ads.AdSettings;
import com.facebook.biddingkit.bidders.BidResponseCallback;
import com.facebook.biddingkit.bidders.BidderWithNotifier;
import com.facebook.biddingkit.facebook.bidder.FacebookBidder;
import com.facebook.biddingkit.gen.BidWithNotification;
import com.facebook.biddingkit.gen.FacebookAdBidFormat;
import com.hisavana.common.base.BaseQueryPrice;
import com.hisavana.common.bean.Network;
import com.hisavana.common.constant.ComConstants;
import com.hisavana.common.interfacz.IBidWithNotify;
import com.transsion.core.pool.TranssionPoolManager;
import java.util.ArrayList;

public class FanBidding
extends BaseQueryPrice {
    private int b;
    private long k;

    public void setBannerSize(int n) {
        this.b = n;
    }

    public void queryPrice(Context context, final Network network) {
        if (network == null) {
            return;
        }
        boolean bl = AdSettings.isTestMode((Context)context);
        AdLogUtil.Log().w("FanBidding", "*----> start fan real time bidding...,is test mode:" + bl);
        AdSettings.setTestMode((boolean)bl);
        FacebookAdBidFormat facebookAdBidFormat = null;
        switch (network.getAdt()) {
            case 2: {
                if (this.b == 0) {
                    facebookAdBidFormat = FacebookAdBidFormat.BANNER_HEIGHT_50;
                    break;
                }
                if (this.b == 3 || this.b == 1) {
                    facebookAdBidFormat = FacebookAdBidFormat.BANNER_HEIGHT_90;
                    break;
                }
                if (this.b != 2) break;
                facebookAdBidFormat = FacebookAdBidFormat.BANNER_HEIGHT_250;
                break;
            }
            case 3: {
                facebookAdBidFormat = FacebookAdBidFormat.INTERSTITIAL;
                break;
            }
            case 1: {
                facebookAdBidFormat = FacebookAdBidFormat.NATIVE;
                break;
            }
            case 10: {
                facebookAdBidFormat = FacebookAdBidFormat.NATIVE_BANNER;
                break;
            }
            case 5: {
                facebookAdBidFormat = FacebookAdBidFormat.REWARDED_VIDEO;
                break;
            }
            default: {
                network.setPrice(Double.valueOf(0.0));
                if (this.mQueryPriceListener != null) {
                    this.mQueryPriceListener.onQueryPriceFailed();
                }
                return;
            }
        }
        AdLogUtil.Log().d("FanBidding", "fbtoken is : " + ComConstants.fbBidToken);
        BidderWithNotifier bidderWithNotifier = new FacebookBidder.Builder(network.getApplicationId(), network.getCodeSeatId(), facebookAdBidFormat, ComConstants.fbBidToken).setTestMode(bl).buildWithNotifier();
        final long l = System.currentTimeMillis();
        this.c();
        bidderWithNotifier.retrieveBidWithNotificationCompleted(new BidResponseCallback(){

            public void handleBidResponse(BidWithNotification bidWithNotification) {
                long l2 = System.currentTimeMillis() - l;
                if (bidWithNotification == null || network == null) {
                    return;
                }
                double d = bidWithNotification.getPrice();
                FanBidding.this.a(d);
                network.setPrice(Double.valueOf(d));
                network.setBidInfo((IBidWithNotify)new BidWithNotify(bidWithNotification));
                AdLogUtil.Log().d("FanBidding", "*----> fan bidding success ---,price is:" + d + ",id:" + network.codeSeatId);
                if (Looper.myLooper() == Looper.getMainLooper() && FanBidding.this.mQueryPriceListener != null) {
                    FanBidding.this.mQueryPriceListener.onQueryPriceSuccess(new ArrayList());
                } else {
                    FanBidding.this.mMainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (FanBidding.this.mQueryPriceListener != null) {
                                ArrayList<Network> arrayList = new ArrayList<Network>();
                                arrayList.add(network);
                                FanBidding.this.mQueryPriceListener.onQueryPriceSuccess(arrayList);
                            }
                        }
                    });
                }
            }

            public void handleBidResponseFailure(String string) {
                long l2 = System.currentTimeMillis() - l;
                AdLogUtil.Log().d("FanBidding", "*----> bidding request fail --- :" + string + ",time use:" + l2);
                if (network == null) {
                    return;
                }
                FanBidding.this.a(-1, string);
                if (Looper.myLooper() == Looper.getMainLooper() && FanBidding.this.mQueryPriceListener != null) {
                    FanBidding.this.mQueryPriceListener.onQueryPriceFailed();
                } else {
                    FanBidding.this.mMainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (FanBidding.this.mQueryPriceListener != null) {
                                FanBidding.this.mQueryPriceListener.onQueryPriceFailed();
                            }
                        }
                    });
                }
            }
        });
    }

    private void c() {
        Bundle bundle = new Bundle();
        this.k = System.currentTimeMillis();
        bundle.putLong("inquiry_request_ts", this.k);
        this.adBiddingTracking(bundle);
    }

    private void a(double d) {
        Bundle bundle = new Bundle();
        long l = System.currentTimeMillis();
        bundle.putLong("inquiry_return_ts", l);
        bundle.putInt("error_code", 0);
        bundle.putDouble("bidding_price", d);
        bundle.putLong("inquiry_return_time", l - this.k);
        this.adBiddingReturnTracking(bundle);
    }

    private void a(int n, String string) {
        Bundle bundle = new Bundle();
        long l = System.currentTimeMillis();
        bundle.putLong("inquiry_return_ts", l);
        bundle.putLong("inquiry_return_time", l - this.k);
        bundle.putInt("error_code", n);
        bundle.putDouble("bidding_price", 0.0);
        bundle.putString("error_message", string);
        this.adBiddingReturnTracking(bundle);
    }

    public void destroy() {
        this.mQueryPriceListener = null;
    }

    private static class BidWithNotify
    implements IBidWithNotify {
        private final BidWithNotification o;
        private boolean p = false;
        private long q;

        BidWithNotify(BidWithNotification bidWithNotification) {
            this.o = bidWithNotification;
            this.q = System.currentTimeMillis();
        }

        public void notifyWin() {
            AdLogUtil.Log().d("FanBidding", "notify fan bidding win");
            if (Looper.myLooper() == Looper.getMainLooper()) {
                TranssionPoolManager.getInstance().addTask(new Runnable(){

                    @Override
                    public void run() {
                        if (BidWithNotify.this.o != null) {
                            BidWithNotify.this.o.notifyWin();
                        }
                        BidWithNotify.this.p = true;
                    }
                });
            } else {
                this.o.notifyWin();
                this.p = true;
            }
        }

        public void notifyLoss() {
            if (this.p) {
                return;
            }
            AdLogUtil.Log().d("FanBidding", "notify fan bidding failed");
            if (Looper.myLooper() == Looper.getMainLooper()) {
                TranssionPoolManager.getInstance().addTask(new Runnable(){

                    @Override
                    public void run() {
                        if (BidWithNotify.this.o != null) {
                            BidWithNotify.this.o.notifyLoss();
                        }
                    }
                });
            } else {
                this.o.notifyLoss();
            }
        }

        public String getPayload() {
            return this.o.getPayload();
        }

        public boolean isExpired() {
            return Math.abs(System.currentTimeMillis() - this.q) > (long)ComConstants.BID_PRICE_CACHE_TIME;
        }
    }
}

