/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.fblibrary.excuter;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.hisavana.common.base.BaseVideo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.fblibrary.excuter.check.ExistsCheck;

public class FanVideo
extends BaseVideo {
    private RewardedVideoAd m;
    private RewardedVideoAdListener n;

    public FanVideo(Context context, Network network) {
        super(context, network);
    }

    public void loadAd() {
        if (this.mContext != null && this.mContext.get() != null) {
            this.a();
        }
    }

    private void a() {
        super.loadAd();
    }

    public boolean isLoaded() {
        return this.m != null;
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.m != null) {
            this.m = null;
        }
        if (this.n != null) {
            this.n = null;
        }
        AdLogUtil.Log().d("video", "destroyAd " + this.getLogString());
    }

    protected void initVideo() {
        if (null != this.mContext && null != this.mContext.get()) {
            this.m = new RewardedVideoAd((Context)this.mContext.get(), this.mNetwork.codeSeatId);
            this.n = new RewardedVideoAdListener(){

                public void onError(Ad ad, AdError adError) {
                    if (null != adError) {
                        AdLogUtil.Log().w("video", "FanVideo --> ad load failed, error :" + adError.getErrorMessage() + FanVideo.this.getLogString());
                        FanVideo.this.adFailedToLoad(new TAdErrorCode(adError.getErrorCode(), adError.getErrorMessage()));
                    }
                    FanVideo.this.m = null;
                }

                public void onAdLoaded(Ad ad) {
                    AdLogUtil.Log().d("video", "FanVideo --> Video Ad was loaded." + FanVideo.this.getLogString());
                    FanVideo.this.adLoaded();
                }

                public void onAdClicked(Ad ad) {
                    AdLogUtil.Log().d("video", "FanVideo --> Ad onAdClicked." + FanVideo.this.getLogString());
                    FanVideo.this.adClicked();
                }

                public void onLoggingImpression(Ad ad) {
                    AdLogUtil.Log().d("video", "FanVideo --> Ad was shown." + FanVideo.this.getLogString());
                    FanVideo.this.adImpression();
                }

                public void onRewardedVideoCompleted() {
                    AdLogUtil.Log().d("video", "FanVideo --> The user earned the reward." + FanVideo.this.getLogString());
                    FanVideo.this.onReward();
                }

                public void onRewardedVideoClosed() {
                    FanVideo.this.m = null;
                    AdLogUtil.Log().d("video", "FanVideo --> video is adClosed" + FanVideo.this.getLogString());
                    FanVideo.this.adClosed();
                }
            };
        }
    }

    protected void onVideoStartLoad() {
        if (null != this.m && null != this.n) {
            try {
                final long l = System.currentTimeMillis();
                ExistsCheck.initFan((Context)this.mContext.get(), new AudienceNetworkAds.InitListener(){

                    public void onInitialized(AudienceNetworkAds.InitResult initResult) {
                        AdLogUtil.Log().d("FanVideo", "onInitialized " + (System.currentTimeMillis() - l));
                        if (initResult == null || !initResult.isSuccess()) {
                            FanVideo.this.adFailedToLoad(TAdErrorCode.FAN_INIT_ERROR);
                            return;
                        }
                        try {
                            if (!TextUtils.isEmpty(FanVideo.this.mNetwork.getBidInfo() != null ? FanVideo.this.mNetwork.getBidInfo().getPayload() : null)) {
                                FanVideo.this.m.loadAd(FanVideo.this.m.buildLoadAdConfig().withBid(FanVideo.this.mNetwork.getBidInfo().getPayload()).withAdListener(FanVideo.this.n).build());
                                FanVideo.this.mNetwork.setBidInfo(null);
                            } else {
                                FanVideo.this.m.loadAd(FanVideo.this.m.buildLoadAdConfig().withAdListener(FanVideo.this.n).build());
                            }
                        }
                        catch (Throwable throwable) {
                            AdLogUtil.Log().e("FanVideo", "onVideoStartLoad " + Log.getStackTraceString((Throwable)throwable));
                        }
                    }
                });
            }
            catch (Exception exception) {
                AdLogUtil.Log().e("FanVideo", Log.getStackTraceString((Throwable)exception));
            }
        }
    }

    protected void onVideoShow() {
        if (null == this.mContext || null == this.mContext.get()) {
            AdLogUtil.Log().w("video", "FanVideo --> onVideoShow null == mContext.get() || null == mContext" + this.getLogString());
            return;
        }
        if (null != this.m) {
            AdLogUtil.Log().d("video", "FanVideo --> onVideoShow." + this.getLogString());
            this.m.show();
        } else {
            AdLogUtil.Log().w("video", "FanVideo --> The rewarded ad wasn't ready yet.");
        }
    }
}

