/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.fblibrary.excuter;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.hisavana.common.base.BaseVideo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.fblibrary.excuter.check.ExistsCheck;
import com.transsion.core.CoreUtil;

public class FanVideo
extends BaseVideo {
    private RewardedVideoAd n;
    private RewardedVideoAdListener o;

    public FanVideo(Context context, Network network) {
        super(context, network);
    }

    public void loadAd() {
        this.a();
    }

    private void a() {
        super.loadAd();
    }

    public boolean isLoaded() {
        return this.n != null;
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.n != null) {
            this.n = null;
        }
        if (this.o != null) {
            this.o = null;
        }
        AdLogUtil.Log().d("video", "destroyAd " + this.getLogString());
    }

    protected void initVideo() {
        if (null != this.mContext && null != this.mContext.get()) {
            return;
        }
        Context context = (Context)this.mContext.get();
        if (null != context && this.mNetwork != null) {
            this.n = new RewardedVideoAd(context, this.mNetwork.getCodeSeatId());
            this.o = new RewardedVideoAdListener(){

                public void onError(Ad ad, AdError adError) {
                    if (null != adError) {
                        AdLogUtil.Log().w("video", "FanVideo --> ad load failed, error :" + adError.getErrorMessage() + FanVideo.this.getLogString());
                        FanVideo.this.adFailedToLoad(new TAdErrorCode(adError.getErrorCode(), adError.getErrorMessage()));
                    }
                    FanVideo.this.n = null;
                }

                public void onAdLoaded(Ad ad) {
                    AdLogUtil.Log().d("video", "FanVideo --> Video Ad was loaded." + FanVideo.this.getLogString());
                    FanVideo.this.adLoaded();
                }

                public void onAdClicked(Ad ad) {
                    AdLogUtil.Log().d("video", "FanVideo --> Ad onAdClicked." + FanVideo.this.getLogString());
                    FanVideo.this.adClicked();
                }

                public void onLoggingImpression(Ad ad) {
                    AdLogUtil.Log().d("video", "FanVideo --> Ad was shown." + FanVideo.this.getLogString());
                    FanVideo.this.adImpression();
                }

                public void onRewardedVideoCompleted() {
                    AdLogUtil.Log().d("video", "FanVideo --> The user earned the reward." + FanVideo.this.getLogString());
                    FanVideo.this.onReward();
                }

                public void onRewardedVideoClosed() {
                    FanVideo.this.n = null;
                    AdLogUtil.Log().d("video", "FanVideo --> video is adClosed" + FanVideo.this.getLogString());
                    FanVideo.this.adClosed();
                }
            };
        }
    }

    protected void onVideoStartLoad() {
        if (null != this.n && null != this.o) {
            try {
                final long l = System.currentTimeMillis();
                ExistsCheck.initFan(CoreUtil.getContext(), new AudienceNetworkAds.InitListener(){

                    public void onInitialized(AudienceNetworkAds.InitResult initResult) {
                        AdLogUtil.Log().d("FanVideo", "onInitialized " + (System.currentTimeMillis() - l));
                        if (initResult == null || !initResult.isSuccess() || FanVideo.this.n == null || FanVideo.this.mNetwork == null) {
                            FanVideo.this.adFailedToLoad(TAdErrorCode.FAN_INIT_ERROR);
                            return;
                        }
                        try {
                            if (!TextUtils.isEmpty(FanVideo.this.mNetwork.getBidInfo() != null ? FanVideo.this.mNetwork.getBidInfo().getPayload() : null)) {
                                FanVideo.this.n.loadAd(FanVideo.this.n.buildLoadAdConfig().withBid(FanVideo.this.mNetwork.getBidInfo().getPayload()).withAdListener(FanVideo.this.o).build());
                                FanVideo.this.mNetwork.setBidInfo(null);
                            } else {
                                FanVideo.this.n.loadAd(FanVideo.this.n.buildLoadAdConfig().withAdListener(FanVideo.this.o).build());
                            }
                        }
                        catch (Throwable throwable) {
                            AdLogUtil.Log().e("FanVideo", "onVideoStartLoad " + Log.getStackTraceString((Throwable)throwable));
                        }
                    }
                });
            }
            catch (Exception exception) {
                AdLogUtil.Log().e("FanVideo", Log.getStackTraceString((Throwable)exception));
            }
        }
    }

    protected void onVideoShow() {
        if (null != this.n) {
            AdLogUtil.Log().d("video", "FanVideo --> onVideoShow." + this.getLogString());
            this.n.show();
        } else {
            AdLogUtil.Log().w("video", "FanVideo --> The rewarded ad wasn't ready yet.");
        }
    }
}

