/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.fblibrary.excuter.bidding;

import android.content.Context;
import com.facebook.ads.AdSettings;
import com.facebook.biddingkit.bidders.BidResponseCallback;
import com.facebook.biddingkit.bidders.BidderWithNotifier;
import com.facebook.biddingkit.facebook.bidder.FacebookBidder;
import com.facebook.biddingkit.gen.BidWithNotification;
import com.facebook.biddingkit.gen.FacebookAdBidFormat;
import com.hisavana.common.base.BaseQueryPrice;
import com.hisavana.common.bean.Network;
import com.hisavana.common.constant.ComConstants;
import com.hisavana.common.interfacz.IBidWithNotify;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.common.utils.ThreadUtils;
import java.util.ArrayList;

public class FanBidding
extends BaseQueryPrice {
    private int b;

    public void setBannerSize(int n) {
        this.b = n;
    }

    public void queryPrice(Context context, final Network network) {
        if (network == null) {
            return;
        }
        boolean bl = AdSettings.isTestMode((Context)context);
        AdLogUtil.Log().w("FanBidding", "*----> start fan real time bidding...,is test mode:" + bl);
        AdSettings.setTestMode((boolean)bl);
        FacebookAdBidFormat facebookAdBidFormat = null;
        switch (network.getAdt()) {
            case 2: {
                facebookAdBidFormat = this.a(this.b);
                break;
            }
            case 3: {
                facebookAdBidFormat = FacebookAdBidFormat.INTERSTITIAL;
                break;
            }
            case 1: {
                facebookAdBidFormat = FacebookAdBidFormat.NATIVE;
                break;
            }
            case 10: {
                facebookAdBidFormat = FacebookAdBidFormat.NATIVE_BANNER;
                break;
            }
            case 5: {
                facebookAdBidFormat = FacebookAdBidFormat.REWARDED_VIDEO;
                break;
            }
            default: {
                network.setPrice(Double.valueOf(0.0));
                if (this.mQueryPriceListener != null) {
                    this.mQueryPriceListener.onQueryPriceFailed();
                }
                return;
            }
        }
        AdLogUtil.Log().d("FanBidding", "fbtoken is : " + ComConstants.fbBidToken);
        BidderWithNotifier bidderWithNotifier = new FacebookBidder.Builder(network.getApplicationId(), network.getCodeSeatId(), facebookAdBidFormat, ComConstants.fbBidToken).setTestMode(bl).buildWithNotifier();
        final long l = System.currentTimeMillis();
        this.trackingBiddingStart();
        bidderWithNotifier.retrieveBidWithNotificationCompleted(new BidResponseCallback(){

            public void handleBidResponse(BidWithNotification bidWithNotification) {
                if (bidWithNotification == null || network == null) {
                    return;
                }
                double d = bidWithNotification.getPrice();
                FanBidding.this.trackingBiddingSuccess(d);
                network.setPrice(Double.valueOf(d));
                network.setBidInfo((IBidWithNotify)new BidWithNotify(bidWithNotification));
                AdLogUtil.Log().d("FanBidding", "*----> fan bidding success ---,price is:" + d + ",id:" + network.getCodeSeatId());
                if (FanBidding.this.mQueryPriceListener != null) {
                    ArrayList<Network> arrayList = new ArrayList<Network>();
                    arrayList.add(network);
                    FanBidding.this.mQueryPriceListener.onQueryPriceSuccess(arrayList);
                }
            }

            public void handleBidResponseFailure(String string) {
                long l2 = System.currentTimeMillis() - l;
                AdLogUtil.Log().d("FanBidding", "*----> bidding request fail --- :" + string + ",time use:" + l2);
                if (network == null) {
                    return;
                }
                FanBidding.this.trackingBiddingFailed(30006, string);
                if (FanBidding.this.mQueryPriceListener != null) {
                    FanBidding.this.mQueryPriceListener.onQueryPriceFailed();
                }
            }
        });
    }

    private FacebookAdBidFormat a(int n) {
        FacebookAdBidFormat facebookAdBidFormat = null;
        if (n == 0) {
            facebookAdBidFormat = FacebookAdBidFormat.BANNER_HEIGHT_50;
        } else if (n == 3 || n == 1) {
            facebookAdBidFormat = FacebookAdBidFormat.BANNER_HEIGHT_90;
        } else if (n == 2) {
            facebookAdBidFormat = FacebookAdBidFormat.BANNER_HEIGHT_250;
        }
        return facebookAdBidFormat;
    }

    public void destroy() {
        this.mQueryPriceListener = null;
    }

    private static class BidWithNotify
    implements IBidWithNotify {
        private final BidWithNotification p;
        private boolean q = false;
        private long r;

        BidWithNotify(BidWithNotification bidWithNotification) {
            this.p = bidWithNotification;
            this.r = System.currentTimeMillis();
        }

        public void notifyWin() {
            AdLogUtil.Log().d("FanBidding", "notify fan bidding win");
            if (ThreadUtils.isInUiThread()) {
                ThreadUtils.runOnWorkThread(() -> {
                    if (this.p != null) {
                        this.p.notifyWin();
                    }
                    this.q = true;
                });
            } else if (this.p != null) {
                this.p.notifyWin();
                this.q = true;
            }
        }

        public void notifyLoss() {
            if (this.q) {
                return;
            }
            AdLogUtil.Log().d("FanBidding", "notify fan bidding failed");
            if (ThreadUtils.isInUiThread()) {
                ThreadUtils.runOnWorkThread(() -> {
                    if (this.p != null) {
                        this.p.notifyLoss();
                    }
                });
            } else if (this.p != null) {
                this.p.notifyLoss();
            }
        }

        public String getPayload() {
            if (this.p != null) {
                return this.p.getPayload();
            }
            return null;
        }

        public boolean isExpired() {
            return Math.abs(System.currentTimeMillis() - this.r) > (long)ComConstants.BID_PRICE_CACHE_TIME;
        }
    }
}

