/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.inmobi;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hisavana.common.base.BaseInterstitial;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.common.utils.ThreadUtils;
import com.hisavana.inmobi.check.ExistsCheck;
import com.hisavana.inmobi.holder.InMobiBidListener;
import com.inmobi.ads.AdMetaInfo;
import com.inmobi.ads.InMobiAdRequestStatus;
import com.inmobi.ads.InMobiInterstitial;
import com.inmobi.ads.listeners.InterstitialAdEventListener;
import com.inmobi.sdk.SdkInitializationListener;
import java.util.Map;

public class InMobiInterstitialAd
extends BaseInterstitial {
    private volatile InMobiInterstitial a;
    private InMobiBidListener b;
    private volatile int c = 3;

    public void setLoadType(int n) {
        this.c = n;
    }

    public InMobiInterstitialAd(Context context, Network network) {
        super(context, network);
    }

    protected void initInterstitial() {
        AdLogUtil.Log().d("inmobi", "initInterstitial");
    }

    protected void onInterstitialStartLoad() {
        ThreadUtils.getIoPool().execute(() -> {
            Context context;
            AdLogUtil.Log().d("inmobi", "onInterstitialStartLoad");
            final long l = System.currentTimeMillis();
            if (this.mNetwork == null) {
                this.adFailedToLoad(new TAdErrorCode(30003, " network is null"));
                return;
            }
            Context context2 = context = this.mContext == null ? null : (Context)this.mContext.get();
            if (context == null) {
                this.adFailedToLoad(new TAdErrorCode(30003, " context is null"));
                return;
            }
            ExistsCheck.initInmobi(context, this.mNetwork.getApplicationId(), new SdkInitializationListener(){

                public void onInitializationComplete(@Nullable Error error) {
                    AdLogUtil.Log().d("inmobi", "InMobiInterstitialAd initTime " + (System.currentTimeMillis() - l) + " --> onInterstitialStartLoad --> loadType = " + InMobiInterstitialAd.this.c);
                    if (error != null) {
                        InMobiInterstitialAd.this.adFailedToLoad(TAdErrorCode.ERROR_AD_SOURCE_INIT_FAILED);
                        return;
                    }
                    try {
                        InMobiInterstitialAd.this.a();
                    }
                    catch (Exception exception) {
                        AdLogUtil.Log().e(Log.getStackTraceString((Throwable)exception));
                        InMobiInterstitialAd.this.adFailedToLoad(new TAdErrorCode(30003, "InMobiInterstitialAd ad failed to load with error: " + exception.getMessage()));
                        return;
                    }
                    if (null == InMobiInterstitialAd.this.a) {
                        InMobiInterstitialAd.this.adFailedToLoad(new TAdErrorCode(30003, "null == interstitial"));
                        return;
                    }
                    if (InMobiInterstitialAd.this.c == 1) {
                        InMobiInterstitialAd.this.a.getPreloadManager().preload();
                    } else if (InMobiInterstitialAd.this.c == 2) {
                        InMobiInterstitialAd.this.a.getPreloadManager().load();
                        InMobiInterstitialAd.this.mNetwork.setBidInfo(null);
                    }
                }
            });
        });
    }

    protected void onInterstitialShow(Activity activity) {
        if (null != this.a && this.a.isReady()) {
            this.a.show();
        } else {
            this.onAdShowError(TAdErrorCode.ERROR_SHOW_EXCEPTION);
            AdLogUtil.Log().e("inmobi", "onInterstitialShow show error,interstitial is null");
        }
    }

    public boolean isLoaded() {
        return null != this.a && this.a.isReady();
    }

    public void loadWithBid() {
        this.initInterstitial();
        this.onInterstitialStartLoad();
    }

    public void setInMobiBidListener(InMobiBidListener inMobiBidListener) {
        this.b = inMobiBidListener;
    }

    private void a() {
        Long l;
        Context context;
        AdLogUtil.Log().d("inmobi", "initInMobi");
        if (this.mNetwork == null) {
            this.adFailedToLoad(new TAdErrorCode(30003, " network is null"));
            return;
        }
        Context context2 = context = this.mContext == null ? null : (Context)this.mContext.get();
        if (context == null) {
            this.adFailedToLoad(new TAdErrorCode(30003, " context is null"));
            return;
        }
        if (null != this.a) {
            AdLogUtil.Log().d("inmobi", "InMobiInterstitialAd --> null != interstitial ----- loadType = " + this.c);
            return;
        }
        try {
            l = Long.parseLong(this.mNetwork.getCodeSeatId());
        }
        catch (Exception exception) {
            this.adFailedToLoad(new TAdErrorCode(30003, "codeSeatId Exception"));
            return;
        }
        this.a = new InMobiInterstitial(context, l.longValue(), new InterstitialAdEventListener(){

            public void onAdFetchSuccessful(@NonNull InMobiInterstitial inMobiInterstitial, @NonNull AdMetaInfo adMetaInfo) {
                if (null != InMobiInterstitialAd.this.b && InMobiInterstitialAd.this.c == 1) {
                    InMobiInterstitialAd.this.setLoadType(2);
                    InMobiInterstitialAd.this.b.onAdFetchSuccessful(inMobiInterstitial, adMetaInfo);
                } else {
                    AdLogUtil.Log().e("inmobi", "InMobiInterstitialAd --> onAdFetchSuccessful --> null == bidListener ----- loadType = " + InMobiInterstitialAd.this.c);
                }
            }

            public void onAdFetchFailed(@NonNull InMobiInterstitial inMobiInterstitial, @NonNull InMobiAdRequestStatus inMobiAdRequestStatus) {
                if (null != InMobiInterstitialAd.this.b && InMobiInterstitialAd.this.c == 1) {
                    InMobiInterstitialAd.this.setLoadType(2);
                    InMobiInterstitialAd.this.b.onAdFetchFailed(inMobiInterstitial, inMobiAdRequestStatus);
                }
            }

            public void onAdLoadFailed(@NonNull InMobiInterstitial inMobiInterstitial, @NonNull InMobiAdRequestStatus inMobiAdRequestStatus) {
                AdLogUtil.Log().d("inmobi", "InMobiInterstitialAd --> onAdLoadFailed ");
                InMobiInterstitialAd.this.adFailedToLoad(new TAdErrorCode(30003, inMobiAdRequestStatus.getMessage()));
            }

            public void onAdLoadSucceeded(@NonNull InMobiInterstitial inMobiInterstitial, @NonNull AdMetaInfo adMetaInfo) {
                AdLogUtil.Log().d("inmobi", "InMobiInterstitialAd --> onAdLoadSucceeded");
                InMobiInterstitialAd.this.adLoaded();
            }

            public void onAdClicked(@NonNull InMobiInterstitial inMobiInterstitial, Map<Object, Object> map) {
                AdLogUtil.Log().d("inmobi", "InMobiInterstitialAd --> onAdClicked");
                InMobiInterstitialAd.this.adClicked(null);
            }

            public void onAdDismissed(@NonNull InMobiInterstitial inMobiInterstitial) {
                AdLogUtil.Log().d("inmobi", "InMobiInterstitialAd --> onAdDismissed");
                InMobiInterstitialAd.this.adClosed();
            }

            public void onAdDisplayed(@NonNull InMobiInterstitial inMobiInterstitial, @NonNull AdMetaInfo adMetaInfo) {
                AdLogUtil.Log().d("inmobi", "InMobiInterstitialAd --> onAdDisplayed");
                InMobiInterstitialAd.this.adImpression(null);
            }

            public void onAdDisplayFailed(@NonNull InMobiInterstitial inMobiInterstitial) {
                AdLogUtil.Log().d("inmobi", "InMobiInterstitialAd --> onAdDisplayFailed");
                InMobiInterstitialAd.this.onAdShowError(TAdErrorCode.ERROR_SHOW_EXCEPTION);
            }

            public void onAdWillDisplay(@NonNull InMobiInterstitial inMobiInterstitial) {
                AdLogUtil.Log().d("inmobi", "InMobiInterstitialAd --> onAdWillDisplay");
            }

            public void onRewardsUnlocked(@NonNull InMobiInterstitial inMobiInterstitial, Map<Object, Object> map) {
                AdLogUtil.Log().d("inmobi", "InMobiInterstitialAd --> onRewardsUnlocked");
            }

            public void onUserLeftApplication(@NonNull InMobiInterstitial inMobiInterstitial) {
                AdLogUtil.Log().d("inmobi", "InMobiInterstitialAd --> onUserLeftApplication");
            }
        });
    }
}

