/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.ironsource;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.cloud.sdk.commonutil.util.LifecycleUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.common.base.BaseVideo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.ironsource.check.ExistsCheck;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.ISDemandOnlyRewardedVideoListener;

public class IronSourceVideo
extends BaseVideo {
    private boolean a = false;

    public IronSourceVideo(Context context, Network network) {
        super(context, network);
    }

    protected void initVideo() {
    }

    protected void onVideoStartLoad() {
        if (this.mNetwork == null) {
            this.adFailedToLoad(TAdErrorCode.IRON_SOURCE_VIDEO_DEFAULT_ERROR);
            return;
        }
        if (!ExistsCheck.initIronSource(this.mNetwork.getApplicationId())) {
            AdLogUtil.Log().e("iron_source_log", "onVideoStartLoad init fail");
            this.adFailedToLoad(TAdErrorCode.IRON_SOURCE_VIDEO_DEFAULT_ERROR);
            return;
        }
        Activity activity = LifecycleUtil.getMainActivity();
        if (null != activity && null != this.mNetwork && !TextUtils.isEmpty((CharSequence)this.mNetwork.getCodeSeatId())) {
            this.a();
            IronSource.loadISDemandOnlyRewardedVideo((Activity)activity, (String)this.mNetwork.getCodeSeatId());
        } else {
            this.adFailedToLoad(TAdErrorCode.IRON_SOURCE_VIDEO_DEFAULT_ERROR);
            AdLogUtil.Log().e("iron_source_log", "IronSourceVideo --> onVideoStartLoad --> null == mainActivity || null == mNetwork" + this.getLogString());
        }
    }

    protected void onVideoShow() {
        if (null == this.mNetwork || TextUtils.isEmpty((CharSequence)this.mNetwork.getCodeSeatId())) {
            this.onAdShowError(TAdErrorCode.IRON_SOURCE_VIDEO_DEFAULT_ERROR);
            return;
        }
        boolean bl = IronSource.isISDemandOnlyRewardedVideoAvailable((String)this.mNetwork.getCodeSeatId());
        if (bl) {
            this.a();
            IronSource.showISDemandOnlyRewardedVideo((String)this.mNetwork.getCodeSeatId());
        } else {
            AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onVideoShow --> available == false" + this.getLogString());
            this.onAdShowError(TAdErrorCode.IRON_SOURCE_VIDEO_DEFAULT_ERROR);
        }
    }

    public boolean isLoaded() {
        boolean bl = false;
        if (null != this.mNetwork && !TextUtils.isEmpty((CharSequence)this.mNetwork.getCodeSeatId())) {
            bl = IronSource.isISDemandOnlyRewardedVideoAvailable((String)this.mNetwork.getCodeSeatId());
        }
        return bl;
    }

    protected int getTimeOutTime() {
        return 30000;
    }

    public void onTimeOut() {
        this.a = true;
        boolean bl = false;
        if (null != this.mNetwork && !TextUtils.isEmpty((CharSequence)this.mNetwork.getCodeSeatId())) {
            bl = IronSource.isISDemandOnlyRewardedVideoAvailable((String)this.mNetwork.getCodeSeatId());
        }
        if (bl) {
            this.adLoaded();
        } else {
            this.adFailedToLoad(TAdErrorCode.IRON_SOURCE_TIME_OUT_ERROR);
        }
    }

    public void destroyAd() {
        super.destroyAd();
        AdLogUtil.Log().d("iron_source_log", "destroy " + this.getLogString());
    }

    private void a() {
        IronSource.setISDemandOnlyRewardedVideoListener((ISDemandOnlyRewardedVideoListener)new ISDemandOnlyRewardedVideoListener(){

            public void onRewardedVideoAdLoadSuccess(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdLoadSuccess s = " + string + IronSourceVideo.this.getLogString());
                if (!IronSourceVideo.this.a) {
                    Preconditions.runOnMainThread(() -> ((IronSourceVideo)IronSourceVideo.this).adLoaded());
                }
            }

            public void onRewardedVideoAdLoadFailed(String string, IronSourceError ironSourceError) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdLoadFailed s = " + string + "  --- ironSourceError = " + ironSourceError + IronSourceVideo.this.getLogString());
                Preconditions.runOnMainThread(() -> {
                    if (null != ironSourceError && !IronSourceVideo.this.a) {
                        IronSourceVideo.this.adFailedToLoad(new TAdErrorCode(ironSourceError.getErrorCode(), ironSourceError.getErrorMessage()));
                    }
                });
            }

            public void onRewardedVideoAdOpened(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdOpened s = " + string + IronSourceVideo.this.getLogString());
                Preconditions.runOnMainThread(() -> IronSourceVideo.this.adImpression());
            }

            public void onRewardedVideoAdClosed(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdClosed s = " + string + IronSourceVideo.this.getLogString());
                Preconditions.runOnMainThread(() -> IronSourceVideo.this.adClosed());
            }

            public void onRewardedVideoAdShowFailed(String string, IronSourceError ironSourceError) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdShowFailed s = " + string + " ---  ironSourceError = " + ironSourceError + IronSourceVideo.this.getLogString());
                if (null != ironSourceError) {
                    Preconditions.runOnMainThread(() -> IronSourceVideo.this.onAdShowError(new TAdErrorCode(ironSourceError.getErrorCode(), ironSourceError.getErrorMessage())));
                }
            }

            public void onRewardedVideoAdClicked(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdClicked s = " + string + IronSourceVideo.this.getLogString());
                Preconditions.runOnMainThread(() -> IronSourceVideo.this.adClicked());
            }

            public void onRewardedVideoAdRewarded(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdRewarded s = " + string + IronSourceVideo.this.getLogString());
                Preconditions.runOnMainThread(() -> IronSourceVideo.this.onReward());
            }
        });
    }
}

