/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.ironsource;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.cloud.sdk.commonutil.util.LifecycleUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.common.base.BaseInterstitial;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.ironsource.check.ExistsCheck;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.demandOnly.ISDemandOnlyInterstitialListener;
import com.ironsource.mediationsdk.logger.IronSourceError;

public class IronSourceInterstitial
extends BaseInterstitial {
    private boolean a = false;

    public IronSourceInterstitial(Context context, Network network) {
        super(context, network);
    }

    private void a() {
        IronSource.setISDemandOnlyInterstitialListener((ISDemandOnlyInterstitialListener)new ISDemandOnlyInterstitialListener(){

            public void onInterstitialAdReady(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onInterstitialAdReady instanceId = " + string + IronSourceInterstitial.this.getLogString());
                if (!IronSourceInterstitial.this.a) {
                    Preconditions.runOnMainThread(() -> ((IronSourceInterstitial)IronSourceInterstitial.this).adLoaded());
                }
            }

            public void onInterstitialAdLoadFailed(String string, IronSourceError ironSourceError) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onInterstitialAdLoadFailed --> instanceId = " + string + " --- error = " + ironSourceError + IronSourceInterstitial.this.getLogString());
                if (ironSourceError != null && !IronSourceInterstitial.this.a) {
                    Preconditions.runOnMainThread(() -> {
                        IronSourceError ironSourceError2 = ironSourceError;
                        int n = ironSourceError2.getErrorCode();
                        IronSourceInterstitial.this.adFailedToLoad(new TAdErrorCode(n, ironSourceError2.getErrorMessage()));
                    });
                }
            }

            public void onInterstitialAdOpened(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onInterstitialAdOpened instanceId = " + string + IronSourceInterstitial.this.getLogString());
                Preconditions.runOnMainThread(() -> ((IronSourceInterstitial)IronSourceInterstitial.this).adImpression());
            }

            public void onInterstitialAdClosed(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onInterstitialAdClosed instanceId = " + string + IronSourceInterstitial.this.getLogString());
                Preconditions.runOnMainThread(() -> IronSourceInterstitial.this.adClosed());
            }

            public void onInterstitialAdShowFailed(String string, IronSourceError ironSourceError) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onRewardedVideoAdShowFailed " + ironSourceError + IronSourceInterstitial.this.getLogString());
                if (ironSourceError != null) {
                    Preconditions.runOnMainThread(() -> IronSourceInterstitial.this.onAdShowError(new TAdErrorCode(ironSourceError.getErrorCode(), "IronSourceInterstitial --> ironSourceError : " + ironSourceError.getErrorMessage())));
                }
            }

            public void onInterstitialAdClicked(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onInterstitialAdClicked instanceId = " + string + IronSourceInterstitial.this.getLogString());
                Preconditions.runOnMainThread(() -> ((IronSourceInterstitial)IronSourceInterstitial.this).adClicked());
            }
        });
    }

    protected void initInterstitial() {
    }

    protected void onInterstitialStartLoad() {
        Network network;
        Network network2 = this.mNetwork;
        if (network2 == null) {
            this.adFailedToLoad(TAdErrorCode.IRON_SOURCE_INTERSTITIAL_DEFAULT_ERROR);
            return;
        }
        if (!ExistsCheck.initIronSource(network2.getApplicationId())) {
            AdLogUtil.Log().e("iron_source_log", "onInterstitialStartLoad init fail");
            this.adFailedToLoad(TAdErrorCode.IRON_SOURCE_INTERSTITIAL_DEFAULT_ERROR);
            return;
        }
        network2 = LifecycleUtil.getMainActivity();
        if (network2 != null && (network = this.mNetwork) != null && !TextUtils.isEmpty((CharSequence)network.getCodeSeatId())) {
            IronSourceInterstitial ironSourceInterstitial = this;
            ironSourceInterstitial.a();
            IronSource.loadISDemandOnlyInterstitial((Activity)network2, (String)ironSourceInterstitial.mNetwork.getCodeSeatId());
        } else {
            this.adFailedToLoad(TAdErrorCode.IRON_SOURCE_INTERSTITIAL_DEFAULT_ERROR);
            AdLogUtil.Log().e("iron_source_log", "IronSourceInterstitial --> onInterstitialStartLoad --> null == mainActivity || null == mNetwork" + this.getLogString());
        }
    }

    protected void onInterstitialShow(Activity activity) {
        activity = this.mNetwork;
        if (activity != null && !TextUtils.isEmpty((CharSequence)activity.getCodeSeatId())) {
            if (IronSource.isISDemandOnlyInterstitialReady((String)this.mNetwork.getCodeSeatId())) {
                IronSourceInterstitial ironSourceInterstitial = this;
                ironSourceInterstitial.a();
                IronSource.showISDemandOnlyInterstitial((String)ironSourceInterstitial.mNetwork.getCodeSeatId());
            } else {
                this.onAdShowError(TAdErrorCode.IRON_SOURCE_INTERSTITIAL_DEFAULT_ERROR);
            }
            return;
        }
        this.onAdShowError(TAdErrorCode.IRON_SOURCE_INTERSTITIAL_DEFAULT_ERROR);
    }

    public boolean isLoaded() {
        boolean bl = false;
        Network network = this.mNetwork;
        if (network != null && !TextUtils.isEmpty((CharSequence)network.getCodeSeatId())) {
            bl = IronSource.isISDemandOnlyInterstitialReady((String)this.mNetwork.getCodeSeatId());
        }
        return bl;
    }

    protected int getTimeOutTime() {
        return 30000;
    }

    public void onTimeOut() {
        this.a = true;
        boolean bl = false;
        Network network = this.mNetwork;
        if (network != null && !TextUtils.isEmpty((CharSequence)network.getCodeSeatId())) {
            bl = IronSource.isISDemandOnlyInterstitialReady((String)this.mNetwork.getCodeSeatId());
        }
        if (bl) {
            this.adLoaded();
        } else {
            this.adFailedToLoad(TAdErrorCode.IRON_SOURCE_TIME_OUT_ERROR);
        }
    }

    public void destroyAd() {
        super.destroyAd();
        AdLogUtil.Log().d("iron_source_log", "destroy " + this.getLogString());
    }
}

