/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.ironsource;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.cloud.sdk.commonutil.util.LifecycleUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.common.base.BaseVideo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.ironsource.check.ExistsCheck;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.demandOnly.ISDemandOnlyRewardedVideoListener;
import com.ironsource.mediationsdk.logger.IronSourceError;

public class IronSourceVideo
extends BaseVideo {
    private boolean a = false;

    public IronSourceVideo(Context context, Network network) {
        super(context, network);
    }

    private void a() {
        IronSource.setISDemandOnlyRewardedVideoListener((ISDemandOnlyRewardedVideoListener)new ISDemandOnlyRewardedVideoListener(){

            public void onRewardedVideoAdLoadSuccess(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdLoadSuccess s = " + string + IronSourceVideo.this.getLogString());
                if (!IronSourceVideo.this.a) {
                    Preconditions.runOnMainThread(() -> ((IronSourceVideo)IronSourceVideo.this).adLoaded());
                }
            }

            public void onRewardedVideoAdLoadFailed(String string, IronSourceError ironSourceError) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdLoadFailed s = " + string + "  --- ironSourceError = " + ironSourceError + IronSourceVideo.this.getLogString());
                Preconditions.runOnMainThread(() -> {
                    if (ironSourceError != null && !IronSourceVideo.this.a) {
                        IronSourceError ironSourceError2 = ironSourceError;
                        int n = ironSourceError2.getErrorCode();
                        IronSourceVideo.this.adFailedToLoad(new TAdErrorCode(n, ironSourceError2.getErrorMessage()));
                    }
                });
            }

            public void onRewardedVideoAdOpened(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdOpened s = " + string + IronSourceVideo.this.getLogString());
                Preconditions.runOnMainThread(() -> ((IronSourceVideo)IronSourceVideo.this).adImpression());
            }

            public void onRewardedVideoAdClosed(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdClosed s = " + string + IronSourceVideo.this.getLogString());
                Preconditions.runOnMainThread(() -> IronSourceVideo.this.adClosed());
            }

            public void onRewardedVideoAdShowFailed(String string, IronSourceError ironSourceError) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdShowFailed s = " + string + " ---  ironSourceError = " + ironSourceError + IronSourceVideo.this.getLogString());
                if (ironSourceError != null) {
                    Preconditions.runOnMainThread(() -> {
                        IronSourceError ironSourceError2 = ironSourceError;
                        int n = ironSourceError2.getErrorCode();
                        IronSourceVideo.this.onAdShowError(new TAdErrorCode(n, ironSourceError2.getErrorMessage()));
                    });
                }
            }

            public void onRewardedVideoAdClicked(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdClicked s = " + string + IronSourceVideo.this.getLogString());
                Preconditions.runOnMainThread(() -> ((IronSourceVideo)IronSourceVideo.this).adClicked());
            }

            public void onRewardedVideoAdRewarded(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdRewarded s = " + string + IronSourceVideo.this.getLogString());
                Preconditions.runOnMainThread(() -> IronSourceVideo.this.onReward());
            }
        });
    }

    protected void initVideo() {
    }

    protected void onVideoStartLoad() {
        Network network;
        Network network2 = this.mNetwork;
        if (network2 == null) {
            this.adFailedToLoad(TAdErrorCode.IRON_SOURCE_VIDEO_DEFAULT_ERROR);
            return;
        }
        if (!ExistsCheck.initIronSource(network2.getApplicationId())) {
            AdLogUtil.Log().e("iron_source_log", "onVideoStartLoad init fail");
            this.adFailedToLoad(TAdErrorCode.IRON_SOURCE_VIDEO_DEFAULT_ERROR);
            return;
        }
        network2 = LifecycleUtil.getMainActivity();
        if (network2 != null && (network = this.mNetwork) != null && !TextUtils.isEmpty((CharSequence)network.getCodeSeatId())) {
            IronSourceVideo ironSourceVideo = this;
            ironSourceVideo.a();
            IronSource.loadISDemandOnlyRewardedVideo((Activity)network2, (String)ironSourceVideo.mNetwork.getCodeSeatId());
        } else {
            this.adFailedToLoad(TAdErrorCode.IRON_SOURCE_VIDEO_DEFAULT_ERROR);
            AdLogUtil.Log().e("iron_source_log", "IronSourceVideo --> onVideoStartLoad --> null == mainActivity || null == mNetwork" + this.getLogString());
        }
    }

    protected void onVideoShow() {
        Network network = this.mNetwork;
        if (network != null && !TextUtils.isEmpty((CharSequence)network.getCodeSeatId())) {
            if (IronSource.isISDemandOnlyRewardedVideoAvailable((String)this.mNetwork.getCodeSeatId())) {
                IronSourceVideo ironSourceVideo = this;
                ironSourceVideo.a();
                IronSource.showISDemandOnlyRewardedVideo((String)ironSourceVideo.mNetwork.getCodeSeatId());
            } else {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onVideoShow --> available == false" + this.getLogString());
                this.onAdShowError(TAdErrorCode.IRON_SOURCE_VIDEO_DEFAULT_ERROR);
            }
            return;
        }
        this.onAdShowError(TAdErrorCode.IRON_SOURCE_VIDEO_DEFAULT_ERROR);
    }

    public boolean isLoaded() {
        boolean bl = false;
        Network network = this.mNetwork;
        if (network != null && !TextUtils.isEmpty((CharSequence)network.getCodeSeatId())) {
            bl = IronSource.isISDemandOnlyRewardedVideoAvailable((String)this.mNetwork.getCodeSeatId());
        }
        return bl;
    }

    protected int getTimeOutTime() {
        return 30000;
    }

    public void onTimeOut() {
        this.a = true;
        boolean bl = false;
        Network network = this.mNetwork;
        if (network != null && !TextUtils.isEmpty((CharSequence)network.getCodeSeatId())) {
            bl = IronSource.isISDemandOnlyRewardedVideoAvailable((String)this.mNetwork.getCodeSeatId());
        }
        if (bl) {
            this.adLoaded();
        } else {
            this.adFailedToLoad(TAdErrorCode.IRON_SOURCE_TIME_OUT_ERROR);
        }
    }

    public void destroyAd() {
        super.destroyAd();
        AdLogUtil.Log().d("iron_source_log", "destroy " + this.getLogString());
    }
}

