/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.ironsource;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.cloud.sdk.commonutil.util.LifecycleUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.common.base.BaseInterstitial;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.ironsource.check.ExistsCheck;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.ISDemandOnlyInterstitialListener;

public class IronSourceInterstitial
extends BaseInterstitial {
    private boolean a = false;

    public IronSourceInterstitial(Context context, Network network) {
        super(context, network);
    }

    protected void initInterstitial() {
    }

    protected void onInterstitialStartLoad() {
        if (this.mNetwork == null) {
            this.adFailedToLoad(TAdErrorCode.IRON_SOURCE_INTERSTITIAL_DEFAULT_ERROR);
            return;
        }
        if (!ExistsCheck.initIronSource(this.mNetwork.getApplicationId())) {
            AdLogUtil.Log().e("iron_source_log", "onInterstitialStartLoad init fail");
            this.adFailedToLoad(TAdErrorCode.IRON_SOURCE_INTERSTITIAL_DEFAULT_ERROR);
            return;
        }
        Activity activity = LifecycleUtil.getMainActivity();
        if (null != activity && !TextUtils.isEmpty((CharSequence)this.mNetwork.getCodeSeatId())) {
            this.a();
            IronSource.loadISDemandOnlyInterstitial((Activity)activity, (String)this.mNetwork.getCodeSeatId());
        } else {
            this.adFailedToLoad(TAdErrorCode.IRON_SOURCE_INTERSTITIAL_DEFAULT_ERROR);
            AdLogUtil.Log().e("iron_source_log", "IronSourceInterstitial --> onInterstitialStartLoad --> null == mainActivity || null == mNetwork" + this.getLogString());
        }
    }

    protected void onInterstitialShow(Activity activity) {
        if (null == this.mNetwork || TextUtils.isEmpty((CharSequence)this.mNetwork.getCodeSeatId())) {
            this.onAdShowError(TAdErrorCode.IRON_SOURCE_INTERSTITIAL_DEFAULT_ERROR);
            return;
        }
        boolean bl = IronSource.isISDemandOnlyInterstitialReady((String)this.mNetwork.getCodeSeatId());
        if (bl) {
            this.a();
            IronSource.showISDemandOnlyInterstitial((String)this.mNetwork.getCodeSeatId());
        } else {
            this.onAdShowError(TAdErrorCode.IRON_SOURCE_INTERSTITIAL_DEFAULT_ERROR);
        }
    }

    public boolean isLoaded() {
        boolean bl = false;
        if (null != this.mNetwork && !TextUtils.isEmpty((CharSequence)this.mNetwork.getCodeSeatId())) {
            bl = IronSource.isISDemandOnlyInterstitialReady((String)this.mNetwork.getCodeSeatId());
        }
        return bl;
    }

    protected int getTimeOutTime() {
        return 30000;
    }

    public void onTimeOut() {
        this.a = true;
        boolean bl = false;
        if (null != this.mNetwork && !TextUtils.isEmpty((CharSequence)this.mNetwork.getCodeSeatId())) {
            bl = IronSource.isISDemandOnlyInterstitialReady((String)this.mNetwork.getCodeSeatId());
        }
        if (bl) {
            this.adLoaded();
        } else {
            this.adFailedToLoad(TAdErrorCode.IRON_SOURCE_TIME_OUT_ERROR);
        }
    }

    public void destroyAd() {
        super.destroyAd();
        AdLogUtil.Log().d("iron_source_log", "destroy " + this.getLogString());
    }

    private void a() {
        IronSource.setISDemandOnlyInterstitialListener((ISDemandOnlyInterstitialListener)new ISDemandOnlyInterstitialListener(){

            public void onInterstitialAdReady(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onInterstitialAdReady instanceId = " + string + IronSourceInterstitial.this.getLogString());
                if (!IronSourceInterstitial.this.a) {
                    Preconditions.runOnMainThread(() -> ((IronSourceInterstitial)IronSourceInterstitial.this).adLoaded());
                }
            }

            public void onInterstitialAdLoadFailed(String string, IronSourceError ironSourceError) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onInterstitialAdLoadFailed --> instanceId = " + string + " --- error = " + ironSourceError + IronSourceInterstitial.this.getLogString());
                if (null != ironSourceError && !IronSourceInterstitial.this.a) {
                    Preconditions.runOnMainThread(() -> IronSourceInterstitial.this.adFailedToLoad(new TAdErrorCode(ironSourceError.getErrorCode(), ironSourceError.getErrorMessage())));
                }
            }

            public void onInterstitialAdOpened(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onInterstitialAdOpened instanceId = " + string + IronSourceInterstitial.this.getLogString());
                Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

                    public void onRun() {
                        IronSourceInterstitial.this.adImpression(null);
                    }
                });
            }

            public void onInterstitialAdClosed(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onInterstitialAdClosed instanceId = " + string + IronSourceInterstitial.this.getLogString());
                Preconditions.runOnMainThread(() -> IronSourceInterstitial.this.adClosed());
            }

            public void onInterstitialAdShowFailed(String string, IronSourceError ironSourceError) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onRewardedVideoAdShowFailed " + ironSourceError + IronSourceInterstitial.this.getLogString());
                if (null != ironSourceError) {
                    Preconditions.runOnMainThread(() -> IronSourceInterstitial.this.onAdShowError(new TAdErrorCode(ironSourceError.getErrorCode(), "IronSourceInterstitial --> ironSourceError : " + ironSourceError.getErrorMessage())));
                }
            }

            public void onInterstitialAdClicked(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onInterstitialAdClicked instanceId = " + string + IronSourceInterstitial.this.getLogString());
                Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

                    public void onRun() {
                        IronSourceInterstitial.this.adClicked(null);
                    }
                });
            }
        });
    }
}

