/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.ironsource;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.cloud.sdk.commonutil.util.LifecycleUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.common.base.BaseInterstitial;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.ironsource.check.ExistsCheck;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.demandOnly.ISDemandOnlyInterstitialListener;
import com.ironsource.mediationsdk.logger.IronSourceError;

public class IronSourceInterstitial
extends BaseInterstitial {
    private boolean a = false;

    public IronSourceInterstitial(Context context, Network network) {
        super(context, network);
    }

    private void a() {
        IronSource.setISDemandOnlyInterstitialListener((ISDemandOnlyInterstitialListener)new ISDemandOnlyInterstitialListener(){

            public void onInterstitialAdReady(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onInterstitialAdReady instanceId = " + string + IronSourceInterstitial.this.getLogString());
                if (!IronSourceInterstitial.this.a) {
                    Preconditions.runOnMainThread(() -> ((IronSourceInterstitial)IronSourceInterstitial.this).adLoaded());
                }
            }

            public void onInterstitialAdLoadFailed(String string, IronSourceError ironSourceError) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onInterstitialAdLoadFailed --> instanceId = " + string + " --- error = " + ironSourceError + IronSourceInterstitial.this.getLogString());
                if (ironSourceError != null && !IronSourceInterstitial.this.a) {
                    Preconditions.runOnMainThread(() -> {
                        IronSourceError ironSourceError2 = ironSourceError;
                        int n = ironSourceError2.getErrorCode();
                        IronSourceInterstitial.this.adFailedToLoad(new TAdErrorCode(n, ironSourceError2.getErrorMessage()));
                    });
                }
            }

            public void onInterstitialAdOpened(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onInterstitialAdOpened instanceId = " + string + IronSourceInterstitial.this.getLogString());
                Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

                    public void onRun() {
                        IronSourceInterstitial.this.adImpression(null);
                    }
                });
            }

            public void onInterstitialAdClosed(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onInterstitialAdClosed instanceId = " + string + IronSourceInterstitial.this.getLogString());
                Preconditions.runOnMainThread(() -> IronSourceInterstitial.this.adClosed());
            }

            public void onInterstitialAdShowFailed(String string, IronSourceError ironSourceError) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onRewardedVideoAdShowFailed " + ironSourceError + IronSourceInterstitial.this.getLogString());
                if (ironSourceError != null) {
                    Preconditions.runOnMainThread(() -> IronSourceInterstitial.this.onAdShowError(new TAdErrorCode(ironSourceError.getErrorCode(), "IronSourceInterstitial --> ironSourceError : " + ironSourceError.getErrorMessage())));
                }
            }

            public void onInterstitialAdClicked(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceInterstitial --> onInterstitialAdClicked instanceId = " + string + IronSourceInterstitial.this.getLogString());
                Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

                    public void onRun() {
                        IronSourceInterstitial.this.adClicked(null);
                    }
                });
            }
        });
    }

    protected void initInterstitial() {
    }

    protected void onInterstitialStartLoad() {
        Network network = ironSourceInterstitial2.mNetwork;
        if (network == null) {
            TAdErrorCode tAdErrorCode;
            IronSourceInterstitial ironSourceInterstitial = ironSourceInterstitial2;
            IronSourceInterstitial ironSourceInterstitial2 = tAdErrorCode;
            tAdErrorCode = new TAdErrorCode(30003, "network is null");
            ironSourceInterstitial.adFailedToLoad((TAdErrorCode)ironSourceInterstitial2);
            return;
        }
        if (!ExistsCheck.initIronSource(network.getApplicationId())) {
            AdLogUtil.Log().e("iron_source_log", "onInterstitialStartLoad init fail");
            ironSourceInterstitial2.adFailedToLoad(TAdErrorCode.ERROR_AD_SOURCE_INIT_FAILED);
            return;
        }
        network = LifecycleUtil.getMainActivity();
        if (network != null && !TextUtils.isEmpty((CharSequence)ironSourceInterstitial2.mNetwork.getCodeSeatId())) {
            IronSourceInterstitial ironSourceInterstitial = ironSourceInterstitial2;
            ironSourceInterstitial.a();
            IronSource.loadISDemandOnlyInterstitial((Activity)network, (String)ironSourceInterstitial.mNetwork.getCodeSeatId());
        } else {
            ironSourceInterstitial2.adFailedToLoad(new TAdErrorCode(30003, "code seat id is null"));
            AdLogUtil.Log().e("iron_source_log", "IronSourceInterstitial --> onInterstitialStartLoad --> null == mainActivity || null == mNetwork" + ironSourceInterstitial2.getLogString());
        }
    }

    protected void onInterstitialShow(Activity activity) {
        activity = this.mNetwork;
        if (activity != null && !TextUtils.isEmpty((CharSequence)activity.getCodeSeatId())) {
            if (IronSource.isISDemandOnlyInterstitialReady((String)this.mNetwork.getCodeSeatId())) {
                IronSourceInterstitial ironSourceInterstitial = this;
                ironSourceInterstitial.a();
                IronSource.showISDemandOnlyInterstitial((String)ironSourceInterstitial.mNetwork.getCodeSeatId());
            } else {
                this.onAdShowError(TAdErrorCode.ERROR_SHOW_EXCEPTION);
            }
            return;
        }
        this.onAdShowError(TAdErrorCode.ERROR_SHOW_EXCEPTION);
    }

    public boolean isLoaded() {
        boolean bl = false;
        Network network = this.mNetwork;
        if (network != null && !TextUtils.isEmpty((CharSequence)network.getCodeSeatId())) {
            bl = IronSource.isISDemandOnlyInterstitialReady((String)this.mNetwork.getCodeSeatId());
        }
        return bl;
    }

    protected int getTimeOutTime() {
        return 30000;
    }

    public void onTimeOut() {
        this.a = true;
        boolean bl = false;
        Network network = this.mNetwork;
        if (network != null && !TextUtils.isEmpty((CharSequence)network.getCodeSeatId())) {
            bl = IronSource.isISDemandOnlyInterstitialReady((String)this.mNetwork.getCodeSeatId());
        }
        if (bl) {
            this.adLoaded();
        } else {
            this.adFailedToLoad(TAdErrorCode.ERROR_AD_REQUEST_TIME_OUT);
        }
    }

    public void destroyAd() {
        super.destroyAd();
        AdLogUtil.Log().d("iron_source_log", "destroy " + this.getLogString());
    }
}

