/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.ironsource;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.cloud.sdk.commonutil.util.LifecycleUtil;
import com.cloud.sdk.commonutil.util.Preconditions;
import com.hisavana.common.base.BaseVideo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.ironsource.check.ExistsCheck;
import com.ironsource.environment.ContextProvider;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.demandOnly.ISDemandOnlyRewardedVideoListener;
import com.ironsource.mediationsdk.logger.IronSourceError;

public class IronSourceVideo
extends BaseVideo {
    private boolean a = false;

    public IronSourceVideo(Context context, Network network) {
        super(context, network);
    }

    private void a() {
        IronSource.setISDemandOnlyRewardedVideoListener((ISDemandOnlyRewardedVideoListener)new ISDemandOnlyRewardedVideoListener(){

            public void onRewardedVideoAdLoadSuccess(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdLoadSuccess s = " + string + IronSourceVideo.this.getLogString());
                if (!IronSourceVideo.this.a) {
                    Preconditions.runOnMainThread(() -> ((IronSourceVideo)IronSourceVideo.this).adLoaded());
                }
                ContextProvider.getInstance().updateActivity(null);
            }

            public void onRewardedVideoAdLoadFailed(String string, IronSourceError ironSourceError) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdLoadFailed s = " + string + "  --- ironSourceError = " + ironSourceError + IronSourceVideo.this.getLogString());
                Preconditions.runOnMainThread(() -> {
                    if (ironSourceError != null && !IronSourceVideo.this.a) {
                        IronSourceError ironSourceError2 = ironSourceError;
                        int n = ironSourceError2.getErrorCode();
                        IronSourceVideo.this.adFailedToLoad(new TAdErrorCode(n, ironSourceError2.getErrorMessage()));
                    }
                });
                ContextProvider.getInstance().updateActivity(null);
            }

            public void onRewardedVideoAdOpened(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdOpened s = " + string + IronSourceVideo.this.getLogString());
                Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

                    public void onRun() {
                        IronSourceVideo.this.adImpression(null);
                    }
                });
                ContextProvider.getInstance().updateActivity(null);
            }

            public void onRewardedVideoAdClosed(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdClosed s = " + string + IronSourceVideo.this.getLogString());
                Preconditions.runOnMainThread(() -> IronSourceVideo.this.adClosed());
                ContextProvider.getInstance().updateActivity(null);
            }

            public void onRewardedVideoAdShowFailed(String string, IronSourceError ironSourceError) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdShowFailed s = " + string + " ---  ironSourceError = " + ironSourceError + IronSourceVideo.this.getLogString());
                if (ironSourceError != null) {
                    Preconditions.runOnMainThread(() -> {
                        IronSourceError ironSourceError2 = ironSourceError;
                        int n = ironSourceError2.getErrorCode();
                        IronSourceVideo.this.onAdShowError(new TAdErrorCode(n, ironSourceError2.getErrorMessage()));
                    });
                    ContextProvider.getInstance().updateActivity(null);
                }
            }

            public void onRewardedVideoAdClicked(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdClicked s = " + string + IronSourceVideo.this.getLogString());
                Preconditions.runOnMainThread((Preconditions.Callback)new Preconditions.Callback(){

                    public void onRun() {
                        IronSourceVideo.this.adClicked(null);
                    }
                });
            }

            public void onRewardedVideoAdRewarded(String string) {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onRewardedVideoAdRewarded s = " + string + IronSourceVideo.this.getLogString());
                Preconditions.runOnMainThread(() -> IronSourceVideo.this.onReward());
                ContextProvider.getInstance().updateActivity(null);
            }
        });
    }

    protected void initVideo() {
    }

    protected void onVideoStartLoad() {
        Network network = ironSourceVideo2.mNetwork;
        if (network == null) {
            TAdErrorCode tAdErrorCode;
            IronSourceVideo ironSourceVideo = ironSourceVideo2;
            IronSourceVideo ironSourceVideo2 = tAdErrorCode;
            tAdErrorCode = new TAdErrorCode(30003, "network is null");
            ironSourceVideo.adFailedToLoad((TAdErrorCode)ironSourceVideo2);
            return;
        }
        if (!ExistsCheck.initIronSource(network.getApplicationId())) {
            AdLogUtil.Log().e("iron_source_log", "onVideoStartLoad init fail");
            ironSourceVideo2.adFailedToLoad(TAdErrorCode.ERROR_AD_SOURCE_INIT_FAILED);
            return;
        }
        network = LifecycleUtil.getMainActivity();
        if (network != null && !TextUtils.isEmpty((CharSequence)ironSourceVideo2.mNetwork.getCodeSeatId())) {
            IronSourceVideo ironSourceVideo = ironSourceVideo2;
            ironSourceVideo.a();
            IronSource.loadISDemandOnlyRewardedVideo((Activity)network, (String)ironSourceVideo.mNetwork.getCodeSeatId());
        } else {
            ironSourceVideo2.adFailedToLoad(new TAdErrorCode(30003, "code seat id is null"));
            AdLogUtil.Log().e("iron_source_log", "IronSourceVideo --> onVideoStartLoad --> null == mainActivity || null == mNetwork" + ironSourceVideo2.getLogString());
        }
    }

    protected void onVideoShow(Activity activity) {
        activity = this.mNetwork;
        if (activity != null && !TextUtils.isEmpty((CharSequence)activity.getCodeSeatId())) {
            if (IronSource.isISDemandOnlyRewardedVideoAvailable((String)this.mNetwork.getCodeSeatId())) {
                IronSourceVideo ironSourceVideo = this;
                ironSourceVideo.a();
                IronSource.showISDemandOnlyRewardedVideo((String)ironSourceVideo.mNetwork.getCodeSeatId());
            } else {
                AdLogUtil.Log().d("iron_source_log", "IronSourceVideo --> onVideoShow --> available == false" + this.getLogString());
                this.onAdShowError(TAdErrorCode.ERROR_SHOW_EXCEPTION);
            }
            return;
        }
        this.onAdShowError(TAdErrorCode.ERROR_SHOW_EXCEPTION);
    }

    public boolean isLoaded() {
        boolean bl = false;
        Network network = this.mNetwork;
        if (network != null && !TextUtils.isEmpty((CharSequence)network.getCodeSeatId())) {
            bl = IronSource.isISDemandOnlyRewardedVideoAvailable((String)this.mNetwork.getCodeSeatId());
        }
        return bl;
    }

    protected int getTimeOutTime() {
        return 30000;
    }

    public void onTimeOut() {
        this.a = true;
        boolean bl = false;
        Network network = this.mNetwork;
        if (network != null && !TextUtils.isEmpty((CharSequence)network.getCodeSeatId())) {
            bl = IronSource.isISDemandOnlyRewardedVideoAvailable((String)this.mNetwork.getCodeSeatId());
        }
        if (bl) {
            this.adLoaded();
        } else {
            this.adFailedToLoad(TAdErrorCode.ERROR_AD_REQUEST_TIME_OUT);
        }
    }

    public void destroyAd() {
        super.destroyAd();
        ContextProvider.getInstance().updateActivity(null);
        AdLogUtil.Log().d("iron_source_log", "destroy " + this.getLogString());
    }
}

