/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.ironsource.excuter;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import com.hisavana.common.base.BaseBanner;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.hisavana.ironsource.check.ExistsCheck;
import com.unity3d.mediation.LevelPlayAdError;
import com.unity3d.mediation.LevelPlayAdInfo;
import com.unity3d.mediation.LevelPlayAdSize;
import com.unity3d.mediation.LevelPlayConfiguration;
import com.unity3d.mediation.LevelPlayInitError;
import com.unity3d.mediation.LevelPlayInitListener;
import com.unity3d.mediation.banner.LevelPlayBannerAdView;
import com.unity3d.mediation.banner.LevelPlayBannerAdViewListener;
import java.lang.ref.WeakReference;

public class IronSourceBanner
extends BaseBanner {
    private String a = "IronSourceInterstitial";
    private LevelPlayBannerAdView b;
    private final int c;

    public IronSourceBanner(Context context, Network network, int n) {
        super(context, network);
        this.c = n;
    }

    protected View getBanner() {
        WeakReference weakReference = this.mContext;
        weakReference = weakReference == null ? null : (Context)weakReference.get();
        if (weakReference != null && this.mNetwork != null) {
            if (this.b == null) {
                LevelPlayBannerAdView levelPlayBannerAdView;
                LevelPlayBannerAdView levelPlayBannerAdView2;
                LevelPlayAdSize levelPlayAdSize;
                switch (this.c) {
                    default: {
                        levelPlayAdSize = LevelPlayAdSize.BANNER;
                        break;
                    }
                    case 2: {
                        levelPlayAdSize = LevelPlayAdSize.MEDIUM_RECTANGLE;
                        break;
                    }
                    case 1: 
                    case 3: {
                        levelPlayAdSize = LevelPlayAdSize.LARGE;
                        break;
                    }
                    case 0: {
                        levelPlayAdSize = LevelPlayAdSize.BANNER;
                    }
                }
                LevelPlayBannerAdView levelPlayBannerAdView3 = levelPlayBannerAdView2 = levelPlayBannerAdView;
                levelPlayBannerAdView3((Context)weakReference, this.mNetwork.getCodeSeatId());
                this.b = levelPlayBannerAdView3;
                levelPlayBannerAdView.setAdSize(levelPlayAdSize);
                this.b.setBannerListener(new LevelPlayBannerAdViewListener(){

                    public void onAdLoaded(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
                        double d;
                        AdLogUtil.Log().d(IronSourceBanner.this.a, "onAdLoaded, levelPlayAdInfo=" + levelPlayAdInfo);
                        double d2 = levelPlayAdInfo.getRevenue();
                        if (d > 0.0) {
                            IronSourceBanner.this.setEcpmPrice(d2 * 1000.0 * 100.0);
                        }
                        IronSourceBanner.this.adLoaded();
                    }

                    public void onAdLoadFailed(@NonNull LevelPlayAdError levelPlayAdError) {
                        AdLogUtil.Log().d(IronSourceBanner.this.a, "onAdLoadFailed, LevelPlayAdError=" + levelPlayAdError);
                        LevelPlayAdError levelPlayAdError2 = levelPlayAdError;
                        int n = levelPlayAdError2.getErrorCode();
                        IronSourceBanner.this.adFailedToLoad(new TAdErrorCode(n, levelPlayAdError2.getErrorMessage()));
                    }

                    public void onAdDisplayed(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
                        AdLogUtil.Log().d(IronSourceBanner.this.a, "onAdDisplayed, LevelPlayAdError=" + levelPlayAdInfo);
                        IronSourceBanner.this.adImpression(null);
                    }

                    public void onAdDisplayFailed(@NonNull LevelPlayAdInfo levelPlayAdInfo, @NonNull LevelPlayAdError levelPlayAdError) {
                        AdLogUtil.Log().d(IronSourceBanner.this.a, "onAdDisplayFailed, LevelPlayAdError=" + levelPlayAdError + ", LevelPlayAdInfo = " + levelPlayAdInfo);
                        LevelPlayAdError levelPlayAdError2 = levelPlayAdError;
                        int n = levelPlayAdError2.getErrorCode();
                        IronSourceBanner.this.onAdShowError(new TAdErrorCode(n, levelPlayAdError2.getErrorMessage()));
                    }

                    public void onAdClicked(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
                        AdLogUtil.Log().d(IronSourceBanner.this.a, "onAdClicked, LevelPlayAdInfo = " + levelPlayAdInfo);
                        IronSourceBanner.this.adClicked(null);
                    }

                    public void onAdExpanded(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
                        AdLogUtil.Log().d(IronSourceBanner.this.a, "onAdExpanded, LevelPlayAdInfo = " + levelPlayAdInfo);
                    }

                    public void onAdCollapsed(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
                        AdLogUtil.Log().d(IronSourceBanner.this.a, "onAdCollapsed, LevelPlayAdInfo = " + levelPlayAdInfo);
                    }

                    public void onAdLeftApplication(@NonNull LevelPlayAdInfo levelPlayAdInfo) {
                        AdLogUtil.Log().d(IronSourceBanner.this.a, "onAdLeftApplication, LevelPlayAdInfo = " + levelPlayAdInfo);
                    }
                });
            }
            return this.b;
        }
        return this.b;
    }

    protected void onBannerLoad() {
        Network network;
        if (this.b != null && (network = this.mNetwork) != null) {
            ExistsCheck.initIronSource(network.getApplicationId(), new LevelPlayInitListener(){

                public void onInitSuccess(@NonNull LevelPlayConfiguration levelPlayConfiguration) {
                    IronSourceBanner.this.b.loadAd();
                }

                public void onInitFailed(@NonNull LevelPlayInitError levelPlayInitError) {
                    LevelPlayInitError levelPlayInitError2 = levelPlayInitError;
                    int n = levelPlayInitError2.getErrorCode();
                    IronSourceBanner.this.adFailedToLoad(new TAdErrorCode(n, levelPlayInitError2.getErrorMessage()));
                }
            });
            return;
        }
        AdLogUtil.Log().w(this.a, "load error: bannerAdView is " + this.b + this.getLogString());
        this.adFailedToLoad(TAdErrorCode.ERROR_AD_REQUEST_FAILED);
    }

    protected void showBanner() {
    }

    protected void onBannerDestroy() {
        LevelPlayBannerAdView levelPlayBannerAdView = this.b;
        if (levelPlayBannerAdView != null) {
            levelPlayBannerAdView.destroy();
        }
        AdLogUtil.Log().d(this.a, "banner destroy" + this.getLogString());
    }
}

