/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.mediation.ad;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.RunTimer;
import com.hisavana.common.base.BaseAd;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.bean.TAdRequestBody;
import com.hisavana.common.interfacz.Iad;
import com.hisavana.common.interfacz.TAdListener;
import com.hisavana.common.tracking.TrackingManager;
import com.hisavana.common.tracking.TrackingUtil;
import com.hisavana.mediation.a.a;
import com.hisavana.mediation.ad.TAdListenerAdapter;
import com.hisavana.mediation.bean.CloudControlConfig;
import com.hisavana.mediation.config.TAdManager;
import com.hisavana.mediation.config.d;
import com.hisavana.mediation.handler.CacheHandler;
import java.util.ArrayList;

public abstract class TBaseAd<T extends Iad> {
    private Handler mHandler = new Handler(Looper.getMainLooper());
    protected String j = "";
    protected Context mContext = null;
    protected Context k = null;
    private RunTimer l;
    private CacheHandler m;
    protected boolean n;
    private boolean o = false;
    private CloudControlConfig.CodeSeat p;
    protected TAdRequestBody mAdRequestBody;
    protected TAdListenerAdapter q;
    public int mFillSource;
    private RunTimer.TimeOutCallback r = new RunTimer.TimeOutCallback(){

        public void isTimeOut() {
            AdLogUtil.Log().e("ad_flow_log", "TBaseAd --> Load ad is time out");
            TBaseAd.this.clearCurrentAd();
            if (TBaseAd.this.mAdRequestBody != null && TBaseAd.this.mAdRequestBody.getAdListener() != null) {
                TBaseAd.this.mAdRequestBody.getAdListener().onError(TAdErrorCode.MEDIAITON_TIME_OUT_ERROR);
            }
        }
    };
    private String s;
    private long time;
    private Bundle mBundle;

    protected TBaseAd(Context context, String string) {
        this.j = string;
        this.mContext = context.getApplicationContext();
        this.k = context;
        AdLogUtil.Log().d("ad_flow_log", "TBaseAd --> mAdUnit:=" + string);
        this.g();
    }

    protected TBaseAd(Context context) {
        this.mContext = context.getApplicationContext();
        this.k = context;
        this.g();
    }

    public final void loadAd() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    TBaseAd.this.c();
                }
            });
            return;
        }
        this.c();
    }

    private void c() {
        this.n = false;
        this.clearCurrentAd();
        this.o = true;
        if (!a.isNetWorkAvailable()) {
            AdLogUtil.Log().e("ad_flow_log", "TBaseAd --> net error");
            this.a(TAdErrorCode.NETWORK_ERROR);
            this.o = false;
            return;
        }
        AdLogUtil.Log().d("ad_flow_log", "TBaseAd --> Current app id is:" + TAdManager.getAppId());
        if (TextUtils.isEmpty((CharSequence)TAdManager.getAppId())) {
            this.o = false;
            this.a(TAdErrorCode.INVALID_AD_REQUESST);
            AdLogUtil.Log().e("ad_flow_log", "TBaseAd --> Network request is invalid, the appId or appToken must be valid");
            return;
        }
        if (!d.c(this.j)) {
            AdLogUtil.Log().e("ad_flow_log", "TBaseAd --> current ad unit is close  mAdUnit =" + this.j);
            this.a(TAdErrorCode.MEDIATION_CLOSE_ERROR);
            this.o = false;
            return;
        }
        this.p = d.b(this.j);
        if (!this.n) {
            this.runTimerTask();
        }
        this.d();
        this.e();
    }

    private final void d() {
        if (this.mAdRequestBody == null) {
            this.m = null;
            return;
        }
        this.m = this.b();
        if (this.m != null) {
            this.m.setRequestBody(this.mAdRequestBody);
            this.m.a(this.l);
        }
    }

    private void e() {
        AdLogUtil.Log().d("ad_flow_log", "TBaseAd --> start mediation load");
        AdLogUtil.Log().d("ad_flow_log", "TBaseAd --> current cloudConfig is " + (this.p != null ? this.p.toString() : "null"));
        if (this.p == null) {
            this.a(TAdErrorCode.AD_UNIT_CONFIG_EMPTY);
            return;
        }
        ArrayList<Network> arrayList = this.p.getNetworks();
        if (arrayList == null && arrayList.size() <= 0) {
            AdLogUtil.Log().e("ad_flow_log", "TBaseAd --> ad is empty");
            this.a(TAdErrorCode.AD_IS_EMPTY);
            return;
        }
        this.i();
        CacheHandler cacheHandler = this.h();
        if (cacheHandler != null) {
            cacheHandler.setBundle(this.mBundle);
            cacheHandler.a(this.mContext, this.k, this.p, false);
        }
    }

    private void runTimerTask() {
        int n = 60000;
        if (this.mAdRequestBody != null) {
            n = this.mAdRequestBody.getScheduleTime();
        }
        if (null != this.p) {
            n = this.p.getAdRequestTimeout() * 1000;
        }
        if (n > 0) {
            if (this.l == null) {
                this.l = new RunTimer();
            }
            this.l.resetTimerTask();
            this.l.setTimeOutCallback(this.r);
            this.l.setScheduleTime(n);
            this.l.runTimerTask();
            AdLogUtil.Log().d("ad_flow_log", "TBaseAd --> start timer,schedule time is " + n);
        }
    }

    protected void clearCurrentAd() {
        AdLogUtil.Log().d("ad_flow_log", "TBase ad destroy");
        if (this.o) {
            this.j();
        }
        this.stopTimer();
        if (this.m != null) {
            this.m.destroy();
        }
        this.m = null;
        if (this.o) {
            AdLogUtil.Log().d("ad_flow_log", "cancel request ad ");
        }
    }

    public void setRequestBody(TAdRequestBody tAdRequestBody) {
        if (tAdRequestBody == null) {
            return;
        }
        if (this.mAdRequestBody == null) {
            this.g();
        }
        this.mAdRequestBody.copyAttributes(tAdRequestBody);
        if (this.q != null) {
            this.q.setAdListener(tAdRequestBody.getAdListener());
        }
    }

    public void destroy() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    TBaseAd.this.onDestroy();
                }
            });
            return;
        }
        this.onDestroy();
    }

    private void onDestroy() {
        this.mContext = null;
        this.k = null;
        this.q = null;
        this.mAdRequestBody = null;
        this.n = false;
        this.p = null;
        this.clearCurrentAd();
        this.o = false;
    }

    public void stopTimer() {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.f();
        } else {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    TBaseAd.this.f();
                }
            });
        }
    }

    private void f() {
        if (this.l != null) {
            AdLogUtil.Log().d("ad_flow_log", "stop timer");
            this.l.resetTimerTask();
            this.l = null;
        }
    }

    public void setLoaded(boolean bl) {
        this.n = bl;
    }

    public void setLoading(boolean bl) {
        this.o = bl;
    }

    private void a(TAdErrorCode tAdErrorCode) {
        if (this.mAdRequestBody != null && this.mAdRequestBody.getAdListener() != null) {
            this.mAdRequestBody.getAdListener().onError(tAdErrorCode);
        }
    }

    private void g() {
        this.q = new TAdListenerAdapter(this);
        this.mAdRequestBody = new TAdRequestBody.AdRequestBodyBuild().setAdListener((TAdListener)this.q).build();
    }

    protected void a() {
    }

    protected abstract CacheHandler b();

    protected final CacheHandler h() {
        if (this.mAdRequestBody == null) {
            return null;
        }
        return this.m;
    }

    private void i() {
        this.s = TrackingUtil.getTriggerId();
        this.mBundle = new Bundle();
        this.mBundle.putString("trigger_id", this.s);
        this.time = System.currentTimeMillis();
        this.mBundle.putLong("trigger_ts", this.time);
        this.mBundle.putInt("ad_type", this.p.getCodeSeatType().intValue());
        this.mBundle.putString("app_id", TAdManager.getAppId());
        this.mBundle.putString("code_seat_id", this.j);
        TrackingManager.trackingADTrigger((Bundle)this.mBundle);
    }

    public void trackingAdLoaded(int n, String string, int n2) {
        if (this.mBundle == null) {
            AdLogUtil.Log().e("ad_flow_log", "mBundle is null");
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("trigger_id", this.mBundle.getString("trigger_id"));
        bundle.putLong("trigger_ts", this.mBundle.getLong("trigger_ts"));
        bundle.putInt("ad_type", this.mBundle.getInt("ad_type"));
        Bundle bundle2 = null;
        Object var6_6 = null;
        if (this.h() != null && this.h().M() != null && (var6_6 = this.h().M().getCache(this.j, false)) != null) {
            if (var6_6 instanceof BaseAd) {
                bundle2 = ((BaseAd)var6_6).mBundle;
            } else if (var6_6 instanceof TAdNativeInfo) {
                bundle2 = ((TAdNativeInfo)var6_6).getNativeAdWrapper().getAdImpl().mBundle;
            }
        }
        if (bundle2 != null) {
            bundle.putInt("platform", bundle2.getInt("platform"));
            bundle.putString("app_id", bundle2.getString("app_id"));
            bundle.putString("code_seat_id", bundle2.getString("code_seat_id"));
            bundle.putDouble("bidding_price", bundle2.getDouble("bidding_price"));
            bundle.putInt("priority", bundle2.getInt("priority"));
            bundle.putInt("ad_count", bundle2.getInt("ad_count"));
            bundle.putInt("is_retreatad", bundle2.getInt("is_retreatad"));
            bundle.putInt("is_default_ad", bundle2.getInt("is_default_ad"));
            bundle.putString("cld_app_id", bundle2.getString("cld_app_id"));
            bundle.putString("cld_code_seat_id", bundle2.getString("cld_code_seat_id"));
        }
        bundle.putInt("is_timeout", 0);
        bundle.putInt("error_code", n);
        bundle.putString("error_message", string);
        TAdNativeInfo tAdNativeInfo = null;
        if (var6_6 instanceof TAdNativeInfo) {
            tAdNativeInfo = var6_6;
        }
        if (tAdNativeInfo != null) {
            bundle.putString("ad_title", tAdNativeInfo.getTitle());
            bundle.putString("ad_url", "");
            bundle.putString("description", tAdNativeInfo.getDescription());
            bundle.putString("image_url", tAdNativeInfo.getImageList() != null && tAdNativeInfo.getImageList().size() > 0 ? ((TAdNativeInfo.Image)tAdNativeInfo.getImageList().get(0)).getUrl() : "");
            bundle.putString("icon_url", tAdNativeInfo.getIcon() != null ? tAdNativeInfo.getIcon().getUrl() : "");
            bundle.putString("endcard_url", "");
            bundle.putString("app_name", "");
            bundle.putString("package_name", "");
            bundle.putString("download_url", "");
        }
        bundle.putInt("filling_source", n2);
        bundle.putLong("filling_ts", System.currentTimeMillis());
        TrackingManager.trackingAdLoaded((Bundle)bundle);
    }

    private void j() {
        Object y;
        if (null == this.mBundle) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("trigger_id", this.mBundle.getString("trigger_id"));
        bundle.putLong("trigger_ts", this.mBundle.getLong("trigger_ts"));
        bundle.putLong("request_ts", this.mBundle.getLong("request_ts"));
        if (this.mBundle.getLong("request_ts") > 0L) {
            bundle.putInt("request_time", (int)(this.mBundle.getLong("request_ts") - this.mBundle.getLong("trigger_ts")));
        }
        bundle.putString("request_id", this.mBundle.getString("request_id"));
        bundle.putInt("ad_type", this.mBundle.getInt("ad_type"));
        bundle.putString("cld_app_id", this.mBundle.getString("cld_app_id"));
        bundle.putString("cld_code_seat_id", this.mBundle.getString("cld_code_seat_id"));
        bundle.putInt("platform", this.mBundle.getInt("platform"));
        bundle.putString("app_id", this.mBundle.getString("app_id"));
        bundle.putString("code_seat_id", this.mBundle.getString("code_seat_id"));
        bundle.putDouble("bidding_price", this.mBundle.getDouble("bidding_price"));
        if (this.m != null && this.m.M() != null && (y = this.m.M().getCache(this.j, false)) instanceof BaseAd) {
            Bundle bundle2 = ((BaseAd)y).mBundle;
            bundle.putInt("ad_count", bundle2.getInt("ad_count"));
            bundle.putInt("priority", bundle2.getInt("priority"));
        }
        bundle.putInt("is_retreatad", this.mBundle.getInt("is_retreatad"));
        bundle.putString("cld_configure_id", this.mBundle.getString("cld_configure_id"));
        bundle.putInt("is_preload", this.mBundle.getInt("is_preload"));
        TrackingManager.trackingAdCancel((Bundle)bundle);
    }

    public void trackingTriggerShowError() {
        if (null == this.mBundle) {
            AdLogUtil.Log().e("ad_flow_log", "trackShowError --> null == mBundle");
            return;
        }
        Bundle bundle = new Bundle();
        try {
            bundle.putString("trigger_id", this.mBundle.getString("trigger_id"));
            bundle.putLong("trigger_ts", this.mBundle.getLong("trigger_ts"));
            bundle.putInt("ad_type", this.mBundle.getInt("ad_type"));
            bundle.putString("cld_app_id", this.mBundle.getString("cld_app_id"));
            bundle.putString("cld_code_seat_id", this.mBundle.getString("cld_code_seat_id"));
            bundle.putInt("platform", this.mBundle.getInt("platform"));
            bundle.putString("app_id", this.mBundle.getString("app_id"));
            bundle.putString("code_seat_id", this.mBundle.getString("code_seat_id"));
            bundle.putDouble("bidding_price", this.mBundle.getDouble("bidding_price"));
            bundle.putString("error_code", String.valueOf(1025));
            bundle.putString("error_message", TAdErrorCode.NO_AD_OR_AD_IS_EXPIRED.getErrorMessage());
            TrackingManager.trackingTrigerShow((Bundle)bundle);
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("ad_flow_log", Log.getStackTraceString((Throwable)exception));
        }
    }
}

