/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.mediation.handler;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.bean.TAdRequestBody;
import com.hisavana.common.constant.ComConstants;
import com.hisavana.common.interfacz.ICacheAd;
import com.hisavana.common.interfacz.Iad;
import com.hisavana.common.interfacz.TAdListener;
import com.hisavana.common.interfacz.WrapTAdAllianceListener;
import com.hisavana.common.tracking.TrackingUtil;
import com.hisavana.mediation.a.b;
import com.hisavana.mediation.ad.TAdListenerAdapter;
import com.hisavana.mediation.bean.AdCache;
import com.hisavana.mediation.bean.CloudControlConfig;
import com.hisavana.mediation.config.TAdManager;
import com.hisavana.mediation.config.d;
import com.hisavana.mediation.handler.a;
import com.transsion.core.CoreUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;

public abstract class CacheHandler<T extends Iad, C>
extends a {
    private int I;
    private ArrayList<T> J = new ArrayList();
    protected int K;
    protected int L;
    private Handler mHandler;
    protected C M;
    protected String j;
    private int N = 0;
    private int O = 0;
    private int P = 0;
    private AtomicInteger Q = new AtomicInteger();
    private boolean R = false;
    protected Network S;
    protected int mProgress = 1;
    private List<Double> T = new ArrayList<Double>();
    private T U;
    private T V;
    private int W = -1;
    protected int X = 1;
    private int Y;
    private AdCache.AdCacheExpiredWatcher watcher = new AdCache.AdCacheExpiredWatcher(){

        @Override
        public void onExpired(ICacheAd iCacheAd) {
            AdLogUtil.Log().d("CacheHandler", "ad expired");
        }
    };
    protected Bundle Z;
    private boolean aa;

    public CacheHandler(String string, TAdRequestBody tAdRequestBody) {
        this.mHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                switch (message.what) {
                    case 1001: {
                        AdLogUtil.Log().e("CacheHandler", "receive MSG_REQUEST_NEXT_GROUP_WAITING...");
                        CacheHandler.this.b(true);
                        break;
                    }
                    case 1002: {
                        AdLogUtil.Log().e("CacheHandler", "receive MSG_BIDDING_WAITING...");
                        CacheHandler.this.I();
                        break;
                    }
                    default: {
                        if (!(message.obj instanceof Iad)) break;
                        ((Iad)message.obj).loadAd();
                    }
                }
            }
        };
        this.ab = tAdRequestBody;
        this.j = string;
        this.M().registerWatcher(this.watcher);
    }

    private void B() {
        this.J.clear();
        this.R = false;
        this.O = 0;
        this.I = 0;
        this.Q.set(0);
        this.V = null;
    }

    public boolean a(Context context, Context context2, CloudControlConfig.CodeSeat codeSeat, boolean bl) {
        if (codeSeat == null) {
            return false;
        }
        this.B();
        this.Y = codeSeat.codeSeatType;
        this.aa = bl;
        this.L = Math.max(codeSeat.getBiddingWaitTime(), 0);
        this.K = Math.max(codeSeat.getAdRequestTimeInterval(), 0);
        this.N = codeSeat.getAdRequestConcurrentCount() <= 0 ? 1 : codeSeat.getAdRequestConcurrentCount();
        this.W = codeSeat.getPreload() != false ? codeSeat.getPreloadLogic() : -1;
        this.N = bl ? 1 : this.N;
        this.X = Math.max(1, codeSeat.getAdRequestCount());
        if (bl && this.W == -1) {
            AdLogUtil.Log().w("CacheHandler", "preload is close...");
            return false;
        }
        AdLogUtil.Log().e("CacheHandler", "WaitBiddingTime:" + this.L + ",WaitNextGroupRequestTime:" + this.K + ",ReqCount:" + this.N + ",PoolAppendStrategy:" + this.W + ",ReqCount:" + this.N);
        ArrayList<Network> arrayList = codeSeat.getNetworks();
        if (arrayList == null || arrayList.size() == 0) {
            AdLogUtil.Log().w("CacheHandler", "adUnit:" + this.j + " no network");
            return false;
        }
        if (bl && this.W == 1 && this.M().hasAds(this.j)) {
            AdLogUtil.Log().d("CacheHandler", "autoAppend & INSUFFICIENT_APPEND,but adunit:" + this.j + " has cached ad");
            return false;
        }
        for (Network network : arrayList) {
            if (network == null || !b.e(network.getSource())) continue;
            network.setPrice(Double.valueOf(this.M().getPrice(this.j, network.getSource(), network.getCodeSeatId())));
        }
        Collections.sort(arrayList, new Comparator<Network>(){

            @Override
            public int compare(Network network, Network network2) {
                if (network != null && network2 != null) {
                    if (network.getPrice() <= 0.0 && b.e(network.getSource())) {
                        return -1;
                    }
                    if (network2.getPrice() <= 0.0 && b.e(network2.getSource())) {
                        return 1;
                    }
                    return -((int)(network.getPrice() * 100.0 - network2.getPrice() * 100.0));
                }
                return 0;
            }
        });
        AdLogUtil.Log().d("CacheHandler", ((Object)arrayList).toString());
        AdLogUtil.Log().e("CacheHandler", "Currently " + this.M().getAdNum(this.j) + " ad in pool....");
        JSONArray jSONArray = new JSONArray();
        boolean bl2 = false;
        for (Network network : arrayList) {
            if (network == null) continue;
            this.T.add(network.getPrice());
            if (network.getSource() == 0) {
                this.S = network;
            }
            if (bl2) {
                AdLogUtil.Log().e("CacheHandler", bl2 ? " exist higher ecpm ad in current waterfall." : "price is 0 ,source is " + network.getSource() + ",codeSeat is " + network.getCodeSeatId());
                continue;
            }
            if (!ComConstants.isFbAppExist && network.getSource() == 2) {
                AdLogUtil.Log().e("CacheHandler", "not exist fb application");
                continue;
            }
            bl2 = bl2 || this.M().getAdNum(this.j, network.getSource(), network.getCodeSeatId()) > 0;
            int n = this.a(this.j, network.getSource(), network.getCodeSeatId(), Math.max(1, Math.min(this.L(), codeSeat.getAdRequestCount())));
            if (n <= 0) {
                AdLogUtil.Log().e("CacheHandler", "ad source:" + network.getSource() + " ,network codeSeat :" + network.getCodeSeatId() + "need number <= 0");
                continue;
            }
            T t = this.a(network.getSource() == 1 ? context2 : context, network, n, (int)codeSeat.getCacheTimeout());
            if (t == null) {
                AdLogUtil.Log().e("CacheHandler", "adUnit:" + this.j + " ,create execute:" + network.getSource() + " fail");
                continue;
            }
            t.setEcpmPrice(network.getPrice().doubleValue());
            Bundle bundle = new Bundle();
            bundle.putInt("platform", network.getSource().intValue());
            bundle.putString("app_id", network.applicationId);
            bundle.putString("code_seat_id", network.codeSeatId);
            bundle.putDouble("bidding_price", network.getPrice().doubleValue());
            bundle.putInt("ad_type", codeSeat.codeSeatType.intValue());
            t.setTrackingBundle(bundle);
            AdLogUtil.Log().i("CacheHandler", "add ad to list,ad  adUnit:" + this.j + " adSource:" + t.getAdSource() + ",network codeSeat:" + network.getCodeSeatId() + " request num:" + n);
            this.J.add(t);
        }
        if (jSONArray != null && jSONArray.length() > 0) {
            try {
                AdLogUtil.Log().d("CacheHandler", "network_price:" + jSONArray.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.C();
        if (!bl && this.mProgress == 1) {
            AdLogUtil.Log().d("CacheHandler", "start WaitForBidding & startWaitForNextGroupRequest");
            this.F();
            this.G();
        }
        return true;
    }

    @Override
    public void destroy() {
        super.destroy();
        for (int i = 0; i < this.J.size(); ++i) {
            try {
                Iad iad = (Iad)this.J.get(i);
                if (iad == null) continue;
                iad.stopLoader();
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.J.clear();
        if (this.U != null) {
            this.U.stopLoader();
        }
        if (this.V != null) {
            this.V.stopLoader();
        }
        this.V = null;
        this.O = 0;
        this.M().unRegisterWatcher();
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.mHandler = null;
        this.I = 0;
        this.mProgress = 3;
        this.K();
    }

    @Override
    public boolean C() {
        int n;
        if (this.ab == null) {
            return false;
        }
        Iad iad = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = this.N;
        for (n = 0; n < this.J.size(); ++n) {
            try {
                int n3 = 0;
                if (this.O == 0) {
                    iad = (Iad)this.J.get(n);
                    if (iad != null && iad.isSupportRtBidding()) {
                        ++this.P;
                        ++n2;
                    }
                } else {
                    n3 = this.O * n2 + this.P + n;
                }
                if (n >= n2 || n3 >= this.J.size()) break;
                if (iad == null) {
                    iad = (Iad)this.J.get(n3);
                }
                if (this.V != null && this.mProgress == 1 && iad.getEcpmPrice() <= this.V.getEcpmPrice()) {
                    arrayList.add(this.V);
                    break;
                }
                if (iad == null) continue;
                iad.setRequestBody(this.a(this.ab, iad, this.mProgress == 3 ? 2 : 1));
                arrayList.add(iad);
                AdLogUtil.Log().d("CacheHandler", "add ad to nowExecuterList, index :" + n3 + " ad source :" + iad.getAdSource() + "network placementID:" + iad.getPlacementId());
                continue;
            }
            catch (Throwable throwable) {
                AdLogUtil.Log().e("CacheHandler", Log.getStackTraceString((Throwable)throwable));
            }
        }
        if (arrayList.size() > 0) {
            ++this.O;
            for (n = 0; n < arrayList.size(); ++n) {
                Iad iad2 = (Iad)arrayList.get(n);
                iad2.setTrackingBundle(this.b(0));
                iad2.loadAd();
                if (iad2.isSupportRtBidding() && iad2 != this.V) continue;
                this.Q.addAndGet(1);
            }
        }
        return arrayList.size() > 0;
    }

    private void D() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(1001);
        }
    }

    private void E() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(1002);
        }
    }

    private void F() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(1002);
            this.mHandler.sendEmptyMessageDelayed(1002, (long)this.L);
        }
    }

    private void G() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(1001);
            this.mHandler.sendEmptyMessageDelayed(1001, (long)this.K);
        }
    }

    protected final void H() {
        if (this.mProgress == 2 && this.ab != null) {
            AdLogUtil.Log().d("CacheHandler", "start take default ad...");
            Map<Boolean, C> map = this.J();
            if (map == null || !map.containsKey(true)) {
                this.b(TAdErrorCode.AD_FILL_FAILED);
                AdLogUtil.Log().w("CacheHandler", "take default ad failed,no ad fill");
                return;
            }
            this.M = map.get(true);
            AdLogUtil.Log().d("CacheHandler", "mUseCache set value:" + (this.M == null ? null : "object"));
            if (this.ab != null && this.ab.getAdListener() != null && this.ab.getAdListener() instanceof TAdListenerAdapter) {
                ((TAdListenerAdapter)this.ab.getAdListener()).setFillSource(3);
            }
            this.b(this.M);
            AdLogUtil.Log().d("CacheHandler", "--- finish take default ad,and notifyLoadBest ---");
        }
    }

    protected final void I() {
        if (this.mProgress == 1 && this.ab != null) {
            Map<Boolean, C> map;
            AdLogUtil.Log().d("CacheHandler", "start bidding...");
            this.mProgress = 2;
            this.D();
            this.E();
            if (this.V != null) {
                this.V.onBiddingTimeEnd();
            }
            if ((map = this.J()) == null || !map.containsKey(true)) {
                AdLogUtil.Log().d("CacheHandler", "bidding failed,no ad fill,start request default ad");
                if (this.S != null) {
                    AdLogUtil.Log().d("CacheHandler", "send request default ad");
                    T t = this.a(CoreUtil.getContext(), this.S, 1, 0);
                    if (null == t) {
                        AdLogUtil.Log().e("CacheHandler", "null == executer \u4e0d\u52a0\u8f7d\u6253\u5e95\u5e7f\u544a\u4e86");
                        this.b(TAdErrorCode.AD_FILL_FAILED);
                        return;
                    }
                    t.setDefaultAd(true);
                    t.setTrackingBundle(this.b(1));
                    t.setRequestBody(this.a(this.ab, t, 3));
                    t.loadAd();
                }
                return;
            }
            this.M = map.get(true);
            AdLogUtil.Log().d("CacheHandler", "mUseCache set value:" + (this.M == null ? null : "object"));
            if (this.ab != null && this.ab.getAdListener() != null && this.ab.getAdListener() instanceof TAdListenerAdapter) {
                ((TAdListenerAdapter)this.ab.getAdListener()).setFillSource(this.R ? 1 : 2);
            }
            this.b(this.M);
            AdLogUtil.Log().d("CacheHandler", "--- finish bidding,and notifyLoadBest ---");
        }
    }

    protected Map<Boolean, C> J() {
        return null;
    }

    protected final void b(TAdErrorCode tAdErrorCode) {
        AdLogUtil.Log().w("CacheHandler", "notify load failed");
        this.stopTimer();
        this.mProgress = 3;
        this.c(tAdErrorCode);
    }

    protected final void a(C c2) {
        if (c2 instanceof ArrayList) {
            this.M().removeCaches(this.j, (ArrayList)c2);
        } else {
            this.M().removeCache(this.j, (ICacheAd)c2);
        }
    }

    protected final void a(@NonNull CacheTAdAllianceListener cacheTAdAllianceListener) {
        this.stopTimer();
        Object c2 = cacheTAdAllianceListener.getCache();
        double d2 = cacheTAdAllianceListener.getExecuter().getEcpmPrice();
        try {
            if (c2 == null) {
                return;
            }
            if (c2 instanceof ArrayList) {
                for (ICacheAd iCacheAd : (ArrayList)c2) {
                    iCacheAd.setEcpmPrice(d2);
                }
                this.M().addCaches(this.j, (ArrayList)c2);
            } else {
                ((ICacheAd)c2).setEcpmPrice(d2);
                this.M().addCache(this.j, (ICacheAd)c2);
            }
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("CacheHandler", Log.getStackTraceString((Throwable)exception));
        }
    }

    protected int a(String string, int n, String string2, int n2) {
        return n2 - this.M().getAdNum(string, n, string2);
    }

    protected abstract void b(C var1);

    protected abstract void a(@NonNull C var1, TAdRequestBody var2);

    protected abstract T a(@NonNull Context var1, @NonNull Network var2, int var3, int var4);

    protected abstract void c(C var1);

    public void K() {
        AdLogUtil.Log().d("AdCache", "----------------->destroy,mUseCache:" + this.M);
        this.a(this.M, null);
        this.c(this.M);
        AdLogUtil.Log().d("AdCache", "destroy current use cache");
        this.M = null;
    }

    protected int L() {
        return 1;
    }

    @NonNull
    public abstract <Y extends ICacheAd> AdCache<Y> M();

    public C N() {
        return this.M;
    }

    protected void c(TAdErrorCode tAdErrorCode) {
        if (this.ab != null && this.ab.getAdListener() != null) {
            this.ab.getAdListener().onError(tAdErrorCode);
        }
    }

    private boolean O() {
        int n = this.J.size();
        return this.I >= n && n > 0;
    }

    private boolean P() {
        return this.Q.get() > 0;
    }

    protected TAdRequestBody a(@NonNull TAdRequestBody tAdRequestBody, T t, int n) {
        return new TAdRequestBody.AdRequestBodyBuild().setAdListener((TAdListener)new CacheTAdAllianceListener(this, null, t, n)).build();
    }

    private boolean Q() {
        if (!this.P() && (this.R || this.O()) && this.mProgress == 1) {
            this.I();
            return true;
        }
        return false;
    }

    private void b(boolean bl) {
        AdLogUtil.Log().d("CacheHandler", "load next group ad...");
        boolean bl2 = this.C();
        if (bl2 && bl) {
            AdLogUtil.Log().d("CacheHandler", "startWaitForNextGroupRequest");
            this.G();
        }
    }

    public void setBundle(Bundle bundle) {
        this.Z = bundle;
    }

    private Bundle b(int n) {
        Bundle bundle = new Bundle();
        if (null == this.Z) {
            return bundle;
        }
        if (this.aa) {
            bundle.putInt("request_type", 2);
        } else {
            bundle.putInt("request_type", 1);
        }
        bundle.putString("trigger_id", this.Z.getString("trigger_id"));
        bundle.putLong("trigger_ts", this.Z.getLong("trigger_ts"));
        bundle.putLong("request_ts", System.currentTimeMillis());
        bundle.putInt("request_time", (int)(System.currentTimeMillis() - this.Z.getLong("trigger_ts")));
        bundle.putString("request_id", TrackingUtil.getTriggerId());
        bundle.putString("cld_app_id", TAdManager.getAppId());
        bundle.putString("cld_code_seat_id", this.Z.getString("code_seat_id"));
        bundle.putInt("priority", this.O);
        bundle.putInt("ad_type", this.Y);
        if (n == 1) {
            bundle.putString("app_id", this.Z.getString("app_id"));
            bundle.putString("code_seat_id", this.Z.getString("code_seat_id"));
            bundle.putDouble("bidding_price", this.Z.getDouble("bidding_price"));
        }
        return bundle;
    }

    protected class CacheTAdAllianceListener
    extends WrapTAdAllianceListener {
        private T mExecuter;
        private C cache;
        private final int mRequestCategory;
        final /* synthetic */ CacheHandler this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public CacheTAdAllianceListener(@NonNull TAdRequestBody tAdRequestBody, T t, int n2) {
            this.this$0 = (CacheHandler)n;
            super(tAdRequestBody);
            this.mExecuter = t;
            this.mRequestCategory = n2;
        }

        public C getCache() {
            return this.cache;
        }

        public T getExecuter() {
            return this.mExecuter;
        }

        private String getProgressName() {
            switch (this.this$0.mProgress) {
                case 1: {
                    return "PROGRESS_REQUEST";
                }
                case 2: {
                    return "PROGRESS_BIDDING";
                }
                case 3: {
                    return "PROGRESS_DISPATCHED";
                }
            }
            return null;
        }

        private void onLoaded() {
            this.this$0.Q.decrementAndGet();
            if (this.this$0.mProgress == 1) {
                this.this$0.R = true;
            }
            AdLogUtil.Log().d("CacheHandler", "onLoaded().............,mProgress = " + this.getProgressName() + ",mFlightingAdCount.get() = " + this.this$0.Q.get());
            this.this$0.a(this);
            AdLogUtil.Log().d("CacheHandler", "ad fill adSource:" + this.mExecuter.getAdSource() + ", isDefaultAd: " + (this.mRequestCategory == 3) + ", ad placementId: " + this.mExecuter.getPlacementId());
            if (this.mRequestCategory == 1) {
                this.this$0.Q();
            } else if (this.mRequestCategory == 3) {
                this.this$0.H();
            }
        }

        public void onLoad(List<TAdNativeInfo> list) {
            if (this.mExecuter == null) {
                AdLogUtil.Log().d("CacheHandler", "mExecuter is null");
                return;
            }
            this.cache = list;
            this.onLoaded();
        }

        public void onLoad() {
            if (this.mExecuter == null) {
                AdLogUtil.Log().d("CacheHandler", "mExecuter is null");
                return;
            }
            this.cache = this.mExecuter;
            this.onLoaded();
        }

        public void onError(TAdErrorCode tAdErrorCode) {
            if (this.mExecuter == null) {
                AdLogUtil.Log().d("CacheHandler", "mExecuter is null");
                return;
            }
            this.this$0.Q.decrementAndGet();
            AdLogUtil.Log().e("CacheHandler", "request ad fail,error code: " + (tAdErrorCode != null ? Integer.valueOf(tAdErrorCode.getErrorCode()) : null) + ",adSource:" + this.mExecuter.getAdSource() + ", isDefaultAd:" + (this.mRequestCategory == 3) + ", ad placementId: " + this.mExecuter.getPlacementId());
            if (this.mRequestCategory == 2) {
                AdLogUtil.Log().d("CacheHandler", "current is preload");
                this.this$0.b(false);
            } else if (this.this$0.mProgress == 1) {
                this.this$0.I++;
                AdLogUtil.Log().d("CacheHandler", "onError.............,,mDispatched:" + this.getProgressName() + ",mFlightingAdCount.get() = " + this.this$0.Q.get() + ",mExistLoadedBeforeBidding = " + this.this$0.R + ",isAllFailed = " + this.this$0.O());
                if (this.this$0.Q()) {
                    return;
                }
                if (!this.this$0.P() && !this.this$0.R && this.this$0.mProgress == 1) {
                    this.this$0.b(true);
                }
            } else if (this.mRequestCategory == 3) {
                this.this$0.b(TAdErrorCode.AD_FILL_FAILED);
                AdLogUtil.Log().w("CacheHandler", "take default ad failed,no ad fill");
            }
        }

        public void onShow() {
            super.onShow();
            AdLogUtil.Log().d("CacheHandler", "ad onshow() " + this.this$0.j + ",removed impressed ad from cache,mUseCache:" + this.this$0.M);
            if (this.this$0.P()) {
                AdLogUtil.Log().d("CacheHandler", "currently have requesting ad,terminate preload flow.");
                return;
            }
            if (!com.hisavana.mediation.a.a.isNetWorkAvailable()) {
                AdLogUtil.Log().d("CacheHandler", "network is disconnect");
                return;
            }
            this.this$0.a(CoreUtil.getContext(), CoreUtil.getContext(), d.b(this.this$0.j), true);
        }

        public void onRtBiddingReturn(double d2) {
            if (this.this$0.T.size() <= 0) {
                return;
            }
            if (d2 >= (Double)this.this$0.T.get(0)) {
                AdLogUtil.Log().d("CacheHandler", "current price is the highest from real time bidding,start request creative");
                this.mExecuter.loadAd();
                this.this$0.Q.addAndGet(1);
            } else if (this.this$0.V == null) {
                this.this$0.V = this.mExecuter;
            }
        }

        public void onSkipClick() {
            if (this.this$0.ab != null && this.this$0.ab.getAdListener() != null && this.this$0.ab.getAdListener() instanceof TAdListenerAdapter) {
                ((TAdListenerAdapter)this.this$0.ab.getAdListener()).onSkipClick();
            }
        }

        public void onTimeReach() {
            if (this.this$0.ab != null && this.this$0.ab.getAdListener() != null && this.this$0.ab.getAdListener() instanceof TAdListenerAdapter) {
                ((TAdListenerAdapter)this.this$0.ab.getAdListener()).onTimeReach();
            }
        }
    }
}

