/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.mediation.handler;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.control.AdxPreferencesHelper;
import com.hisavana.common.base.BaseAd;
import com.hisavana.common.bean.AdNativeInfo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.bean.TAdRequestBody;
import com.hisavana.common.interfacz.ICacheAd;
import com.hisavana.common.interfacz.Iad;
import com.hisavana.common.interfacz.QueryPriceListener;
import com.hisavana.common.interfacz.TAdListener;
import com.hisavana.common.interfacz.WrapTAdAllianceListener;
import com.hisavana.common.tracking.TrackingManager;
import com.hisavana.mediation.a.b;
import com.hisavana.mediation.ad.TAdListenerAdapter;
import com.hisavana.mediation.bean.AdCache;
import com.hisavana.mediation.bean.CloudControlConfig;
import com.hisavana.mediation.config.TAdManager;
import com.hisavana.mediation.config.f;
import com.hisavana.mediation.handler.a;
import com.transsion.core.CoreUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class CacheHandler<T extends Iad, C>
extends a {
    private final CopyOnWriteArrayList<T> av;
    private final b aw;
    protected int ax;
    protected int ay;
    private Handler mHandler;
    protected C az;
    protected String j;
    private int aA = 0;
    private int aB = 0;
    private AtomicInteger aC = new AtomicInteger();
    private boolean aD = false;
    protected Network aE;
    protected int mProgress;
    private String aF = null;
    private int aG = -1;
    protected int aH = 1;
    private int aI;
    private int aJ;
    private AdCache.AdCacheExpiredWatcher watcher = new AdCache.AdCacheExpiredWatcher(){

        @Override
        public void onExpired(ICacheAd iCacheAd) {
            AdLogUtil.Log().d("CacheHandler", "ad expired");
        }
    };
    protected Bundle aK;

    public CacheHandler(String string, TAdRequestBody tAdRequestBody) {
        this.mHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                switch (message.what) {
                    case 1001: {
                        AdLogUtil.Log().w("CacheHandler", "receive MSG_REQUEST_NEXT_GROUP_WAITING...");
                        CacheHandler.this.d(true);
                        break;
                    }
                    case 1002: {
                        AdLogUtil.Log().w("CacheHandler", "receive MSG_BIDDING_WAITING...");
                        CacheHandler.this.g(1);
                        break;
                    }
                    default: {
                        if (!(message.obj instanceof Iad)) break;
                        ((Iad)message.obj).loadAd();
                    }
                }
            }
        };
        this.aP = tAdRequestBody;
        this.j = string;
        this.O().registerWatcher(this.watcher);
        this.aw = new b(this);
        this.av = new CopyOnWriteArrayList();
    }

    private boolean e(int n) {
        return n == 2 || n == 4;
    }

    public int z() {
        return this.aI;
    }

    public boolean a(Context context, Context context2, CloudControlConfig.CodeSeat codeSeat, int n) {
        if (codeSeat == null) {
            return false;
        }
        AdLogUtil.Log().w("CacheHandler", "*----> start load request,loadType is " + n);
        this.av.clear();
        this.aD = false;
        this.aC.set(0);
        this.aI = n;
        this.aJ = codeSeat.getCodeSeatType();
        this.ay = Math.max(codeSeat.getBiddingWaitTime(), 0);
        this.ax = Math.max(codeSeat.getAdRequestTimeInterval(), 0);
        this.aA = codeSeat.getAdRequestConcurrentCount() <= 0 ? 1 : codeSeat.getAdRequestConcurrentCount();
        this.aG = codeSeat.getPreload() != false ? codeSeat.getPreloadLogic() : -1;
        this.aA = this.e(n) ? 1 : this.aA;
        this.aH = Math.max(1, Math.min(this.M(), codeSeat.getAdRequestCount()));
        this.mProgress = 1;
        this.aF = codeSeat.getCodeSeatId();
        if (n == 2 && this.aG == -1) {
            AdLogUtil.Log().w("CacheHandler", "*----> preload is close...");
            return false;
        }
        AdLogUtil.Log().i("CacheHandler", "*----> WaitBiddingTime:" + this.ay + ",WaitNextGroupRequestTime:" + this.ax + ",ConcurrentReqCount:" + this.aA + ",PoolAppendStrategy:" + this.aG + ",adRequestCount:" + codeSeat.adRequestCount);
        if (codeSeat.getNetworks() == null || codeSeat.getNetworks().size() == 0) {
            AdLogUtil.Log().w("CacheHandler", "*----> adUnit:" + this.j + " no networks , load/preload/trigger_preload request end");
            return false;
        }
        if (n == 2 && this.aG == 1 && this.O().hasAds(this.j)) {
            AdLogUtil.Log().w("CacheHandler", "*----> autoAppend & INSUFFICIENT_APPEND,but adunit:" + this.j + " has cached ad, load/preload/trigger_preload request end");
            return false;
        }
        if (this.e(n)) {
            this.b(context, context2, codeSeat, n);
        } else {
            List<Network> list = this.aw.c(codeSeat.getNetworks());
            if (list == null || list.isEmpty()) {
                this.b(context, context2, codeSeat, n);
            }
            this.a(context, context2, codeSeat, list);
        }
        return true;
    }

    private void a(@NonNull T t) {
        this.av.add(t);
    }

    public void e(List<Network> list) {
        for (Network network : list) {
            double d2;
            if (network == null || !((d2 = this.O().getNetworkPrice(this.j, network.getSource(), network.getCodeSeatId())) > 0.0)) continue;
            network.setPrice(Double.valueOf(d2));
        }
        Collections.sort(list, new Comparator<Network>(){

            @Override
            public int compare(Network network, Network network2) {
                if (network == null || network2 == null) {
                    return 0;
                }
                int n = -((int)(network.getPrice() * 100.0 - network2.getPrice() * 100.0));
                if (n == 0) {
                    if (CacheHandler.this.O().getAdNum(CacheHandler.this.j, network.getSource(), network.getCodeSeatId()) > 0) {
                        return -1;
                    }
                    if (CacheHandler.this.O().getAdNum(CacheHandler.this.j, network2.getSource(), network2.getCodeSeatId()) > 0) {
                        return 1;
                    }
                }
                return n;
            }
        });
    }

    private boolean a(Context context, Context context2, CloudControlConfig.CodeSeat codeSeat, List<Network> list) {
        List<Network> list2 = this.aw.a(codeSeat.getNetworks());
        if (list2 == null) {
            list2 = new ArrayList<Network>();
        }
        if (list != null && list.size() > 0) {
            list2.addAll(list);
        }
        this.e(list2);
        AdLogUtil.Log().d("CacheHandler", "*----> " + list2.toString());
        AdLogUtil.Log().d("CacheHandler", "*----> Currently " + this.O().getAdNum(this.j) + " ad in pool....");
        boolean bl = false;
        for (Network network : list2) {
            if (network == null) continue;
            if (network.getSource() == 0) {
                this.aE = network;
            }
            if (bl) {
                AdLogUtil.Log().d("CacheHandler", "*----> exist higher ecpm ad in current waterfall.");
                continue;
            }
            int n = Math.max(1, Math.min(this.M(), codeSeat.getAdRequestCount()));
            bl = this.O().getAdNum(this.j, network.getSource(), network.getCodeSeatId()) > 0;
            n = this.a(this.j, network.getSource(), network.getCodeSeatId(), n);
            if (n <= 0) {
                AdLogUtil.Log().d("CacheHandler", "*----> ad source:" + network.getSource() + " ,network codeSeat :" + network.getCodeSeatId() + ",need number <= 0");
                continue;
            }
            T t = this.a(context, context2, codeSeat, network);
            if (t == null) continue;
            this.a((C)t);
        }
        if (this.av.size() <= 0) {
            AdLogUtil.Log().w("CacheHandler", "*----> get highest price cahced\uff0cload/preload/trigger_preload request end ");
            this.g(2);
            return true;
        }
        this.B();
        if (!this.e(this.aI)) {
            AdLogUtil.Log().d("CacheHandler", "start WaitForBidding & startWaitForNextGroupRequest");
            this.E();
            this.F();
        }
        return true;
    }

    private void b(final Context context, final Context context2, final CloudControlConfig.CodeSeat codeSeat, final int n) {
        this.aw.a(codeSeat.getNetworks(), new QueryPriceListener(){

            public void onQueryPriceSuccess(List<Network> list) {
                AdLogUtil.Log().d("CacheHandler", "receive query price success");
                this.f(list);
            }

            public void onQueryPriceFailed() {
                AdLogUtil.Log().d("CacheHandler", "receive query price failed");
                this.f(null);
            }

            private void f(List<Network> list) {
                if (CacheHandler.this.e(n)) {
                    AdLogUtil.Log().d("CacheHandler", "--- preload mode ---");
                    CacheHandler.this.a(context, context2, codeSeat, list);
                } else if (list != null && !list.isEmpty() && !CacheHandler.this.J()) {
                    AdLogUtil.Log().d("CacheHandler", "--- load ad mode --- ,call loadAd to request ad creative");
                    for (Network network : list) {
                        Iad iad = CacheHandler.this.a(context, context2, codeSeat, network);
                        if (iad == null) continue;
                        CacheHandler.this.a((C)iad);
                        CacheHandler.this.a(iad, false);
                    }
                    CacheHandler.this.A();
                }
            }
        });
    }

    private void A() {
        Serializable serializable;
        AdLogUtil.Log().d("CacheHandler", "sort executer list");
        if (TAdManager.isDebug()) {
            serializable = new StringBuilder();
            for (Iad iad : this.av) {
                if (iad == null || iad.getNetwork() == null) continue;
                ((StringBuilder)serializable).append(iad.getNetwork().toString());
            }
            AdLogUtil.Log().d("CacheHandler", "*before* sort executer list are: " + ((StringBuilder)serializable).toString());
        }
        try {
            serializable = new ArrayList<T>(this.av);
            Collections.sort(serializable, new Comparator<T>(){

                @Override
                public int compare(T t, T t2) {
                    if (t != null && t2 != null && t.getNetwork() != null && t2.getNetwork() != null) {
                        return -((int)(t.getNetwork().getPrice() * 100.0 - t2.getNetwork().getPrice() * 100.0));
                    }
                    return 0;
                }
            });
            this.av.clear();
            this.av.addAll((Collection<T>)((Object)serializable));
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("CacheHandler", Log.getStackTraceString((Throwable)exception));
        }
        if (TAdManager.isDebug()) {
            serializable = new StringBuilder();
            for (Iad iad : this.av) {
                if (iad == null || iad.getNetwork() == null) continue;
                ((StringBuilder)serializable).append(iad.getNetwork().toString());
            }
            AdLogUtil.Log().d("CacheHandler", "*after* sort executer list are: " + ((StringBuilder)serializable).toString());
        }
    }

    private T a(Context context, Context context2, CloudControlConfig.CodeSeat codeSeat, Network network) {
        int n = codeSeat.getAdRequestCount();
        T t = this.a(network.getSource() == 1 ? context2 : context, network, n, (int)codeSeat.getCacheTimeout());
        if (t == null) {
            AdLogUtil.Log().e("CacheHandler", "create execute:" + network.getSource() + " fail");
            return null;
        }
        t.setEcpmPrice(network.getPrice().doubleValue());
        AdLogUtil.Log().i("CacheHandler", "*----> add ad to list adSource:" + t.getAdSource() + ",network codeSeat:" + network.getCodeSeatId() + " request num:" + n);
        return t;
    }

    @Override
    public void destroy() {
        super.destroy();
        for (Iad iad : this.av) {
            if (iad == null) continue;
            iad.stopLoader();
        }
        this.aw.destroy();
        this.av.clear();
        this.aB = 0;
        this.O().unRegisterWatcher();
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.mHandler = null;
        this.mProgress = 3;
        this.L();
    }

    private String f(int n) {
        switch (n) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "LOADING";
            }
            case 2: {
                return "SUCCESS";
            }
            case 3: {
                return "FAILED";
            }
        }
        return "";
    }

    private boolean a(T t, boolean bl) {
        if (t != null && t.getLoadStatus() == 0) {
            AdLogUtil.Log().d("CacheHandler", "*----> loadAd id: " + t.getPlacementId() + ",EcpmPrice: " + t.getEcpmPrice() + ",AdSource: " + t.getAdSource() + ",isDefaultAd: " + bl);
            int n = bl ? 3 : this.aI;
            t.setRequestBody(this.a(this.aP, t, n));
            t.setTrackingBundle(this.b(t.getNetwork()));
            t.setDefaultAd(bl);
            t.setRequestType(this.aI);
            this.aw.a(t.getNetwork(), true);
            t.loadAd();
            this.aC.addAndGet(1);
            t.setLoadStatus(1);
            return true;
        }
        return false;
    }

    public boolean B() {
        if (this.aP == null) {
            return false;
        }
        AdLogUtil.Log().d("CacheHandler", "*----> load ad num: " + this.aA + " with group");
        int n = 0;
        for (Iad iad : this.av) {
            if (iad == null || !this.a(iad, false)) continue;
            ++this.aB;
            if (++n < this.aA) continue;
            break;
        }
        return n > 0;
    }

    private void C() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(1001);
        }
    }

    private void D() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(1002);
        }
    }

    private void E() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(1002);
            this.mHandler.sendEmptyMessageDelayed(1002, (long)this.ay);
        }
    }

    private void F() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(1001);
            this.mHandler.sendEmptyMessageDelayed(1001, (long)this.ax);
        }
    }

    protected final void a(C c2) {
        if (this.mProgress == 2 && this.H() != null && this.H().getDispatchListener() != null) {
            AdLogUtil.Log().w("CacheHandler", " *----> start take default ad...");
            this.b((T)c2);
            if (c2 == null) {
                this.b(TAdErrorCode.AD_FILL_FAILED);
                AdLogUtil.Log().w("CacheHandler", " *----> take default ad failed,no ad fill");
                return;
            }
            this.az = c2;
            this.a(c2, 3);
            AdLogUtil.Log().w("CacheHandler", "*----> finish take default ad,and notifyLoadBest ---");
        }
    }

    private boolean G() {
        return this.aI == 1 && this.aE != null;
    }

    private TAdListenerAdapter H() {
        if (this.aP != null && this.aP.getAdListener() != null && this.aP.getAdListener() instanceof TAdListenerAdapter) {
            return (TAdListenerAdapter)this.aP.getAdListener();
        }
        return null;
    }

    private boolean I() {
        return this.aI != 2 && this.mProgress == 1 && this.H() != null && this.H().getDispatchListener() != null;
    }

    protected final void g(int n) {
        if (this.I()) {
            AdLogUtil.Log().w("CacheHandler", "*----> start bidding...");
            this.h(n);
            this.mProgress = 2;
            this.C();
            this.D();
            this.az = this.K();
            if (this.az == null) {
                AdLogUtil.Log().w("CacheHandler", " *----> bidding failed,no ad fill,start request default ad");
                if (this.G()) {
                    AdLogUtil.Log().w("CacheHandler", "*----> send request default ad");
                    T t = this.a(CoreUtil.getContext(), this.aE, 1, 0);
                    if (null == t) {
                        AdLogUtil.Log().w("CacheHandler", "*----> null == executer \u5f53\u524d\u5e7f\u544a\u7c7b\u578b\u4e0d\u652f\u6301\u6253\u5e95\u5e7f\u544a \u4e0d\u52a0\u8f7d\u6253\u5e95\u5e7f\u544a\u4e86");
                        this.b(TAdErrorCode.AD_FILL_FAILED);
                        return;
                    }
                    this.a(t, true);
                } else {
                    AdLogUtil.Log().w("CacheHandler", "*----> mSSPNetwork == null  \u5f53\u524d\u6ca1\u6709\u914d\u7f6e SSP \u7684\u5e7f\u544a\uff0c\u4e0d\u53d6\u6253\u5e95\u5e7f\u544a ");
                    this.b(TAdErrorCode.AD_FILL_FAILED);
                }
                return;
            }
            this.a(this.az, this.aD ? 1 : 2);
            AdLogUtil.Log().w("CacheHandler", "*----> finish take bidding ad,and notifyLoadBest ---");
        }
    }

    private boolean J() {
        return this.mProgress >= 2;
    }

    protected abstract C K();

    protected abstract void b(C var1);

    private final void a(C c2, int n) {
        TAdListenerAdapter tAdListenerAdapter = this.H();
        if (tAdListenerAdapter != null) {
            tAdListenerAdapter.setFillSource(n);
            this.stopTimer();
            tAdListenerAdapter.onAdLoad(c2);
        }
    }

    private final void b(TAdErrorCode tAdErrorCode) {
        AdLogUtil.Log().w("CacheHandler", "notify load failed");
        this.stopTimer();
        this.mProgress = 3;
        this.c(tAdErrorCode);
    }

    protected final void a(@NonNull CacheTAdAllianceListener cacheTAdAllianceListener) {
        Object c2 = cacheTAdAllianceListener.getCache();
        double d2 = cacheTAdAllianceListener.getExecuter().getEcpmPrice();
        try {
            if (c2 == null) {
                return;
            }
            if (c2 instanceof ArrayList) {
                for (ICacheAd iCacheAd : (ArrayList)c2) {
                    iCacheAd.setEcpmPrice(d2);
                }
                this.O().addCaches(this.j, (ArrayList)c2);
            } else {
                ((ICacheAd)c2).setEcpmPrice(d2);
                this.O().addCache(this.j, (ICacheAd)c2);
            }
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("CacheHandler", Log.getStackTraceString((Throwable)exception));
        }
    }

    protected int a(String string, int n, String string2, int n2) {
        return n2 - this.O().getAdNum(string, n, string2);
    }

    protected abstract T a(@NonNull Context var1, @NonNull Network var2, int var3, int var4);

    protected abstract void c(C var1);

    public void L() {
        AdLogUtil.Log().d("AdCache", "----------------->destroy,mUseCache:" + this.az);
        this.c(this.az);
        AdLogUtil.Log().d("AdCache", "destroy current use cache");
        this.az = null;
    }

    protected int M() {
        return 1;
    }

    public String getCodeSeatId() {
        return this.aF;
    }

    public int N() {
        return this.aJ;
    }

    @NonNull
    public abstract <Y extends ICacheAd> AdCache<Y> O();

    public C P() {
        return this.az;
    }

    public abstract boolean isExpired();

    protected void c(TAdErrorCode tAdErrorCode) {
        if (this.aP != null && this.aP.getAdListener() != null) {
            this.aP.getAdListener().onError(tAdErrorCode);
        }
    }

    private boolean Q() {
        return this.aC.get() > 0;
    }

    protected TAdRequestBody a(@NonNull TAdRequestBody tAdRequestBody, T t, int n) {
        return new TAdRequestBody.AdRequestBodyBuild().setAdListener((TAdListener)new CacheTAdAllianceListener(this, null, t, n)).build();
    }

    private boolean R() {
        if (TAdManager.isDebug()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Iad iad : this.av) {
                if (iad == null) continue;
                stringBuilder.append(this.f(iad.getLoadStatus()) + ",");
            }
            AdLogUtil.Log().d("CacheHandler", "--- executer list load status--- : " + stringBuilder.toString());
        }
        for (Iad iad : this.av) {
            int n;
            if (iad == null || (n = iad.getLoadStatus()) == 3) continue;
            if (n == 2) {
                return true;
            }
            if (n != 0 && n != 1) continue;
            return false;
        }
        return true;
    }

    private boolean S() {
        if (this.mProgress != 3 && this.R()) {
            this.g(2);
            return true;
        }
        return false;
    }

    private boolean d(boolean bl) {
        if (this.mProgress == 3) {
            return false;
        }
        AdLogUtil.Log().d("CacheHandler", "load next group ad...");
        boolean bl2 = this.B();
        if (bl) {
            AdLogUtil.Log().d("CacheHandler", "startWaitForNextGroupRequest");
            this.F();
        }
        return bl2;
    }

    public void setBundle(Bundle bundle) {
        this.aK = bundle;
    }

    public Bundle b(Network network) {
        Bundle bundle = new Bundle();
        if (null == this.aK) {
            return bundle;
        }
        bundle.putInt("request_type", this.aI);
        bundle.putInt("platform", network != null ? network.getSource() : -1);
        bundle.putString("app_id", network != null ? network.applicationId : "-1");
        bundle.putString("code_seat_id", network != null ? network.codeSeatId : "-1");
        bundle.putDouble("bidding_price", network != null ? network.getPrice() : -1.0);
        bundle.putInt("ad_type", network != null ? network.getAdt() : -1);
        bundle.putString("trigger_id", this.aK.getString("trigger_id"));
        bundle.putLong("trigger_ts", this.aK.getLong("trigger_ts"));
        bundle.putInt("is_pre_trigger", this.aK.getInt("is_pre_trigger"));
        bundle.putLong("request_ts", System.currentTimeMillis());
        bundle.putInt("request_time", (int)(System.currentTimeMillis() - this.aK.getLong("trigger_ts")));
        bundle.putString("cld_app_id", TAdManager.getAppId());
        bundle.putString("cld_code_seat_id", this.aK.getString("code_seat_id"));
        bundle.putInt("priority", this.aB);
        return bundle;
    }

    private void h(int n) {
        for (Iad iad : this.av) {
            if (iad == null) continue;
            iad.setTimeOut(true);
        }
        if (this.e(this.aI)) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("trigger_id", this.aK.getString("trigger_id"));
        bundle.putLong("trigger_ts", this.aK.getLong("trigger_ts"));
        bundle.putInt("ad_type", this.aJ);
        bundle.putString("cld_app_id", SspAd.AppId);
        bundle.putString("cld_code_seat_id", this.aK.getString("code_seat_id"));
        bundle.putInt("bid_start_time_type", n);
        bundle.putFloat("bid_start_duration", (float)this.ay);
        bundle.putFloat("trigger_to_bid_duration", (float)(System.currentTimeMillis() - this.aK.getLong("trigger_ts")));
        bundle.putString("cld_configure_id", AdxPreferencesHelper.getInstance().getString("cloudControlVersion"));
        TrackingManager.trackingStartBid((Bundle)bundle);
    }

    private void b(T t) {
        if (t != null && t.getAdSource() == 0 && t.getNetwork() != null && t.getNetwork().getPrice().doubleValue() != t.getEcpmPrice()) {
            AdLogUtil.Log().d("CacheHandler", "*----> replace cloud price use first price\uff0cfirstprice\uff1a" + t.getEcpmPrice() + "\uff0ccloud price\uff1a" + t.getNetwork().getPrice());
            t.getNetwork().setPrice(Double.valueOf(t.getEcpmPrice()));
            if (t instanceof BaseAd) {
                ((BaseAd)t).mBundle.putDouble("bidding_price", t.getEcpmPrice());
            } else if (t instanceof AdNativeInfo) {
                ((AdNativeInfo)t).getNativeAdWrapper().getAdImpl().mBundle.putDouble("bidding_price", t.getEcpmPrice());
            }
            if (!t.isDefaultAd()) {
                this.A();
            }
        }
    }

    protected class CacheTAdAllianceListener
    extends WrapTAdAllianceListener {
        private T mExecuter;
        private C cache;
        private final int requestCategory;
        final /* synthetic */ CacheHandler this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public CacheTAdAllianceListener(@NonNull TAdRequestBody tAdRequestBody, T t, int n2) {
            this.this$0 = (CacheHandler)n;
            super(tAdRequestBody);
            this.mExecuter = t;
            this.requestCategory = n2;
        }

        public C getCache() {
            return this.cache;
        }

        public T getExecuter() {
            return this.mExecuter;
        }

        private String getProgressName() {
            if (this.this$0.mProgress == 0) {
                return null;
            }
            return this.this$0.mProgress == 1 ? "PROGRESS_REQUEST" : (this.this$0.mProgress == 2 ? "PROGRESS_BIDDING" : "PROGRESS_DISPATCHED");
        }

        private void onAdLoaded() {
            this.this$0.aC.decrementAndGet();
            if (this.mExecuter == null) {
                AdLogUtil.Log().d("CacheHandler", "mExecuter is null");
                return;
            }
            this.mExecuter.setLoadStatus(2);
            this.this$0.aD = this.this$0.mProgress == 1;
            this.this$0.b((T)this.mExecuter);
            if (this.requestCategory == 3) {
                this.this$0.a(this.cache);
            } else {
                this.this$0.a(this);
                AdLogUtil.Log().d("CacheHandler", "*----> onLoaded(),mProgress = " + this.getProgressName() + ",mFlightingAdCount.get() = " + this.this$0.aC.get() + ",ad fill adSource:" + this.mExecuter.getAdSource() + ", isDefaultAd: " + (this.requestCategory == 3) + ", ad placementId: " + this.mExecuter.getPlacementId());
                if (!(this.requestCategory != 1 && this.requestCategory != 4 || this.this$0.S() || this.this$0.Q())) {
                    this.this$0.d(this.requestCategory == 1);
                }
            }
        }

        public void onLoad(List<TAdNativeInfo> list) {
            this.cache = list;
            this.onAdLoaded();
        }

        public void onLoad() {
            this.cache = this.mExecuter;
            this.onAdLoaded();
        }

        public void onError(TAdErrorCode tAdErrorCode) {
            this.this$0.aC.decrementAndGet();
            if (this.mExecuter == null) {
                AdLogUtil.Log().d("CacheHandler", "mExecuter is null");
                return;
            }
            this.mExecuter.setLoadStatus(3);
            AdLogUtil.Log().d("CacheHandler", "*----> request ad fail,error code: " + (tAdErrorCode != null ? Integer.valueOf(tAdErrorCode.getErrorCode()) : null) + ",adSource:" + this.mExecuter.getAdSource() + ", isDefaultAd:" + (this.requestCategory == 3) + ", ad placementId: " + this.mExecuter.getPlacementId() + ",mFlightingAdCount.get() = " + this.this$0.aC.get());
            if (this.requestCategory == 4) {
                AdLogUtil.Log().d("CacheHandler", "current is pre trigger");
                if (!this.this$0.d(false)) {
                    this.this$0.b(TAdErrorCode.AD_FILL_FAILED);
                }
            } else if (this.requestCategory == 2) {
                AdLogUtil.Log().d("CacheHandler", "current is pre trigger");
                this.this$0.d(false);
            } else if (this.requestCategory == 1) {
                if (!this.this$0.S() && !this.this$0.Q()) {
                    this.this$0.d(true);
                }
            } else if (this.requestCategory == 3) {
                this.this$0.b(TAdErrorCode.AD_FILL_FAILED);
                AdLogUtil.Log().w("CacheHandler", "take default ad failed,no ad fill");
            }
        }

        public void onShow() {
            super.onShow();
            AdLogUtil.Log().d("CacheHandler", "*----> ad onshow() " + this.this$0.j);
            if (this.this$0.Q()) {
                AdLogUtil.Log().d("CacheHandler", "currently have requesting ad,terminate preload flow.");
                return;
            }
            if (!com.hisavana.mediation.c.a.isNetWorkAvailable()) {
                AdLogUtil.Log().d("CacheHandler", "network is disconnect");
                return;
            }
            this.this$0.a(CoreUtil.getContext(), CoreUtil.getContext(), f.d(this.this$0.j), 2);
        }

        public void onSkipClick() {
            if (this.this$0.aP != null && this.this$0.aP.getAdListener() != null && this.this$0.aP.getAdListener() instanceof TAdListenerAdapter) {
                ((TAdListenerAdapter)this.this$0.aP.getAdListener()).onSkipClick();
            }
        }

        public void onTimeReach() {
            if (this.this$0.aP != null && this.this$0.aP.getAdListener() != null && this.this$0.aP.getAdListener() instanceof TAdListenerAdapter) {
                ((TAdListenerAdapter)this.this$0.aP.getAdListener()).onTimeReach();
            }
        }
    }
}

