/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.mediation.bean;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.hisavana.common.interfacz.ICacheAd;
import com.hisavana.mediation.config.TAdManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class AdCache<T extends ICacheAd> {
    private static AdCacheComp mComparator = new AdCacheComp();
    HashMap<String, ArrayList<T>> map = new HashMap();
    private AdCacheExpiredWatcher watcher;
    private static final String TAG = "AdCache";

    private ArrayList<T> getOrCreateList(String string) {
        ArrayList<Object> arrayList = this.map.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.map.put(string, arrayList);
        }
        return arrayList;
    }

    public void addCache(String string, @NonNull T t) {
        ArrayList<T> arrayList = this.getOrCreateList(string);
        try {
            int n = Collections.binarySearch(arrayList, t, mComparator);
            if (n < 0) {
                n = -(n + 1);
            }
            arrayList.add(n, t);
            AdLogUtil.Log().d(TAG, "*----> add Caches list is :" + arrayList.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addCaches(String string, ArrayList<T> arrayList) {
        ArrayList<T> arrayList2 = this.getOrCreateList(string);
        arrayList2.addAll(arrayList);
        try {
            AdLogUtil.Log().d(TAG, "*----> add Caches list is :" + arrayList2.size());
            Collections.sort(arrayList2, mComparator);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void removeCache(String string, T t) {
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList != null && arrayList.size() > 0) {
            AdLogUtil.Log().d(TAG, "---> Remove ad:" + t.getPlacementId() + " from cache");
            arrayList.remove(t);
        }
    }

    public boolean hasAd(String string, T t) {
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList.contains(t);
        }
        return false;
    }

    public T getCache(String string, boolean bl) {
        ICacheAd iCacheAd = null;
        ArrayList<T> arrayList = this.getCaches(string, 1, bl);
        if (arrayList != null && !arrayList.isEmpty()) {
            iCacheAd = (ICacheAd)arrayList.get(0);
        }
        return (T)iCacheAd;
    }

    public ArrayList<T> getCaches(@NonNull String string, int n, boolean bl) {
        ICacheAd iCacheAd;
        ArrayList<ICacheAd> arrayList = null;
        ArrayList<T> arrayList2 = this.map.get(string);
        if (arrayList2 == null) {
            return arrayList;
        }
        Iterator<T> iterator = arrayList2.iterator();
        if (TAdManager.isDebug()) {
            iCacheAd = arrayList2.iterator();
            AdLogUtil.Log().d(TAG, "*----> current ad pool size is :" + arrayList2.size());
            while (iCacheAd.hasNext()) {
                ICacheAd iCacheAd2 = (ICacheAd)iCacheAd.next();
                AdLogUtil.Log().d(TAG, "---> ad: " + iCacheAd2.getPlacementId() + "\uff0cprice\uff1a" + iCacheAd2.getEcpmPrice());
            }
        }
        while (iterator.hasNext()) {
            iCacheAd = (ICacheAd)iterator.next();
            if (null == iCacheAd) continue;
            if (bl) {
                AdLogUtil.Log().d(TAG, "---> Remove ad:" + iCacheAd.getPlacementId() + " from cache");
                iterator.remove();
            }
            if (iCacheAd.isExpired()) {
                if (!bl) {
                    iterator.remove();
                }
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<ICacheAd>();
            }
            arrayList.add(iCacheAd);
            if (arrayList.size() < n) continue;
            break;
        }
        return arrayList;
    }

    public void updateSecondPrice(T t, String string) {
        double d2;
        if (t != null && t.getAdSource() == 0 && (d2 = this.getMaxPrice(string, t)) > 0.0) {
            t.setSecondPrice(d2);
        }
    }

    private double getMaxPrice(String string, T t) {
        double d2 = 0.0;
        if (string == null) {
            return d2;
        }
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return d2;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            if (t != null && t == iCacheAd) {
                AdLogUtil.Log().d("ssp_second_price", "*----> getMaxPrice updateSecondPrice()\uff0cexcludeAd == iteratorAd");
                continue;
            }
            AdLogUtil.Log().d(TAG, "*----> max ad in pool is :" + iCacheAd.getPlacementId() + ",EcpmPrice is :" + iCacheAd.getEcpmPrice() + ",AdSource is :" + iCacheAd.getAdSource() + ",isDefaultAd :" + iCacheAd.isDefaultAd() + ",ValidTimeLimit :" + iCacheAd.getValidTimeLimit());
            d2 = iCacheAd.getEcpmPrice();
            break;
        }
        return d2;
    }

    public double getMaxPrice(String string) {
        return this.getMaxPrice(string, null);
    }

    public boolean hasAds(String string) {
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return false;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            return true;
        }
        return false;
    }

    public int getAdNum(String string) {
        int n = 0;
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return n;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            ++n;
            AdLogUtil.Log().d(TAG, "*----> ad in pool is :" + iCacheAd.getPlacementId() + ",EcpmPrice is :" + iCacheAd.getEcpmPrice() + ",AdSource is :" + iCacheAd.getAdSource() + ",isDefaultAd :" + iCacheAd.isDefaultAd() + ",ValidTimeLimit :" + iCacheAd.getValidTimeLimit());
        }
        return n;
    }

    public int getAdNum(String string, int n, String string2) {
        int n2 = 0;
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return n2;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            if (iCacheAd.getAdSource() != n || !TextUtils.equals((CharSequence)iCacheAd.getPlacementId(), (CharSequence)string2)) continue;
            ++n2;
        }
        return n2;
    }

    public double getNetworkPrice(String string, int n, String string2) {
        double d2 = 0.0;
        ArrayList<T> arrayList = this.map.get(string);
        if (arrayList == null) {
            return d2;
        }
        Iterator<T> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                if (this.watcher != null) {
                    this.watcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            if (iCacheAd.getAdSource() != n || !TextUtils.equals((CharSequence)iCacheAd.getPlacementId(), (CharSequence)string2)) continue;
            d2 = iCacheAd.getEcpmPrice();
            break;
        }
        return d2;
    }

    public void registerWatcher(AdCacheExpiredWatcher adCacheExpiredWatcher) {
        this.watcher = adCacheExpiredWatcher;
    }

    public void unRegisterWatcher() {
        this.watcher = null;
    }

    public static interface AdCacheExpiredWatcher {
        public void onExpired(ICacheAd var1);
    }

    public static class AdCacheComp
    implements Comparator<ICacheAd> {
        @Override
        public int compare(ICacheAd iCacheAd, ICacheAd iCacheAd2) {
            try {
                if (iCacheAd.isExpired() && !iCacheAd2.isExpired()) {
                    return 1;
                }
                if (!iCacheAd.isExpired() && iCacheAd2.isExpired()) {
                    return -1;
                }
                if (iCacheAd.getEcpmPrice() == iCacheAd2.getEcpmPrice()) {
                    if (iCacheAd.getValidTimeLimit() - iCacheAd2.getValidTimeLimit() < 0L) {
                        return -1;
                    }
                    if (iCacheAd.getValidTimeLimit() - iCacheAd2.getValidTimeLimit() > 0L) {
                        return 1;
                    }
                    return 0;
                }
                return -((int)(iCacheAd.getEcpmPrice() * 100.0 - iCacheAd2.getEcpmPrice() * 100.0));
            }
            catch (Throwable throwable) {
                return 0;
            }
        }
    }
}

