/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.mediation.handler;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.RunTimer;
import com.cloud.hisavana.sdk.data.control.AdxPreferencesHelper;
import com.hisavana.common.base.BaseAd;
import com.hisavana.common.bean.AdCache;
import com.hisavana.common.bean.AdNativeInfo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.bean.TAdRequestBody;
import com.hisavana.common.interfacz.ICacheAd;
import com.hisavana.common.interfacz.Iad;
import com.hisavana.common.interfacz.QueryPriceListener;
import com.hisavana.common.interfacz.TAdListener;
import com.hisavana.common.interfacz.WrapTAdAllianceListener;
import com.hisavana.common.tracking.TrackingManager;
import com.hisavana.mediation.a.b;
import com.hisavana.mediation.ad.TAdListenerAdapter;
import com.hisavana.mediation.bean.CloudControlConfig;
import com.hisavana.mediation.c.a;
import com.hisavana.mediation.config.TAdManager;
import com.hisavana.mediation.config.f;
import com.transsion.core.CoreUtil;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class CacheHandler<T extends Iad, C> {
    protected TAdListenerAdapter p;
    protected RunTimer ay;
    private final CopyOnWriteArrayList<T> az;
    private final b aA;
    protected int aB;
    protected int aC;
    private Handler mHandler;
    protected C aD;
    protected String mAdUnit;
    private int aE = 0;
    private int aF = 0;
    private final AtomicInteger aG = new AtomicInteger();
    private boolean aH = false;
    protected Network aI;
    protected int mProgress;
    private String aJ = null;
    protected int aK = 1;
    private int aL;
    private int aM;
    private WeakReference<Context> aN;
    private AdCache.AdCacheExpiredWatcher aO = new AdCache.AdCacheExpiredWatcher(){

        public void onExpired(ICacheAd iCacheAd) {
            AdLogUtil.Log().d("CacheHandler", "ad expired");
        }
    };
    protected Bundle aP;

    public CacheHandler(String string, TAdListenerAdapter tAdListenerAdapter) {
        this.mHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                switch (message.what) {
                    case 1001: {
                        AdLogUtil.Log().w("CacheHandler", "receive MSG_REQUEST_NEXT_GROUP_WAITING...");
                        CacheHandler.this.e(true);
                        break;
                    }
                    case 1002: {
                        AdLogUtil.Log().w("CacheHandler", "receive MSG_BIDDING_WAITING...");
                        CacheHandler.this.g(1);
                        break;
                    }
                    default: {
                        if (!(message.obj instanceof Iad)) break;
                        ((Iad)message.obj).loadAd();
                    }
                }
            }
        };
        this.p = tAdListenerAdapter;
        this.mAdUnit = string;
        this.O().registerWatcher(this.aO);
        this.aA = new b(this);
        this.az = new CopyOnWriteArrayList();
    }

    private boolean e(int n) {
        return n == 2 || n == 4;
    }

    public int A() {
        return this.aL;
    }

    public boolean a(Context context, Context context2, CloudControlConfig.CodeSeat codeSeat, int n) {
        int n2;
        if (codeSeat == null) {
            return false;
        }
        this.aN = new WeakReference<Context>(context2);
        this.aH = false;
        this.aG.set(0);
        this.aL = n;
        this.aM = codeSeat.getCodeSeatType();
        this.aC = Math.max(codeSeat.getBiddingWaitTime(), 0);
        this.aB = Math.max(codeSeat.getAdRequestTimeInterval(), 0);
        this.aE = codeSeat.getAdRequestConcurrentCount() <= 0 ? 1 : codeSeat.getAdRequestConcurrentCount();
        this.aE = this.e(n) ? 1 : this.aE;
        this.aK = Math.max(1, Math.min(this.M(), codeSeat.getAdRequestCount()));
        this.mProgress = 1;
        this.aJ = codeSeat.getCodeSeatId();
        int n3 = n2 = codeSeat.getPreload() != false ? codeSeat.getPreloadLogic() : -1;
        if (n == 2 && n2 == -1) {
            AdLogUtil.Log().w("CacheHandler", "*----> preload is close...");
            return false;
        }
        AdLogUtil.Log().i("CacheHandler", "*----> WaitBiddingTime:" + this.aC + ",WaitNextGroupRequestTime:" + this.aB + ",ConcurrentReqCount:" + this.aE + ",PoolAppendStrategy:" + n2 + ",adRequestCount:" + codeSeat.adRequestCount + ",loadType:" + this.aL);
        if (codeSeat.getNetworks() == null || codeSeat.getNetworks().size() == 0) {
            AdLogUtil.Log().w("CacheHandler", "*----> adUnit:" + this.mAdUnit + " no networks , load/preload/trigger_preload request end");
            return false;
        }
        if (n == 2 && n2 == 1 && this.O().hasAds(this.mAdUnit)) {
            AdLogUtil.Log().w("CacheHandler", "*----> autoAppend & INSUFFICIENT_APPEND,but adunit:" + this.mAdUnit + " has cached ad, load/preload/trigger_preload request end");
            return false;
        }
        this.aA.a(codeSeat.getNetworks());
        if (this.e(n)) {
            this.b(context, context2, codeSeat, n);
        } else {
            List<Network> list = this.aA.d(codeSeat.getNetworks());
            if (list == null || list.isEmpty()) {
                this.b(context, context2, codeSeat, n);
            }
            this.a(context, context2, codeSeat, list);
        }
        return true;
    }

    private void a(@NonNull T t) {
        this.az.add(t);
    }

    public void f(List<Network> list) {
        for (Network network : list) {
            double d2;
            if (network == null || !((d2 = this.O().getNetworkPrice(this.mAdUnit, network.getSource().intValue(), network.getCodeSeatId())) > 0.0)) continue;
            network.setPrice(Double.valueOf(d2));
        }
        Collections.sort(list, new Comparator<Network>(){

            @Override
            public int compare(Network network, Network network2) {
                if (network == null || network2 == null) {
                    return 0;
                }
                int n = -((int)(network.getPrice() * 100.0 - network2.getPrice() * 100.0));
                if (n == 0) {
                    if (CacheHandler.this.O().getAdNum(CacheHandler.this.mAdUnit, network.getSource().intValue(), network.getCodeSeatId()) > 0) {
                        return -1;
                    }
                    if (CacheHandler.this.O().getAdNum(CacheHandler.this.mAdUnit, network2.getSource().intValue(), network2.getCodeSeatId()) > 0) {
                        return 1;
                    }
                }
                return n;
            }
        });
    }

    private boolean a(Context context, Context context2, CloudControlConfig.CodeSeat codeSeat, List<Network> list) {
        List<Network> list2 = this.aA.b(codeSeat.getNetworks());
        if (list2 == null) {
            list2 = new ArrayList<Network>();
        }
        if (list != null && list.size() > 0) {
            list2.addAll(list);
        }
        this.f(list2);
        AdLogUtil.Log().d("CacheHandler", "*----> " + list2.toString());
        boolean bl = false;
        int n = Math.max(1, Math.min(this.M(), codeSeat.getAdRequestCount()));
        for (Network network : list2) {
            T t;
            if (network == null) continue;
            Network network2 = this.aI = network.getSource() == 0 ? network : this.aI;
            if (bl) {
                AdLogUtil.Log().d("CacheHandler", "*----> exist higher ecpm ad in current waterfall.");
                continue;
            }
            int n2 = this.O().getAdNum(this.mAdUnit, network.getSource().intValue(), network.getCodeSeatId());
            boolean bl2 = bl = n2 > 0;
            if (n - n2 <= 0) {
                AdLogUtil.Log().d("CacheHandler", "*----> ad source:" + network.getSource() + " ,network codeSeat :" + network.getCodeSeatId() + ",need number <= 0");
                continue;
            }
            if (this.b(network) || null == (t = this.a(context, context2, codeSeat, network))) continue;
            this.a((C)t);
        }
        if (this.az.size() <= 0) {
            this.g(2);
            return true;
        }
        this.D();
        if (!this.e(this.aL)) {
            AdLogUtil.Log().d("CacheHandler", "start WaitForBidding & startWaitForNextGroupRequest");
            this.G();
            this.H();
        }
        return true;
    }

    private void b(final Context context, final Context context2, final CloudControlConfig.CodeSeat codeSeat, final int n) {
        this.aA.a(codeSeat.getNetworks(), new QueryPriceListener(){

            public void onQueryPriceSuccess(List<Network> list) {
                AdLogUtil.Log().d("CacheHandler", "receive query price success");
                this.g(list);
            }

            public void onQueryPriceFailed() {
                AdLogUtil.Log().d("CacheHandler", "receive query price failed");
                this.g(null);
            }

            private void g(List<Network> list) {
                if (CacheHandler.this.e(n)) {
                    AdLogUtil.Log().d("CacheHandler", "--- preload mode ---");
                    CacheHandler.this.a(context, context2, codeSeat, list);
                } else if (list != null && !list.isEmpty() && !CacheHandler.this.K()) {
                    AdLogUtil.Log().d("CacheHandler", "--- load ad mode --- ,call loadAd to request ad creative");
                    for (Network network : list) {
                        Iad iad;
                        if (CacheHandler.this.b(network) || null == (iad = CacheHandler.this.a(context, context2, codeSeat, network))) continue;
                        CacheHandler.this.a((C)iad);
                        CacheHandler.this.a(iad, false);
                    }
                    CacheHandler.this.B();
                }
            }
        });
    }

    private void B() {
        Serializable serializable;
        AdLogUtil.Log().d("CacheHandler", "sort executer list");
        if (TAdManager.isDebug()) {
            serializable = new StringBuilder();
            for (Iad iad : this.az) {
                if (iad == null || iad.getNetwork() == null) continue;
                ((StringBuilder)serializable).append(iad.getNetwork().toString());
            }
            AdLogUtil.Log().d("CacheHandler", "*before* sort executer list are: " + ((StringBuilder)serializable).toString());
        }
        try {
            serializable = new ArrayList<T>(this.az);
            Collections.sort(serializable, new Comparator<T>(){

                @Override
                public int compare(T t, T t2) {
                    if (t != null && t2 != null && t.getNetwork() != null && t2.getNetwork() != null) {
                        return -((int)(t.getNetwork().getPrice() * 100.0 - t2.getNetwork().getPrice() * 100.0));
                    }
                    return 0;
                }
            });
            this.az.clear();
            this.az.addAll((Collection<T>)((Object)serializable));
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("CacheHandler", Log.getStackTraceString((Throwable)exception));
        }
        if (TAdManager.isDebug()) {
            serializable = new StringBuilder();
            for (Iad iad : this.az) {
                if (iad == null || iad.getNetwork() == null) continue;
                ((StringBuilder)serializable).append(iad.getNetwork().toString());
            }
            AdLogUtil.Log().d("CacheHandler", "*after* sort executer list are: " + ((StringBuilder)serializable).toString());
        }
    }

    private T a(Context context, Context context2, CloudControlConfig.CodeSeat codeSeat, Network network) {
        int n = codeSeat.getAdRequestCount();
        T t = this.a(network.getSource() == 1 || network.getSource() == 3 ? context2 : context, network, n, (int)codeSeat.getCacheTimeout());
        if (t == null) {
            AdLogUtil.Log().e("CacheHandler", "create execute:" + network.getSource() + " fail");
            return null;
        }
        t.setEcpmPrice(network.getPrice().doubleValue());
        t.setAdUnit(this.mAdUnit);
        AdLogUtil.Log().i("CacheHandler", "*----> add ad to list adSource:" + t.getAdSource() + ",network codeSeat:" + network.getCodeSeatId() + " request num:" + n);
        return t;
    }

    public ArrayList<T> C() {
        if (null == this.az) {
            return null;
        }
        ArrayList<Iad> arrayList = new ArrayList<Iad>();
        for (Iad iad : this.az) {
            if (null == iad || iad.getLoadStatus() != 1) continue;
            arrayList.add(iad);
        }
        return arrayList;
    }

    public void a(ArrayList<T> arrayList) {
        if (null == arrayList || null == this.az) {
            return;
        }
        AdLogUtil.Log().d("CacheHandler", "*----> mExecuterListCopy.size() = " + arrayList.size());
        this.az.clear();
        this.az.addAll(arrayList);
    }

    public boolean b(Network network) {
        for (Iad iad : this.az) {
            if (null == iad || null == iad.getNetwork() || null == iad.getNetwork().getCodeSeatId() || !network.getCodeSeatId().equals(iad.getNetwork().getCodeSeatId())) continue;
            AdLogUtil.Log().d("CacheHandler", "*----> executer is exist,network id:" + iad.getNetwork().getCodeSeatId());
            return true;
        }
        return false;
    }

    private void d(boolean bl) {
        if (null != this.az) {
            for (Iad iad : this.az) {
                if (iad == null || !bl && iad.getLoadStatus() == 1) continue;
                iad.stopLoader();
            }
            if (bl) {
                this.az.clear();
            }
        }
        this.p = null;
        this.aF = 0;
        this.stopTimer();
        this.aA.destroy();
        this.O().unRegisterWatcher();
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.mHandler = null;
        this.mProgress = 3;
        AdLogUtil.Log().d("AdCache", "----------------->destroy,mUseCache:" + this.aD);
        this.c(this.aD);
        this.aD = null;
    }

    public void clearCurrentAd() {
        this.d(false);
    }

    public void destroy() {
        this.d(true);
    }

    private String f(int n) {
        switch (n) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "LOADING";
            }
            case 2: {
                return "SUCCESS";
            }
            case 3: {
                return "FAILED";
            }
        }
        return "";
    }

    private boolean a(T t, boolean bl) {
        if (t != null && t.getLoadStatus() == 0) {
            AdLogUtil.Log().d("CacheHandler", "*----> loadAd id: " + t.getPlacementId() + ",EcpmPrice: " + t.getEcpmPrice() + ",AdSource: " + t.getAdSource() + ",isDefaultAd: " + bl);
            int n = bl ? 3 : this.aL;
            t.setRequestBody(this.a(t, n));
            t.setTrackingBundle(this.c(t.getNetwork()));
            t.setDefaultAd(bl);
            t.setRequestType(this.aL);
            this.aA.a(t.getNetwork(), true);
            t.loadAd();
            this.aG.addAndGet(1);
            t.setLoadStatus(1);
            return true;
        }
        return false;
    }

    public boolean D() {
        if (this.p == null) {
            return false;
        }
        AdLogUtil.Log().d("CacheHandler", "*----> load ad num: " + this.aE + " with group");
        int n = 0;
        for (Iad iad : this.az) {
            if (iad == null || !this.a(iad, false)) continue;
            ++this.aF;
            if (++n < this.aE) continue;
            break;
        }
        return n > 0;
    }

    private void E() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(1001);
        }
    }

    private void F() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(1002);
        }
    }

    private void G() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(1002);
            this.mHandler.sendEmptyMessageDelayed(1002, (long)this.aC);
        }
    }

    private void H() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(1001);
            this.mHandler.sendEmptyMessageDelayed(1001, (long)this.aB);
        }
    }

    protected final void a(C c2) {
        if (this.mProgress == 2 && this.p != null && this.p.getDispatchListener() != null) {
            AdLogUtil.Log().w("CacheHandler", " *----> start take default ad...");
            this.b((T)c2);
            if (c2 == null) {
                this.b(TAdErrorCode.AD_FILL_FAILED);
                AdLogUtil.Log().w("CacheHandler", " *----> take default ad failed,no ad fill");
                return;
            }
            this.aD = c2;
            this.a(c2, 3);
            AdLogUtil.Log().w("CacheHandler", "*----> finish take default ad,and notifyLoadBest ---");
        }
    }

    private boolean I() {
        return this.aL == 1 && this.aI != null;
    }

    private boolean J() {
        return this.aL != 2 && this.mProgress == 1 && this.p != null && this.p.getDispatchListener() != null;
    }

    protected final void g(int n) {
        if (this.J()) {
            AdLogUtil.Log().w("CacheHandler", "*----> start bidding...");
            this.h(n);
            this.mProgress = 2;
            this.E();
            this.F();
            this.aD = this.L();
            if (this.aD == null) {
                AdLogUtil.Log().w("CacheHandler", " *----> bidding failed,no ad fill,start request default ad");
                if (this.I()) {
                    AdLogUtil.Log().w("CacheHandler", "*----> send request default ad");
                    T t = this.a(CoreUtil.getContext(), this.aI, 1, 0);
                    if (null == t) {
                        AdLogUtil.Log().w("CacheHandler", "*----> null == executer \u5f53\u524d\u5e7f\u544a\u7c7b\u578b\u4e0d\u652f\u6301\u6253\u5e95\u5e7f\u544a \u4e0d\u52a0\u8f7d\u6253\u5e95\u5e7f\u544a\u4e86");
                        this.b(TAdErrorCode.AD_FILL_FAILED);
                        return;
                    }
                    this.a(t, true);
                } else {
                    AdLogUtil.Log().w("CacheHandler", "*----> mSSPNetwork == null  \u5f53\u524d\u6ca1\u6709\u914d\u7f6e SSP \u7684\u5e7f\u544a\uff0c\u4e0d\u53d6\u6253\u5e95\u5e7f\u544a ");
                    this.b(TAdErrorCode.AD_FILL_FAILED);
                }
                return;
            }
            this.a(this.aD, this.aH ? 1 : 2);
            AdLogUtil.Log().w("CacheHandler", "*----> finish take bidding ad,and notifyLoadBest ---");
        }
    }

    private boolean K() {
        return this.mProgress >= 2;
    }

    protected abstract C L();

    protected abstract void b(C var1);

    private final void a(C c2, int n) {
        if (this.p != null) {
            this.p.setFillSource(n);
            this.stopTimer();
            this.p.onAdLoad(c2);
        }
    }

    private final void b(TAdErrorCode tAdErrorCode) {
        AdLogUtil.Log().w("CacheHandler", "notify load failed");
        this.stopTimer();
        this.mProgress = 3;
        this.c(tAdErrorCode);
    }

    protected abstract T a(@NonNull Context var1, @NonNull Network var2, int var3, int var4);

    protected abstract void c(C var1);

    protected int M() {
        return 1;
    }

    public String getCodeSeatId() {
        return this.aJ;
    }

    public int N() {
        return this.aM;
    }

    @NonNull
    public abstract <Y extends ICacheAd> AdCache<Y> O();

    public C P() {
        return this.aD;
    }

    public abstract boolean isExpired();

    protected void c(TAdErrorCode tAdErrorCode) {
        if (this.p != null) {
            this.p.onError(tAdErrorCode);
        }
    }

    private boolean Q() {
        return this.aG.get() > 0;
    }

    protected TAdRequestBody a(T t, int n) {
        return new TAdRequestBody.AdRequestBodyBuild().setAdListener((TAdListener)new CacheTAdAllianceListener(this, t, n)).build();
    }

    private boolean R() {
        if (TAdManager.isDebug()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Iad iad : this.az) {
                if (iad == null) continue;
                stringBuilder.append(this.f(iad.getLoadStatus()) + ",");
            }
            AdLogUtil.Log().d("CacheHandler", "--- executer list load status--- : " + stringBuilder.toString());
        }
        block6: for (Iad iad : this.az) {
            if (iad == null) continue;
            int n = iad.getLoadStatus();
            switch (n) {
                case 3: {
                    continue block6;
                }
                case 2: {
                    return true;
                }
                case 0: 
                case 1: {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean S() {
        if (this.mProgress != 3 && this.R()) {
            this.g(2);
            return true;
        }
        return false;
    }

    private boolean e(boolean bl) {
        if (this.mProgress == 3) {
            return false;
        }
        AdLogUtil.Log().d("CacheHandler", "load next group ad...");
        boolean bl2 = this.D();
        if (bl) {
            AdLogUtil.Log().d("CacheHandler", "startWaitForNextGroupRequest");
            this.H();
        }
        return bl2;
    }

    public final void a(@NonNull TAdListenerAdapter tAdListenerAdapter) {
        this.p = tAdListenerAdapter;
    }

    public final void a(RunTimer runTimer) {
        this.ay = runTimer;
    }

    public void stopTimer() {
        if (this.ay != null) {
            AdLogUtil.Log().w("LoadHandler", "stop timer");
            this.ay.resetTimerTask();
            this.ay = null;
        }
    }

    private void b(T t) {
        if (t != null && t.getAdSource() == 0 && t.getNetwork() != null && t.getNetwork().getPrice().doubleValue() != t.getEcpmPrice()) {
            AdLogUtil.Log().d("CacheHandler", "*----> replace cloud price use first price\uff0cfirstprice\uff1a" + t.getEcpmPrice() + "\uff0ccloud price\uff1a" + t.getNetwork().getPrice());
            t.getNetwork().setPrice(Double.valueOf(t.getEcpmPrice()));
            if (t instanceof BaseAd) {
                ((BaseAd)t).mBundle.putDouble("bidding_price", t.getEcpmPrice());
            } else if (t instanceof AdNativeInfo) {
                ((AdNativeInfo)t).getNativeAdWrapper().getAdImpl().mBundle.putDouble("bidding_price", t.getEcpmPrice());
            }
            if (!t.isDefaultAd()) {
                this.B();
            }
        }
    }

    public void setBundle(Bundle bundle) {
        this.aP = bundle;
    }

    public Bundle c(Network network) {
        Bundle bundle = new Bundle();
        if (null == this.aP) {
            return bundle;
        }
        bundle.putInt("request_type", this.aL);
        bundle.putInt("platform", network != null ? network.getSource() : -1);
        bundle.putString("app_id", network != null ? network.applicationId : "-1");
        bundle.putString("code_seat_id", network != null ? network.codeSeatId : "-1");
        bundle.putDouble("bidding_price", network != null ? network.getPrice() : -1.0);
        bundle.putInt("ad_type", network != null ? network.getAdt() : -1);
        bundle.putString("trigger_id", this.aP.getString("trigger_id"));
        bundle.putLong("trigger_ts", this.aP.getLong("trigger_ts"));
        bundle.putInt("is_pre_trigger", this.aP.getInt("is_pre_trigger"));
        bundle.putLong("request_ts", System.currentTimeMillis());
        bundle.putInt("request_time", (int)(System.currentTimeMillis() - this.aP.getLong("trigger_ts")));
        bundle.putString("cld_app_id", TAdManager.getAppId());
        bundle.putString("cld_code_seat_id", this.aP.getString("code_seat_id"));
        bundle.putInt("priority", this.aF);
        return bundle;
    }

    private void h(int n) {
        for (Iad iad : this.az) {
            if (iad == null) continue;
            iad.setTimeOut(true);
        }
        if (this.e(this.aL)) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("trigger_id", this.aP.getString("trigger_id"));
        bundle.putLong("trigger_ts", this.aP.getLong("trigger_ts"));
        bundle.putInt("ad_type", this.aM);
        bundle.putString("cld_app_id", SspAd.AppId);
        bundle.putString("cld_code_seat_id", this.aP.getString("code_seat_id"));
        bundle.putInt("bid_start_time_type", n);
        bundle.putFloat("bid_start_duration", (float)this.aC);
        bundle.putFloat("trigger_to_bid_duration", (float)(System.currentTimeMillis() - this.aP.getLong("trigger_ts")));
        bundle.putString("cld_configure_id", AdxPreferencesHelper.getInstance().getString("cloudControlVersion"));
        TrackingManager.trackingStartBid((Bundle)bundle);
    }

    protected class CacheTAdAllianceListener
    extends WrapTAdAllianceListener {
        private T mExecuter;
        private C cache;
        private final int requestCategory;
        final /* synthetic */ CacheHandler this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public CacheTAdAllianceListener(T t, int n2) {
            this.this$0 = (CacheHandler)n;
            this.mExecuter = t;
            this.requestCategory = n2;
        }

        public C getCache() {
            return this.cache;
        }

        public T getExecuter() {
            return this.mExecuter;
        }

        private String getProgressName() {
            if (this.this$0.mProgress == 0) {
                return null;
            }
            return this.this$0.mProgress == 1 ? "PROGRESS_REQUEST" : (this.this$0.mProgress == 2 ? "PROGRESS_BIDDING" : "PROGRESS_DISPATCHED");
        }

        private void onAdLoaded() {
            this.this$0.aG.decrementAndGet();
            if (this.mExecuter == null) {
                AdLogUtil.Log().d("CacheHandler", "mExecuter is null");
                return;
            }
            this.mExecuter.setLoadStatus(2);
            this.this$0.aH = this.this$0.mProgress == 1;
            this.this$0.b((T)this.mExecuter);
            if (this.requestCategory == 3) {
                this.this$0.a(this.cache);
            } else {
                AdLogUtil.Log().d("CacheHandler", "*----> onLoaded(),mProgress = " + this.getProgressName() + ",mFlightingAdCount.get() = " + this.this$0.aG.get() + ",ad fill adSource:" + this.mExecuter.getAdSource() + ", isDefaultAd: " + (this.requestCategory == 3) + ", ad placementId: " + this.mExecuter.getPlacementId());
                if (!(this.requestCategory != 1 && this.requestCategory != 4 || this.this$0.S() || this.this$0.Q())) {
                    this.this$0.e(this.requestCategory == 1);
                }
            }
        }

        public void onLoad(List<TAdNativeInfo> list) {
            this.cache = list;
            this.onAdLoaded();
        }

        public void onLoad() {
            this.cache = this.mExecuter;
            this.onAdLoaded();
        }

        public void onError(TAdErrorCode tAdErrorCode) {
            this.this$0.aG.decrementAndGet();
            if (this.mExecuter == null) {
                AdLogUtil.Log().d("CacheHandler", "mExecuter is null");
                return;
            }
            this.mExecuter.setLoadStatus(3);
            AdLogUtil.Log().d("CacheHandler", "*----> request ad fail,error code: " + (tAdErrorCode != null ? Integer.valueOf(tAdErrorCode.getErrorCode()) : null) + ",adSource:" + this.mExecuter.getAdSource() + ", isDefaultAd:" + (this.requestCategory == 3) + ", ad placementId: " + this.mExecuter.getPlacementId() + ",mFlightingAdCount.get() = " + this.this$0.aG.get());
            switch (this.requestCategory) {
                case 4: {
                    AdLogUtil.Log().d("CacheHandler", "current is pre trigger");
                    if (this.this$0.e(false)) break;
                    this.this$0.b(TAdErrorCode.AD_FILL_FAILED);
                    break;
                }
                case 2: {
                    AdLogUtil.Log().d("CacheHandler", "current is pre load");
                    this.this$0.e(false);
                    break;
                }
                case 1: {
                    if (this.this$0.S() || this.this$0.Q()) break;
                    this.this$0.e(true);
                    break;
                }
                case 3: {
                    this.this$0.b(TAdErrorCode.AD_FILL_FAILED);
                    AdLogUtil.Log().w("CacheHandler", "take default ad failed,no ad fill");
                }
            }
        }

        public void onShow() {
            super.onShow();
            AdLogUtil.Log().d("CacheHandler", "*----> ad onshow() " + this.this$0.mAdUnit);
            if (this.this$0.Q()) {
                AdLogUtil.Log().d("CacheHandler", "currently have requesting ad,terminate preload flow.");
                return;
            }
            if (!a.isNetWorkAvailable()) {
                AdLogUtil.Log().d("CacheHandler", "network is disconnect");
                return;
            }
            Context context = CoreUtil.getContext();
            if (null != this.this$0.aN && null != this.this$0.aN.get()) {
                context = (Context)this.this$0.aN.get();
            }
            this.this$0.az.clear();
            this.this$0.a(CoreUtil.getContext(), context, f.d(this.this$0.mAdUnit), 2);
        }

        public void onSkipClick() {
            if (this.this$0.p != null) {
                this.this$0.p.onSkipClick();
            }
        }

        public void onTimeReach() {
            if (this.this$0.p != null) {
                this.this$0.p.onTimeReach();
            }
        }
    }
}

